/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Allows to specify additional options when project is saved to Project Server or Project Online.")
public class ProjectServerSaveOptionsDTO {
    @SerializedName(value="ProjectName")
    private String projectName = null;
    @SerializedName(value="ProjectGuid")
    private String projectGuid = null;
    @SerializedName(value="Timeout")
    private String timeout = null;
    @SerializedName(value="PollingInterval")
    private String pollingInterval = null;

    public ProjectServerSaveOptionsDTO projectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    @ApiModelProperty(value="Gets or sets name of a project which is displayed in Project Server \\ Project     Online projects list. Should be unique within Project Server \\ Project Online     instance. Is the value is omitted, the value of Prj.Name property will be used     instead.")
    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public ProjectServerSaveOptionsDTO projectGuid(String projectGuid) {
        this.projectGuid = projectGuid;
        return this;
    }

    @ApiModelProperty(value="Gets or sets unique identifier of a project. Should be unique within Project     Server \\ Project Online instance.")
    public String getProjectGuid() {
        return this.projectGuid;
    }

    public void setProjectGuid(String projectGuid) {
        this.projectGuid = projectGuid;
    }

    public ProjectServerSaveOptionsDTO timeout(String timeout) {
        this.timeout = timeout;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets timeout used when waiting for processing of save project request     by a Project Server's queue processing service. The default value for this property     is 1 minute. The processing time may be longer for large projects or in case when Project     Server instance is too busy responding to other requests.")
    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public ProjectServerSaveOptionsDTO pollingInterval(String pollingInterval) {
        this.pollingInterval = pollingInterval;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets interval between queue job status requests. The default value is     2 seconds.")
    public String getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(String pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectServerSaveOptionsDTO projectServerSaveOptionsDTO = (ProjectServerSaveOptionsDTO)o;
        return Objects.equals(this.projectName, projectServerSaveOptionsDTO.projectName) && Objects.equals(this.projectGuid, projectServerSaveOptionsDTO.projectGuid) && Objects.equals(this.timeout, projectServerSaveOptionsDTO.timeout) && Objects.equals(this.pollingInterval, projectServerSaveOptionsDTO.pollingInterval);
    }

    public int hashCode() {
        return Objects.hash(this.projectName, this.projectGuid, this.timeout, this.pollingInterval);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectServerSaveOptionsDTO {\n");
        sb.append("    projectName: ").append(this.toIndentedString(this.projectName)).append("\n");
        sb.append("    projectGuid: ").append(this.toIndentedString(this.projectGuid)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    pollingInterval: ").append(this.toIndentedString(this.pollingInterval)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

