/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.AssignmentBaseline;
import com.aspose.tasks.cloud.model.BookingType;
import com.aspose.tasks.cloud.model.ExtendedAttribute;
import com.aspose.tasks.cloud.model.RateScaleType;
import com.aspose.tasks.cloud.model.RateType;
import com.aspose.tasks.cloud.model.TimeUnitType;
import com.aspose.tasks.cloud.model.TimephasedData;
import com.aspose.tasks.cloud.model.WorkContourType;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Represents a resource assignment in a project.")
public class ResourceAssignment {
    @SerializedName(value="TaskUid")
    private Integer taskUid = -1;
    @SerializedName(value="ResourceUid")
    private Integer resourceUid = -1;
    @SerializedName(value="Guid")
    private String guid = null;
    @SerializedName(value="Uid")
    private Integer uid = null;
    @SerializedName(value="PercentWorkComplete")
    private Integer percentWorkComplete = null;
    @SerializedName(value="ActualCost")
    private BigDecimal actualCost = null;
    @SerializedName(value="ActualFinish")
    private OffsetDateTime actualFinish = null;
    @SerializedName(value="ActualOvertimeCost")
    private BigDecimal actualOvertimeCost = null;
    @SerializedName(value="ActualOvertimeWork")
    private String actualOvertimeWork = null;
    @SerializedName(value="ActualStart")
    private OffsetDateTime actualStart = null;
    @SerializedName(value="ActualWork")
    private String actualWork = null;
    @SerializedName(value="Acwp")
    private Double acwp = null;
    @SerializedName(value="Confirmed")
    private Boolean confirmed = null;
    @SerializedName(value="Cost")
    private BigDecimal cost = null;
    @SerializedName(value="CostRateTableType")
    private RateType costRateTableType = null;
    @SerializedName(value="CostVariance")
    private Double costVariance = null;
    @SerializedName(value="Cv")
    private Double cv = null;
    @SerializedName(value="Delay")
    private Integer delay = null;
    @SerializedName(value="Finish")
    private OffsetDateTime finish = null;
    @SerializedName(value="FinishVariance")
    private Integer finishVariance = null;
    @SerializedName(value="Hyperlink")
    private String hyperlink = null;
    @SerializedName(value="HyperlinkAddress")
    private String hyperlinkAddress = null;
    @SerializedName(value="HyperlinkSubAddress")
    private String hyperlinkSubAddress = null;
    @SerializedName(value="WorkVariance")
    private Double workVariance = null;
    @SerializedName(value="HasFixedRateUnits")
    private Boolean hasFixedRateUnits = null;
    @SerializedName(value="FixedMaterial")
    private Boolean fixedMaterial = null;
    @SerializedName(value="LevelingDelay")
    private Integer levelingDelay = null;
    @SerializedName(value="LevelingDelayFormat")
    private TimeUnitType levelingDelayFormat = null;
    @SerializedName(value="LinkedFields")
    private Boolean linkedFields = null;
    @SerializedName(value="Milestone")
    private Boolean milestone = null;
    @SerializedName(value="Notes")
    private String notes = null;
    @SerializedName(value="Overallocated")
    private Boolean overallocated = null;
    @SerializedName(value="OvertimeCost")
    private BigDecimal overtimeCost = null;
    @SerializedName(value="OvertimeWork")
    private String overtimeWork = null;
    @SerializedName(value="PeakUnits")
    private Double peakUnits = null;
    @SerializedName(value="RegularWork")
    private String regularWork = null;
    @SerializedName(value="RemainingCost")
    private BigDecimal remainingCost = null;
    @SerializedName(value="RemainingOvertimeCost")
    private BigDecimal remainingOvertimeCost = null;
    @SerializedName(value="RemainingOvertimeWork")
    private String remainingOvertimeWork = null;
    @SerializedName(value="RemainingWork")
    private String remainingWork = null;
    @SerializedName(value="ResponsePending")
    private Boolean responsePending = null;
    @SerializedName(value="Start")
    private OffsetDateTime start = null;
    @SerializedName(value="Stop")
    private OffsetDateTime stop = null;
    @SerializedName(value="Resume")
    private OffsetDateTime resume = null;
    @SerializedName(value="StartVariance")
    private Integer startVariance = null;
    @SerializedName(value="Summary")
    private Boolean summary = null;
    @SerializedName(value="Sv")
    private Double sv = null;
    @SerializedName(value="Units")
    private Double units = 1.0;
    @SerializedName(value="UpdateNeeded")
    private Boolean updateNeeded = null;
    @SerializedName(value="Vac")
    private Double vac = null;
    @SerializedName(value="Work")
    private String work = null;
    @SerializedName(value="WorkContour")
    private WorkContourType workContour = null;
    @SerializedName(value="Bcws")
    private Double bcws = null;
    @SerializedName(value="Bcwp")
    private Double bcwp = null;
    @SerializedName(value="BookingType")
    private BookingType bookingType = null;
    @SerializedName(value="ActualWorkProtected")
    private String actualWorkProtected = null;
    @SerializedName(value="ActualOvertimeWorkProtected")
    private String actualOvertimeWorkProtected = null;
    @SerializedName(value="CreationDate")
    private OffsetDateTime creationDate = null;
    @SerializedName(value="AssnOwner")
    private String assnOwner = null;
    @SerializedName(value="AssnOwnerGuid")
    private String assnOwnerGuid = null;
    @SerializedName(value="BudgetCost")
    private BigDecimal budgetCost = null;
    @SerializedName(value="BudgetWork")
    private String budgetWork = null;
    @SerializedName(value="RateScale")
    private RateScaleType rateScale = null;
    @SerializedName(value="Baselines")
    private List<AssignmentBaseline> baselines = null;
    @SerializedName(value="ExtendedAttributes")
    private List<ExtendedAttribute> extendedAttributes = null;
    @SerializedName(value="TimephasedData")
    private List<TimephasedData> timephasedData = null;

    public ResourceAssignment taskUid(Integer taskUid) {
        this.taskUid = taskUid;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets a task unique id to which a resource is assigned.")
    public Integer getTaskUid() {
        return this.taskUid;
    }

    public void setTaskUid(Integer taskUid) {
        this.taskUid = taskUid;
    }

    public ResourceAssignment resourceUid(Integer resourceUid) {
        this.resourceUid = resourceUid;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets a resource unique id assigned to a task.")
    public Integer getResourceUid() {
        return this.resourceUid;
    }

    public void setResourceUid(Integer resourceUid) {
        this.resourceUid = resourceUid;
    }

    public ResourceAssignment guid(String guid) {
        this.guid = guid;
        return this;
    }

    @ApiModelProperty(value="Returns or sets the global unique identifier of an assignment.")
    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public ResourceAssignment uid(Integer uid) {
        this.uid = uid;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the unique identifier of an assignment.")
    public Integer getUid() {
        return this.uid;
    }

    public void setUid(Integer uid) {
        this.uid = uid;
    }

    public ResourceAssignment percentWorkComplete(Integer percentWorkComplete) {
        this.percentWorkComplete = percentWorkComplete;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the amount of a work completed on an assignment.")
    public Integer getPercentWorkComplete() {
        return this.percentWorkComplete;
    }

    public void setPercentWorkComplete(Integer percentWorkComplete) {
        this.percentWorkComplete = percentWorkComplete;
    }

    public ResourceAssignment actualCost(BigDecimal actualCost) {
        this.actualCost = actualCost;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the actual cost incurred on an assignment.")
    public BigDecimal getActualCost() {
        return this.actualCost;
    }

    public void setActualCost(BigDecimal actualCost) {
        this.actualCost = actualCost;
    }

    public ResourceAssignment actualFinish(OffsetDateTime actualFinish) {
        this.actualFinish = actualFinish;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the actual finish date of an assignment.")
    public OffsetDateTime getActualFinish() {
        return this.actualFinish;
    }

    public void setActualFinish(OffsetDateTime actualFinish) {
        this.actualFinish = actualFinish;
    }

    public ResourceAssignment actualOvertimeCost(BigDecimal actualOvertimeCost) {
        this.actualOvertimeCost = actualOvertimeCost;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the actual overtime cost incurred on an assignment.")
    public BigDecimal getActualOvertimeCost() {
        return this.actualOvertimeCost;
    }

    public void setActualOvertimeCost(BigDecimal actualOvertimeCost) {
        this.actualOvertimeCost = actualOvertimeCost;
    }

    public ResourceAssignment actualOvertimeWork(String actualOvertimeWork) {
        this.actualOvertimeWork = actualOvertimeWork;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the actual amount of an overtime work incurred on an assignment.")
    public String getActualOvertimeWork() {
        return this.actualOvertimeWork;
    }

    public void setActualOvertimeWork(String actualOvertimeWork) {
        this.actualOvertimeWork = actualOvertimeWork;
    }

    public ResourceAssignment actualStart(OffsetDateTime actualStart) {
        this.actualStart = actualStart;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the actual start date of an assignment.")
    public OffsetDateTime getActualStart() {
        return this.actualStart;
    }

    public void setActualStart(OffsetDateTime actualStart) {
        this.actualStart = actualStart;
    }

    public ResourceAssignment actualWork(String actualWork) {
        this.actualWork = actualWork;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the actual amount of a work incurred on an assignment.")
    public String getActualWork() {
        return this.actualWork;
    }

    public void setActualWork(String actualWork) {
        this.actualWork = actualWork;
    }

    public ResourceAssignment acwp(Double acwp) {
        this.acwp = acwp;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the actual cost of a work performed on an assignment to-date.")
    public Double getAcwp() {
        return this.acwp;
    }

    public void setAcwp(Double acwp) {
        this.acwp = acwp;
    }

    public ResourceAssignment confirmed(Boolean confirmed) {
        this.confirmed = confirmed;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether a resource has accepted all of its assignments.")
    public Boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(Boolean confirmed) {
        this.confirmed = confirmed;
    }

    public ResourceAssignment cost(BigDecimal cost) {
        this.cost = cost;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the projected or scheduled cost of an assignment.")
    public BigDecimal getCost() {
        return this.cost;
    }

    public void setCost(BigDecimal cost) {
        this.cost = cost;
    }

    public ResourceAssignment costRateTableType(RateType costRateTableType) {
        this.costRateTableType = costRateTableType;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the cost rate table used for this assignment.")
    public RateType getCostRateTableType() {
        return this.costRateTableType;
    }

    public void setCostRateTableType(RateType costRateTableType) {
        this.costRateTableType = costRateTableType;
    }

    public ResourceAssignment costVariance(Double costVariance) {
        this.costVariance = costVariance;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the difference between the cost and baseline cost of a resource.")
    public Double getCostVariance() {
        return this.costVariance;
    }

    public void setCostVariance(Double costVariance) {
        this.costVariance = costVariance;
    }

    public ResourceAssignment cv(Double cv) {
        this.cv = cv;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the earned value cost variance.")
    public Double getCv() {
        return this.cv;
    }

    public void setCv(Double cv) {
        this.cv = cv;
    }

    public ResourceAssignment delay(Integer delay) {
        this.delay = delay;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the delay of an assignment.")
    public Integer getDelay() {
        return this.delay;
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public ResourceAssignment finish(OffsetDateTime finish) {
        this.finish = finish;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the scheduled finish date of an assignment.")
    public OffsetDateTime getFinish() {
        return this.finish;
    }

    public void setFinish(OffsetDateTime finish) {
        this.finish = finish;
    }

    public ResourceAssignment finishVariance(Integer finishVariance) {
        this.finishVariance = finishVariance;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the variance of an assignment finish date from a baseline finish date.")
    public Integer getFinishVariance() {
        return this.finishVariance;
    }

    public void setFinishVariance(Integer finishVariance) {
        this.finishVariance = finishVariance;
    }

    public ResourceAssignment hyperlink(String hyperlink) {
        this.hyperlink = hyperlink;
        return this;
    }

    @ApiModelProperty(value="Returns or sets the title of the hyperlink associated with an assignment.")
    public String getHyperlink() {
        return this.hyperlink;
    }

    public void setHyperlink(String hyperlink) {
        this.hyperlink = hyperlink;
    }

    public ResourceAssignment hyperlinkAddress(String hyperlinkAddress) {
        this.hyperlinkAddress = hyperlinkAddress;
        return this;
    }

    @ApiModelProperty(value="Returns or sets the hyperlink associated with an assignment.")
    public String getHyperlinkAddress() {
        return this.hyperlinkAddress;
    }

    public void setHyperlinkAddress(String hyperlinkAddress) {
        this.hyperlinkAddress = hyperlinkAddress;
    }

    public ResourceAssignment hyperlinkSubAddress(String hyperlinkSubAddress) {
        this.hyperlinkSubAddress = hyperlinkSubAddress;
        return this;
    }

    @ApiModelProperty(value="Returns or sets the document bookmark of the hyperlink associated with an assignment.")
    public String getHyperlinkSubAddress() {
        return this.hyperlinkSubAddress;
    }

    public void setHyperlinkSubAddress(String hyperlinkSubAddress) {
        this.hyperlinkSubAddress = hyperlinkSubAddress;
    }

    public ResourceAssignment workVariance(Double workVariance) {
        this.workVariance = workVariance;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the variance of an assignment work from the baseline work as minutes.")
    public Double getWorkVariance() {
        return this.workVariance;
    }

    public void setWorkVariance(Double workVariance) {
        this.workVariance = workVariance;
    }

    public ResourceAssignment hasFixedRateUnits(Boolean hasFixedRateUnits) {
        this.hasFixedRateUnits = hasFixedRateUnits;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the Units have Fixed Rate.")
    public Boolean isHasFixedRateUnits() {
        return this.hasFixedRateUnits;
    }

    public void setHasFixedRateUnits(Boolean hasFixedRateUnits) {
        this.hasFixedRateUnits = hasFixedRateUnits;
    }

    public ResourceAssignment fixedMaterial(Boolean fixedMaterial) {
        this.fixedMaterial = fixedMaterial;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the consumption of an assigned material resource occurs in a single, fixed amount.")
    public Boolean isFixedMaterial() {
        return this.fixedMaterial;
    }

    public void setFixedMaterial(Boolean fixedMaterial) {
        this.fixedMaterial = fixedMaterial;
    }

    public ResourceAssignment levelingDelay(Integer levelingDelay) {
        this.levelingDelay = levelingDelay;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the delay caused by leveling.")
    public Integer getLevelingDelay() {
        return this.levelingDelay;
    }

    public void setLevelingDelay(Integer levelingDelay) {
        this.levelingDelay = levelingDelay;
    }

    public ResourceAssignment levelingDelayFormat(TimeUnitType levelingDelayFormat) {
        this.levelingDelayFormat = levelingDelayFormat;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the duration format of a delay.")
    public TimeUnitType getLevelingDelayFormat() {
        return this.levelingDelayFormat;
    }

    public void setLevelingDelayFormat(TimeUnitType levelingDelayFormat) {
        this.levelingDelayFormat = levelingDelayFormat;
    }

    public ResourceAssignment linkedFields(Boolean linkedFields) {
        this.linkedFields = linkedFields;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the Project is linked to another OLE object.")
    public Boolean isLinkedFields() {
        return this.linkedFields;
    }

    public void setLinkedFields(Boolean linkedFields) {
        this.linkedFields = linkedFields;
    }

    public ResourceAssignment milestone(Boolean milestone) {
        this.milestone = milestone;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the assignment is a milestone.")
    public Boolean isMilestone() {
        return this.milestone;
    }

    public void setMilestone(Boolean milestone) {
        this.milestone = milestone;
    }

    public ResourceAssignment notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(value="Returns or sets the text notes associated with an assignment.")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public ResourceAssignment overallocated(Boolean overallocated) {
        this.overallocated = overallocated;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the assignment is overallocated.")
    public Boolean isOverallocated() {
        return this.overallocated;
    }

    public void setOverallocated(Boolean overallocated) {
        this.overallocated = overallocated;
    }

    public ResourceAssignment overtimeCost(BigDecimal overtimeCost) {
        this.overtimeCost = overtimeCost;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the sum of the actual and remaining overtime cost of an assignment.")
    public BigDecimal getOvertimeCost() {
        return this.overtimeCost;
    }

    public void setOvertimeCost(BigDecimal overtimeCost) {
        this.overtimeCost = overtimeCost;
    }

    public ResourceAssignment overtimeWork(String overtimeWork) {
        this.overtimeWork = overtimeWork;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the scheduled overtime work of an assignment.")
    public String getOvertimeWork() {
        return this.overtimeWork;
    }

    public void setOvertimeWork(String overtimeWork) {
        this.overtimeWork = overtimeWork;
    }

    public ResourceAssignment peakUnits(Double peakUnits) {
        this.peakUnits = peakUnits;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the largest number of a resource's units assigned to a task.")
    public Double getPeakUnits() {
        return this.peakUnits;
    }

    public void setPeakUnits(Double peakUnits) {
        this.peakUnits = peakUnits;
    }

    public ResourceAssignment regularWork(String regularWork) {
        this.regularWork = regularWork;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the amount of a non-overtime work scheduled for an assignment.")
    public String getRegularWork() {
        return this.regularWork;
    }

    public void setRegularWork(String regularWork) {
        this.regularWork = regularWork;
    }

    public ResourceAssignment remainingCost(BigDecimal remainingCost) {
        this.remainingCost = remainingCost;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the remaining projected cost of completing an assignment.")
    public BigDecimal getRemainingCost() {
        return this.remainingCost;
    }

    public void setRemainingCost(BigDecimal remainingCost) {
        this.remainingCost = remainingCost;
    }

    public ResourceAssignment remainingOvertimeCost(BigDecimal remainingOvertimeCost) {
        this.remainingOvertimeCost = remainingOvertimeCost;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the remaining projected overtime cost of completing an assignment.")
    public BigDecimal getRemainingOvertimeCost() {
        return this.remainingOvertimeCost;
    }

    public void setRemainingOvertimeCost(BigDecimal remainingOvertimeCost) {
        this.remainingOvertimeCost = remainingOvertimeCost;
    }

    public ResourceAssignment remainingOvertimeWork(String remainingOvertimeWork) {
        this.remainingOvertimeWork = remainingOvertimeWork;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the remaining overtime work scheduled to complete an assignment.")
    public String getRemainingOvertimeWork() {
        return this.remainingOvertimeWork;
    }

    public void setRemainingOvertimeWork(String remainingOvertimeWork) {
        this.remainingOvertimeWork = remainingOvertimeWork;
    }

    public ResourceAssignment remainingWork(String remainingWork) {
        this.remainingWork = remainingWork;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the remaining work scheduled to complete an assignment.")
    public String getRemainingWork() {
        return this.remainingWork;
    }

    public void setRemainingWork(String remainingWork) {
        this.remainingWork = remainingWork;
    }

    public ResourceAssignment responsePending(Boolean responsePending) {
        this.responsePending = responsePending;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the response has been received for a TeamAssign message.")
    public Boolean isResponsePending() {
        return this.responsePending;
    }

    public void setResponsePending(Boolean responsePending) {
        this.responsePending = responsePending;
    }

    public ResourceAssignment start(OffsetDateTime start) {
        this.start = start;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the scheduled start date of an assignment.")
    public OffsetDateTime getStart() {
        return this.start;
    }

    public void setStart(OffsetDateTime start) {
        this.start = start;
    }

    public ResourceAssignment stop(OffsetDateTime stop) {
        this.stop = stop;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the date when assignment is stopped.")
    public OffsetDateTime getStop() {
        return this.stop;
    }

    public void setStop(OffsetDateTime stop) {
        this.stop = stop;
    }

    public ResourceAssignment resume(OffsetDateTime resume) {
        this.resume = resume;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the date when assignment is resumed.")
    public OffsetDateTime getResume() {
        return this.resume;
    }

    public void setResume(OffsetDateTime resume) {
        this.resume = resume;
    }

    public ResourceAssignment startVariance(Integer startVariance) {
        this.startVariance = startVariance;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the variance of an assignment start date from a baseline start date.")
    public Integer getStartVariance() {
        return this.startVariance;
    }

    public void setStartVariance(Integer startVariance) {
        this.startVariance = startVariance;
    }

    public ResourceAssignment summary(Boolean summary) {
        this.summary = summary;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the task is a summary task.")
    public Boolean isSummary() {
        return this.summary;
    }

    public void setSummary(Boolean summary) {
        this.summary = summary;
    }

    public ResourceAssignment sv(Double sv) {
        this.sv = sv;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the earned value schedule variance, through the project status date.")
    public Double getSv() {
        return this.sv;
    }

    public void setSv(Double sv) {
        this.sv = sv;
    }

    public ResourceAssignment units(Double units) {
        this.units = units;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the number of units for an assignment.")
    public Double getUnits() {
        return this.units;
    }

    public void setUnits(Double units) {
        this.units = units;
    }

    public ResourceAssignment updateNeeded(Boolean updateNeeded) {
        this.updateNeeded = updateNeeded;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the resource assigned to a task needs to be updated as to the status of the task.")
    public Boolean isUpdateNeeded() {
        return this.updateNeeded;
    }

    public void setUpdateNeeded(Boolean updateNeeded) {
        this.updateNeeded = updateNeeded;
    }

    public ResourceAssignment vac(Double vac) {
        this.vac = vac;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the difference between basline cost and total cost. Read/write Double.")
    public Double getVac() {
        return this.vac;
    }

    public void setVac(Double vac) {
        this.vac = vac;
    }

    public ResourceAssignment work(String work) {
        this.work = work;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the amount of scheduled work for an assignment. Read/write TimeSpan.")
    public String getWork() {
        return this.work;
    }

    public void setWork(String work) {
        this.work = work;
    }

    public ResourceAssignment workContour(WorkContourType workContour) {
        this.workContour = workContour;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the work contour of an assignment.")
    public WorkContourType getWorkContour() {
        return this.workContour;
    }

    public void setWorkContour(WorkContourType workContour) {
        this.workContour = workContour;
    }

    public ResourceAssignment bcws(Double bcws) {
        this.bcws = bcws;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the budgeted cost of a work on assignment.")
    public Double getBcws() {
        return this.bcws;
    }

    public void setBcws(Double bcws) {
        this.bcws = bcws;
    }

    public ResourceAssignment bcwp(Double bcwp) {
        this.bcwp = bcwp;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the budgeted cost of a work performed on assignment to-date.")
    public Double getBcwp() {
        return this.bcwp;
    }

    public void setBcwp(Double bcwp) {
        this.bcwp = bcwp;
    }

    public ResourceAssignment bookingType(BookingType bookingType) {
        this.bookingType = bookingType;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the booking type of an assignment.")
    public BookingType getBookingType() {
        return this.bookingType;
    }

    public void setBookingType(BookingType bookingType) {
        this.bookingType = bookingType;
    }

    public ResourceAssignment actualWorkProtected(String actualWorkProtected) {
        this.actualWorkProtected = actualWorkProtected;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the duration through which actual work is protected.")
    public String getActualWorkProtected() {
        return this.actualWorkProtected;
    }

    public void setActualWorkProtected(String actualWorkProtected) {
        this.actualWorkProtected = actualWorkProtected;
    }

    public ResourceAssignment actualOvertimeWorkProtected(String actualOvertimeWorkProtected) {
        this.actualOvertimeWorkProtected = actualOvertimeWorkProtected;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the duration through which actual overtime work is protected.")
    public String getActualOvertimeWorkProtected() {
        return this.actualOvertimeWorkProtected;
    }

    public void setActualOvertimeWorkProtected(String actualOvertimeWorkProtected) {
        this.actualOvertimeWorkProtected = actualOvertimeWorkProtected;
    }

    public ResourceAssignment creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the date that the assignment was created.")
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public ResourceAssignment assnOwner(String assnOwner) {
        this.assnOwner = assnOwner;
        return this;
    }

    @ApiModelProperty(value="Returns or sets the name of an assignment owner.")
    public String getAssnOwner() {
        return this.assnOwner;
    }

    public void setAssnOwner(String assnOwner) {
        this.assnOwner = assnOwner;
    }

    public ResourceAssignment assnOwnerGuid(String assnOwnerGuid) {
        this.assnOwnerGuid = assnOwnerGuid;
        return this;
    }

    @ApiModelProperty(value="Returns or sets the Guid of an assignment owner.")
    public String getAssnOwnerGuid() {
        return this.assnOwnerGuid;
    }

    public void setAssnOwnerGuid(String assnOwnerGuid) {
        this.assnOwnerGuid = assnOwnerGuid;
    }

    public ResourceAssignment budgetCost(BigDecimal budgetCost) {
        this.budgetCost = budgetCost;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the budgeted cost of resources on an assignment.")
    public BigDecimal getBudgetCost() {
        return this.budgetCost;
    }

    public void setBudgetCost(BigDecimal budgetCost) {
        this.budgetCost = budgetCost;
    }

    public ResourceAssignment budgetWork(String budgetWork) {
        this.budgetWork = budgetWork;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the budgeted work amount for a work or material resources on an assignment.")
    public String getBudgetWork() {
        return this.budgetWork;
    }

    public void setBudgetWork(String budgetWork) {
        this.budgetWork = budgetWork;
    }

    public ResourceAssignment rateScale(RateScaleType rateScale) {
        this.rateScale = rateScale;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns the time unit for the usage rate of the material resource assignment.")
    public RateScaleType getRateScale() {
        return this.rateScale;
    }

    public void setRateScale(RateScaleType rateScale) {
        this.rateScale = rateScale;
    }

    public ResourceAssignment baselines(List<AssignmentBaseline> baselines) {
        this.baselines = baselines;
        return this;
    }

    public ResourceAssignment addBaselinesItem(AssignmentBaseline baselinesItem) {
        if (this.baselines == null) {
            this.baselines = new ArrayList<AssignmentBaseline>();
        }
        this.baselines.add(baselinesItem);
        return this;
    }

    @ApiModelProperty(value="List of ResourceAssignment's Baseline values.")
    public List<AssignmentBaseline> getBaselines() {
        return this.baselines;
    }

    public void setBaselines(List<AssignmentBaseline> baselines) {
        this.baselines = baselines;
    }

    public ResourceAssignment extendedAttributes(List<ExtendedAttribute> extendedAttributes) {
        this.extendedAttributes = extendedAttributes;
        return this;
    }

    public ResourceAssignment addExtendedAttributesItem(ExtendedAttribute extendedAttributesItem) {
        if (this.extendedAttributes == null) {
            this.extendedAttributes = new ArrayList<ExtendedAttribute>();
        }
        this.extendedAttributes.add(extendedAttributesItem);
        return this;
    }

    @ApiModelProperty(value="ResourceAssignment extended attributes.")
    public List<ExtendedAttribute> getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public void setExtendedAttributes(List<ExtendedAttribute> extendedAttributes) {
        this.extendedAttributes = extendedAttributes;
    }

    public ResourceAssignment timephasedData(List<TimephasedData> timephasedData) {
        this.timephasedData = timephasedData;
        return this;
    }

    public ResourceAssignment addTimephasedDataItem(TimephasedData timephasedDataItem) {
        if (this.timephasedData == null) {
            this.timephasedData = new ArrayList<TimephasedData>();
        }
        this.timephasedData.add(timephasedDataItem);
        return this;
    }

    @ApiModelProperty(value="Represents a collection of TimephasedData objects.")
    public List<TimephasedData> getTimephasedData() {
        return this.timephasedData;
    }

    public void setTimephasedData(List<TimephasedData> timephasedData) {
        this.timephasedData = timephasedData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceAssignment resourceAssignment = (ResourceAssignment)o;
        return Objects.equals(this.taskUid, resourceAssignment.taskUid) && Objects.equals(this.resourceUid, resourceAssignment.resourceUid) && Objects.equals(this.guid, resourceAssignment.guid) && Objects.equals(this.uid, resourceAssignment.uid) && Objects.equals(this.percentWorkComplete, resourceAssignment.percentWorkComplete) && Objects.equals(this.actualCost, resourceAssignment.actualCost) && Objects.equals(this.actualFinish, resourceAssignment.actualFinish) && Objects.equals(this.actualOvertimeCost, resourceAssignment.actualOvertimeCost) && Objects.equals(this.actualOvertimeWork, resourceAssignment.actualOvertimeWork) && Objects.equals(this.actualStart, resourceAssignment.actualStart) && Objects.equals(this.actualWork, resourceAssignment.actualWork) && Objects.equals(this.acwp, resourceAssignment.acwp) && Objects.equals(this.confirmed, resourceAssignment.confirmed) && Objects.equals(this.cost, resourceAssignment.cost) && Objects.equals((Object)this.costRateTableType, (Object)resourceAssignment.costRateTableType) && Objects.equals(this.costVariance, resourceAssignment.costVariance) && Objects.equals(this.cv, resourceAssignment.cv) && Objects.equals(this.delay, resourceAssignment.delay) && Objects.equals(this.finish, resourceAssignment.finish) && Objects.equals(this.finishVariance, resourceAssignment.finishVariance) && Objects.equals(this.hyperlink, resourceAssignment.hyperlink) && Objects.equals(this.hyperlinkAddress, resourceAssignment.hyperlinkAddress) && Objects.equals(this.hyperlinkSubAddress, resourceAssignment.hyperlinkSubAddress) && Objects.equals(this.workVariance, resourceAssignment.workVariance) && Objects.equals(this.hasFixedRateUnits, resourceAssignment.hasFixedRateUnits) && Objects.equals(this.fixedMaterial, resourceAssignment.fixedMaterial) && Objects.equals(this.levelingDelay, resourceAssignment.levelingDelay) && Objects.equals((Object)this.levelingDelayFormat, (Object)resourceAssignment.levelingDelayFormat) && Objects.equals(this.linkedFields, resourceAssignment.linkedFields) && Objects.equals(this.milestone, resourceAssignment.milestone) && Objects.equals(this.notes, resourceAssignment.notes) && Objects.equals(this.overallocated, resourceAssignment.overallocated) && Objects.equals(this.overtimeCost, resourceAssignment.overtimeCost) && Objects.equals(this.overtimeWork, resourceAssignment.overtimeWork) && Objects.equals(this.peakUnits, resourceAssignment.peakUnits) && Objects.equals(this.regularWork, resourceAssignment.regularWork) && Objects.equals(this.remainingCost, resourceAssignment.remainingCost) && Objects.equals(this.remainingOvertimeCost, resourceAssignment.remainingOvertimeCost) && Objects.equals(this.remainingOvertimeWork, resourceAssignment.remainingOvertimeWork) && Objects.equals(this.remainingWork, resourceAssignment.remainingWork) && Objects.equals(this.responsePending, resourceAssignment.responsePending) && Objects.equals(this.start, resourceAssignment.start) && Objects.equals(this.stop, resourceAssignment.stop) && Objects.equals(this.resume, resourceAssignment.resume) && Objects.equals(this.startVariance, resourceAssignment.startVariance) && Objects.equals(this.summary, resourceAssignment.summary) && Objects.equals(this.sv, resourceAssignment.sv) && Objects.equals(this.units, resourceAssignment.units) && Objects.equals(this.updateNeeded, resourceAssignment.updateNeeded) && Objects.equals(this.vac, resourceAssignment.vac) && Objects.equals(this.work, resourceAssignment.work) && Objects.equals((Object)this.workContour, (Object)resourceAssignment.workContour) && Objects.equals(this.bcws, resourceAssignment.bcws) && Objects.equals(this.bcwp, resourceAssignment.bcwp) && Objects.equals((Object)this.bookingType, (Object)resourceAssignment.bookingType) && Objects.equals(this.actualWorkProtected, resourceAssignment.actualWorkProtected) && Objects.equals(this.actualOvertimeWorkProtected, resourceAssignment.actualOvertimeWorkProtected) && Objects.equals(this.creationDate, resourceAssignment.creationDate) && Objects.equals(this.assnOwner, resourceAssignment.assnOwner) && Objects.equals(this.assnOwnerGuid, resourceAssignment.assnOwnerGuid) && Objects.equals(this.budgetCost, resourceAssignment.budgetCost) && Objects.equals(this.budgetWork, resourceAssignment.budgetWork) && Objects.equals((Object)this.rateScale, (Object)resourceAssignment.rateScale) && Objects.equals(this.baselines, resourceAssignment.baselines) && Objects.equals(this.extendedAttributes, resourceAssignment.extendedAttributes) && Objects.equals(this.timephasedData, resourceAssignment.timephasedData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.taskUid, this.resourceUid, this.guid, this.uid, this.percentWorkComplete, this.actualCost, this.actualFinish, this.actualOvertimeCost, this.actualOvertimeWork, this.actualStart, this.actualWork, this.acwp, this.confirmed, this.cost, this.costRateTableType, this.costVariance, this.cv, this.delay, this.finish, this.finishVariance, this.hyperlink, this.hyperlinkAddress, this.hyperlinkSubAddress, this.workVariance, this.hasFixedRateUnits, this.fixedMaterial, this.levelingDelay, this.levelingDelayFormat, this.linkedFields, this.milestone, this.notes, this.overallocated, this.overtimeCost, this.overtimeWork, this.peakUnits, this.regularWork, this.remainingCost, this.remainingOvertimeCost, this.remainingOvertimeWork, this.remainingWork, this.responsePending, this.start, this.stop, this.resume, this.startVariance, this.summary, this.sv, this.units, this.updateNeeded, this.vac, this.work, this.workContour, this.bcws, this.bcwp, this.bookingType, this.actualWorkProtected, this.actualOvertimeWorkProtected, this.creationDate, this.assnOwner, this.assnOwnerGuid, this.budgetCost, this.budgetWork, this.rateScale, this.baselines, this.extendedAttributes, this.timephasedData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceAssignment {\n");
        sb.append("    taskUid: ").append(this.toIndentedString(this.taskUid)).append("\n");
        sb.append("    resourceUid: ").append(this.toIndentedString(this.resourceUid)).append("\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("    percentWorkComplete: ").append(this.toIndentedString(this.percentWorkComplete)).append("\n");
        sb.append("    actualCost: ").append(this.toIndentedString(this.actualCost)).append("\n");
        sb.append("    actualFinish: ").append(this.toIndentedString(this.actualFinish)).append("\n");
        sb.append("    actualOvertimeCost: ").append(this.toIndentedString(this.actualOvertimeCost)).append("\n");
        sb.append("    actualOvertimeWork: ").append(this.toIndentedString(this.actualOvertimeWork)).append("\n");
        sb.append("    actualStart: ").append(this.toIndentedString(this.actualStart)).append("\n");
        sb.append("    actualWork: ").append(this.toIndentedString(this.actualWork)).append("\n");
        sb.append("    acwp: ").append(this.toIndentedString(this.acwp)).append("\n");
        sb.append("    confirmed: ").append(this.toIndentedString(this.confirmed)).append("\n");
        sb.append("    cost: ").append(this.toIndentedString(this.cost)).append("\n");
        sb.append("    costRateTableType: ").append(this.toIndentedString((Object)this.costRateTableType)).append("\n");
        sb.append("    costVariance: ").append(this.toIndentedString(this.costVariance)).append("\n");
        sb.append("    cv: ").append(this.toIndentedString(this.cv)).append("\n");
        sb.append("    delay: ").append(this.toIndentedString(this.delay)).append("\n");
        sb.append("    finish: ").append(this.toIndentedString(this.finish)).append("\n");
        sb.append("    finishVariance: ").append(this.toIndentedString(this.finishVariance)).append("\n");
        sb.append("    hyperlink: ").append(this.toIndentedString(this.hyperlink)).append("\n");
        sb.append("    hyperlinkAddress: ").append(this.toIndentedString(this.hyperlinkAddress)).append("\n");
        sb.append("    hyperlinkSubAddress: ").append(this.toIndentedString(this.hyperlinkSubAddress)).append("\n");
        sb.append("    workVariance: ").append(this.toIndentedString(this.workVariance)).append("\n");
        sb.append("    hasFixedRateUnits: ").append(this.toIndentedString(this.hasFixedRateUnits)).append("\n");
        sb.append("    fixedMaterial: ").append(this.toIndentedString(this.fixedMaterial)).append("\n");
        sb.append("    levelingDelay: ").append(this.toIndentedString(this.levelingDelay)).append("\n");
        sb.append("    levelingDelayFormat: ").append(this.toIndentedString((Object)this.levelingDelayFormat)).append("\n");
        sb.append("    linkedFields: ").append(this.toIndentedString(this.linkedFields)).append("\n");
        sb.append("    milestone: ").append(this.toIndentedString(this.milestone)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    overallocated: ").append(this.toIndentedString(this.overallocated)).append("\n");
        sb.append("    overtimeCost: ").append(this.toIndentedString(this.overtimeCost)).append("\n");
        sb.append("    overtimeWork: ").append(this.toIndentedString(this.overtimeWork)).append("\n");
        sb.append("    peakUnits: ").append(this.toIndentedString(this.peakUnits)).append("\n");
        sb.append("    regularWork: ").append(this.toIndentedString(this.regularWork)).append("\n");
        sb.append("    remainingCost: ").append(this.toIndentedString(this.remainingCost)).append("\n");
        sb.append("    remainingOvertimeCost: ").append(this.toIndentedString(this.remainingOvertimeCost)).append("\n");
        sb.append("    remainingOvertimeWork: ").append(this.toIndentedString(this.remainingOvertimeWork)).append("\n");
        sb.append("    remainingWork: ").append(this.toIndentedString(this.remainingWork)).append("\n");
        sb.append("    responsePending: ").append(this.toIndentedString(this.responsePending)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    stop: ").append(this.toIndentedString(this.stop)).append("\n");
        sb.append("    resume: ").append(this.toIndentedString(this.resume)).append("\n");
        sb.append("    startVariance: ").append(this.toIndentedString(this.startVariance)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("    sv: ").append(this.toIndentedString(this.sv)).append("\n");
        sb.append("    units: ").append(this.toIndentedString(this.units)).append("\n");
        sb.append("    updateNeeded: ").append(this.toIndentedString(this.updateNeeded)).append("\n");
        sb.append("    vac: ").append(this.toIndentedString(this.vac)).append("\n");
        sb.append("    work: ").append(this.toIndentedString(this.work)).append("\n");
        sb.append("    workContour: ").append(this.toIndentedString((Object)this.workContour)).append("\n");
        sb.append("    bcws: ").append(this.toIndentedString(this.bcws)).append("\n");
        sb.append("    bcwp: ").append(this.toIndentedString(this.bcwp)).append("\n");
        sb.append("    bookingType: ").append(this.toIndentedString((Object)this.bookingType)).append("\n");
        sb.append("    actualWorkProtected: ").append(this.toIndentedString(this.actualWorkProtected)).append("\n");
        sb.append("    actualOvertimeWorkProtected: ").append(this.toIndentedString(this.actualOvertimeWorkProtected)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    assnOwner: ").append(this.toIndentedString(this.assnOwner)).append("\n");
        sb.append("    assnOwnerGuid: ").append(this.toIndentedString(this.assnOwnerGuid)).append("\n");
        sb.append("    budgetCost: ").append(this.toIndentedString(this.budgetCost)).append("\n");
        sb.append("    budgetWork: ").append(this.toIndentedString(this.budgetWork)).append("\n");
        sb.append("    rateScale: ").append(this.toIndentedString((Object)this.rateScale)).append("\n");
        sb.append("    baselines: ").append(this.toIndentedString(this.baselines)).append("\n");
        sb.append("    extendedAttributes: ").append(this.toIndentedString(this.extendedAttributes)).append("\n");
        sb.append("    timephasedData: ").append(this.toIndentedString(this.timephasedData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

