/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.Baseline;
import com.aspose.tasks.cloud.model.TimeUnitType;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Represents baseline values of a task.")
public class TaskBaseline
extends Baseline {
    @SerializedName(value="Start")
    private OffsetDateTime start = null;
    @SerializedName(value="Finish")
    private OffsetDateTime finish = null;
    @SerializedName(value="Duration")
    private String duration = null;
    @SerializedName(value="FixedCost")
    private Double fixedCost = null;
    @SerializedName(value="DurationFormat")
    private TimeUnitType durationFormat = null;
    @SerializedName(value="EstimatedDuration")
    private Boolean estimatedDuration = null;

    public TaskBaseline start(OffsetDateTime start) {
        this.start = start;
        return this;
    }

    @ApiModelProperty(required=true, value="The scheduled start date of the task when the baseline was saved.")
    public OffsetDateTime getStart() {
        return this.start;
    }

    public void setStart(OffsetDateTime start) {
        this.start = start;
    }

    public TaskBaseline finish(OffsetDateTime finish) {
        this.finish = finish;
        return this;
    }

    @ApiModelProperty(required=true, value="The scheduled finish date of the task when the baseline was saved.")
    public OffsetDateTime getFinish() {
        return this.finish;
    }

    public void setFinish(OffsetDateTime finish) {
        this.finish = finish;
    }

    public TaskBaseline duration(String duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(required=true, value="The scheduled duration of the task when the baseline was saved.")
    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public TaskBaseline fixedCost(Double fixedCost) {
        this.fixedCost = fixedCost;
        return this;
    }

    @ApiModelProperty(required=true, value="The fixed cost of the task when the baseline was saved.")
    public Double getFixedCost() {
        return this.fixedCost;
    }

    public void setFixedCost(Double fixedCost) {
        this.fixedCost = fixedCost;
    }

    public TaskBaseline durationFormat(TimeUnitType durationFormat) {
        this.durationFormat = durationFormat;
        return this;
    }

    @ApiModelProperty(required=true, value="The format for expressing the duration of the task baseline.")
    public TimeUnitType getDurationFormat() {
        return this.durationFormat;
    }

    public void setDurationFormat(TimeUnitType durationFormat) {
        this.durationFormat = durationFormat;
    }

    public TaskBaseline estimatedDuration(Boolean estimatedDuration) {
        this.estimatedDuration = estimatedDuration;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the baseline duration of the task was estimated.")
    public Boolean isEstimatedDuration() {
        return this.estimatedDuration;
    }

    public void setEstimatedDuration(Boolean estimatedDuration) {
        this.estimatedDuration = estimatedDuration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskBaseline taskBaseline = (TaskBaseline)o;
        return Objects.equals(this.start, taskBaseline.start) && Objects.equals(this.finish, taskBaseline.finish) && Objects.equals(this.duration, taskBaseline.duration) && Objects.equals(this.fixedCost, taskBaseline.fixedCost) && Objects.equals((Object)this.durationFormat, (Object)taskBaseline.durationFormat) && Objects.equals(this.estimatedDuration, taskBaseline.estimatedDuration) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.start, this.finish, this.duration, this.fixedCost, this.durationFormat, this.estimatedDuration, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaskBaseline {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    finish: ").append(this.toIndentedString(this.finish)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    fixedCost: ").append(this.toIndentedString(this.fixedCost)).append("\n");
        sb.append("    durationFormat: ").append(this.toIndentedString((Object)this.durationFormat)).append("\n");
        sb.append("    estimatedDuration: ").append(this.toIndentedString(this.estimatedDuration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

