/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.VbaModule;
import com.aspose.tasks.cloud.model.VbaReference;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents VbaProject")
public class VbaProject {
    @SerializedName(value="CompilationArguments")
    private String compilationArguments = null;
    @SerializedName(value="Description")
    private String description = null;
    @SerializedName(value="HelpContextId")
    private Integer helpContextId = null;
    @SerializedName(value="HelpFile")
    private String helpFile = null;
    @SerializedName(value="Modules")
    private List<VbaModule> modules = null;
    @SerializedName(value="Name")
    private String name = null;
    @SerializedName(value="References")
    private List<VbaReference> references = null;

    public VbaProject compilationArguments(String compilationArguments) {
        this.compilationArguments = compilationArguments;
        return this;
    }

    @ApiModelProperty(value="Gets conditional Compilation Arguments")
    public String getCompilationArguments() {
        return this.compilationArguments;
    }

    public void setCompilationArguments(String compilationArguments) {
        this.compilationArguments = compilationArguments;
    }

    public VbaProject description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Gets a project Description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public VbaProject helpContextId(Integer helpContextId) {
        this.helpContextId = helpContextId;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets a project Help Context Id")
    public Integer getHelpContextId() {
        return this.helpContextId;
    }

    public void setHelpContextId(Integer helpContextId) {
        this.helpContextId = helpContextId;
    }

    public VbaProject helpFile(String helpFile) {
        this.helpFile = helpFile;
        return this;
    }

    @ApiModelProperty(value="Gets a help file name")
    public String getHelpFile() {
        return this.helpFile;
    }

    public void setHelpFile(String helpFile) {
        this.helpFile = helpFile;
    }

    public VbaProject modules(List<VbaModule> modules) {
        this.modules = modules;
        return this;
    }

    public VbaProject addModulesItem(VbaModule modulesItem) {
        if (this.modules == null) {
            this.modules = new ArrayList<VbaModule>();
        }
        this.modules.add(modulesItem);
        return this;
    }

    @ApiModelProperty(value="Gets a collection of VbaModuleCollection")
    public List<VbaModule> getModules() {
        return this.modules;
    }

    public void setModules(List<VbaModule> modules) {
        this.modules = modules;
    }

    public VbaProject name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Gets project name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VbaProject references(List<VbaReference> references) {
        this.references = references;
        return this;
    }

    public VbaProject addReferencesItem(VbaReference referencesItem) {
        if (this.references == null) {
            this.references = new ArrayList<VbaReference>();
        }
        this.references.add(referencesItem);
        return this;
    }

    @ApiModelProperty(value="Gets a collection of VbaReferenceCollection")
    public List<VbaReference> getReferences() {
        return this.references;
    }

    public void setReferences(List<VbaReference> references) {
        this.references = references;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VbaProject vbaProject = (VbaProject)o;
        return Objects.equals(this.compilationArguments, vbaProject.compilationArguments) && Objects.equals(this.description, vbaProject.description) && Objects.equals(this.helpContextId, vbaProject.helpContextId) && Objects.equals(this.helpFile, vbaProject.helpFile) && Objects.equals(this.modules, vbaProject.modules) && Objects.equals(this.name, vbaProject.name) && Objects.equals(this.references, vbaProject.references);
    }

    public int hashCode() {
        return Objects.hash(this.compilationArguments, this.description, this.helpContextId, this.helpFile, this.modules, this.name, this.references);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VbaProject {\n");
        sb.append("    compilationArguments: ").append(this.toIndentedString(this.compilationArguments)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    helpContextId: ").append(this.toIndentedString(this.helpContextId)).append("\n");
        sb.append("    helpFile: ").append(this.toIndentedString(this.helpFile)).append("\n");
        sb.append("    modules: ").append(this.toIndentedString(this.modules)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    references: ").append(this.toIndentedString(this.references)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

