/*
 * --------------------------------------------------------------------------------
 * <copyright company="Aspose" file="WordsApi.java">
 *   Copyright (c) 2025 Aspose.Words for Cloud
 * </copyright>
 * <summary>
 *   Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 * 
 *  The above copyright notice and this permission notice shall be included in all
 *  copies or substantial portions of the Software.
 * 
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 *  SOFTWARE.
 * </summary>
 * --------------------------------------------------------------------------------
 */

package com.aspose.words.cloud.api;

import com.aspose.words.cloud.*;
import com.aspose.words.cloud.model.*;
import com.aspose.words.cloud.model.requests.*;
import com.aspose.words.cloud.model.responses.*;
import com.squareup.okhttp.Response;
import java.io.IOException;
import jakarta.mail.BodyPart;
import javax.crypto.Cipher;
import jakarta.mail.MessagingException;
import java.lang.reflect.Type;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.*;
import java.io.File;

public class WordsApi implements EncryptorFactory {
    private ApiClient apiClient;

    public WordsApi(String clientId, String clientSecret, String baseUrl) {
        this(new ApiClient(clientId, clientSecret, baseUrl));
    }

    public WordsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WordsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.apiClient.setEncryptorProvider(this);
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call acceptAllRevisionsValidateBeforeCall(AcceptAllRevisionsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Accepts all the revisions in the document.
     * @param request Request object
     * @return RevisionsModificationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public RevisionsModificationResponse acceptAllRevisions(AcceptAllRevisionsRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< RevisionsModificationResponse > resp = acceptAllRevisionsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< RevisionsModificationResponse > resp = acceptAllRevisionsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Accepts all the revisions in the document.
     * @param request Request object
     * @return ApiResponse< RevisionsModificationResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< RevisionsModificationResponse > acceptAllRevisionsWithHttpInfo(AcceptAllRevisionsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = acceptAllRevisionsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Accepts all the revisions in the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call acceptAllRevisionsAsync(AcceptAllRevisionsRequest request, final ApiCallback< RevisionsModificationResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = acceptAllRevisionsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call acceptAllRevisionsOnlineValidateBeforeCall(AcceptAllRevisionsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Accepts all the revisions in the document.
     * @param request Request object
     * @return AcceptAllRevisionsOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public AcceptAllRevisionsOnlineResponse acceptAllRevisionsOnline(AcceptAllRevisionsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< AcceptAllRevisionsOnlineResponse > resp = acceptAllRevisionsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< AcceptAllRevisionsOnlineResponse > resp = acceptAllRevisionsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Accepts all the revisions in the document.
     * @param request Request object
     * @return ApiResponse< AcceptAllRevisionsOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< AcceptAllRevisionsOnlineResponse > acceptAllRevisionsOnlineWithHttpInfo(AcceptAllRevisionsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = acceptAllRevisionsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Accepts all the revisions in the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call acceptAllRevisionsOnlineAsync(AcceptAllRevisionsOnlineRequest request, final ApiCallback< AcceptAllRevisionsOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = acceptAllRevisionsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call appendDocumentValidateBeforeCall(AppendDocumentRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Appends documents to the original document.
     * @param request Request object
     * @return DocumentResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DocumentResponse appendDocument(AppendDocumentRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DocumentResponse > resp = appendDocumentWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DocumentResponse > resp = appendDocumentWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Appends documents to the original document.
     * @param request Request object
     * @return ApiResponse< DocumentResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DocumentResponse > appendDocumentWithHttpInfo(AppendDocumentRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = appendDocumentValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Appends documents to the original document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call appendDocumentAsync(AppendDocumentRequest request, final ApiCallback< DocumentResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = appendDocumentValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call appendDocumentOnlineValidateBeforeCall(AppendDocumentOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Appends documents to the original document.
     * @param request Request object
     * @return AppendDocumentOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public AppendDocumentOnlineResponse appendDocumentOnline(AppendDocumentOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< AppendDocumentOnlineResponse > resp = appendDocumentOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< AppendDocumentOnlineResponse > resp = appendDocumentOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Appends documents to the original document.
     * @param request Request object
     * @return ApiResponse< AppendDocumentOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< AppendDocumentOnlineResponse > appendDocumentOnlineWithHttpInfo(AppendDocumentOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = appendDocumentOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Appends documents to the original document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call appendDocumentOnlineAsync(AppendDocumentOnlineRequest request, final ApiCallback< AppendDocumentOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = appendDocumentOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call applyStyleToDocumentElementValidateBeforeCall(ApplyStyleToDocumentElementRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Applies a style to the document node.
     * @param request Request object
     * @return WordsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public WordsResponse applyStyleToDocumentElement(ApplyStyleToDocumentElementRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< WordsResponse > resp = applyStyleToDocumentElementWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< WordsResponse > resp = applyStyleToDocumentElementWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Applies a style to the document node.
     * @param request Request object
     * @return ApiResponse< WordsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< WordsResponse > applyStyleToDocumentElementWithHttpInfo(ApplyStyleToDocumentElementRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = applyStyleToDocumentElementValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Applies a style to the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call applyStyleToDocumentElementAsync(ApplyStyleToDocumentElementRequest request, final ApiCallback< WordsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = applyStyleToDocumentElementValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call applyStyleToDocumentElementOnlineValidateBeforeCall(ApplyStyleToDocumentElementOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Applies a style to the document node.
     * @param request Request object
     * @return ApplyStyleToDocumentElementOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ApplyStyleToDocumentElementOnlineResponse applyStyleToDocumentElementOnline(ApplyStyleToDocumentElementOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ApplyStyleToDocumentElementOnlineResponse > resp = applyStyleToDocumentElementOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ApplyStyleToDocumentElementOnlineResponse > resp = applyStyleToDocumentElementOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Applies a style to the document node.
     * @param request Request object
     * @return ApiResponse< ApplyStyleToDocumentElementOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ApplyStyleToDocumentElementOnlineResponse > applyStyleToDocumentElementOnlineWithHttpInfo(ApplyStyleToDocumentElementOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = applyStyleToDocumentElementOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Applies a style to the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call applyStyleToDocumentElementOnlineAsync(ApplyStyleToDocumentElementOnlineRequest request, final ApiCallback< ApplyStyleToDocumentElementOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = applyStyleToDocumentElementOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call buildReportValidateBeforeCall(BuildReportRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Executes the report generation process using the specified document template and the external data source in XML, JSON or CSV format.
     * @param request Request object
     * @return DocumentResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DocumentResponse buildReport(BuildReportRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DocumentResponse > resp = buildReportWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DocumentResponse > resp = buildReportWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Executes the report generation process using the specified document template and the external data source in XML, JSON or CSV format.
     * @param request Request object
     * @return ApiResponse< DocumentResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DocumentResponse > buildReportWithHttpInfo(BuildReportRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = buildReportValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Executes the report generation process using the specified document template and the external data source in XML, JSON or CSV format. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call buildReportAsync(BuildReportRequest request, final ApiCallback< DocumentResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = buildReportValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call buildReportOnlineValidateBeforeCall(BuildReportOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Executes the report generation process online using the specified document template and the external data source in XML, JSON or CSV format.
     * @param request Request object
     * @return byte[]
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public byte[] buildReportOnline(BuildReportOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< byte[] > resp = buildReportOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< byte[] > resp = buildReportOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Executes the report generation process online using the specified document template and the external data source in XML, JSON or CSV format.
     * @param request Request object
     * @return ApiResponse< byte[] >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< byte[] > buildReportOnlineWithHttpInfo(BuildReportOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = buildReportOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Executes the report generation process online using the specified document template and the external data source in XML, JSON or CSV format. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call buildReportOnlineAsync(BuildReportOnlineRequest request, final ApiCallback< byte[] > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = buildReportOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call classifyValidateBeforeCall(ClassifyRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Runs a multi-class text classification for the specified raw text.
     * @param request Request object
     * @return ClassificationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ClassificationResponse classify(ClassifyRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ClassificationResponse > resp = classifyWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ClassificationResponse > resp = classifyWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Runs a multi-class text classification for the specified raw text.
     * @param request Request object
     * @return ApiResponse< ClassificationResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ClassificationResponse > classifyWithHttpInfo(ClassifyRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = classifyValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Runs a multi-class text classification for the specified raw text. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call classifyAsync(ClassifyRequest request, final ApiCallback< ClassificationResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = classifyValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call classifyDocumentValidateBeforeCall(ClassifyDocumentRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Runs a multi-class text classification for the document.
     * @param request Request object
     * @return ClassificationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ClassificationResponse classifyDocument(ClassifyDocumentRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ClassificationResponse > resp = classifyDocumentWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ClassificationResponse > resp = classifyDocumentWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Runs a multi-class text classification for the document.
     * @param request Request object
     * @return ApiResponse< ClassificationResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ClassificationResponse > classifyDocumentWithHttpInfo(ClassifyDocumentRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = classifyDocumentValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Runs a multi-class text classification for the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call classifyDocumentAsync(ClassifyDocumentRequest request, final ApiCallback< ClassificationResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = classifyDocumentValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call classifyDocumentOnlineValidateBeforeCall(ClassifyDocumentOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Runs a multi-class text classification for the document.
     * @param request Request object
     * @return ClassificationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ClassificationResponse classifyDocumentOnline(ClassifyDocumentOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ClassificationResponse > resp = classifyDocumentOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ClassificationResponse > resp = classifyDocumentOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Runs a multi-class text classification for the document.
     * @param request Request object
     * @return ApiResponse< ClassificationResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ClassificationResponse > classifyDocumentOnlineWithHttpInfo(ClassifyDocumentOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = classifyDocumentOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Runs a multi-class text classification for the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call classifyDocumentOnlineAsync(ClassifyDocumentOnlineRequest request, final ApiCallback< ClassificationResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = classifyDocumentOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call compareDocumentValidateBeforeCall(CompareDocumentRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Compares two documents.
     * @param request Request object
     * @return DocumentResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DocumentResponse compareDocument(CompareDocumentRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DocumentResponse > resp = compareDocumentWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DocumentResponse > resp = compareDocumentWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Compares two documents.
     * @param request Request object
     * @return ApiResponse< DocumentResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DocumentResponse > compareDocumentWithHttpInfo(CompareDocumentRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = compareDocumentValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Compares two documents. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call compareDocumentAsync(CompareDocumentRequest request, final ApiCallback< DocumentResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = compareDocumentValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call compareDocumentOnlineValidateBeforeCall(CompareDocumentOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Compares two documents.
     * @param request Request object
     * @return CompareDocumentOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public CompareDocumentOnlineResponse compareDocumentOnline(CompareDocumentOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< CompareDocumentOnlineResponse > resp = compareDocumentOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< CompareDocumentOnlineResponse > resp = compareDocumentOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Compares two documents.
     * @param request Request object
     * @return ApiResponse< CompareDocumentOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< CompareDocumentOnlineResponse > compareDocumentOnlineWithHttpInfo(CompareDocumentOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = compareDocumentOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Compares two documents. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call compareDocumentOnlineAsync(CompareDocumentOnlineRequest request, final ApiCallback< CompareDocumentOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = compareDocumentOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call compressDocumentValidateBeforeCall(CompressDocumentRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Compress and resize images inside the document.
     * The default settings allows to reduce the size of the document without any visible degradation of images quality.
     * @param request Request object
     * @return CompressResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public CompressResponse compressDocument(CompressDocumentRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< CompressResponse > resp = compressDocumentWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< CompressResponse > resp = compressDocumentWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Compress and resize images inside the document.
     * The default settings allows to reduce the size of the document without any visible degradation of images quality.
     * @param request Request object
     * @return ApiResponse< CompressResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< CompressResponse > compressDocumentWithHttpInfo(CompressDocumentRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = compressDocumentValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Compress and resize images inside the document.
     * The default settings allows to reduce the size of the document without any visible degradation of images quality. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call compressDocumentAsync(CompressDocumentRequest request, final ApiCallback< CompressResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = compressDocumentValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call compressDocumentOnlineValidateBeforeCall(CompressDocumentOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Compress and resize images inside the document.
     * The default settings allows to reduce the size of the document without any visible degradation of images quality.
     * @param request Request object
     * @return CompressDocumentOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public CompressDocumentOnlineResponse compressDocumentOnline(CompressDocumentOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< CompressDocumentOnlineResponse > resp = compressDocumentOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< CompressDocumentOnlineResponse > resp = compressDocumentOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Compress and resize images inside the document.
     * The default settings allows to reduce the size of the document without any visible degradation of images quality.
     * @param request Request object
     * @return ApiResponse< CompressDocumentOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< CompressDocumentOnlineResponse > compressDocumentOnlineWithHttpInfo(CompressDocumentOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = compressDocumentOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Compress and resize images inside the document.
     * The default settings allows to reduce the size of the document without any visible degradation of images quality. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call compressDocumentOnlineAsync(CompressDocumentOnlineRequest request, final ApiCallback< CompressDocumentOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = compressDocumentOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call convertDocumentValidateBeforeCall(ConvertDocumentRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Converts a document on a local drive to the specified format.
     * @param request Request object
     * @return byte[]
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public byte[] convertDocument(ConvertDocumentRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< byte[] > resp = convertDocumentWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< byte[] > resp = convertDocumentWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Converts a document on a local drive to the specified format.
     * @param request Request object
     * @return ApiResponse< byte[] >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< byte[] > convertDocumentWithHttpInfo(ConvertDocumentRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = convertDocumentValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Converts a document on a local drive to the specified format. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call convertDocumentAsync(ConvertDocumentRequest request, final ApiCallback< byte[] > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = convertDocumentValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call copyFileValidateBeforeCall(CopyFileRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Copy file.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void copyFile(CopyFileRequest request) throws ApiException, MessagingException, IOException {
        try {
    copyFileWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    copyFileWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Copy file.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > copyFileWithHttpInfo(CopyFileRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = copyFileValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Copy file. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call copyFileAsync(CopyFileRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = copyFileValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call copyFolderValidateBeforeCall(CopyFolderRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Copy folder.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void copyFolder(CopyFolderRequest request) throws ApiException, MessagingException, IOException {
        try {
    copyFolderWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    copyFolderWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Copy folder.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > copyFolderWithHttpInfo(CopyFolderRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = copyFolderValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Copy folder. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call copyFolderAsync(CopyFolderRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = copyFolderValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call copyStyleValidateBeforeCall(CopyStyleRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Makes a copy of the style in the document.
     * @param request Request object
     * @return StyleResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public StyleResponse copyStyle(CopyStyleRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< StyleResponse > resp = copyStyleWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< StyleResponse > resp = copyStyleWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Makes a copy of the style in the document.
     * @param request Request object
     * @return ApiResponse< StyleResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< StyleResponse > copyStyleWithHttpInfo(CopyStyleRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = copyStyleValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Makes a copy of the style in the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call copyStyleAsync(CopyStyleRequest request, final ApiCallback< StyleResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = copyStyleValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call copyStyleOnlineValidateBeforeCall(CopyStyleOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Makes a copy of the style in the document.
     * @param request Request object
     * @return CopyStyleOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public CopyStyleOnlineResponse copyStyleOnline(CopyStyleOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< CopyStyleOnlineResponse > resp = copyStyleOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< CopyStyleOnlineResponse > resp = copyStyleOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Makes a copy of the style in the document.
     * @param request Request object
     * @return ApiResponse< CopyStyleOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< CopyStyleOnlineResponse > copyStyleOnlineWithHttpInfo(CopyStyleOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = copyStyleOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Makes a copy of the style in the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call copyStyleOnlineAsync(CopyStyleOnlineRequest request, final ApiCallback< CopyStyleOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = copyStyleOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call copyStylesFromTemplateValidateBeforeCall(CopyStylesFromTemplateRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Copies styles from the origin document to the target document.
     * @param request Request object
     * @return WordsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public WordsResponse copyStylesFromTemplate(CopyStylesFromTemplateRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< WordsResponse > resp = copyStylesFromTemplateWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< WordsResponse > resp = copyStylesFromTemplateWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Copies styles from the origin document to the target document.
     * @param request Request object
     * @return ApiResponse< WordsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< WordsResponse > copyStylesFromTemplateWithHttpInfo(CopyStylesFromTemplateRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = copyStylesFromTemplateValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Copies styles from the origin document to the target document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call copyStylesFromTemplateAsync(CopyStylesFromTemplateRequest request, final ApiCallback< WordsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = copyStylesFromTemplateValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createDocumentValidateBeforeCall(CreateDocumentRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Creates a new document in cloud storage in the format, determined by the file extension.
     * Supported all save format extensions.
     * @param request Request object
     * @return DocumentResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DocumentResponse createDocument(CreateDocumentRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DocumentResponse > resp = createDocumentWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DocumentResponse > resp = createDocumentWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Creates a new document in cloud storage in the format, determined by the file extension.
     * Supported all save format extensions.
     * @param request Request object
     * @return ApiResponse< DocumentResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DocumentResponse > createDocumentWithHttpInfo(CreateDocumentRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = createDocumentValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Creates a new document in cloud storage in the format, determined by the file extension.
     * Supported all save format extensions. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createDocumentAsync(CreateDocumentRequest request, final ApiCallback< DocumentResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createDocumentValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createFolderValidateBeforeCall(CreateFolderRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Create the folder.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void createFolder(CreateFolderRequest request) throws ApiException, MessagingException, IOException {
        try {
    createFolderWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    createFolderWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Create the folder.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > createFolderWithHttpInfo(CreateFolderRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = createFolderValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Create the folder. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createFolderAsync(CreateFolderRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createFolderValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createOrUpdateDocumentPropertyValidateBeforeCall(CreateOrUpdateDocumentPropertyRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Adds a new or updates an existing document property.
     * @param request Request object
     * @return DocumentPropertyResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DocumentPropertyResponse createOrUpdateDocumentProperty(CreateOrUpdateDocumentPropertyRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DocumentPropertyResponse > resp = createOrUpdateDocumentPropertyWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DocumentPropertyResponse > resp = createOrUpdateDocumentPropertyWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Adds a new or updates an existing document property.
     * @param request Request object
     * @return ApiResponse< DocumentPropertyResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DocumentPropertyResponse > createOrUpdateDocumentPropertyWithHttpInfo(CreateOrUpdateDocumentPropertyRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = createOrUpdateDocumentPropertyValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Adds a new or updates an existing document property. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createOrUpdateDocumentPropertyAsync(CreateOrUpdateDocumentPropertyRequest request, final ApiCallback< DocumentPropertyResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createOrUpdateDocumentPropertyValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createOrUpdateDocumentPropertyOnlineValidateBeforeCall(CreateOrUpdateDocumentPropertyOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Adds a new or updates an existing document property.
     * @param request Request object
     * @return CreateOrUpdateDocumentPropertyOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public CreateOrUpdateDocumentPropertyOnlineResponse createOrUpdateDocumentPropertyOnline(CreateOrUpdateDocumentPropertyOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< CreateOrUpdateDocumentPropertyOnlineResponse > resp = createOrUpdateDocumentPropertyOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< CreateOrUpdateDocumentPropertyOnlineResponse > resp = createOrUpdateDocumentPropertyOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Adds a new or updates an existing document property.
     * @param request Request object
     * @return ApiResponse< CreateOrUpdateDocumentPropertyOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< CreateOrUpdateDocumentPropertyOnlineResponse > createOrUpdateDocumentPropertyOnlineWithHttpInfo(CreateOrUpdateDocumentPropertyOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = createOrUpdateDocumentPropertyOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Adds a new or updates an existing document property. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createOrUpdateDocumentPropertyOnlineAsync(CreateOrUpdateDocumentPropertyOnlineRequest request, final ApiCallback< CreateOrUpdateDocumentPropertyOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createOrUpdateDocumentPropertyOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteAllParagraphTabStopsValidateBeforeCall(DeleteAllParagraphTabStopsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes paragraph tab stops from the document node.
     * @param request Request object
     * @return TabStopsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TabStopsResponse deleteAllParagraphTabStops(DeleteAllParagraphTabStopsRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TabStopsResponse > resp = deleteAllParagraphTabStopsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TabStopsResponse > resp = deleteAllParagraphTabStopsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes paragraph tab stops from the document node.
     * @param request Request object
     * @return ApiResponse< TabStopsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TabStopsResponse > deleteAllParagraphTabStopsWithHttpInfo(DeleteAllParagraphTabStopsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteAllParagraphTabStopsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes paragraph tab stops from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteAllParagraphTabStopsAsync(DeleteAllParagraphTabStopsRequest request, final ApiCallback< TabStopsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteAllParagraphTabStopsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteAllParagraphTabStopsOnlineValidateBeforeCall(DeleteAllParagraphTabStopsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes paragraph tab stops from the document node.
     * @param request Request object
     * @return DeleteAllParagraphTabStopsOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DeleteAllParagraphTabStopsOnlineResponse deleteAllParagraphTabStopsOnline(DeleteAllParagraphTabStopsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DeleteAllParagraphTabStopsOnlineResponse > resp = deleteAllParagraphTabStopsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DeleteAllParagraphTabStopsOnlineResponse > resp = deleteAllParagraphTabStopsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes paragraph tab stops from the document node.
     * @param request Request object
     * @return ApiResponse< DeleteAllParagraphTabStopsOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DeleteAllParagraphTabStopsOnlineResponse > deleteAllParagraphTabStopsOnlineWithHttpInfo(DeleteAllParagraphTabStopsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteAllParagraphTabStopsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes paragraph tab stops from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteAllParagraphTabStopsOnlineAsync(DeleteAllParagraphTabStopsOnlineRequest request, final ApiCallback< DeleteAllParagraphTabStopsOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteAllParagraphTabStopsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteBookmarkValidateBeforeCall(DeleteBookmarkRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a bookmark from the document.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteBookmark(DeleteBookmarkRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteBookmarkWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteBookmarkWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes a bookmark from the document.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteBookmarkWithHttpInfo(DeleteBookmarkRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteBookmarkValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a bookmark from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteBookmarkAsync(DeleteBookmarkRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteBookmarkValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteBookmarkOnlineValidateBeforeCall(DeleteBookmarkOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a bookmark from the document.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteBookmarkOnline(DeleteBookmarkOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteBookmarkOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteBookmarkOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a bookmark from the document.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteBookmarkOnlineWithHttpInfo(DeleteBookmarkOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteBookmarkOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a bookmark from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteBookmarkOnlineAsync(DeleteBookmarkOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteBookmarkOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteBookmarksValidateBeforeCall(DeleteBookmarksRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes all bookmarks from the document.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteBookmarks(DeleteBookmarksRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteBookmarksWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteBookmarksWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes all bookmarks from the document.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteBookmarksWithHttpInfo(DeleteBookmarksRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteBookmarksValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes all bookmarks from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteBookmarksAsync(DeleteBookmarksRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteBookmarksValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteBookmarksOnlineValidateBeforeCall(DeleteBookmarksOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes all bookmarks from the document.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteBookmarksOnline(DeleteBookmarksOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteBookmarksOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteBookmarksOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes all bookmarks from the document.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteBookmarksOnlineWithHttpInfo(DeleteBookmarksOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteBookmarksOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes all bookmarks from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteBookmarksOnlineAsync(DeleteBookmarksOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteBookmarksOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteBorderValidateBeforeCall(DeleteBorderRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a border from the document node.
     * The 'nodePath' parameter should refer to a paragraph, a cell or a row.
     * @param request Request object
     * @return BorderResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public BorderResponse deleteBorder(DeleteBorderRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< BorderResponse > resp = deleteBorderWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< BorderResponse > resp = deleteBorderWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a border from the document node.
     * The 'nodePath' parameter should refer to a paragraph, a cell or a row.
     * @param request Request object
     * @return ApiResponse< BorderResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< BorderResponse > deleteBorderWithHttpInfo(DeleteBorderRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteBorderValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a border from the document node.
     * The 'nodePath' parameter should refer to a paragraph, a cell or a row. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteBorderAsync(DeleteBorderRequest request, final ApiCallback< BorderResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteBorderValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteBorderOnlineValidateBeforeCall(DeleteBorderOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a border from the document node.
     * The 'nodePath' parameter should refer to a paragraph, a cell or a row.
     * @param request Request object
     * @return DeleteBorderOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DeleteBorderOnlineResponse deleteBorderOnline(DeleteBorderOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DeleteBorderOnlineResponse > resp = deleteBorderOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DeleteBorderOnlineResponse > resp = deleteBorderOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a border from the document node.
     * The 'nodePath' parameter should refer to a paragraph, a cell or a row.
     * @param request Request object
     * @return ApiResponse< DeleteBorderOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DeleteBorderOnlineResponse > deleteBorderOnlineWithHttpInfo(DeleteBorderOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteBorderOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a border from the document node.
     * The 'nodePath' parameter should refer to a paragraph, a cell or a row. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteBorderOnlineAsync(DeleteBorderOnlineRequest request, final ApiCallback< DeleteBorderOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteBorderOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteBordersValidateBeforeCall(DeleteBordersRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes borders from the document node.
     * The 'nodePath' parameter should refer to a paragraph, a cell or a row.
     * @param request Request object
     * @return BordersResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public BordersResponse deleteBorders(DeleteBordersRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< BordersResponse > resp = deleteBordersWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< BordersResponse > resp = deleteBordersWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes borders from the document node.
     * The 'nodePath' parameter should refer to a paragraph, a cell or a row.
     * @param request Request object
     * @return ApiResponse< BordersResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< BordersResponse > deleteBordersWithHttpInfo(DeleteBordersRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteBordersValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes borders from the document node.
     * The 'nodePath' parameter should refer to a paragraph, a cell or a row. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteBordersAsync(DeleteBordersRequest request, final ApiCallback< BordersResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteBordersValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteBordersOnlineValidateBeforeCall(DeleteBordersOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes borders from the document node.
     * The 'nodePath' parameter should refer to a paragraph, a cell or a row.
     * @param request Request object
     * @return DeleteBordersOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DeleteBordersOnlineResponse deleteBordersOnline(DeleteBordersOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DeleteBordersOnlineResponse > resp = deleteBordersOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DeleteBordersOnlineResponse > resp = deleteBordersOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes borders from the document node.
     * The 'nodePath' parameter should refer to a paragraph, a cell or a row.
     * @param request Request object
     * @return ApiResponse< DeleteBordersOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DeleteBordersOnlineResponse > deleteBordersOnlineWithHttpInfo(DeleteBordersOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteBordersOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes borders from the document node.
     * The 'nodePath' parameter should refer to a paragraph, a cell or a row. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteBordersOnlineAsync(DeleteBordersOnlineRequest request, final ApiCallback< DeleteBordersOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteBordersOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteCommentValidateBeforeCall(DeleteCommentRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a comment from the document.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteComment(DeleteCommentRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteCommentWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteCommentWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes a comment from the document.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteCommentWithHttpInfo(DeleteCommentRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteCommentValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a comment from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteCommentAsync(DeleteCommentRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteCommentValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteCommentOnlineValidateBeforeCall(DeleteCommentOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a comment from the document.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteCommentOnline(DeleteCommentOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteCommentOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteCommentOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a comment from the document.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteCommentOnlineWithHttpInfo(DeleteCommentOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteCommentOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a comment from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteCommentOnlineAsync(DeleteCommentOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteCommentOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteCommentsValidateBeforeCall(DeleteCommentsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes all comments from the document.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteComments(DeleteCommentsRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteCommentsWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteCommentsWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes all comments from the document.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteCommentsWithHttpInfo(DeleteCommentsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteCommentsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes all comments from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteCommentsAsync(DeleteCommentsRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteCommentsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteCommentsOnlineValidateBeforeCall(DeleteCommentsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes all comments from the document.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteCommentsOnline(DeleteCommentsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteCommentsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteCommentsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes all comments from the document.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteCommentsOnlineWithHttpInfo(DeleteCommentsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteCommentsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes all comments from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteCommentsOnlineAsync(DeleteCommentsOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteCommentsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteCustomXmlPartValidateBeforeCall(DeleteCustomXmlPartRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes the custom xml part from the document.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteCustomXmlPart(DeleteCustomXmlPartRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteCustomXmlPartWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteCustomXmlPartWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes the custom xml part from the document.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteCustomXmlPartWithHttpInfo(DeleteCustomXmlPartRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteCustomXmlPartValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes the custom xml part from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteCustomXmlPartAsync(DeleteCustomXmlPartRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteCustomXmlPartValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteCustomXmlPartOnlineValidateBeforeCall(DeleteCustomXmlPartOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes the custom xml part from the document.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteCustomXmlPartOnline(DeleteCustomXmlPartOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteCustomXmlPartOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteCustomXmlPartOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes the custom xml part from the document.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteCustomXmlPartOnlineWithHttpInfo(DeleteCustomXmlPartOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteCustomXmlPartOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes the custom xml part from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteCustomXmlPartOnlineAsync(DeleteCustomXmlPartOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteCustomXmlPartOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteCustomXmlPartsValidateBeforeCall(DeleteCustomXmlPartsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes all custom xml parts from the document.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteCustomXmlParts(DeleteCustomXmlPartsRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteCustomXmlPartsWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteCustomXmlPartsWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes all custom xml parts from the document.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteCustomXmlPartsWithHttpInfo(DeleteCustomXmlPartsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteCustomXmlPartsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes all custom xml parts from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteCustomXmlPartsAsync(DeleteCustomXmlPartsRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteCustomXmlPartsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteCustomXmlPartsOnlineValidateBeforeCall(DeleteCustomXmlPartsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes all custom xml parts from the document.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteCustomXmlPartsOnline(DeleteCustomXmlPartsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteCustomXmlPartsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteCustomXmlPartsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes all custom xml parts from the document.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteCustomXmlPartsOnlineWithHttpInfo(DeleteCustomXmlPartsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteCustomXmlPartsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes all custom xml parts from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteCustomXmlPartsOnlineAsync(DeleteCustomXmlPartsOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteCustomXmlPartsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteDocumentPropertyValidateBeforeCall(DeleteDocumentPropertyRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a document property.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteDocumentProperty(DeleteDocumentPropertyRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteDocumentPropertyWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteDocumentPropertyWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes a document property.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteDocumentPropertyWithHttpInfo(DeleteDocumentPropertyRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteDocumentPropertyValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a document property. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteDocumentPropertyAsync(DeleteDocumentPropertyRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteDocumentPropertyValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteDocumentPropertyOnlineValidateBeforeCall(DeleteDocumentPropertyOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a document property.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteDocumentPropertyOnline(DeleteDocumentPropertyOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteDocumentPropertyOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteDocumentPropertyOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a document property.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteDocumentPropertyOnlineWithHttpInfo(DeleteDocumentPropertyOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteDocumentPropertyOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a document property. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteDocumentPropertyOnlineAsync(DeleteDocumentPropertyOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteDocumentPropertyOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteDrawingObjectValidateBeforeCall(DeleteDrawingObjectRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a DrawingObject from the document node.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteDrawingObject(DeleteDrawingObjectRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteDrawingObjectWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteDrawingObjectWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes a DrawingObject from the document node.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteDrawingObjectWithHttpInfo(DeleteDrawingObjectRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteDrawingObjectValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a DrawingObject from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteDrawingObjectAsync(DeleteDrawingObjectRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteDrawingObjectValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteDrawingObjectOnlineValidateBeforeCall(DeleteDrawingObjectOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a DrawingObject from the document node.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteDrawingObjectOnline(DeleteDrawingObjectOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteDrawingObjectOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteDrawingObjectOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a DrawingObject from the document node.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteDrawingObjectOnlineWithHttpInfo(DeleteDrawingObjectOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteDrawingObjectOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a DrawingObject from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteDrawingObjectOnlineAsync(DeleteDrawingObjectOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteDrawingObjectOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteFieldValidateBeforeCall(DeleteFieldRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a field from the document node.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteField(DeleteFieldRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteFieldWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteFieldWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes a field from the document node.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteFieldWithHttpInfo(DeleteFieldRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteFieldValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a field from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteFieldAsync(DeleteFieldRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteFieldValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteFieldOnlineValidateBeforeCall(DeleteFieldOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a field from the document node.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteFieldOnline(DeleteFieldOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteFieldOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteFieldOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a field from the document node.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteFieldOnlineWithHttpInfo(DeleteFieldOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteFieldOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a field from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteFieldOnlineAsync(DeleteFieldOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteFieldOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteFieldsValidateBeforeCall(DeleteFieldsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes fields from the document node.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteFields(DeleteFieldsRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteFieldsWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteFieldsWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes fields from the document node.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteFieldsWithHttpInfo(DeleteFieldsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteFieldsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes fields from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteFieldsAsync(DeleteFieldsRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteFieldsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteFieldsOnlineValidateBeforeCall(DeleteFieldsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes fields from the document node.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteFieldsOnline(DeleteFieldsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteFieldsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteFieldsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes fields from the document node.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteFieldsOnlineWithHttpInfo(DeleteFieldsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteFieldsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes fields from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteFieldsOnlineAsync(DeleteFieldsOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteFieldsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteFileValidateBeforeCall(DeleteFileRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Delete file.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteFile(DeleteFileRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteFileWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteFileWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Delete file.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteFileWithHttpInfo(DeleteFileRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteFileValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Delete file. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteFileAsync(DeleteFileRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteFileValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteFolderValidateBeforeCall(DeleteFolderRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Delete folder.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteFolder(DeleteFolderRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteFolderWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteFolderWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Delete folder.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteFolderWithHttpInfo(DeleteFolderRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteFolderValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Delete folder. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteFolderAsync(DeleteFolderRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteFolderValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteFootnoteValidateBeforeCall(DeleteFootnoteRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a footnote from the document node.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteFootnote(DeleteFootnoteRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteFootnoteWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteFootnoteWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes a footnote from the document node.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteFootnoteWithHttpInfo(DeleteFootnoteRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteFootnoteValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a footnote from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteFootnoteAsync(DeleteFootnoteRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteFootnoteValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteFootnoteOnlineValidateBeforeCall(DeleteFootnoteOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a footnote from the document node.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteFootnoteOnline(DeleteFootnoteOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteFootnoteOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteFootnoteOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a footnote from the document node.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteFootnoteOnlineWithHttpInfo(DeleteFootnoteOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteFootnoteOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a footnote from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteFootnoteOnlineAsync(DeleteFootnoteOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteFootnoteOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteFormFieldValidateBeforeCall(DeleteFormFieldRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a form field from the document node.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteFormField(DeleteFormFieldRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteFormFieldWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteFormFieldWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes a form field from the document node.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteFormFieldWithHttpInfo(DeleteFormFieldRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteFormFieldValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a form field from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteFormFieldAsync(DeleteFormFieldRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteFormFieldValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteFormFieldOnlineValidateBeforeCall(DeleteFormFieldOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a form field from the document node.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteFormFieldOnline(DeleteFormFieldOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteFormFieldOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteFormFieldOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a form field from the document node.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteFormFieldOnlineWithHttpInfo(DeleteFormFieldOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteFormFieldOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a form field from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteFormFieldOnlineAsync(DeleteFormFieldOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteFormFieldOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteHeaderFooterValidateBeforeCall(DeleteHeaderFooterRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a HeaderFooter object from the document section.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteHeaderFooter(DeleteHeaderFooterRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteHeaderFooterWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteHeaderFooterWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes a HeaderFooter object from the document section.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteHeaderFooterWithHttpInfo(DeleteHeaderFooterRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteHeaderFooterValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a HeaderFooter object from the document section. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteHeaderFooterAsync(DeleteHeaderFooterRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteHeaderFooterValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteHeaderFooterOnlineValidateBeforeCall(DeleteHeaderFooterOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a HeaderFooter object from the document section.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteHeaderFooterOnline(DeleteHeaderFooterOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteHeaderFooterOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteHeaderFooterOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a HeaderFooter object from the document section.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteHeaderFooterOnlineWithHttpInfo(DeleteHeaderFooterOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteHeaderFooterOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a HeaderFooter object from the document section. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteHeaderFooterOnlineAsync(DeleteHeaderFooterOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteHeaderFooterOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteHeadersFootersValidateBeforeCall(DeleteHeadersFootersRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes HeaderFooter objects from the document section.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteHeadersFooters(DeleteHeadersFootersRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteHeadersFootersWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteHeadersFootersWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes HeaderFooter objects from the document section.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteHeadersFootersWithHttpInfo(DeleteHeadersFootersRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteHeadersFootersValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes HeaderFooter objects from the document section. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteHeadersFootersAsync(DeleteHeadersFootersRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteHeadersFootersValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteHeadersFootersOnlineValidateBeforeCall(DeleteHeadersFootersOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes HeaderFooter objects from the document section.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteHeadersFootersOnline(DeleteHeadersFootersOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteHeadersFootersOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteHeadersFootersOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes HeaderFooter objects from the document section.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteHeadersFootersOnlineWithHttpInfo(DeleteHeadersFootersOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteHeadersFootersOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes HeaderFooter objects from the document section. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteHeadersFootersOnlineAsync(DeleteHeadersFootersOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteHeadersFootersOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteMacrosValidateBeforeCall(DeleteMacrosRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes macros from the document.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteMacros(DeleteMacrosRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteMacrosWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteMacrosWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes macros from the document.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteMacrosWithHttpInfo(DeleteMacrosRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteMacrosValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes macros from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteMacrosAsync(DeleteMacrosRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteMacrosValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteMacrosOnlineValidateBeforeCall(DeleteMacrosOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes macros from the document.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteMacrosOnline(DeleteMacrosOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteMacrosOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteMacrosOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes macros from the document.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteMacrosOnlineWithHttpInfo(DeleteMacrosOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteMacrosOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes macros from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteMacrosOnlineAsync(DeleteMacrosOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteMacrosOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteOfficeMathObjectValidateBeforeCall(DeleteOfficeMathObjectRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes an OfficeMath object from the document node.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteOfficeMathObject(DeleteOfficeMathObjectRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteOfficeMathObjectWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteOfficeMathObjectWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes an OfficeMath object from the document node.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteOfficeMathObjectWithHttpInfo(DeleteOfficeMathObjectRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteOfficeMathObjectValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes an OfficeMath object from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteOfficeMathObjectAsync(DeleteOfficeMathObjectRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteOfficeMathObjectValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteOfficeMathObjectOnlineValidateBeforeCall(DeleteOfficeMathObjectOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes an OfficeMath object from the document node.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteOfficeMathObjectOnline(DeleteOfficeMathObjectOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteOfficeMathObjectOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteOfficeMathObjectOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes an OfficeMath object from the document node.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteOfficeMathObjectOnlineWithHttpInfo(DeleteOfficeMathObjectOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteOfficeMathObjectOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes an OfficeMath object from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteOfficeMathObjectOnlineAsync(DeleteOfficeMathObjectOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteOfficeMathObjectOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteOfficeMathObjectsValidateBeforeCall(DeleteOfficeMathObjectsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes all office math objects from the document.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteOfficeMathObjects(DeleteOfficeMathObjectsRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteOfficeMathObjectsWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteOfficeMathObjectsWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes all office math objects from the document.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteOfficeMathObjectsWithHttpInfo(DeleteOfficeMathObjectsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteOfficeMathObjectsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes all office math objects from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteOfficeMathObjectsAsync(DeleteOfficeMathObjectsRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteOfficeMathObjectsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteOfficeMathObjectsOnlineValidateBeforeCall(DeleteOfficeMathObjectsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes all office math objects from the document.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteOfficeMathObjectsOnline(DeleteOfficeMathObjectsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteOfficeMathObjectsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteOfficeMathObjectsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes all office math objects from the document.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteOfficeMathObjectsOnlineWithHttpInfo(DeleteOfficeMathObjectsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteOfficeMathObjectsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes all office math objects from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteOfficeMathObjectsOnlineAsync(DeleteOfficeMathObjectsOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteOfficeMathObjectsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteParagraphValidateBeforeCall(DeleteParagraphRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a paragraph from the document node.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteParagraph(DeleteParagraphRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteParagraphWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteParagraphWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes a paragraph from the document node.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteParagraphWithHttpInfo(DeleteParagraphRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteParagraphValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a paragraph from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteParagraphAsync(DeleteParagraphRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteParagraphValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteParagraphListFormatValidateBeforeCall(DeleteParagraphListFormatRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes the formatting properties of a paragraph list from the document node.
     * @param request Request object
     * @return ParagraphListFormatResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ParagraphListFormatResponse deleteParagraphListFormat(DeleteParagraphListFormatRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ParagraphListFormatResponse > resp = deleteParagraphListFormatWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ParagraphListFormatResponse > resp = deleteParagraphListFormatWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes the formatting properties of a paragraph list from the document node.
     * @param request Request object
     * @return ApiResponse< ParagraphListFormatResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ParagraphListFormatResponse > deleteParagraphListFormatWithHttpInfo(DeleteParagraphListFormatRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteParagraphListFormatValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes the formatting properties of a paragraph list from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteParagraphListFormatAsync(DeleteParagraphListFormatRequest request, final ApiCallback< ParagraphListFormatResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteParagraphListFormatValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteParagraphListFormatOnlineValidateBeforeCall(DeleteParagraphListFormatOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes the formatting properties of a paragraph list from the document node.
     * @param request Request object
     * @return DeleteParagraphListFormatOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DeleteParagraphListFormatOnlineResponse deleteParagraphListFormatOnline(DeleteParagraphListFormatOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DeleteParagraphListFormatOnlineResponse > resp = deleteParagraphListFormatOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DeleteParagraphListFormatOnlineResponse > resp = deleteParagraphListFormatOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes the formatting properties of a paragraph list from the document node.
     * @param request Request object
     * @return ApiResponse< DeleteParagraphListFormatOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DeleteParagraphListFormatOnlineResponse > deleteParagraphListFormatOnlineWithHttpInfo(DeleteParagraphListFormatOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteParagraphListFormatOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes the formatting properties of a paragraph list from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteParagraphListFormatOnlineAsync(DeleteParagraphListFormatOnlineRequest request, final ApiCallback< DeleteParagraphListFormatOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteParagraphListFormatOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteParagraphOnlineValidateBeforeCall(DeleteParagraphOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a paragraph from the document node.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteParagraphOnline(DeleteParagraphOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteParagraphOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteParagraphOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a paragraph from the document node.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteParagraphOnlineWithHttpInfo(DeleteParagraphOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteParagraphOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a paragraph from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteParagraphOnlineAsync(DeleteParagraphOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteParagraphOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteParagraphTabStopValidateBeforeCall(DeleteParagraphTabStopRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a paragraph tab stop from the document node.
     * @param request Request object
     * @return TabStopsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TabStopsResponse deleteParagraphTabStop(DeleteParagraphTabStopRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TabStopsResponse > resp = deleteParagraphTabStopWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TabStopsResponse > resp = deleteParagraphTabStopWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a paragraph tab stop from the document node.
     * @param request Request object
     * @return ApiResponse< TabStopsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TabStopsResponse > deleteParagraphTabStopWithHttpInfo(DeleteParagraphTabStopRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteParagraphTabStopValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a paragraph tab stop from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteParagraphTabStopAsync(DeleteParagraphTabStopRequest request, final ApiCallback< TabStopsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteParagraphTabStopValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteParagraphTabStopOnlineValidateBeforeCall(DeleteParagraphTabStopOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a paragraph tab stop from the document node.
     * @param request Request object
     * @return DeleteParagraphTabStopOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DeleteParagraphTabStopOnlineResponse deleteParagraphTabStopOnline(DeleteParagraphTabStopOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DeleteParagraphTabStopOnlineResponse > resp = deleteParagraphTabStopOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DeleteParagraphTabStopOnlineResponse > resp = deleteParagraphTabStopOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a paragraph tab stop from the document node.
     * @param request Request object
     * @return ApiResponse< DeleteParagraphTabStopOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DeleteParagraphTabStopOnlineResponse > deleteParagraphTabStopOnlineWithHttpInfo(DeleteParagraphTabStopOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteParagraphTabStopOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a paragraph tab stop from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteParagraphTabStopOnlineAsync(DeleteParagraphTabStopOnlineRequest request, final ApiCallback< DeleteParagraphTabStopOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteParagraphTabStopOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteRunValidateBeforeCall(DeleteRunRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a Run object from the paragraph.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteRun(DeleteRunRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteRunWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteRunWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes a Run object from the paragraph.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteRunWithHttpInfo(DeleteRunRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteRunValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a Run object from the paragraph. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteRunAsync(DeleteRunRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteRunValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteRunOnlineValidateBeforeCall(DeleteRunOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a Run object from the paragraph.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteRunOnline(DeleteRunOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteRunOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteRunOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a Run object from the paragraph.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteRunOnlineWithHttpInfo(DeleteRunOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteRunOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a Run object from the paragraph. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteRunOnlineAsync(DeleteRunOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteRunOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteSectionValidateBeforeCall(DeleteSectionRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a section from the document.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteSection(DeleteSectionRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteSectionWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteSectionWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes a section from the document.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteSectionWithHttpInfo(DeleteSectionRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteSectionValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a section from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteSectionAsync(DeleteSectionRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteSectionValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteSectionOnlineValidateBeforeCall(DeleteSectionOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a section from the document.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteSectionOnline(DeleteSectionOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteSectionOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteSectionOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a section from the document.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteSectionOnlineWithHttpInfo(DeleteSectionOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteSectionOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a section from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteSectionOnlineAsync(DeleteSectionOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteSectionOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteStructuredDocumentTagValidateBeforeCall(DeleteStructuredDocumentTagRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a StructuredDocumentTag (SDT) from the document node.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteStructuredDocumentTag(DeleteStructuredDocumentTagRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteStructuredDocumentTagWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteStructuredDocumentTagWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes a StructuredDocumentTag (SDT) from the document node.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteStructuredDocumentTagWithHttpInfo(DeleteStructuredDocumentTagRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteStructuredDocumentTagValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a StructuredDocumentTag (SDT) from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteStructuredDocumentTagAsync(DeleteStructuredDocumentTagRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteStructuredDocumentTagValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteStructuredDocumentTagOnlineValidateBeforeCall(DeleteStructuredDocumentTagOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a StructuredDocumentTag (SDT) from the document node.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteStructuredDocumentTagOnline(DeleteStructuredDocumentTagOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteStructuredDocumentTagOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteStructuredDocumentTagOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a StructuredDocumentTag (SDT) from the document node.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteStructuredDocumentTagOnlineWithHttpInfo(DeleteStructuredDocumentTagOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteStructuredDocumentTagOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a StructuredDocumentTag (SDT) from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteStructuredDocumentTagOnlineAsync(DeleteStructuredDocumentTagOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteStructuredDocumentTagOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteTableValidateBeforeCall(DeleteTableRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a table from the document node.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteTable(DeleteTableRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteTableWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteTableWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes a table from the document node.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteTableWithHttpInfo(DeleteTableRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteTableValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a table from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteTableAsync(DeleteTableRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteTableValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteTableCellValidateBeforeCall(DeleteTableCellRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a cell from the table row.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteTableCell(DeleteTableCellRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteTableCellWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteTableCellWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes a cell from the table row.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteTableCellWithHttpInfo(DeleteTableCellRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteTableCellValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a cell from the table row. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteTableCellAsync(DeleteTableCellRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteTableCellValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteTableCellOnlineValidateBeforeCall(DeleteTableCellOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a cell from the table row.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteTableCellOnline(DeleteTableCellOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteTableCellOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteTableCellOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a cell from the table row.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteTableCellOnlineWithHttpInfo(DeleteTableCellOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteTableCellOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a cell from the table row. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteTableCellOnlineAsync(DeleteTableCellOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteTableCellOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteTableOnlineValidateBeforeCall(DeleteTableOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a table from the document node.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteTableOnline(DeleteTableOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteTableOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteTableOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a table from the document node.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteTableOnlineWithHttpInfo(DeleteTableOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteTableOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a table from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteTableOnlineAsync(DeleteTableOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteTableOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteTableRowValidateBeforeCall(DeleteTableRowRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a row from the table.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void deleteTableRow(DeleteTableRowRequest request) throws ApiException, MessagingException, IOException {
        try {
    deleteTableRowWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    deleteTableRowWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Removes a row from the table.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > deleteTableRowWithHttpInfo(DeleteTableRowRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteTableRowValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a row from the table. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteTableRowAsync(DeleteTableRowRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteTableRowValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteTableRowOnlineValidateBeforeCall(DeleteTableRowOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a row from the table.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> deleteTableRowOnline(DeleteTableRowOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = deleteTableRowOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = deleteTableRowOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a row from the table.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > deleteTableRowOnlineWithHttpInfo(DeleteTableRowOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteTableRowOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a row from the table. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteTableRowOnlineAsync(DeleteTableRowOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteTableRowOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteWatermarkValidateBeforeCall(DeleteWatermarkRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a watermark from the document.
     * @param request Request object
     * @return DocumentResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DocumentResponse deleteWatermark(DeleteWatermarkRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DocumentResponse > resp = deleteWatermarkWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DocumentResponse > resp = deleteWatermarkWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a watermark from the document.
     * @param request Request object
     * @return ApiResponse< DocumentResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DocumentResponse > deleteWatermarkWithHttpInfo(DeleteWatermarkRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteWatermarkValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a watermark from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteWatermarkAsync(DeleteWatermarkRequest request, final ApiCallback< DocumentResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteWatermarkValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteWatermarkOnlineValidateBeforeCall(DeleteWatermarkOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes a watermark from the document.
     * @param request Request object
     * @return DeleteWatermarkOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DeleteWatermarkOnlineResponse deleteWatermarkOnline(DeleteWatermarkOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DeleteWatermarkOnlineResponse > resp = deleteWatermarkOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DeleteWatermarkOnlineResponse > resp = deleteWatermarkOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes a watermark from the document.
     * @param request Request object
     * @return ApiResponse< DeleteWatermarkOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DeleteWatermarkOnlineResponse > deleteWatermarkOnlineWithHttpInfo(DeleteWatermarkOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = deleteWatermarkOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Removes a watermark from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteWatermarkOnlineAsync(DeleteWatermarkOnlineRequest request, final ApiCallback< DeleteWatermarkOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteWatermarkOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call downloadFileValidateBeforeCall(DownloadFileRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Download file.
     * @param request Request object
     * @return byte[]
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public byte[] downloadFile(DownloadFileRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< byte[] > resp = downloadFileWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< byte[] > resp = downloadFileWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Download file.
     * @param request Request object
     * @return ApiResponse< byte[] >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< byte[] > downloadFileWithHttpInfo(DownloadFileRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = downloadFileValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Download file. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call downloadFileAsync(DownloadFileRequest request, final ApiCallback< byte[] > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = downloadFileValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call executeMailMergeValidateBeforeCall(ExecuteMailMergeRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Executes a Mail Merge operation.
     * @param request Request object
     * @return DocumentResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DocumentResponse executeMailMerge(ExecuteMailMergeRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DocumentResponse > resp = executeMailMergeWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DocumentResponse > resp = executeMailMergeWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Executes a Mail Merge operation.
     * @param request Request object
     * @return ApiResponse< DocumentResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DocumentResponse > executeMailMergeWithHttpInfo(ExecuteMailMergeRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = executeMailMergeValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Executes a Mail Merge operation. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call executeMailMergeAsync(ExecuteMailMergeRequest request, final ApiCallback< DocumentResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = executeMailMergeValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call executeMailMergeOnlineValidateBeforeCall(ExecuteMailMergeOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Executes a Mail Merge operation online.
     * @param request Request object
     * @return byte[]
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public byte[] executeMailMergeOnline(ExecuteMailMergeOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< byte[] > resp = executeMailMergeOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< byte[] > resp = executeMailMergeOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Executes a Mail Merge operation online.
     * @param request Request object
     * @return ApiResponse< byte[] >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< byte[] > executeMailMergeOnlineWithHttpInfo(ExecuteMailMergeOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = executeMailMergeOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Executes a Mail Merge operation online. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call executeMailMergeOnlineAsync(ExecuteMailMergeOnlineRequest request, final ApiCallback< byte[] > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = executeMailMergeOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAllRevisionsValidateBeforeCall(GetAllRevisionsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Get all information about revisions.
     * @param request Request object
     * @return RevisionsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public RevisionsResponse getAllRevisions(GetAllRevisionsRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< RevisionsResponse > resp = getAllRevisionsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< RevisionsResponse > resp = getAllRevisionsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Get all information about revisions.
     * @param request Request object
     * @return ApiResponse< RevisionsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< RevisionsResponse > getAllRevisionsWithHttpInfo(GetAllRevisionsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getAllRevisionsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Get all information about revisions. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAllRevisionsAsync(GetAllRevisionsRequest request, final ApiCallback< RevisionsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAllRevisionsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAllRevisionsOnlineValidateBeforeCall(GetAllRevisionsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Get all information about revisions.
     * @param request Request object
     * @return RevisionsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public RevisionsResponse getAllRevisionsOnline(GetAllRevisionsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< RevisionsResponse > resp = getAllRevisionsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< RevisionsResponse > resp = getAllRevisionsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Get all information about revisions.
     * @param request Request object
     * @return ApiResponse< RevisionsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< RevisionsResponse > getAllRevisionsOnlineWithHttpInfo(GetAllRevisionsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getAllRevisionsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Get all information about revisions. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAllRevisionsOnlineAsync(GetAllRevisionsOnlineRequest request, final ApiCallback< RevisionsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAllRevisionsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAvailableFontsValidateBeforeCall(GetAvailableFontsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads available fonts from the document.
     * @param request Request object
     * @return AvailableFontsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public AvailableFontsResponse getAvailableFonts(GetAvailableFontsRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< AvailableFontsResponse > resp = getAvailableFontsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< AvailableFontsResponse > resp = getAvailableFontsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads available fonts from the document.
     * @param request Request object
     * @return ApiResponse< AvailableFontsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< AvailableFontsResponse > getAvailableFontsWithHttpInfo(GetAvailableFontsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getAvailableFontsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads available fonts from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAvailableFontsAsync(GetAvailableFontsRequest request, final ApiCallback< AvailableFontsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAvailableFontsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getBookmarkByNameValidateBeforeCall(GetBookmarkByNameRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a bookmark, specified by name, from the document.
     * @param request Request object
     * @return BookmarkResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public BookmarkResponse getBookmarkByName(GetBookmarkByNameRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< BookmarkResponse > resp = getBookmarkByNameWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< BookmarkResponse > resp = getBookmarkByNameWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a bookmark, specified by name, from the document.
     * @param request Request object
     * @return ApiResponse< BookmarkResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< BookmarkResponse > getBookmarkByNameWithHttpInfo(GetBookmarkByNameRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getBookmarkByNameValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a bookmark, specified by name, from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getBookmarkByNameAsync(GetBookmarkByNameRequest request, final ApiCallback< BookmarkResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getBookmarkByNameValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getBookmarkByNameOnlineValidateBeforeCall(GetBookmarkByNameOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a bookmark, specified by name, from the document.
     * @param request Request object
     * @return BookmarkResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public BookmarkResponse getBookmarkByNameOnline(GetBookmarkByNameOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< BookmarkResponse > resp = getBookmarkByNameOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< BookmarkResponse > resp = getBookmarkByNameOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a bookmark, specified by name, from the document.
     * @param request Request object
     * @return ApiResponse< BookmarkResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< BookmarkResponse > getBookmarkByNameOnlineWithHttpInfo(GetBookmarkByNameOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getBookmarkByNameOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a bookmark, specified by name, from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getBookmarkByNameOnlineAsync(GetBookmarkByNameOnlineRequest request, final ApiCallback< BookmarkResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getBookmarkByNameOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getBookmarksValidateBeforeCall(GetBookmarksRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads bookmarks from the document.
     * @param request Request object
     * @return BookmarksResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public BookmarksResponse getBookmarks(GetBookmarksRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< BookmarksResponse > resp = getBookmarksWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< BookmarksResponse > resp = getBookmarksWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads bookmarks from the document.
     * @param request Request object
     * @return ApiResponse< BookmarksResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< BookmarksResponse > getBookmarksWithHttpInfo(GetBookmarksRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getBookmarksValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads bookmarks from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getBookmarksAsync(GetBookmarksRequest request, final ApiCallback< BookmarksResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getBookmarksValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getBookmarksOnlineValidateBeforeCall(GetBookmarksOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads bookmarks from the document.
     * @param request Request object
     * @return BookmarksResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public BookmarksResponse getBookmarksOnline(GetBookmarksOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< BookmarksResponse > resp = getBookmarksOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< BookmarksResponse > resp = getBookmarksOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads bookmarks from the document.
     * @param request Request object
     * @return ApiResponse< BookmarksResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< BookmarksResponse > getBookmarksOnlineWithHttpInfo(GetBookmarksOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getBookmarksOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads bookmarks from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getBookmarksOnlineAsync(GetBookmarksOnlineRequest request, final ApiCallback< BookmarksResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getBookmarksOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getBorderValidateBeforeCall(GetBorderRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a border from the document node.
     * The 'nodePath' parameter should refer to a paragraph, a cell or a row.
     * @param request Request object
     * @return BorderResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public BorderResponse getBorder(GetBorderRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< BorderResponse > resp = getBorderWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< BorderResponse > resp = getBorderWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a border from the document node.
     * The 'nodePath' parameter should refer to a paragraph, a cell or a row.
     * @param request Request object
     * @return ApiResponse< BorderResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< BorderResponse > getBorderWithHttpInfo(GetBorderRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getBorderValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a border from the document node.
     * The 'nodePath' parameter should refer to a paragraph, a cell or a row. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getBorderAsync(GetBorderRequest request, final ApiCallback< BorderResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getBorderValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getBorderOnlineValidateBeforeCall(GetBorderOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a border from the document node.
     * The 'nodePath' parameter should refer to a paragraph, a cell or a row.
     * @param request Request object
     * @return BorderResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public BorderResponse getBorderOnline(GetBorderOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< BorderResponse > resp = getBorderOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< BorderResponse > resp = getBorderOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a border from the document node.
     * The 'nodePath' parameter should refer to a paragraph, a cell or a row.
     * @param request Request object
     * @return ApiResponse< BorderResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< BorderResponse > getBorderOnlineWithHttpInfo(GetBorderOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getBorderOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a border from the document node.
     * The 'nodePath' parameter should refer to a paragraph, a cell or a row. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getBorderOnlineAsync(GetBorderOnlineRequest request, final ApiCallback< BorderResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getBorderOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getBordersValidateBeforeCall(GetBordersRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads borders from the document node.
     * @param request Request object
     * @return BordersResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public BordersResponse getBorders(GetBordersRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< BordersResponse > resp = getBordersWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< BordersResponse > resp = getBordersWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads borders from the document node.
     * @param request Request object
     * @return ApiResponse< BordersResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< BordersResponse > getBordersWithHttpInfo(GetBordersRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getBordersValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads borders from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getBordersAsync(GetBordersRequest request, final ApiCallback< BordersResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getBordersValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getBordersOnlineValidateBeforeCall(GetBordersOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads borders from the document node.
     * @param request Request object
     * @return BordersResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public BordersResponse getBordersOnline(GetBordersOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< BordersResponse > resp = getBordersOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< BordersResponse > resp = getBordersOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads borders from the document node.
     * @param request Request object
     * @return ApiResponse< BordersResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< BordersResponse > getBordersOnlineWithHttpInfo(GetBordersOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getBordersOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads borders from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getBordersOnlineAsync(GetBordersOnlineRequest request, final ApiCallback< BordersResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getBordersOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCommentValidateBeforeCall(GetCommentRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a comment from the document.
     * @param request Request object
     * @return CommentResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public CommentResponse getComment(GetCommentRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< CommentResponse > resp = getCommentWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< CommentResponse > resp = getCommentWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a comment from the document.
     * @param request Request object
     * @return ApiResponse< CommentResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< CommentResponse > getCommentWithHttpInfo(GetCommentRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getCommentValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a comment from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCommentAsync(GetCommentRequest request, final ApiCallback< CommentResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getCommentValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCommentOnlineValidateBeforeCall(GetCommentOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a comment from the document.
     * @param request Request object
     * @return CommentResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public CommentResponse getCommentOnline(GetCommentOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< CommentResponse > resp = getCommentOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< CommentResponse > resp = getCommentOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a comment from the document.
     * @param request Request object
     * @return ApiResponse< CommentResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< CommentResponse > getCommentOnlineWithHttpInfo(GetCommentOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getCommentOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a comment from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCommentOnlineAsync(GetCommentOnlineRequest request, final ApiCallback< CommentResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getCommentOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCommentsValidateBeforeCall(GetCommentsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads comments from the document.
     * @param request Request object
     * @return CommentsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public CommentsResponse getComments(GetCommentsRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< CommentsResponse > resp = getCommentsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< CommentsResponse > resp = getCommentsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads comments from the document.
     * @param request Request object
     * @return ApiResponse< CommentsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< CommentsResponse > getCommentsWithHttpInfo(GetCommentsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getCommentsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads comments from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCommentsAsync(GetCommentsRequest request, final ApiCallback< CommentsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getCommentsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCommentsOnlineValidateBeforeCall(GetCommentsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads comments from the document.
     * @param request Request object
     * @return CommentsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public CommentsResponse getCommentsOnline(GetCommentsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< CommentsResponse > resp = getCommentsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< CommentsResponse > resp = getCommentsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads comments from the document.
     * @param request Request object
     * @return ApiResponse< CommentsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< CommentsResponse > getCommentsOnlineWithHttpInfo(GetCommentsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getCommentsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads comments from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCommentsOnlineAsync(GetCommentsOnlineRequest request, final ApiCallback< CommentsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getCommentsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCustomXmlPartValidateBeforeCall(GetCustomXmlPartRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads the custom xml part from the document.
     * @param request Request object
     * @return CustomXmlPartResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public CustomXmlPartResponse getCustomXmlPart(GetCustomXmlPartRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< CustomXmlPartResponse > resp = getCustomXmlPartWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< CustomXmlPartResponse > resp = getCustomXmlPartWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads the custom xml part from the document.
     * @param request Request object
     * @return ApiResponse< CustomXmlPartResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< CustomXmlPartResponse > getCustomXmlPartWithHttpInfo(GetCustomXmlPartRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getCustomXmlPartValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads the custom xml part from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCustomXmlPartAsync(GetCustomXmlPartRequest request, final ApiCallback< CustomXmlPartResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getCustomXmlPartValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCustomXmlPartOnlineValidateBeforeCall(GetCustomXmlPartOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads the custom xml part from the document.
     * @param request Request object
     * @return CustomXmlPartResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public CustomXmlPartResponse getCustomXmlPartOnline(GetCustomXmlPartOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< CustomXmlPartResponse > resp = getCustomXmlPartOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< CustomXmlPartResponse > resp = getCustomXmlPartOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads the custom xml part from the document.
     * @param request Request object
     * @return ApiResponse< CustomXmlPartResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< CustomXmlPartResponse > getCustomXmlPartOnlineWithHttpInfo(GetCustomXmlPartOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getCustomXmlPartOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads the custom xml part from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCustomXmlPartOnlineAsync(GetCustomXmlPartOnlineRequest request, final ApiCallback< CustomXmlPartResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getCustomXmlPartOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCustomXmlPartsValidateBeforeCall(GetCustomXmlPartsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads custom xml parts from the document.
     * @param request Request object
     * @return CustomXmlPartsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public CustomXmlPartsResponse getCustomXmlParts(GetCustomXmlPartsRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< CustomXmlPartsResponse > resp = getCustomXmlPartsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< CustomXmlPartsResponse > resp = getCustomXmlPartsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads custom xml parts from the document.
     * @param request Request object
     * @return ApiResponse< CustomXmlPartsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< CustomXmlPartsResponse > getCustomXmlPartsWithHttpInfo(GetCustomXmlPartsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getCustomXmlPartsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads custom xml parts from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCustomXmlPartsAsync(GetCustomXmlPartsRequest request, final ApiCallback< CustomXmlPartsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getCustomXmlPartsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCustomXmlPartsOnlineValidateBeforeCall(GetCustomXmlPartsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads custom xml parts from the document.
     * @param request Request object
     * @return CustomXmlPartsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public CustomXmlPartsResponse getCustomXmlPartsOnline(GetCustomXmlPartsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< CustomXmlPartsResponse > resp = getCustomXmlPartsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< CustomXmlPartsResponse > resp = getCustomXmlPartsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads custom xml parts from the document.
     * @param request Request object
     * @return ApiResponse< CustomXmlPartsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< CustomXmlPartsResponse > getCustomXmlPartsOnlineWithHttpInfo(GetCustomXmlPartsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getCustomXmlPartsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads custom xml parts from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCustomXmlPartsOnlineAsync(GetCustomXmlPartsOnlineRequest request, final ApiCallback< CustomXmlPartsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getCustomXmlPartsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentValidateBeforeCall(GetDocumentRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads common information from the document.
     * @param request Request object
     * @return DocumentResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DocumentResponse getDocument(GetDocumentRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DocumentResponse > resp = getDocumentWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DocumentResponse > resp = getDocumentWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads common information from the document.
     * @param request Request object
     * @return ApiResponse< DocumentResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DocumentResponse > getDocumentWithHttpInfo(GetDocumentRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads common information from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentAsync(GetDocumentRequest request, final ApiCallback< DocumentResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentDrawingObjectByIndexValidateBeforeCall(GetDocumentDrawingObjectByIndexRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a DrawingObject from the document node.
     * @param request Request object
     * @return DrawingObjectResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DrawingObjectResponse getDocumentDrawingObjectByIndex(GetDocumentDrawingObjectByIndexRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DrawingObjectResponse > resp = getDocumentDrawingObjectByIndexWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DrawingObjectResponse > resp = getDocumentDrawingObjectByIndexWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a DrawingObject from the document node.
     * @param request Request object
     * @return ApiResponse< DrawingObjectResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DrawingObjectResponse > getDocumentDrawingObjectByIndexWithHttpInfo(GetDocumentDrawingObjectByIndexRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentDrawingObjectByIndexValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a DrawingObject from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentDrawingObjectByIndexAsync(GetDocumentDrawingObjectByIndexRequest request, final ApiCallback< DrawingObjectResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentDrawingObjectByIndexValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentDrawingObjectByIndexOnlineValidateBeforeCall(GetDocumentDrawingObjectByIndexOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a DrawingObject from the document node.
     * @param request Request object
     * @return DrawingObjectResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DrawingObjectResponse getDocumentDrawingObjectByIndexOnline(GetDocumentDrawingObjectByIndexOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DrawingObjectResponse > resp = getDocumentDrawingObjectByIndexOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DrawingObjectResponse > resp = getDocumentDrawingObjectByIndexOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a DrawingObject from the document node.
     * @param request Request object
     * @return ApiResponse< DrawingObjectResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DrawingObjectResponse > getDocumentDrawingObjectByIndexOnlineWithHttpInfo(GetDocumentDrawingObjectByIndexOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentDrawingObjectByIndexOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a DrawingObject from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentDrawingObjectByIndexOnlineAsync(GetDocumentDrawingObjectByIndexOnlineRequest request, final ApiCallback< DrawingObjectResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentDrawingObjectByIndexOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentDrawingObjectImageDataValidateBeforeCall(GetDocumentDrawingObjectImageDataRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads image data of a DrawingObject from the document node.
     * @param request Request object
     * @return byte[]
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public byte[] getDocumentDrawingObjectImageData(GetDocumentDrawingObjectImageDataRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< byte[] > resp = getDocumentDrawingObjectImageDataWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< byte[] > resp = getDocumentDrawingObjectImageDataWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads image data of a DrawingObject from the document node.
     * @param request Request object
     * @return ApiResponse< byte[] >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< byte[] > getDocumentDrawingObjectImageDataWithHttpInfo(GetDocumentDrawingObjectImageDataRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentDrawingObjectImageDataValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads image data of a DrawingObject from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentDrawingObjectImageDataAsync(GetDocumentDrawingObjectImageDataRequest request, final ApiCallback< byte[] > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentDrawingObjectImageDataValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentDrawingObjectImageDataOnlineValidateBeforeCall(GetDocumentDrawingObjectImageDataOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads image data of a DrawingObject from the document node.
     * @param request Request object
     * @return byte[]
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public byte[] getDocumentDrawingObjectImageDataOnline(GetDocumentDrawingObjectImageDataOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< byte[] > resp = getDocumentDrawingObjectImageDataOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< byte[] > resp = getDocumentDrawingObjectImageDataOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads image data of a DrawingObject from the document node.
     * @param request Request object
     * @return ApiResponse< byte[] >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< byte[] > getDocumentDrawingObjectImageDataOnlineWithHttpInfo(GetDocumentDrawingObjectImageDataOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentDrawingObjectImageDataOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads image data of a DrawingObject from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentDrawingObjectImageDataOnlineAsync(GetDocumentDrawingObjectImageDataOnlineRequest request, final ApiCallback< byte[] > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentDrawingObjectImageDataOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentDrawingObjectOleDataValidateBeforeCall(GetDocumentDrawingObjectOleDataRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads OLE data of a DrawingObject from the document node.
     * @param request Request object
     * @return byte[]
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public byte[] getDocumentDrawingObjectOleData(GetDocumentDrawingObjectOleDataRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< byte[] > resp = getDocumentDrawingObjectOleDataWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< byte[] > resp = getDocumentDrawingObjectOleDataWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads OLE data of a DrawingObject from the document node.
     * @param request Request object
     * @return ApiResponse< byte[] >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< byte[] > getDocumentDrawingObjectOleDataWithHttpInfo(GetDocumentDrawingObjectOleDataRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentDrawingObjectOleDataValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads OLE data of a DrawingObject from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentDrawingObjectOleDataAsync(GetDocumentDrawingObjectOleDataRequest request, final ApiCallback< byte[] > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentDrawingObjectOleDataValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentDrawingObjectOleDataOnlineValidateBeforeCall(GetDocumentDrawingObjectOleDataOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads OLE data of a DrawingObject from the document node.
     * @param request Request object
     * @return byte[]
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public byte[] getDocumentDrawingObjectOleDataOnline(GetDocumentDrawingObjectOleDataOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< byte[] > resp = getDocumentDrawingObjectOleDataOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< byte[] > resp = getDocumentDrawingObjectOleDataOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads OLE data of a DrawingObject from the document node.
     * @param request Request object
     * @return ApiResponse< byte[] >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< byte[] > getDocumentDrawingObjectOleDataOnlineWithHttpInfo(GetDocumentDrawingObjectOleDataOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentDrawingObjectOleDataOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads OLE data of a DrawingObject from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentDrawingObjectOleDataOnlineAsync(GetDocumentDrawingObjectOleDataOnlineRequest request, final ApiCallback< byte[] > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentDrawingObjectOleDataOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentDrawingObjectsValidateBeforeCall(GetDocumentDrawingObjectsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads DrawingObjects from the document node.
     * @param request Request object
     * @return DrawingObjectsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DrawingObjectsResponse getDocumentDrawingObjects(GetDocumentDrawingObjectsRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DrawingObjectsResponse > resp = getDocumentDrawingObjectsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DrawingObjectsResponse > resp = getDocumentDrawingObjectsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads DrawingObjects from the document node.
     * @param request Request object
     * @return ApiResponse< DrawingObjectsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DrawingObjectsResponse > getDocumentDrawingObjectsWithHttpInfo(GetDocumentDrawingObjectsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentDrawingObjectsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads DrawingObjects from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentDrawingObjectsAsync(GetDocumentDrawingObjectsRequest request, final ApiCallback< DrawingObjectsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentDrawingObjectsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentDrawingObjectsOnlineValidateBeforeCall(GetDocumentDrawingObjectsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads DrawingObjects from the document node.
     * @param request Request object
     * @return DrawingObjectsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DrawingObjectsResponse getDocumentDrawingObjectsOnline(GetDocumentDrawingObjectsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DrawingObjectsResponse > resp = getDocumentDrawingObjectsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DrawingObjectsResponse > resp = getDocumentDrawingObjectsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads DrawingObjects from the document node.
     * @param request Request object
     * @return ApiResponse< DrawingObjectsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DrawingObjectsResponse > getDocumentDrawingObjectsOnlineWithHttpInfo(GetDocumentDrawingObjectsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentDrawingObjectsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads DrawingObjects from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentDrawingObjectsOnlineAsync(GetDocumentDrawingObjectsOnlineRequest request, final ApiCallback< DrawingObjectsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentDrawingObjectsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentFieldNamesValidateBeforeCall(GetDocumentFieldNamesRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads merge field names from the document.
     * @param request Request object
     * @return FieldNamesResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FieldNamesResponse getDocumentFieldNames(GetDocumentFieldNamesRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FieldNamesResponse > resp = getDocumentFieldNamesWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FieldNamesResponse > resp = getDocumentFieldNamesWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads merge field names from the document.
     * @param request Request object
     * @return ApiResponse< FieldNamesResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FieldNamesResponse > getDocumentFieldNamesWithHttpInfo(GetDocumentFieldNamesRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentFieldNamesValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads merge field names from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentFieldNamesAsync(GetDocumentFieldNamesRequest request, final ApiCallback< FieldNamesResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentFieldNamesValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentFieldNamesOnlineValidateBeforeCall(GetDocumentFieldNamesOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads merge field names from the document.
     * @param request Request object
     * @return FieldNamesResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FieldNamesResponse getDocumentFieldNamesOnline(GetDocumentFieldNamesOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FieldNamesResponse > resp = getDocumentFieldNamesOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FieldNamesResponse > resp = getDocumentFieldNamesOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads merge field names from the document.
     * @param request Request object
     * @return ApiResponse< FieldNamesResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FieldNamesResponse > getDocumentFieldNamesOnlineWithHttpInfo(GetDocumentFieldNamesOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentFieldNamesOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads merge field names from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentFieldNamesOnlineAsync(GetDocumentFieldNamesOnlineRequest request, final ApiCallback< FieldNamesResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentFieldNamesOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentHyperlinkByIndexValidateBeforeCall(GetDocumentHyperlinkByIndexRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a hyperlink from the document.
     * @param request Request object
     * @return HyperlinkResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public HyperlinkResponse getDocumentHyperlinkByIndex(GetDocumentHyperlinkByIndexRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< HyperlinkResponse > resp = getDocumentHyperlinkByIndexWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< HyperlinkResponse > resp = getDocumentHyperlinkByIndexWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a hyperlink from the document.
     * @param request Request object
     * @return ApiResponse< HyperlinkResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< HyperlinkResponse > getDocumentHyperlinkByIndexWithHttpInfo(GetDocumentHyperlinkByIndexRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentHyperlinkByIndexValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a hyperlink from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentHyperlinkByIndexAsync(GetDocumentHyperlinkByIndexRequest request, final ApiCallback< HyperlinkResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentHyperlinkByIndexValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentHyperlinkByIndexOnlineValidateBeforeCall(GetDocumentHyperlinkByIndexOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a hyperlink from the document.
     * @param request Request object
     * @return HyperlinkResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public HyperlinkResponse getDocumentHyperlinkByIndexOnline(GetDocumentHyperlinkByIndexOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< HyperlinkResponse > resp = getDocumentHyperlinkByIndexOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< HyperlinkResponse > resp = getDocumentHyperlinkByIndexOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a hyperlink from the document.
     * @param request Request object
     * @return ApiResponse< HyperlinkResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< HyperlinkResponse > getDocumentHyperlinkByIndexOnlineWithHttpInfo(GetDocumentHyperlinkByIndexOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentHyperlinkByIndexOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a hyperlink from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentHyperlinkByIndexOnlineAsync(GetDocumentHyperlinkByIndexOnlineRequest request, final ApiCallback< HyperlinkResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentHyperlinkByIndexOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentHyperlinksValidateBeforeCall(GetDocumentHyperlinksRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads hyperlinks from the document.
     * @param request Request object
     * @return HyperlinksResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public HyperlinksResponse getDocumentHyperlinks(GetDocumentHyperlinksRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< HyperlinksResponse > resp = getDocumentHyperlinksWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< HyperlinksResponse > resp = getDocumentHyperlinksWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads hyperlinks from the document.
     * @param request Request object
     * @return ApiResponse< HyperlinksResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< HyperlinksResponse > getDocumentHyperlinksWithHttpInfo(GetDocumentHyperlinksRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentHyperlinksValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads hyperlinks from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentHyperlinksAsync(GetDocumentHyperlinksRequest request, final ApiCallback< HyperlinksResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentHyperlinksValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentHyperlinksOnlineValidateBeforeCall(GetDocumentHyperlinksOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads hyperlinks from the document.
     * @param request Request object
     * @return HyperlinksResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public HyperlinksResponse getDocumentHyperlinksOnline(GetDocumentHyperlinksOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< HyperlinksResponse > resp = getDocumentHyperlinksOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< HyperlinksResponse > resp = getDocumentHyperlinksOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads hyperlinks from the document.
     * @param request Request object
     * @return ApiResponse< HyperlinksResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< HyperlinksResponse > getDocumentHyperlinksOnlineWithHttpInfo(GetDocumentHyperlinksOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentHyperlinksOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads hyperlinks from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentHyperlinksOnlineAsync(GetDocumentHyperlinksOnlineRequest request, final ApiCallback< HyperlinksResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentHyperlinksOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentPropertiesValidateBeforeCall(GetDocumentPropertiesRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads document properties.
     * @param request Request object
     * @return DocumentPropertiesResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DocumentPropertiesResponse getDocumentProperties(GetDocumentPropertiesRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DocumentPropertiesResponse > resp = getDocumentPropertiesWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DocumentPropertiesResponse > resp = getDocumentPropertiesWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads document properties.
     * @param request Request object
     * @return ApiResponse< DocumentPropertiesResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DocumentPropertiesResponse > getDocumentPropertiesWithHttpInfo(GetDocumentPropertiesRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentPropertiesValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads document properties. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentPropertiesAsync(GetDocumentPropertiesRequest request, final ApiCallback< DocumentPropertiesResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentPropertiesValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentPropertiesOnlineValidateBeforeCall(GetDocumentPropertiesOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads document properties.
     * @param request Request object
     * @return DocumentPropertiesResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DocumentPropertiesResponse getDocumentPropertiesOnline(GetDocumentPropertiesOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DocumentPropertiesResponse > resp = getDocumentPropertiesOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DocumentPropertiesResponse > resp = getDocumentPropertiesOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads document properties.
     * @param request Request object
     * @return ApiResponse< DocumentPropertiesResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DocumentPropertiesResponse > getDocumentPropertiesOnlineWithHttpInfo(GetDocumentPropertiesOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentPropertiesOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads document properties. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentPropertiesOnlineAsync(GetDocumentPropertiesOnlineRequest request, final ApiCallback< DocumentPropertiesResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentPropertiesOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentPropertyValidateBeforeCall(GetDocumentPropertyRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a document property.
     * @param request Request object
     * @return DocumentPropertyResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DocumentPropertyResponse getDocumentProperty(GetDocumentPropertyRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DocumentPropertyResponse > resp = getDocumentPropertyWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DocumentPropertyResponse > resp = getDocumentPropertyWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a document property.
     * @param request Request object
     * @return ApiResponse< DocumentPropertyResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DocumentPropertyResponse > getDocumentPropertyWithHttpInfo(GetDocumentPropertyRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentPropertyValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a document property. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentPropertyAsync(GetDocumentPropertyRequest request, final ApiCallback< DocumentPropertyResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentPropertyValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentPropertyOnlineValidateBeforeCall(GetDocumentPropertyOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a document property.
     * @param request Request object
     * @return DocumentPropertyResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DocumentPropertyResponse getDocumentPropertyOnline(GetDocumentPropertyOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DocumentPropertyResponse > resp = getDocumentPropertyOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DocumentPropertyResponse > resp = getDocumentPropertyOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a document property.
     * @param request Request object
     * @return ApiResponse< DocumentPropertyResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DocumentPropertyResponse > getDocumentPropertyOnlineWithHttpInfo(GetDocumentPropertyOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentPropertyOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a document property. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentPropertyOnlineAsync(GetDocumentPropertyOnlineRequest request, final ApiCallback< DocumentPropertyResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentPropertyOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentProtectionValidateBeforeCall(GetDocumentProtectionRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads protection properties from the document.
     * @param request Request object
     * @return ProtectionDataResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ProtectionDataResponse getDocumentProtection(GetDocumentProtectionRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ProtectionDataResponse > resp = getDocumentProtectionWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ProtectionDataResponse > resp = getDocumentProtectionWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads protection properties from the document.
     * @param request Request object
     * @return ApiResponse< ProtectionDataResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ProtectionDataResponse > getDocumentProtectionWithHttpInfo(GetDocumentProtectionRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentProtectionValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads protection properties from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentProtectionAsync(GetDocumentProtectionRequest request, final ApiCallback< ProtectionDataResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentProtectionValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentProtectionOnlineValidateBeforeCall(GetDocumentProtectionOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads protection properties from the document.
     * @param request Request object
     * @return ProtectionDataResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ProtectionDataResponse getDocumentProtectionOnline(GetDocumentProtectionOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ProtectionDataResponse > resp = getDocumentProtectionOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ProtectionDataResponse > resp = getDocumentProtectionOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads protection properties from the document.
     * @param request Request object
     * @return ApiResponse< ProtectionDataResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ProtectionDataResponse > getDocumentProtectionOnlineWithHttpInfo(GetDocumentProtectionOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentProtectionOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads protection properties from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentProtectionOnlineAsync(GetDocumentProtectionOnlineRequest request, final ApiCallback< ProtectionDataResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentProtectionOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentStatisticsValidateBeforeCall(GetDocumentStatisticsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads document statistics.
     * @param request Request object
     * @return StatDataResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public StatDataResponse getDocumentStatistics(GetDocumentStatisticsRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< StatDataResponse > resp = getDocumentStatisticsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< StatDataResponse > resp = getDocumentStatisticsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads document statistics.
     * @param request Request object
     * @return ApiResponse< StatDataResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< StatDataResponse > getDocumentStatisticsWithHttpInfo(GetDocumentStatisticsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentStatisticsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads document statistics. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentStatisticsAsync(GetDocumentStatisticsRequest request, final ApiCallback< StatDataResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentStatisticsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentStatisticsOnlineValidateBeforeCall(GetDocumentStatisticsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads document statistics.
     * @param request Request object
     * @return StatDataResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public StatDataResponse getDocumentStatisticsOnline(GetDocumentStatisticsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< StatDataResponse > resp = getDocumentStatisticsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< StatDataResponse > resp = getDocumentStatisticsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads document statistics.
     * @param request Request object
     * @return ApiResponse< StatDataResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< StatDataResponse > getDocumentStatisticsOnlineWithHttpInfo(GetDocumentStatisticsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentStatisticsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads document statistics. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentStatisticsOnlineAsync(GetDocumentStatisticsOnlineRequest request, final ApiCallback< StatDataResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentStatisticsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentWithFormatValidateBeforeCall(GetDocumentWithFormatRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Converts a document in cloud storage to the specified format.
     * @param request Request object
     * @return byte[]
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public byte[] getDocumentWithFormat(GetDocumentWithFormatRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< byte[] > resp = getDocumentWithFormatWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< byte[] > resp = getDocumentWithFormatWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Converts a document in cloud storage to the specified format.
     * @param request Request object
     * @return ApiResponse< byte[] >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< byte[] > getDocumentWithFormatWithHttpInfo(GetDocumentWithFormatRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getDocumentWithFormatValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Converts a document in cloud storage to the specified format. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentWithFormatAsync(GetDocumentWithFormatRequest request, final ApiCallback< byte[] > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentWithFormatValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFieldValidateBeforeCall(GetFieldRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a field from the document node.
     * @param request Request object
     * @return FieldResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FieldResponse getField(GetFieldRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FieldResponse > resp = getFieldWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FieldResponse > resp = getFieldWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a field from the document node.
     * @param request Request object
     * @return ApiResponse< FieldResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FieldResponse > getFieldWithHttpInfo(GetFieldRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getFieldValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a field from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFieldAsync(GetFieldRequest request, final ApiCallback< FieldResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFieldValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFieldOnlineValidateBeforeCall(GetFieldOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a field from the document node.
     * @param request Request object
     * @return FieldResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FieldResponse getFieldOnline(GetFieldOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FieldResponse > resp = getFieldOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FieldResponse > resp = getFieldOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a field from the document node.
     * @param request Request object
     * @return ApiResponse< FieldResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FieldResponse > getFieldOnlineWithHttpInfo(GetFieldOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getFieldOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a field from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFieldOnlineAsync(GetFieldOnlineRequest request, final ApiCallback< FieldResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFieldOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFieldsValidateBeforeCall(GetFieldsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads fields from the document node.
     * @param request Request object
     * @return FieldsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FieldsResponse getFields(GetFieldsRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FieldsResponse > resp = getFieldsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FieldsResponse > resp = getFieldsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads fields from the document node.
     * @param request Request object
     * @return ApiResponse< FieldsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FieldsResponse > getFieldsWithHttpInfo(GetFieldsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getFieldsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads fields from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFieldsAsync(GetFieldsRequest request, final ApiCallback< FieldsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFieldsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFieldsOnlineValidateBeforeCall(GetFieldsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads fields from the document node.
     * @param request Request object
     * @return FieldsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FieldsResponse getFieldsOnline(GetFieldsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FieldsResponse > resp = getFieldsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FieldsResponse > resp = getFieldsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads fields from the document node.
     * @param request Request object
     * @return ApiResponse< FieldsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FieldsResponse > getFieldsOnlineWithHttpInfo(GetFieldsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getFieldsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads fields from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFieldsOnlineAsync(GetFieldsOnlineRequest request, final ApiCallback< FieldsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFieldsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFilesListValidateBeforeCall(GetFilesListRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Get all files and folders within a folder.
     * @param request Request object
     * @return FilesList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FilesList getFilesList(GetFilesListRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FilesList > resp = getFilesListWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FilesList > resp = getFilesListWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Get all files and folders within a folder.
     * @param request Request object
     * @return ApiResponse< FilesList >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FilesList > getFilesListWithHttpInfo(GetFilesListRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getFilesListValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Get all files and folders within a folder. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFilesListAsync(GetFilesListRequest request, final ApiCallback< FilesList > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFilesListValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFootnoteValidateBeforeCall(GetFootnoteRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a footnote from the document node.
     * @param request Request object
     * @return FootnoteResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FootnoteResponse getFootnote(GetFootnoteRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FootnoteResponse > resp = getFootnoteWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FootnoteResponse > resp = getFootnoteWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a footnote from the document node.
     * @param request Request object
     * @return ApiResponse< FootnoteResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FootnoteResponse > getFootnoteWithHttpInfo(GetFootnoteRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getFootnoteValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a footnote from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFootnoteAsync(GetFootnoteRequest request, final ApiCallback< FootnoteResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFootnoteValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFootnoteOnlineValidateBeforeCall(GetFootnoteOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a footnote from the document node.
     * @param request Request object
     * @return FootnoteResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FootnoteResponse getFootnoteOnline(GetFootnoteOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FootnoteResponse > resp = getFootnoteOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FootnoteResponse > resp = getFootnoteOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a footnote from the document node.
     * @param request Request object
     * @return ApiResponse< FootnoteResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FootnoteResponse > getFootnoteOnlineWithHttpInfo(GetFootnoteOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getFootnoteOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a footnote from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFootnoteOnlineAsync(GetFootnoteOnlineRequest request, final ApiCallback< FootnoteResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFootnoteOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFootnotesValidateBeforeCall(GetFootnotesRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads footnotes from the document node.
     * @param request Request object
     * @return FootnotesResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FootnotesResponse getFootnotes(GetFootnotesRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FootnotesResponse > resp = getFootnotesWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FootnotesResponse > resp = getFootnotesWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads footnotes from the document node.
     * @param request Request object
     * @return ApiResponse< FootnotesResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FootnotesResponse > getFootnotesWithHttpInfo(GetFootnotesRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getFootnotesValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads footnotes from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFootnotesAsync(GetFootnotesRequest request, final ApiCallback< FootnotesResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFootnotesValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFootnotesOnlineValidateBeforeCall(GetFootnotesOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads footnotes from the document node.
     * @param request Request object
     * @return FootnotesResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FootnotesResponse getFootnotesOnline(GetFootnotesOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FootnotesResponse > resp = getFootnotesOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FootnotesResponse > resp = getFootnotesOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads footnotes from the document node.
     * @param request Request object
     * @return ApiResponse< FootnotesResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FootnotesResponse > getFootnotesOnlineWithHttpInfo(GetFootnotesOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getFootnotesOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads footnotes from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFootnotesOnlineAsync(GetFootnotesOnlineRequest request, final ApiCallback< FootnotesResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFootnotesOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFormFieldValidateBeforeCall(GetFormFieldRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a form field from the document node.
     * @param request Request object
     * @return FormFieldResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FormFieldResponse getFormField(GetFormFieldRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FormFieldResponse > resp = getFormFieldWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FormFieldResponse > resp = getFormFieldWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a form field from the document node.
     * @param request Request object
     * @return ApiResponse< FormFieldResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FormFieldResponse > getFormFieldWithHttpInfo(GetFormFieldRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getFormFieldValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a form field from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFormFieldAsync(GetFormFieldRequest request, final ApiCallback< FormFieldResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFormFieldValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFormFieldOnlineValidateBeforeCall(GetFormFieldOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a form field from the document node.
     * @param request Request object
     * @return FormFieldResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FormFieldResponse getFormFieldOnline(GetFormFieldOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FormFieldResponse > resp = getFormFieldOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FormFieldResponse > resp = getFormFieldOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a form field from the document node.
     * @param request Request object
     * @return ApiResponse< FormFieldResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FormFieldResponse > getFormFieldOnlineWithHttpInfo(GetFormFieldOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getFormFieldOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a form field from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFormFieldOnlineAsync(GetFormFieldOnlineRequest request, final ApiCallback< FormFieldResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFormFieldOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFormFieldsValidateBeforeCall(GetFormFieldsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads form fields from the document node.
     * @param request Request object
     * @return FormFieldsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FormFieldsResponse getFormFields(GetFormFieldsRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FormFieldsResponse > resp = getFormFieldsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FormFieldsResponse > resp = getFormFieldsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads form fields from the document node.
     * @param request Request object
     * @return ApiResponse< FormFieldsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FormFieldsResponse > getFormFieldsWithHttpInfo(GetFormFieldsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getFormFieldsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads form fields from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFormFieldsAsync(GetFormFieldsRequest request, final ApiCallback< FormFieldsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFormFieldsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFormFieldsOnlineValidateBeforeCall(GetFormFieldsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads form fields from the document node.
     * @param request Request object
     * @return FormFieldsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FormFieldsResponse getFormFieldsOnline(GetFormFieldsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FormFieldsResponse > resp = getFormFieldsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FormFieldsResponse > resp = getFormFieldsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads form fields from the document node.
     * @param request Request object
     * @return ApiResponse< FormFieldsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FormFieldsResponse > getFormFieldsOnlineWithHttpInfo(GetFormFieldsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getFormFieldsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads form fields from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFormFieldsOnlineAsync(GetFormFieldsOnlineRequest request, final ApiCallback< FormFieldsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFormFieldsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getHeaderFooterValidateBeforeCall(GetHeaderFooterRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a HeaderFooter object from the document.
     * @param request Request object
     * @return HeaderFooterResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public HeaderFooterResponse getHeaderFooter(GetHeaderFooterRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< HeaderFooterResponse > resp = getHeaderFooterWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< HeaderFooterResponse > resp = getHeaderFooterWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a HeaderFooter object from the document.
     * @param request Request object
     * @return ApiResponse< HeaderFooterResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< HeaderFooterResponse > getHeaderFooterWithHttpInfo(GetHeaderFooterRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getHeaderFooterValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a HeaderFooter object from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getHeaderFooterAsync(GetHeaderFooterRequest request, final ApiCallback< HeaderFooterResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getHeaderFooterValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getHeaderFooterOfSectionValidateBeforeCall(GetHeaderFooterOfSectionRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a HeaderFooter object from the document section.
     * @param request Request object
     * @return HeaderFooterResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public HeaderFooterResponse getHeaderFooterOfSection(GetHeaderFooterOfSectionRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< HeaderFooterResponse > resp = getHeaderFooterOfSectionWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< HeaderFooterResponse > resp = getHeaderFooterOfSectionWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a HeaderFooter object from the document section.
     * @param request Request object
     * @return ApiResponse< HeaderFooterResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< HeaderFooterResponse > getHeaderFooterOfSectionWithHttpInfo(GetHeaderFooterOfSectionRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getHeaderFooterOfSectionValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a HeaderFooter object from the document section. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getHeaderFooterOfSectionAsync(GetHeaderFooterOfSectionRequest request, final ApiCallback< HeaderFooterResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getHeaderFooterOfSectionValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getHeaderFooterOfSectionOnlineValidateBeforeCall(GetHeaderFooterOfSectionOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a HeaderFooter object from the document section.
     * @param request Request object
     * @return HeaderFooterResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public HeaderFooterResponse getHeaderFooterOfSectionOnline(GetHeaderFooterOfSectionOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< HeaderFooterResponse > resp = getHeaderFooterOfSectionOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< HeaderFooterResponse > resp = getHeaderFooterOfSectionOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a HeaderFooter object from the document section.
     * @param request Request object
     * @return ApiResponse< HeaderFooterResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< HeaderFooterResponse > getHeaderFooterOfSectionOnlineWithHttpInfo(GetHeaderFooterOfSectionOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getHeaderFooterOfSectionOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a HeaderFooter object from the document section. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getHeaderFooterOfSectionOnlineAsync(GetHeaderFooterOfSectionOnlineRequest request, final ApiCallback< HeaderFooterResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getHeaderFooterOfSectionOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getHeaderFooterOnlineValidateBeforeCall(GetHeaderFooterOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a HeaderFooter object from the document.
     * @param request Request object
     * @return HeaderFooterResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public HeaderFooterResponse getHeaderFooterOnline(GetHeaderFooterOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< HeaderFooterResponse > resp = getHeaderFooterOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< HeaderFooterResponse > resp = getHeaderFooterOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a HeaderFooter object from the document.
     * @param request Request object
     * @return ApiResponse< HeaderFooterResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< HeaderFooterResponse > getHeaderFooterOnlineWithHttpInfo(GetHeaderFooterOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getHeaderFooterOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a HeaderFooter object from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getHeaderFooterOnlineAsync(GetHeaderFooterOnlineRequest request, final ApiCallback< HeaderFooterResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getHeaderFooterOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getHeaderFootersValidateBeforeCall(GetHeaderFootersRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads HeaderFooter objects from the document section.
     * @param request Request object
     * @return HeaderFootersResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public HeaderFootersResponse getHeaderFooters(GetHeaderFootersRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< HeaderFootersResponse > resp = getHeaderFootersWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< HeaderFootersResponse > resp = getHeaderFootersWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads HeaderFooter objects from the document section.
     * @param request Request object
     * @return ApiResponse< HeaderFootersResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< HeaderFootersResponse > getHeaderFootersWithHttpInfo(GetHeaderFootersRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getHeaderFootersValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads HeaderFooter objects from the document section. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getHeaderFootersAsync(GetHeaderFootersRequest request, final ApiCallback< HeaderFootersResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getHeaderFootersValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getHeaderFootersOnlineValidateBeforeCall(GetHeaderFootersOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads HeaderFooter objects from the document section.
     * @param request Request object
     * @return HeaderFootersResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public HeaderFootersResponse getHeaderFootersOnline(GetHeaderFootersOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< HeaderFootersResponse > resp = getHeaderFootersOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< HeaderFootersResponse > resp = getHeaderFootersOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads HeaderFooter objects from the document section.
     * @param request Request object
     * @return ApiResponse< HeaderFootersResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< HeaderFootersResponse > getHeaderFootersOnlineWithHttpInfo(GetHeaderFootersOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getHeaderFootersOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads HeaderFooter objects from the document section. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getHeaderFootersOnlineAsync(GetHeaderFootersOnlineRequest request, final ApiCallback< HeaderFootersResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getHeaderFootersOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getInfoValidateBeforeCall(GetInfoRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Returns application info.
     * @param request Request object
     * @return InfoResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InfoResponse getInfo(GetInfoRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InfoResponse > resp = getInfoWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InfoResponse > resp = getInfoWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Returns application info.
     * @param request Request object
     * @return ApiResponse< InfoResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InfoResponse > getInfoWithHttpInfo(GetInfoRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getInfoValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Returns application info. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getInfoAsync(GetInfoRequest request, final ApiCallback< InfoResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getInfoValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getListValidateBeforeCall(GetListRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a list from the document.
     * @param request Request object
     * @return ListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ListResponse getList(GetListRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ListResponse > resp = getListWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ListResponse > resp = getListWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a list from the document.
     * @param request Request object
     * @return ApiResponse< ListResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ListResponse > getListWithHttpInfo(GetListRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getListValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a list from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getListAsync(GetListRequest request, final ApiCallback< ListResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getListValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getListOnlineValidateBeforeCall(GetListOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a list from the document.
     * @param request Request object
     * @return ListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ListResponse getListOnline(GetListOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ListResponse > resp = getListOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ListResponse > resp = getListOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a list from the document.
     * @param request Request object
     * @return ApiResponse< ListResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ListResponse > getListOnlineWithHttpInfo(GetListOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getListOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a list from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getListOnlineAsync(GetListOnlineRequest request, final ApiCallback< ListResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getListOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getListsValidateBeforeCall(GetListsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads lists from the document.
     * @param request Request object
     * @return ListsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ListsResponse getLists(GetListsRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ListsResponse > resp = getListsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ListsResponse > resp = getListsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads lists from the document.
     * @param request Request object
     * @return ApiResponse< ListsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ListsResponse > getListsWithHttpInfo(GetListsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getListsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads lists from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getListsAsync(GetListsRequest request, final ApiCallback< ListsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getListsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getListsOnlineValidateBeforeCall(GetListsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads lists from the document.
     * @param request Request object
     * @return ListsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ListsResponse getListsOnline(GetListsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ListsResponse > resp = getListsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ListsResponse > resp = getListsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads lists from the document.
     * @param request Request object
     * @return ApiResponse< ListsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ListsResponse > getListsOnlineWithHttpInfo(GetListsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getListsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads lists from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getListsOnlineAsync(GetListsOnlineRequest request, final ApiCallback< ListsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getListsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getOfficeMathObjectValidateBeforeCall(GetOfficeMathObjectRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads an OfficeMath object from the document node.
     * @param request Request object
     * @return OfficeMathObjectResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public OfficeMathObjectResponse getOfficeMathObject(GetOfficeMathObjectRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< OfficeMathObjectResponse > resp = getOfficeMathObjectWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< OfficeMathObjectResponse > resp = getOfficeMathObjectWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads an OfficeMath object from the document node.
     * @param request Request object
     * @return ApiResponse< OfficeMathObjectResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< OfficeMathObjectResponse > getOfficeMathObjectWithHttpInfo(GetOfficeMathObjectRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getOfficeMathObjectValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads an OfficeMath object from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getOfficeMathObjectAsync(GetOfficeMathObjectRequest request, final ApiCallback< OfficeMathObjectResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getOfficeMathObjectValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getOfficeMathObjectOnlineValidateBeforeCall(GetOfficeMathObjectOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads an OfficeMath object from the document node.
     * @param request Request object
     * @return OfficeMathObjectResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public OfficeMathObjectResponse getOfficeMathObjectOnline(GetOfficeMathObjectOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< OfficeMathObjectResponse > resp = getOfficeMathObjectOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< OfficeMathObjectResponse > resp = getOfficeMathObjectOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads an OfficeMath object from the document node.
     * @param request Request object
     * @return ApiResponse< OfficeMathObjectResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< OfficeMathObjectResponse > getOfficeMathObjectOnlineWithHttpInfo(GetOfficeMathObjectOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getOfficeMathObjectOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads an OfficeMath object from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getOfficeMathObjectOnlineAsync(GetOfficeMathObjectOnlineRequest request, final ApiCallback< OfficeMathObjectResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getOfficeMathObjectOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getOfficeMathObjectsValidateBeforeCall(GetOfficeMathObjectsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads OfficeMath objects from the document node.
     * @param request Request object
     * @return OfficeMathObjectsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public OfficeMathObjectsResponse getOfficeMathObjects(GetOfficeMathObjectsRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< OfficeMathObjectsResponse > resp = getOfficeMathObjectsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< OfficeMathObjectsResponse > resp = getOfficeMathObjectsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads OfficeMath objects from the document node.
     * @param request Request object
     * @return ApiResponse< OfficeMathObjectsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< OfficeMathObjectsResponse > getOfficeMathObjectsWithHttpInfo(GetOfficeMathObjectsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getOfficeMathObjectsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads OfficeMath objects from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getOfficeMathObjectsAsync(GetOfficeMathObjectsRequest request, final ApiCallback< OfficeMathObjectsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getOfficeMathObjectsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getOfficeMathObjectsOnlineValidateBeforeCall(GetOfficeMathObjectsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads OfficeMath objects from the document node.
     * @param request Request object
     * @return OfficeMathObjectsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public OfficeMathObjectsResponse getOfficeMathObjectsOnline(GetOfficeMathObjectsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< OfficeMathObjectsResponse > resp = getOfficeMathObjectsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< OfficeMathObjectsResponse > resp = getOfficeMathObjectsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads OfficeMath objects from the document node.
     * @param request Request object
     * @return ApiResponse< OfficeMathObjectsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< OfficeMathObjectsResponse > getOfficeMathObjectsOnlineWithHttpInfo(GetOfficeMathObjectsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getOfficeMathObjectsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads OfficeMath objects from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getOfficeMathObjectsOnlineAsync(GetOfficeMathObjectsOnlineRequest request, final ApiCallback< OfficeMathObjectsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getOfficeMathObjectsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getParagraphValidateBeforeCall(GetParagraphRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a paragraph from the document node.
     * @param request Request object
     * @return ParagraphResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ParagraphResponse getParagraph(GetParagraphRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ParagraphResponse > resp = getParagraphWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ParagraphResponse > resp = getParagraphWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a paragraph from the document node.
     * @param request Request object
     * @return ApiResponse< ParagraphResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ParagraphResponse > getParagraphWithHttpInfo(GetParagraphRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getParagraphValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a paragraph from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getParagraphAsync(GetParagraphRequest request, final ApiCallback< ParagraphResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getParagraphValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getParagraphFormatValidateBeforeCall(GetParagraphFormatRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads the formatting properties of a paragraph from the document node.
     * @param request Request object
     * @return ParagraphFormatResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ParagraphFormatResponse getParagraphFormat(GetParagraphFormatRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ParagraphFormatResponse > resp = getParagraphFormatWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ParagraphFormatResponse > resp = getParagraphFormatWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads the formatting properties of a paragraph from the document node.
     * @param request Request object
     * @return ApiResponse< ParagraphFormatResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ParagraphFormatResponse > getParagraphFormatWithHttpInfo(GetParagraphFormatRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getParagraphFormatValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads the formatting properties of a paragraph from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getParagraphFormatAsync(GetParagraphFormatRequest request, final ApiCallback< ParagraphFormatResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getParagraphFormatValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getParagraphFormatOnlineValidateBeforeCall(GetParagraphFormatOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads the formatting properties of a paragraph from the document node.
     * @param request Request object
     * @return ParagraphFormatResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ParagraphFormatResponse getParagraphFormatOnline(GetParagraphFormatOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ParagraphFormatResponse > resp = getParagraphFormatOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ParagraphFormatResponse > resp = getParagraphFormatOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads the formatting properties of a paragraph from the document node.
     * @param request Request object
     * @return ApiResponse< ParagraphFormatResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ParagraphFormatResponse > getParagraphFormatOnlineWithHttpInfo(GetParagraphFormatOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getParagraphFormatOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads the formatting properties of a paragraph from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getParagraphFormatOnlineAsync(GetParagraphFormatOnlineRequest request, final ApiCallback< ParagraphFormatResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getParagraphFormatOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getParagraphListFormatValidateBeforeCall(GetParagraphListFormatRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads the formatting properties of a paragraph list from the document node.
     * @param request Request object
     * @return ParagraphListFormatResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ParagraphListFormatResponse getParagraphListFormat(GetParagraphListFormatRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ParagraphListFormatResponse > resp = getParagraphListFormatWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ParagraphListFormatResponse > resp = getParagraphListFormatWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads the formatting properties of a paragraph list from the document node.
     * @param request Request object
     * @return ApiResponse< ParagraphListFormatResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ParagraphListFormatResponse > getParagraphListFormatWithHttpInfo(GetParagraphListFormatRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getParagraphListFormatValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads the formatting properties of a paragraph list from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getParagraphListFormatAsync(GetParagraphListFormatRequest request, final ApiCallback< ParagraphListFormatResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getParagraphListFormatValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getParagraphListFormatOnlineValidateBeforeCall(GetParagraphListFormatOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads the formatting properties of a paragraph list from the document node.
     * @param request Request object
     * @return ParagraphListFormatResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ParagraphListFormatResponse getParagraphListFormatOnline(GetParagraphListFormatOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ParagraphListFormatResponse > resp = getParagraphListFormatOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ParagraphListFormatResponse > resp = getParagraphListFormatOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads the formatting properties of a paragraph list from the document node.
     * @param request Request object
     * @return ApiResponse< ParagraphListFormatResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ParagraphListFormatResponse > getParagraphListFormatOnlineWithHttpInfo(GetParagraphListFormatOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getParagraphListFormatOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads the formatting properties of a paragraph list from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getParagraphListFormatOnlineAsync(GetParagraphListFormatOnlineRequest request, final ApiCallback< ParagraphListFormatResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getParagraphListFormatOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getParagraphOnlineValidateBeforeCall(GetParagraphOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a paragraph from the document node.
     * @param request Request object
     * @return ParagraphResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ParagraphResponse getParagraphOnline(GetParagraphOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ParagraphResponse > resp = getParagraphOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ParagraphResponse > resp = getParagraphOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a paragraph from the document node.
     * @param request Request object
     * @return ApiResponse< ParagraphResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ParagraphResponse > getParagraphOnlineWithHttpInfo(GetParagraphOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getParagraphOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a paragraph from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getParagraphOnlineAsync(GetParagraphOnlineRequest request, final ApiCallback< ParagraphResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getParagraphOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getParagraphsValidateBeforeCall(GetParagraphsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads paragraphs from the document node.
     * @param request Request object
     * @return ParagraphLinkCollectionResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ParagraphLinkCollectionResponse getParagraphs(GetParagraphsRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ParagraphLinkCollectionResponse > resp = getParagraphsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ParagraphLinkCollectionResponse > resp = getParagraphsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads paragraphs from the document node.
     * @param request Request object
     * @return ApiResponse< ParagraphLinkCollectionResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ParagraphLinkCollectionResponse > getParagraphsWithHttpInfo(GetParagraphsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getParagraphsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads paragraphs from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getParagraphsAsync(GetParagraphsRequest request, final ApiCallback< ParagraphLinkCollectionResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getParagraphsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getParagraphsOnlineValidateBeforeCall(GetParagraphsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads paragraphs from the document node.
     * @param request Request object
     * @return ParagraphLinkCollectionResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ParagraphLinkCollectionResponse getParagraphsOnline(GetParagraphsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ParagraphLinkCollectionResponse > resp = getParagraphsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ParagraphLinkCollectionResponse > resp = getParagraphsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads paragraphs from the document node.
     * @param request Request object
     * @return ApiResponse< ParagraphLinkCollectionResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ParagraphLinkCollectionResponse > getParagraphsOnlineWithHttpInfo(GetParagraphsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getParagraphsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads paragraphs from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getParagraphsOnlineAsync(GetParagraphsOnlineRequest request, final ApiCallback< ParagraphLinkCollectionResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getParagraphsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getParagraphTabStopsValidateBeforeCall(GetParagraphTabStopsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads paragraph tab stops from the document node.
     * @param request Request object
     * @return TabStopsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TabStopsResponse getParagraphTabStops(GetParagraphTabStopsRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TabStopsResponse > resp = getParagraphTabStopsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TabStopsResponse > resp = getParagraphTabStopsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads paragraph tab stops from the document node.
     * @param request Request object
     * @return ApiResponse< TabStopsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TabStopsResponse > getParagraphTabStopsWithHttpInfo(GetParagraphTabStopsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getParagraphTabStopsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads paragraph tab stops from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getParagraphTabStopsAsync(GetParagraphTabStopsRequest request, final ApiCallback< TabStopsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getParagraphTabStopsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getParagraphTabStopsOnlineValidateBeforeCall(GetParagraphTabStopsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads paragraph tab stops from the document node.
     * @param request Request object
     * @return TabStopsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TabStopsResponse getParagraphTabStopsOnline(GetParagraphTabStopsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TabStopsResponse > resp = getParagraphTabStopsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TabStopsResponse > resp = getParagraphTabStopsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads paragraph tab stops from the document node.
     * @param request Request object
     * @return ApiResponse< TabStopsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TabStopsResponse > getParagraphTabStopsOnlineWithHttpInfo(GetParagraphTabStopsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getParagraphTabStopsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads paragraph tab stops from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getParagraphTabStopsOnlineAsync(GetParagraphTabStopsOnlineRequest request, final ApiCallback< TabStopsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getParagraphTabStopsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPublicKeyValidateBeforeCall(GetPublicKeyRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Get asymmetric public key.
     * @param request Request object
     * @return PublicKeyResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public PublicKeyResponse getPublicKey(GetPublicKeyRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< PublicKeyResponse > resp = getPublicKeyWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< PublicKeyResponse > resp = getPublicKeyWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Get asymmetric public key.
     * @param request Request object
     * @return ApiResponse< PublicKeyResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< PublicKeyResponse > getPublicKeyWithHttpInfo(GetPublicKeyRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getPublicKeyValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Get asymmetric public key. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPublicKeyAsync(GetPublicKeyRequest request, final ApiCallback< PublicKeyResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPublicKeyValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getRangeTextValidateBeforeCall(GetRangeTextRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads range text from the document.
     * @param request Request object
     * @return RangeTextResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public RangeTextResponse getRangeText(GetRangeTextRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< RangeTextResponse > resp = getRangeTextWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< RangeTextResponse > resp = getRangeTextWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads range text from the document.
     * @param request Request object
     * @return ApiResponse< RangeTextResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< RangeTextResponse > getRangeTextWithHttpInfo(GetRangeTextRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getRangeTextValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads range text from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getRangeTextAsync(GetRangeTextRequest request, final ApiCallback< RangeTextResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getRangeTextValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getRangeTextOnlineValidateBeforeCall(GetRangeTextOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads range text from the document.
     * @param request Request object
     * @return RangeTextResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public RangeTextResponse getRangeTextOnline(GetRangeTextOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< RangeTextResponse > resp = getRangeTextOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< RangeTextResponse > resp = getRangeTextOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads range text from the document.
     * @param request Request object
     * @return ApiResponse< RangeTextResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< RangeTextResponse > getRangeTextOnlineWithHttpInfo(GetRangeTextOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getRangeTextOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads range text from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getRangeTextOnlineAsync(GetRangeTextOnlineRequest request, final ApiCallback< RangeTextResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getRangeTextOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getRunValidateBeforeCall(GetRunRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a Run object from the paragraph.
     * @param request Request object
     * @return RunResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public RunResponse getRun(GetRunRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< RunResponse > resp = getRunWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< RunResponse > resp = getRunWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a Run object from the paragraph.
     * @param request Request object
     * @return ApiResponse< RunResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< RunResponse > getRunWithHttpInfo(GetRunRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getRunValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a Run object from the paragraph. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getRunAsync(GetRunRequest request, final ApiCallback< RunResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getRunValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getRunFontValidateBeforeCall(GetRunFontRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads the font properties of a Run object from the paragraph.
     * @param request Request object
     * @return FontResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FontResponse getRunFont(GetRunFontRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FontResponse > resp = getRunFontWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FontResponse > resp = getRunFontWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads the font properties of a Run object from the paragraph.
     * @param request Request object
     * @return ApiResponse< FontResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FontResponse > getRunFontWithHttpInfo(GetRunFontRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getRunFontValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads the font properties of a Run object from the paragraph. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getRunFontAsync(GetRunFontRequest request, final ApiCallback< FontResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getRunFontValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getRunFontOnlineValidateBeforeCall(GetRunFontOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads the font properties of a Run object from the paragraph.
     * @param request Request object
     * @return FontResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FontResponse getRunFontOnline(GetRunFontOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FontResponse > resp = getRunFontOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FontResponse > resp = getRunFontOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads the font properties of a Run object from the paragraph.
     * @param request Request object
     * @return ApiResponse< FontResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FontResponse > getRunFontOnlineWithHttpInfo(GetRunFontOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getRunFontOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads the font properties of a Run object from the paragraph. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getRunFontOnlineAsync(GetRunFontOnlineRequest request, final ApiCallback< FontResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getRunFontOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getRunOnlineValidateBeforeCall(GetRunOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a Run object from the paragraph.
     * @param request Request object
     * @return RunResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public RunResponse getRunOnline(GetRunOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< RunResponse > resp = getRunOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< RunResponse > resp = getRunOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a Run object from the paragraph.
     * @param request Request object
     * @return ApiResponse< RunResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< RunResponse > getRunOnlineWithHttpInfo(GetRunOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getRunOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a Run object from the paragraph. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getRunOnlineAsync(GetRunOnlineRequest request, final ApiCallback< RunResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getRunOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getRunsValidateBeforeCall(GetRunsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads Run objects from the paragraph.
     * @param request Request object
     * @return RunsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public RunsResponse getRuns(GetRunsRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< RunsResponse > resp = getRunsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< RunsResponse > resp = getRunsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads Run objects from the paragraph.
     * @param request Request object
     * @return ApiResponse< RunsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< RunsResponse > getRunsWithHttpInfo(GetRunsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getRunsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads Run objects from the paragraph. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getRunsAsync(GetRunsRequest request, final ApiCallback< RunsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getRunsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getRunsOnlineValidateBeforeCall(GetRunsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads Run objects from the paragraph.
     * @param request Request object
     * @return RunsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public RunsResponse getRunsOnline(GetRunsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< RunsResponse > resp = getRunsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< RunsResponse > resp = getRunsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads Run objects from the paragraph.
     * @param request Request object
     * @return ApiResponse< RunsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< RunsResponse > getRunsOnlineWithHttpInfo(GetRunsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getRunsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads Run objects from the paragraph. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getRunsOnlineAsync(GetRunsOnlineRequest request, final ApiCallback< RunsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getRunsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSectionValidateBeforeCall(GetSectionRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a section from the document.
     * @param request Request object
     * @return SectionResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public SectionResponse getSection(GetSectionRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< SectionResponse > resp = getSectionWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< SectionResponse > resp = getSectionWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a section from the document.
     * @param request Request object
     * @return ApiResponse< SectionResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< SectionResponse > getSectionWithHttpInfo(GetSectionRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getSectionValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a section from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSectionAsync(GetSectionRequest request, final ApiCallback< SectionResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getSectionValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSectionOnlineValidateBeforeCall(GetSectionOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a section from the document.
     * @param request Request object
     * @return SectionResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public SectionResponse getSectionOnline(GetSectionOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< SectionResponse > resp = getSectionOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< SectionResponse > resp = getSectionOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a section from the document.
     * @param request Request object
     * @return ApiResponse< SectionResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< SectionResponse > getSectionOnlineWithHttpInfo(GetSectionOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getSectionOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a section from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSectionOnlineAsync(GetSectionOnlineRequest request, final ApiCallback< SectionResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getSectionOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSectionPageSetupValidateBeforeCall(GetSectionPageSetupRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads the page setup of a section from the document.
     * @param request Request object
     * @return SectionPageSetupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public SectionPageSetupResponse getSectionPageSetup(GetSectionPageSetupRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< SectionPageSetupResponse > resp = getSectionPageSetupWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< SectionPageSetupResponse > resp = getSectionPageSetupWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads the page setup of a section from the document.
     * @param request Request object
     * @return ApiResponse< SectionPageSetupResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< SectionPageSetupResponse > getSectionPageSetupWithHttpInfo(GetSectionPageSetupRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getSectionPageSetupValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads the page setup of a section from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSectionPageSetupAsync(GetSectionPageSetupRequest request, final ApiCallback< SectionPageSetupResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getSectionPageSetupValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSectionPageSetupOnlineValidateBeforeCall(GetSectionPageSetupOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads the page setup of a section from the document.
     * @param request Request object
     * @return SectionPageSetupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public SectionPageSetupResponse getSectionPageSetupOnline(GetSectionPageSetupOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< SectionPageSetupResponse > resp = getSectionPageSetupOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< SectionPageSetupResponse > resp = getSectionPageSetupOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads the page setup of a section from the document.
     * @param request Request object
     * @return ApiResponse< SectionPageSetupResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< SectionPageSetupResponse > getSectionPageSetupOnlineWithHttpInfo(GetSectionPageSetupOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getSectionPageSetupOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads the page setup of a section from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSectionPageSetupOnlineAsync(GetSectionPageSetupOnlineRequest request, final ApiCallback< SectionPageSetupResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getSectionPageSetupOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSectionsValidateBeforeCall(GetSectionsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads sections from the document.
     * @param request Request object
     * @return SectionLinkCollectionResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public SectionLinkCollectionResponse getSections(GetSectionsRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< SectionLinkCollectionResponse > resp = getSectionsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< SectionLinkCollectionResponse > resp = getSectionsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads sections from the document.
     * @param request Request object
     * @return ApiResponse< SectionLinkCollectionResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< SectionLinkCollectionResponse > getSectionsWithHttpInfo(GetSectionsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getSectionsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads sections from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSectionsAsync(GetSectionsRequest request, final ApiCallback< SectionLinkCollectionResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getSectionsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSectionsOnlineValidateBeforeCall(GetSectionsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads sections from the document.
     * @param request Request object
     * @return SectionLinkCollectionResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public SectionLinkCollectionResponse getSectionsOnline(GetSectionsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< SectionLinkCollectionResponse > resp = getSectionsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< SectionLinkCollectionResponse > resp = getSectionsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads sections from the document.
     * @param request Request object
     * @return ApiResponse< SectionLinkCollectionResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< SectionLinkCollectionResponse > getSectionsOnlineWithHttpInfo(GetSectionsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getSectionsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads sections from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSectionsOnlineAsync(GetSectionsOnlineRequest request, final ApiCallback< SectionLinkCollectionResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getSectionsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSignaturesValidateBeforeCall(GetSignaturesRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Gets signatures from the document.
     * @param request Request object
     * @return SignatureCollectionResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public SignatureCollectionResponse getSignatures(GetSignaturesRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< SignatureCollectionResponse > resp = getSignaturesWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< SignatureCollectionResponse > resp = getSignaturesWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Gets signatures from the document.
     * @param request Request object
     * @return ApiResponse< SignatureCollectionResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< SignatureCollectionResponse > getSignaturesWithHttpInfo(GetSignaturesRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getSignaturesValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Gets signatures from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSignaturesAsync(GetSignaturesRequest request, final ApiCallback< SignatureCollectionResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getSignaturesValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSignaturesOnlineValidateBeforeCall(GetSignaturesOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Gets signatures from the document.
     * @param request Request object
     * @return SignatureCollectionResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public SignatureCollectionResponse getSignaturesOnline(GetSignaturesOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< SignatureCollectionResponse > resp = getSignaturesOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< SignatureCollectionResponse > resp = getSignaturesOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Gets signatures from the document.
     * @param request Request object
     * @return ApiResponse< SignatureCollectionResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< SignatureCollectionResponse > getSignaturesOnlineWithHttpInfo(GetSignaturesOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getSignaturesOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Gets signatures from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSignaturesOnlineAsync(GetSignaturesOnlineRequest request, final ApiCallback< SignatureCollectionResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getSignaturesOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getStructuredDocumentTagValidateBeforeCall(GetStructuredDocumentTagRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a StructuredDocumentTag (SDT) from the document node.
     * @param request Request object
     * @return StructuredDocumentTagResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public StructuredDocumentTagResponse getStructuredDocumentTag(GetStructuredDocumentTagRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< StructuredDocumentTagResponse > resp = getStructuredDocumentTagWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< StructuredDocumentTagResponse > resp = getStructuredDocumentTagWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a StructuredDocumentTag (SDT) from the document node.
     * @param request Request object
     * @return ApiResponse< StructuredDocumentTagResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< StructuredDocumentTagResponse > getStructuredDocumentTagWithHttpInfo(GetStructuredDocumentTagRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getStructuredDocumentTagValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a StructuredDocumentTag (SDT) from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getStructuredDocumentTagAsync(GetStructuredDocumentTagRequest request, final ApiCallback< StructuredDocumentTagResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getStructuredDocumentTagValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getStructuredDocumentTagOnlineValidateBeforeCall(GetStructuredDocumentTagOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a StructuredDocumentTag (SDT) from the document node.
     * @param request Request object
     * @return StructuredDocumentTagResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public StructuredDocumentTagResponse getStructuredDocumentTagOnline(GetStructuredDocumentTagOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< StructuredDocumentTagResponse > resp = getStructuredDocumentTagOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< StructuredDocumentTagResponse > resp = getStructuredDocumentTagOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a StructuredDocumentTag (SDT) from the document node.
     * @param request Request object
     * @return ApiResponse< StructuredDocumentTagResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< StructuredDocumentTagResponse > getStructuredDocumentTagOnlineWithHttpInfo(GetStructuredDocumentTagOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getStructuredDocumentTagOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a StructuredDocumentTag (SDT) from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getStructuredDocumentTagOnlineAsync(GetStructuredDocumentTagOnlineRequest request, final ApiCallback< StructuredDocumentTagResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getStructuredDocumentTagOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getStructuredDocumentTagsValidateBeforeCall(GetStructuredDocumentTagsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads StructuredDocumentTags (SDT) from the document node.
     * @param request Request object
     * @return StructuredDocumentTagsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public StructuredDocumentTagsResponse getStructuredDocumentTags(GetStructuredDocumentTagsRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< StructuredDocumentTagsResponse > resp = getStructuredDocumentTagsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< StructuredDocumentTagsResponse > resp = getStructuredDocumentTagsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads StructuredDocumentTags (SDT) from the document node.
     * @param request Request object
     * @return ApiResponse< StructuredDocumentTagsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< StructuredDocumentTagsResponse > getStructuredDocumentTagsWithHttpInfo(GetStructuredDocumentTagsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getStructuredDocumentTagsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads StructuredDocumentTags (SDT) from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getStructuredDocumentTagsAsync(GetStructuredDocumentTagsRequest request, final ApiCallback< StructuredDocumentTagsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getStructuredDocumentTagsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getStructuredDocumentTagsOnlineValidateBeforeCall(GetStructuredDocumentTagsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads StructuredDocumentTags (SDT) from the document node.
     * @param request Request object
     * @return StructuredDocumentTagsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public StructuredDocumentTagsResponse getStructuredDocumentTagsOnline(GetStructuredDocumentTagsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< StructuredDocumentTagsResponse > resp = getStructuredDocumentTagsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< StructuredDocumentTagsResponse > resp = getStructuredDocumentTagsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads StructuredDocumentTags (SDT) from the document node.
     * @param request Request object
     * @return ApiResponse< StructuredDocumentTagsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< StructuredDocumentTagsResponse > getStructuredDocumentTagsOnlineWithHttpInfo(GetStructuredDocumentTagsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getStructuredDocumentTagsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads StructuredDocumentTags (SDT) from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getStructuredDocumentTagsOnlineAsync(GetStructuredDocumentTagsOnlineRequest request, final ApiCallback< StructuredDocumentTagsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getStructuredDocumentTagsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getStyleValidateBeforeCall(GetStyleRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a style from the document.
     * @param request Request object
     * @return StyleResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public StyleResponse getStyle(GetStyleRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< StyleResponse > resp = getStyleWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< StyleResponse > resp = getStyleWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a style from the document.
     * @param request Request object
     * @return ApiResponse< StyleResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< StyleResponse > getStyleWithHttpInfo(GetStyleRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getStyleValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a style from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getStyleAsync(GetStyleRequest request, final ApiCallback< StyleResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getStyleValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getStyleFromDocumentElementValidateBeforeCall(GetStyleFromDocumentElementRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a style from the document node.
     * @param request Request object
     * @return StyleResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public StyleResponse getStyleFromDocumentElement(GetStyleFromDocumentElementRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< StyleResponse > resp = getStyleFromDocumentElementWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< StyleResponse > resp = getStyleFromDocumentElementWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a style from the document node.
     * @param request Request object
     * @return ApiResponse< StyleResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< StyleResponse > getStyleFromDocumentElementWithHttpInfo(GetStyleFromDocumentElementRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getStyleFromDocumentElementValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a style from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getStyleFromDocumentElementAsync(GetStyleFromDocumentElementRequest request, final ApiCallback< StyleResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getStyleFromDocumentElementValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getStyleFromDocumentElementOnlineValidateBeforeCall(GetStyleFromDocumentElementOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a style from the document node.
     * @param request Request object
     * @return StyleResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public StyleResponse getStyleFromDocumentElementOnline(GetStyleFromDocumentElementOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< StyleResponse > resp = getStyleFromDocumentElementOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< StyleResponse > resp = getStyleFromDocumentElementOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a style from the document node.
     * @param request Request object
     * @return ApiResponse< StyleResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< StyleResponse > getStyleFromDocumentElementOnlineWithHttpInfo(GetStyleFromDocumentElementOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getStyleFromDocumentElementOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a style from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getStyleFromDocumentElementOnlineAsync(GetStyleFromDocumentElementOnlineRequest request, final ApiCallback< StyleResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getStyleFromDocumentElementOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getStyleOnlineValidateBeforeCall(GetStyleOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a style from the document.
     * @param request Request object
     * @return StyleResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public StyleResponse getStyleOnline(GetStyleOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< StyleResponse > resp = getStyleOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< StyleResponse > resp = getStyleOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a style from the document.
     * @param request Request object
     * @return ApiResponse< StyleResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< StyleResponse > getStyleOnlineWithHttpInfo(GetStyleOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getStyleOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a style from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getStyleOnlineAsync(GetStyleOnlineRequest request, final ApiCallback< StyleResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getStyleOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getStylesValidateBeforeCall(GetStylesRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads styles from the document.
     * @param request Request object
     * @return StylesResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public StylesResponse getStyles(GetStylesRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< StylesResponse > resp = getStylesWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< StylesResponse > resp = getStylesWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads styles from the document.
     * @param request Request object
     * @return ApiResponse< StylesResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< StylesResponse > getStylesWithHttpInfo(GetStylesRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getStylesValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads styles from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getStylesAsync(GetStylesRequest request, final ApiCallback< StylesResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getStylesValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getStylesOnlineValidateBeforeCall(GetStylesOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads styles from the document.
     * @param request Request object
     * @return StylesResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public StylesResponse getStylesOnline(GetStylesOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< StylesResponse > resp = getStylesOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< StylesResponse > resp = getStylesOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads styles from the document.
     * @param request Request object
     * @return ApiResponse< StylesResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< StylesResponse > getStylesOnlineWithHttpInfo(GetStylesOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getStylesOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads styles from the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getStylesOnlineAsync(GetStylesOnlineRequest request, final ApiCallback< StylesResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getStylesOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTableValidateBeforeCall(GetTableRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a table from the document node.
     * @param request Request object
     * @return TableResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TableResponse getTable(GetTableRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TableResponse > resp = getTableWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TableResponse > resp = getTableWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a table from the document node.
     * @param request Request object
     * @return ApiResponse< TableResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TableResponse > getTableWithHttpInfo(GetTableRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getTableValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a table from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTableAsync(GetTableRequest request, final ApiCallback< TableResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTableValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTableCellValidateBeforeCall(GetTableCellRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a cell from the table row.
     * @param request Request object
     * @return TableCellResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TableCellResponse getTableCell(GetTableCellRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TableCellResponse > resp = getTableCellWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TableCellResponse > resp = getTableCellWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a cell from the table row.
     * @param request Request object
     * @return ApiResponse< TableCellResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TableCellResponse > getTableCellWithHttpInfo(GetTableCellRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getTableCellValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a cell from the table row. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTableCellAsync(GetTableCellRequest request, final ApiCallback< TableCellResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTableCellValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTableCellFormatValidateBeforeCall(GetTableCellFormatRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads the formatting properties of a table cell.
     * @param request Request object
     * @return TableCellFormatResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TableCellFormatResponse getTableCellFormat(GetTableCellFormatRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TableCellFormatResponse > resp = getTableCellFormatWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TableCellFormatResponse > resp = getTableCellFormatWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads the formatting properties of a table cell.
     * @param request Request object
     * @return ApiResponse< TableCellFormatResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TableCellFormatResponse > getTableCellFormatWithHttpInfo(GetTableCellFormatRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getTableCellFormatValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads the formatting properties of a table cell. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTableCellFormatAsync(GetTableCellFormatRequest request, final ApiCallback< TableCellFormatResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTableCellFormatValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTableCellFormatOnlineValidateBeforeCall(GetTableCellFormatOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads the formatting properties of a table cell.
     * @param request Request object
     * @return TableCellFormatResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TableCellFormatResponse getTableCellFormatOnline(GetTableCellFormatOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TableCellFormatResponse > resp = getTableCellFormatOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TableCellFormatResponse > resp = getTableCellFormatOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads the formatting properties of a table cell.
     * @param request Request object
     * @return ApiResponse< TableCellFormatResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TableCellFormatResponse > getTableCellFormatOnlineWithHttpInfo(GetTableCellFormatOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getTableCellFormatOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads the formatting properties of a table cell. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTableCellFormatOnlineAsync(GetTableCellFormatOnlineRequest request, final ApiCallback< TableCellFormatResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTableCellFormatOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTableCellOnlineValidateBeforeCall(GetTableCellOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a cell from the table row.
     * @param request Request object
     * @return TableCellResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TableCellResponse getTableCellOnline(GetTableCellOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TableCellResponse > resp = getTableCellOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TableCellResponse > resp = getTableCellOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a cell from the table row.
     * @param request Request object
     * @return ApiResponse< TableCellResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TableCellResponse > getTableCellOnlineWithHttpInfo(GetTableCellOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getTableCellOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a cell from the table row. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTableCellOnlineAsync(GetTableCellOnlineRequest request, final ApiCallback< TableCellResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTableCellOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTableOnlineValidateBeforeCall(GetTableOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a table from the document node.
     * @param request Request object
     * @return TableResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TableResponse getTableOnline(GetTableOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TableResponse > resp = getTableOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TableResponse > resp = getTableOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a table from the document node.
     * @param request Request object
     * @return ApiResponse< TableResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TableResponse > getTableOnlineWithHttpInfo(GetTableOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getTableOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a table from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTableOnlineAsync(GetTableOnlineRequest request, final ApiCallback< TableResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTableOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTablePropertiesValidateBeforeCall(GetTablePropertiesRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads properties of a table from the document node.
     * @param request Request object
     * @return TablePropertiesResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TablePropertiesResponse getTableProperties(GetTablePropertiesRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TablePropertiesResponse > resp = getTablePropertiesWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TablePropertiesResponse > resp = getTablePropertiesWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads properties of a table from the document node.
     * @param request Request object
     * @return ApiResponse< TablePropertiesResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TablePropertiesResponse > getTablePropertiesWithHttpInfo(GetTablePropertiesRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getTablePropertiesValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads properties of a table from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTablePropertiesAsync(GetTablePropertiesRequest request, final ApiCallback< TablePropertiesResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTablePropertiesValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTablePropertiesOnlineValidateBeforeCall(GetTablePropertiesOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads properties of a table from the document node.
     * @param request Request object
     * @return TablePropertiesResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TablePropertiesResponse getTablePropertiesOnline(GetTablePropertiesOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TablePropertiesResponse > resp = getTablePropertiesOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TablePropertiesResponse > resp = getTablePropertiesOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads properties of a table from the document node.
     * @param request Request object
     * @return ApiResponse< TablePropertiesResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TablePropertiesResponse > getTablePropertiesOnlineWithHttpInfo(GetTablePropertiesOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getTablePropertiesOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads properties of a table from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTablePropertiesOnlineAsync(GetTablePropertiesOnlineRequest request, final ApiCallback< TablePropertiesResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTablePropertiesOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTableRowValidateBeforeCall(GetTableRowRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a row from the table.
     * @param request Request object
     * @return TableRowResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TableRowResponse getTableRow(GetTableRowRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TableRowResponse > resp = getTableRowWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TableRowResponse > resp = getTableRowWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a row from the table.
     * @param request Request object
     * @return ApiResponse< TableRowResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TableRowResponse > getTableRowWithHttpInfo(GetTableRowRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getTableRowValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a row from the table. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTableRowAsync(GetTableRowRequest request, final ApiCallback< TableRowResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTableRowValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTableRowFormatValidateBeforeCall(GetTableRowFormatRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads the formatting properties of a table row.
     * @param request Request object
     * @return TableRowFormatResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TableRowFormatResponse getTableRowFormat(GetTableRowFormatRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TableRowFormatResponse > resp = getTableRowFormatWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TableRowFormatResponse > resp = getTableRowFormatWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads the formatting properties of a table row.
     * @param request Request object
     * @return ApiResponse< TableRowFormatResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TableRowFormatResponse > getTableRowFormatWithHttpInfo(GetTableRowFormatRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getTableRowFormatValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads the formatting properties of a table row. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTableRowFormatAsync(GetTableRowFormatRequest request, final ApiCallback< TableRowFormatResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTableRowFormatValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTableRowFormatOnlineValidateBeforeCall(GetTableRowFormatOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads the formatting properties of a table row.
     * @param request Request object
     * @return TableRowFormatResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TableRowFormatResponse getTableRowFormatOnline(GetTableRowFormatOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TableRowFormatResponse > resp = getTableRowFormatOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TableRowFormatResponse > resp = getTableRowFormatOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads the formatting properties of a table row.
     * @param request Request object
     * @return ApiResponse< TableRowFormatResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TableRowFormatResponse > getTableRowFormatOnlineWithHttpInfo(GetTableRowFormatOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getTableRowFormatOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads the formatting properties of a table row. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTableRowFormatOnlineAsync(GetTableRowFormatOnlineRequest request, final ApiCallback< TableRowFormatResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTableRowFormatOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTableRowOnlineValidateBeforeCall(GetTableRowOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads a row from the table.
     * @param request Request object
     * @return TableRowResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TableRowResponse getTableRowOnline(GetTableRowOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TableRowResponse > resp = getTableRowOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TableRowResponse > resp = getTableRowOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads a row from the table.
     * @param request Request object
     * @return ApiResponse< TableRowResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TableRowResponse > getTableRowOnlineWithHttpInfo(GetTableRowOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getTableRowOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads a row from the table. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTableRowOnlineAsync(GetTableRowOnlineRequest request, final ApiCallback< TableRowResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTableRowOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTablesValidateBeforeCall(GetTablesRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads tables from the document node.
     * @param request Request object
     * @return TableLinkCollectionResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TableLinkCollectionResponse getTables(GetTablesRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TableLinkCollectionResponse > resp = getTablesWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TableLinkCollectionResponse > resp = getTablesWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads tables from the document node.
     * @param request Request object
     * @return ApiResponse< TableLinkCollectionResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TableLinkCollectionResponse > getTablesWithHttpInfo(GetTablesRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getTablesValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads tables from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTablesAsync(GetTablesRequest request, final ApiCallback< TableLinkCollectionResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTablesValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTablesOnlineValidateBeforeCall(GetTablesOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Reads tables from the document node.
     * @param request Request object
     * @return TableLinkCollectionResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TableLinkCollectionResponse getTablesOnline(GetTablesOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TableLinkCollectionResponse > resp = getTablesOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TableLinkCollectionResponse > resp = getTablesOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Reads tables from the document node.
     * @param request Request object
     * @return ApiResponse< TableLinkCollectionResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TableLinkCollectionResponse > getTablesOnlineWithHttpInfo(GetTablesOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = getTablesOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Reads tables from the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTablesOnlineAsync(GetTablesOnlineRequest request, final ApiCallback< TableLinkCollectionResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTablesOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertBookmarkValidateBeforeCall(InsertBookmarkRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new bookmark to the document.
     * @param request Request object
     * @return BookmarkResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public BookmarkResponse insertBookmark(InsertBookmarkRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< BookmarkResponse > resp = insertBookmarkWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< BookmarkResponse > resp = insertBookmarkWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new bookmark to the document.
     * @param request Request object
     * @return ApiResponse< BookmarkResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< BookmarkResponse > insertBookmarkWithHttpInfo(InsertBookmarkRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertBookmarkValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new bookmark to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertBookmarkAsync(InsertBookmarkRequest request, final ApiCallback< BookmarkResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertBookmarkValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertBookmarkOnlineValidateBeforeCall(InsertBookmarkOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new bookmark to the document.
     * @param request Request object
     * @return InsertBookmarkOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InsertBookmarkOnlineResponse insertBookmarkOnline(InsertBookmarkOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertBookmarkOnlineResponse > resp = insertBookmarkOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertBookmarkOnlineResponse > resp = insertBookmarkOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new bookmark to the document.
     * @param request Request object
     * @return ApiResponse< InsertBookmarkOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertBookmarkOnlineResponse > insertBookmarkOnlineWithHttpInfo(InsertBookmarkOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertBookmarkOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new bookmark to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertBookmarkOnlineAsync(InsertBookmarkOnlineRequest request, final ApiCallback< InsertBookmarkOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertBookmarkOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertCommentValidateBeforeCall(InsertCommentRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new comment to the document.
     * @param request Request object
     * @return CommentResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public CommentResponse insertComment(InsertCommentRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< CommentResponse > resp = insertCommentWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< CommentResponse > resp = insertCommentWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new comment to the document.
     * @param request Request object
     * @return ApiResponse< CommentResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< CommentResponse > insertCommentWithHttpInfo(InsertCommentRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertCommentValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new comment to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertCommentAsync(InsertCommentRequest request, final ApiCallback< CommentResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertCommentValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertCommentOnlineValidateBeforeCall(InsertCommentOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new comment to the document.
     * @param request Request object
     * @return InsertCommentOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InsertCommentOnlineResponse insertCommentOnline(InsertCommentOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertCommentOnlineResponse > resp = insertCommentOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertCommentOnlineResponse > resp = insertCommentOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new comment to the document.
     * @param request Request object
     * @return ApiResponse< InsertCommentOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertCommentOnlineResponse > insertCommentOnlineWithHttpInfo(InsertCommentOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertCommentOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new comment to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertCommentOnlineAsync(InsertCommentOnlineRequest request, final ApiCallback< InsertCommentOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertCommentOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertCustomXmlPartValidateBeforeCall(InsertCustomXmlPartRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new custom xml part to the document.
     * @param request Request object
     * @return CustomXmlPartResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public CustomXmlPartResponse insertCustomXmlPart(InsertCustomXmlPartRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< CustomXmlPartResponse > resp = insertCustomXmlPartWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< CustomXmlPartResponse > resp = insertCustomXmlPartWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new custom xml part to the document.
     * @param request Request object
     * @return ApiResponse< CustomXmlPartResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< CustomXmlPartResponse > insertCustomXmlPartWithHttpInfo(InsertCustomXmlPartRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertCustomXmlPartValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new custom xml part to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertCustomXmlPartAsync(InsertCustomXmlPartRequest request, final ApiCallback< CustomXmlPartResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertCustomXmlPartValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertCustomXmlPartOnlineValidateBeforeCall(InsertCustomXmlPartOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new custom xml part to the document.
     * @param request Request object
     * @return InsertCustomXmlPartOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InsertCustomXmlPartOnlineResponse insertCustomXmlPartOnline(InsertCustomXmlPartOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertCustomXmlPartOnlineResponse > resp = insertCustomXmlPartOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertCustomXmlPartOnlineResponse > resp = insertCustomXmlPartOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new custom xml part to the document.
     * @param request Request object
     * @return ApiResponse< InsertCustomXmlPartOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertCustomXmlPartOnlineResponse > insertCustomXmlPartOnlineWithHttpInfo(InsertCustomXmlPartOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertCustomXmlPartOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new custom xml part to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertCustomXmlPartOnlineAsync(InsertCustomXmlPartOnlineRequest request, final ApiCallback< InsertCustomXmlPartOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertCustomXmlPartOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertDrawingObjectValidateBeforeCall(InsertDrawingObjectRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new DrawingObject to the document node.
     * @param request Request object
     * @return DrawingObjectResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DrawingObjectResponse insertDrawingObject(InsertDrawingObjectRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DrawingObjectResponse > resp = insertDrawingObjectWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DrawingObjectResponse > resp = insertDrawingObjectWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new DrawingObject to the document node.
     * @param request Request object
     * @return ApiResponse< DrawingObjectResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DrawingObjectResponse > insertDrawingObjectWithHttpInfo(InsertDrawingObjectRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertDrawingObjectValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new DrawingObject to the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertDrawingObjectAsync(InsertDrawingObjectRequest request, final ApiCallback< DrawingObjectResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertDrawingObjectValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertDrawingObjectOnlineValidateBeforeCall(InsertDrawingObjectOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new DrawingObject to the document node.
     * @param request Request object
     * @return InsertDrawingObjectOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InsertDrawingObjectOnlineResponse insertDrawingObjectOnline(InsertDrawingObjectOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertDrawingObjectOnlineResponse > resp = insertDrawingObjectOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertDrawingObjectOnlineResponse > resp = insertDrawingObjectOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new DrawingObject to the document node.
     * @param request Request object
     * @return ApiResponse< InsertDrawingObjectOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertDrawingObjectOnlineResponse > insertDrawingObjectOnlineWithHttpInfo(InsertDrawingObjectOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertDrawingObjectOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new DrawingObject to the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertDrawingObjectOnlineAsync(InsertDrawingObjectOnlineRequest request, final ApiCallback< InsertDrawingObjectOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertDrawingObjectOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertFieldValidateBeforeCall(InsertFieldRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new field to the document node.
     * @param request Request object
     * @return FieldResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FieldResponse insertField(InsertFieldRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FieldResponse > resp = insertFieldWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FieldResponse > resp = insertFieldWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new field to the document node.
     * @param request Request object
     * @return ApiResponse< FieldResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FieldResponse > insertFieldWithHttpInfo(InsertFieldRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertFieldValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new field to the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertFieldAsync(InsertFieldRequest request, final ApiCallback< FieldResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertFieldValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertFieldOnlineValidateBeforeCall(InsertFieldOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new field to the document node.
     * @param request Request object
     * @return InsertFieldOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InsertFieldOnlineResponse insertFieldOnline(InsertFieldOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertFieldOnlineResponse > resp = insertFieldOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertFieldOnlineResponse > resp = insertFieldOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new field to the document node.
     * @param request Request object
     * @return ApiResponse< InsertFieldOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertFieldOnlineResponse > insertFieldOnlineWithHttpInfo(InsertFieldOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertFieldOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new field to the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertFieldOnlineAsync(InsertFieldOnlineRequest request, final ApiCallback< InsertFieldOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertFieldOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertFootnoteValidateBeforeCall(InsertFootnoteRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new footnote to the document node.
     * @param request Request object
     * @return FootnoteResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FootnoteResponse insertFootnote(InsertFootnoteRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FootnoteResponse > resp = insertFootnoteWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FootnoteResponse > resp = insertFootnoteWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new footnote to the document node.
     * @param request Request object
     * @return ApiResponse< FootnoteResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FootnoteResponse > insertFootnoteWithHttpInfo(InsertFootnoteRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertFootnoteValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new footnote to the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertFootnoteAsync(InsertFootnoteRequest request, final ApiCallback< FootnoteResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertFootnoteValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertFootnoteOnlineValidateBeforeCall(InsertFootnoteOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new footnote to the document node.
     * @param request Request object
     * @return InsertFootnoteOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InsertFootnoteOnlineResponse insertFootnoteOnline(InsertFootnoteOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertFootnoteOnlineResponse > resp = insertFootnoteOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertFootnoteOnlineResponse > resp = insertFootnoteOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new footnote to the document node.
     * @param request Request object
     * @return ApiResponse< InsertFootnoteOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertFootnoteOnlineResponse > insertFootnoteOnlineWithHttpInfo(InsertFootnoteOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertFootnoteOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new footnote to the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertFootnoteOnlineAsync(InsertFootnoteOnlineRequest request, final ApiCallback< InsertFootnoteOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertFootnoteOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertFormFieldValidateBeforeCall(InsertFormFieldRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new form field to the document node.
     * @param request Request object
     * @return FormFieldResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public FormFieldResponse insertFormField(InsertFormFieldRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< FormFieldResponse > resp = insertFormFieldWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< FormFieldResponse > resp = insertFormFieldWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new form field to the document node.
     * @param request Request object
     * @return ApiResponse< FormFieldResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< FormFieldResponse > insertFormFieldWithHttpInfo(InsertFormFieldRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertFormFieldValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new form field to the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertFormFieldAsync(InsertFormFieldRequest request, final ApiCallback< FormFieldResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertFormFieldValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertFormFieldOnlineValidateBeforeCall(InsertFormFieldOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new form field to the document node.
     * @param request Request object
     * @return InsertFormFieldOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InsertFormFieldOnlineResponse insertFormFieldOnline(InsertFormFieldOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertFormFieldOnlineResponse > resp = insertFormFieldOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertFormFieldOnlineResponse > resp = insertFormFieldOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new form field to the document node.
     * @param request Request object
     * @return ApiResponse< InsertFormFieldOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertFormFieldOnlineResponse > insertFormFieldOnlineWithHttpInfo(InsertFormFieldOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertFormFieldOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new form field to the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertFormFieldOnlineAsync(InsertFormFieldOnlineRequest request, final ApiCallback< InsertFormFieldOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertFormFieldOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertHeaderFooterValidateBeforeCall(InsertHeaderFooterRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new HeaderFooter object to the document section.
     * @param request Request object
     * @return HeaderFooterResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public HeaderFooterResponse insertHeaderFooter(InsertHeaderFooterRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< HeaderFooterResponse > resp = insertHeaderFooterWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< HeaderFooterResponse > resp = insertHeaderFooterWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new HeaderFooter object to the document section.
     * @param request Request object
     * @return ApiResponse< HeaderFooterResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< HeaderFooterResponse > insertHeaderFooterWithHttpInfo(InsertHeaderFooterRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertHeaderFooterValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new HeaderFooter object to the document section. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertHeaderFooterAsync(InsertHeaderFooterRequest request, final ApiCallback< HeaderFooterResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertHeaderFooterValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertHeaderFooterOnlineValidateBeforeCall(InsertHeaderFooterOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new HeaderFooter object to the document section.
     * @param request Request object
     * @return InsertHeaderFooterOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InsertHeaderFooterOnlineResponse insertHeaderFooterOnline(InsertHeaderFooterOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertHeaderFooterOnlineResponse > resp = insertHeaderFooterOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertHeaderFooterOnlineResponse > resp = insertHeaderFooterOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new HeaderFooter object to the document section.
     * @param request Request object
     * @return ApiResponse< InsertHeaderFooterOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertHeaderFooterOnlineResponse > insertHeaderFooterOnlineWithHttpInfo(InsertHeaderFooterOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertHeaderFooterOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new HeaderFooter object to the document section. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertHeaderFooterOnlineAsync(InsertHeaderFooterOnlineRequest request, final ApiCallback< InsertHeaderFooterOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertHeaderFooterOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertListValidateBeforeCall(InsertListRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new list to the document.
     * @param request Request object
     * @return ListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ListResponse insertList(InsertListRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ListResponse > resp = insertListWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ListResponse > resp = insertListWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new list to the document.
     * @param request Request object
     * @return ApiResponse< ListResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ListResponse > insertListWithHttpInfo(InsertListRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertListValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new list to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertListAsync(InsertListRequest request, final ApiCallback< ListResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertListValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertListOnlineValidateBeforeCall(InsertListOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new list to the document.
     * @param request Request object
     * @return InsertListOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InsertListOnlineResponse insertListOnline(InsertListOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertListOnlineResponse > resp = insertListOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertListOnlineResponse > resp = insertListOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new list to the document.
     * @param request Request object
     * @return ApiResponse< InsertListOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertListOnlineResponse > insertListOnlineWithHttpInfo(InsertListOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertListOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new list to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertListOnlineAsync(InsertListOnlineRequest request, final ApiCallback< InsertListOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertListOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertOrUpdateParagraphTabStopValidateBeforeCall(InsertOrUpdateParagraphTabStopRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new or updates an existing paragraph tab stop in the document node.
     * @param request Request object
     * @return TabStopsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TabStopsResponse insertOrUpdateParagraphTabStop(InsertOrUpdateParagraphTabStopRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TabStopsResponse > resp = insertOrUpdateParagraphTabStopWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TabStopsResponse > resp = insertOrUpdateParagraphTabStopWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new or updates an existing paragraph tab stop in the document node.
     * @param request Request object
     * @return ApiResponse< TabStopsResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TabStopsResponse > insertOrUpdateParagraphTabStopWithHttpInfo(InsertOrUpdateParagraphTabStopRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertOrUpdateParagraphTabStopValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new or updates an existing paragraph tab stop in the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertOrUpdateParagraphTabStopAsync(InsertOrUpdateParagraphTabStopRequest request, final ApiCallback< TabStopsResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertOrUpdateParagraphTabStopValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertOrUpdateParagraphTabStopOnlineValidateBeforeCall(InsertOrUpdateParagraphTabStopOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new or updates an existing paragraph tab stop in the document node.
     * @param request Request object
     * @return InsertOrUpdateParagraphTabStopOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InsertOrUpdateParagraphTabStopOnlineResponse insertOrUpdateParagraphTabStopOnline(InsertOrUpdateParagraphTabStopOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertOrUpdateParagraphTabStopOnlineResponse > resp = insertOrUpdateParagraphTabStopOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertOrUpdateParagraphTabStopOnlineResponse > resp = insertOrUpdateParagraphTabStopOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new or updates an existing paragraph tab stop in the document node.
     * @param request Request object
     * @return ApiResponse< InsertOrUpdateParagraphTabStopOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertOrUpdateParagraphTabStopOnlineResponse > insertOrUpdateParagraphTabStopOnlineWithHttpInfo(InsertOrUpdateParagraphTabStopOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertOrUpdateParagraphTabStopOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new or updates an existing paragraph tab stop in the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertOrUpdateParagraphTabStopOnlineAsync(InsertOrUpdateParagraphTabStopOnlineRequest request, final ApiCallback< InsertOrUpdateParagraphTabStopOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertOrUpdateParagraphTabStopOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertPageNumbersValidateBeforeCall(InsertPageNumbersRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts page numbers to the document.
     * @param request Request object
     * @return DocumentResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DocumentResponse insertPageNumbers(InsertPageNumbersRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DocumentResponse > resp = insertPageNumbersWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DocumentResponse > resp = insertPageNumbersWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts page numbers to the document.
     * @param request Request object
     * @return ApiResponse< DocumentResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DocumentResponse > insertPageNumbersWithHttpInfo(InsertPageNumbersRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertPageNumbersValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts page numbers to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertPageNumbersAsync(InsertPageNumbersRequest request, final ApiCallback< DocumentResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertPageNumbersValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertPageNumbersOnlineValidateBeforeCall(InsertPageNumbersOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts page numbers to the document.
     * @param request Request object
     * @return InsertPageNumbersOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InsertPageNumbersOnlineResponse insertPageNumbersOnline(InsertPageNumbersOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertPageNumbersOnlineResponse > resp = insertPageNumbersOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertPageNumbersOnlineResponse > resp = insertPageNumbersOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts page numbers to the document.
     * @param request Request object
     * @return ApiResponse< InsertPageNumbersOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertPageNumbersOnlineResponse > insertPageNumbersOnlineWithHttpInfo(InsertPageNumbersOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertPageNumbersOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts page numbers to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertPageNumbersOnlineAsync(InsertPageNumbersOnlineRequest request, final ApiCallback< InsertPageNumbersOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertPageNumbersOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertParagraphValidateBeforeCall(InsertParagraphRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new paragraph to the document node.
     * @param request Request object
     * @return ParagraphResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ParagraphResponse insertParagraph(InsertParagraphRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ParagraphResponse > resp = insertParagraphWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ParagraphResponse > resp = insertParagraphWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new paragraph to the document node.
     * @param request Request object
     * @return ApiResponse< ParagraphResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ParagraphResponse > insertParagraphWithHttpInfo(InsertParagraphRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertParagraphValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new paragraph to the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertParagraphAsync(InsertParagraphRequest request, final ApiCallback< ParagraphResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertParagraphValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertParagraphOnlineValidateBeforeCall(InsertParagraphOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new paragraph to the document node.
     * @param request Request object
     * @return InsertParagraphOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InsertParagraphOnlineResponse insertParagraphOnline(InsertParagraphOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertParagraphOnlineResponse > resp = insertParagraphOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertParagraphOnlineResponse > resp = insertParagraphOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new paragraph to the document node.
     * @param request Request object
     * @return ApiResponse< InsertParagraphOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertParagraphOnlineResponse > insertParagraphOnlineWithHttpInfo(InsertParagraphOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertParagraphOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new paragraph to the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertParagraphOnlineAsync(InsertParagraphOnlineRequest request, final ApiCallback< InsertParagraphOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertParagraphOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertRunValidateBeforeCall(InsertRunRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new Run object to the paragraph.
     * @param request Request object
     * @return RunResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public RunResponse insertRun(InsertRunRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< RunResponse > resp = insertRunWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< RunResponse > resp = insertRunWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new Run object to the paragraph.
     * @param request Request object
     * @return ApiResponse< RunResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< RunResponse > insertRunWithHttpInfo(InsertRunRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertRunValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new Run object to the paragraph. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertRunAsync(InsertRunRequest request, final ApiCallback< RunResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertRunValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertRunOnlineValidateBeforeCall(InsertRunOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new Run object to the paragraph.
     * @param request Request object
     * @return InsertRunOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InsertRunOnlineResponse insertRunOnline(InsertRunOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertRunOnlineResponse > resp = insertRunOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertRunOnlineResponse > resp = insertRunOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new Run object to the paragraph.
     * @param request Request object
     * @return ApiResponse< InsertRunOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertRunOnlineResponse > insertRunOnlineWithHttpInfo(InsertRunOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertRunOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new Run object to the paragraph. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertRunOnlineAsync(InsertRunOnlineRequest request, final ApiCallback< InsertRunOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertRunOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertSectionValidateBeforeCall(InsertSectionRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a section to the document.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void insertSection(InsertSectionRequest request) throws ApiException, MessagingException, IOException {
        try {
    insertSectionWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    insertSectionWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Inserts a section to the document.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > insertSectionWithHttpInfo(InsertSectionRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertSectionValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a section to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertSectionAsync(InsertSectionRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertSectionValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertSectionOnlineValidateBeforeCall(InsertSectionOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a section to the document.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> insertSectionOnline(InsertSectionOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = insertSectionOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = insertSectionOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a section to the document.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > insertSectionOnlineWithHttpInfo(InsertSectionOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertSectionOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a section to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertSectionOnlineAsync(InsertSectionOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertSectionOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertStructuredDocumentTagValidateBeforeCall(InsertStructuredDocumentTagRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new StructuredDocumentTag (SDT) to the document node.
     * @param request Request object
     * @return StructuredDocumentTagResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public StructuredDocumentTagResponse insertStructuredDocumentTag(InsertStructuredDocumentTagRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< StructuredDocumentTagResponse > resp = insertStructuredDocumentTagWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< StructuredDocumentTagResponse > resp = insertStructuredDocumentTagWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new StructuredDocumentTag (SDT) to the document node.
     * @param request Request object
     * @return ApiResponse< StructuredDocumentTagResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< StructuredDocumentTagResponse > insertStructuredDocumentTagWithHttpInfo(InsertStructuredDocumentTagRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertStructuredDocumentTagValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new StructuredDocumentTag (SDT) to the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertStructuredDocumentTagAsync(InsertStructuredDocumentTagRequest request, final ApiCallback< StructuredDocumentTagResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertStructuredDocumentTagValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertStructuredDocumentTagOnlineValidateBeforeCall(InsertStructuredDocumentTagOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new StructuredDocumentTag (SDT) to the document node.
     * @param request Request object
     * @return InsertStructuredDocumentTagOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InsertStructuredDocumentTagOnlineResponse insertStructuredDocumentTagOnline(InsertStructuredDocumentTagOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertStructuredDocumentTagOnlineResponse > resp = insertStructuredDocumentTagOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertStructuredDocumentTagOnlineResponse > resp = insertStructuredDocumentTagOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new StructuredDocumentTag (SDT) to the document node.
     * @param request Request object
     * @return ApiResponse< InsertStructuredDocumentTagOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertStructuredDocumentTagOnlineResponse > insertStructuredDocumentTagOnlineWithHttpInfo(InsertStructuredDocumentTagOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertStructuredDocumentTagOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new StructuredDocumentTag (SDT) to the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertStructuredDocumentTagOnlineAsync(InsertStructuredDocumentTagOnlineRequest request, final ApiCallback< InsertStructuredDocumentTagOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertStructuredDocumentTagOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertStyleValidateBeforeCall(InsertStyleRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new style to the document.
     * @param request Request object
     * @return StyleResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public StyleResponse insertStyle(InsertStyleRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< StyleResponse > resp = insertStyleWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< StyleResponse > resp = insertStyleWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new style to the document.
     * @param request Request object
     * @return ApiResponse< StyleResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< StyleResponse > insertStyleWithHttpInfo(InsertStyleRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertStyleValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new style to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertStyleAsync(InsertStyleRequest request, final ApiCallback< StyleResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertStyleValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertStyleOnlineValidateBeforeCall(InsertStyleOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new style to the document.
     * @param request Request object
     * @return InsertStyleOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InsertStyleOnlineResponse insertStyleOnline(InsertStyleOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertStyleOnlineResponse > resp = insertStyleOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertStyleOnlineResponse > resp = insertStyleOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new style to the document.
     * @param request Request object
     * @return ApiResponse< InsertStyleOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertStyleOnlineResponse > insertStyleOnlineWithHttpInfo(InsertStyleOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertStyleOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new style to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertStyleOnlineAsync(InsertStyleOnlineRequest request, final ApiCallback< InsertStyleOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertStyleOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertTableValidateBeforeCall(InsertTableRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new table to the document node.
     * @param request Request object
     * @return TableResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TableResponse insertTable(InsertTableRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TableResponse > resp = insertTableWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TableResponse > resp = insertTableWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new table to the document node.
     * @param request Request object
     * @return ApiResponse< TableResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TableResponse > insertTableWithHttpInfo(InsertTableRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertTableValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new table to the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertTableAsync(InsertTableRequest request, final ApiCallback< TableResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertTableValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertTableCellValidateBeforeCall(InsertTableCellRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new cell to the table row.
     * @param request Request object
     * @return TableCellResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TableCellResponse insertTableCell(InsertTableCellRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TableCellResponse > resp = insertTableCellWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TableCellResponse > resp = insertTableCellWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new cell to the table row.
     * @param request Request object
     * @return ApiResponse< TableCellResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TableCellResponse > insertTableCellWithHttpInfo(InsertTableCellRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertTableCellValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new cell to the table row. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertTableCellAsync(InsertTableCellRequest request, final ApiCallback< TableCellResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertTableCellValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertTableCellOnlineValidateBeforeCall(InsertTableCellOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new cell to the table row.
     * @param request Request object
     * @return InsertTableCellOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InsertTableCellOnlineResponse insertTableCellOnline(InsertTableCellOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertTableCellOnlineResponse > resp = insertTableCellOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertTableCellOnlineResponse > resp = insertTableCellOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new cell to the table row.
     * @param request Request object
     * @return ApiResponse< InsertTableCellOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertTableCellOnlineResponse > insertTableCellOnlineWithHttpInfo(InsertTableCellOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertTableCellOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new cell to the table row. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertTableCellOnlineAsync(InsertTableCellOnlineRequest request, final ApiCallback< InsertTableCellOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertTableCellOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertTableOnlineValidateBeforeCall(InsertTableOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new table to the document node.
     * @param request Request object
     * @return InsertTableOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InsertTableOnlineResponse insertTableOnline(InsertTableOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertTableOnlineResponse > resp = insertTableOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertTableOnlineResponse > resp = insertTableOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new table to the document node.
     * @param request Request object
     * @return ApiResponse< InsertTableOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertTableOnlineResponse > insertTableOnlineWithHttpInfo(InsertTableOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertTableOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new table to the document node. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertTableOnlineAsync(InsertTableOnlineRequest request, final ApiCallback< InsertTableOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertTableOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertTableRowValidateBeforeCall(InsertTableRowRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new row to the table.
     * @param request Request object
     * @return TableRowResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public TableRowResponse insertTableRow(InsertTableRowRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< TableRowResponse > resp = insertTableRowWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< TableRowResponse > resp = insertTableRowWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new row to the table.
     * @param request Request object
     * @return ApiResponse< TableRowResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< TableRowResponse > insertTableRowWithHttpInfo(InsertTableRowRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertTableRowValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new row to the table. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertTableRowAsync(InsertTableRowRequest request, final ApiCallback< TableRowResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertTableRowValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertTableRowOnlineValidateBeforeCall(InsertTableRowOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new row to the table.
     * @param request Request object
     * @return InsertTableRowOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InsertTableRowOnlineResponse insertTableRowOnline(InsertTableRowOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertTableRowOnlineResponse > resp = insertTableRowOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertTableRowOnlineResponse > resp = insertTableRowOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new row to the table.
     * @param request Request object
     * @return ApiResponse< InsertTableRowOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertTableRowOnlineResponse > insertTableRowOnlineWithHttpInfo(InsertTableRowOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertTableRowOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new row to the table. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertTableRowOnlineAsync(InsertTableRowOnlineRequest request, final ApiCallback< InsertTableRowOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertTableRowOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertWatermarkValidateBeforeCall(InsertWatermarkRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Insert a watermark to the document.
     * @param request Request object
     * @return DocumentResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public DocumentResponse insertWatermark(InsertWatermarkRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DocumentResponse > resp = insertWatermarkWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DocumentResponse > resp = insertWatermarkWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Insert a watermark to the document.
     * @param request Request object
     * @return ApiResponse< DocumentResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DocumentResponse > insertWatermarkWithHttpInfo(InsertWatermarkRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertWatermarkValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Insert a watermark to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertWatermarkAsync(InsertWatermarkRequest request, final ApiCallback< DocumentResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertWatermarkValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertWatermarkImageValidateBeforeCall(InsertWatermarkImageRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new watermark image to the document.
     * @deprecated This operation is deprecated and is used for backward compatibility only. Please use InsertWatermark instead.
     * @param request Request object
     * @return DocumentResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    @Deprecated
    public DocumentResponse insertWatermarkImage(InsertWatermarkImageRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DocumentResponse > resp = insertWatermarkImageWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DocumentResponse > resp = insertWatermarkImageWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new watermark image to the document.
     * @param request Request object
     * @return ApiResponse< DocumentResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DocumentResponse > insertWatermarkImageWithHttpInfo(InsertWatermarkImageRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertWatermarkImageValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new watermark image to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertWatermarkImageAsync(InsertWatermarkImageRequest request, final ApiCallback< DocumentResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertWatermarkImageValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertWatermarkImageOnlineValidateBeforeCall(InsertWatermarkImageOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new watermark image to the document.
     * @deprecated This operation is deprecated and is used for backward compatibility only. Please use InsertWatermark instead.
     * @param request Request object
     * @return InsertWatermarkImageOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    @Deprecated
    public InsertWatermarkImageOnlineResponse insertWatermarkImageOnline(InsertWatermarkImageOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertWatermarkImageOnlineResponse > resp = insertWatermarkImageOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertWatermarkImageOnlineResponse > resp = insertWatermarkImageOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new watermark image to the document.
     * @param request Request object
     * @return ApiResponse< InsertWatermarkImageOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertWatermarkImageOnlineResponse > insertWatermarkImageOnlineWithHttpInfo(InsertWatermarkImageOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertWatermarkImageOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new watermark image to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertWatermarkImageOnlineAsync(InsertWatermarkImageOnlineRequest request, final ApiCallback< InsertWatermarkImageOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertWatermarkImageOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertWatermarkOnlineValidateBeforeCall(InsertWatermarkOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Insert a watermark to the document.
     * @param request Request object
     * @return InsertWatermarkOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public InsertWatermarkOnlineResponse insertWatermarkOnline(InsertWatermarkOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertWatermarkOnlineResponse > resp = insertWatermarkOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertWatermarkOnlineResponse > resp = insertWatermarkOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Insert a watermark to the document.
     * @param request Request object
     * @return ApiResponse< InsertWatermarkOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertWatermarkOnlineResponse > insertWatermarkOnlineWithHttpInfo(InsertWatermarkOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertWatermarkOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Insert a watermark to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertWatermarkOnlineAsync(InsertWatermarkOnlineRequest request, final ApiCallback< InsertWatermarkOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertWatermarkOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertWatermarkTextValidateBeforeCall(InsertWatermarkTextRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new watermark text to the document.
     * @deprecated This operation is deprecated and is used for backward compatibility only. Please use InsertWatermark instead.
     * @param request Request object
     * @return DocumentResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    @Deprecated
    public DocumentResponse insertWatermarkText(InsertWatermarkTextRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< DocumentResponse > resp = insertWatermarkTextWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< DocumentResponse > resp = insertWatermarkTextWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new watermark text to the document.
     * @param request Request object
     * @return ApiResponse< DocumentResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< DocumentResponse > insertWatermarkTextWithHttpInfo(InsertWatermarkTextRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertWatermarkTextValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new watermark text to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertWatermarkTextAsync(InsertWatermarkTextRequest request, final ApiCallback< DocumentResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertWatermarkTextValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call insertWatermarkTextOnlineValidateBeforeCall(InsertWatermarkTextOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Inserts a new watermark text to the document.
     * @deprecated This operation is deprecated and is used for backward compatibility only. Please use InsertWatermark instead.
     * @param request Request object
     * @return InsertWatermarkTextOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    @Deprecated
    public InsertWatermarkTextOnlineResponse insertWatermarkTextOnline(InsertWatermarkTextOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< InsertWatermarkTextOnlineResponse > resp = insertWatermarkTextOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< InsertWatermarkTextOnlineResponse > resp = insertWatermarkTextOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Inserts a new watermark text to the document.
     * @param request Request object
     * @return ApiResponse< InsertWatermarkTextOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< InsertWatermarkTextOnlineResponse > insertWatermarkTextOnlineWithHttpInfo(InsertWatermarkTextOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = insertWatermarkTextOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Inserts a new watermark text to the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call insertWatermarkTextOnlineAsync(InsertWatermarkTextOnlineRequest request, final ApiCallback< InsertWatermarkTextOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = insertWatermarkTextOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call linkHeaderFootersToPreviousValidateBeforeCall(LinkHeaderFootersToPreviousRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Links headers / footers of the section to the previous one.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void linkHeaderFootersToPrevious(LinkHeaderFootersToPreviousRequest request) throws ApiException, MessagingException, IOException {
        try {
    linkHeaderFootersToPreviousWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    linkHeaderFootersToPreviousWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Links headers / footers of the section to the previous one.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > linkHeaderFootersToPreviousWithHttpInfo(LinkHeaderFootersToPreviousRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = linkHeaderFootersToPreviousValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Links headers / footers of the section to the previous one. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call linkHeaderFootersToPreviousAsync(LinkHeaderFootersToPreviousRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = linkHeaderFootersToPreviousValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call loadWebDocumentValidateBeforeCall(LoadWebDocumentRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Downloads a document from the Web using URL and saves it to cloud storage in the specified format.
     * @param request Request object
     * @return SaveResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public SaveResponse loadWebDocument(LoadWebDocumentRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< SaveResponse > resp = loadWebDocumentWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< SaveResponse > resp = loadWebDocumentWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Downloads a document from the Web using URL and saves it to cloud storage in the specified format.
     * @param request Request object
     * @return ApiResponse< SaveResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< SaveResponse > loadWebDocumentWithHttpInfo(LoadWebDocumentRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = loadWebDocumentValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Downloads a document from the Web using URL and saves it to cloud storage in the specified format. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call loadWebDocumentAsync(LoadWebDocumentRequest request, final ApiCallback< SaveResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = loadWebDocumentValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call loadWebDocumentOnlineValidateBeforeCall(LoadWebDocumentOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Downloads a document from the Web using URL and saves it to cloud storage in the specified format.
     * @param request Request object
     * @return LoadWebDocumentOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public LoadWebDocumentOnlineResponse loadWebDocumentOnline(LoadWebDocumentOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< LoadWebDocumentOnlineResponse > resp = loadWebDocumentOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< LoadWebDocumentOnlineResponse > resp = loadWebDocumentOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Downloads a document from the Web using URL and saves it to cloud storage in the specified format.
     * @param request Request object
     * @return ApiResponse< LoadWebDocumentOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< LoadWebDocumentOnlineResponse > loadWebDocumentOnlineWithHttpInfo(LoadWebDocumentOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = loadWebDocumentOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Downloads a document from the Web using URL and saves it to cloud storage in the specified format. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call loadWebDocumentOnlineAsync(LoadWebDocumentOnlineRequest request, final ApiCallback< LoadWebDocumentOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = loadWebDocumentOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call mergeWithNextValidateBeforeCall(MergeWithNextRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Merge the section with the next one.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void mergeWithNext(MergeWithNextRequest request) throws ApiException, MessagingException, IOException {
        try {
    mergeWithNextWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    mergeWithNextWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Merge the section with the next one.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > mergeWithNextWithHttpInfo(MergeWithNextRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = mergeWithNextValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Merge the section with the next one. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call mergeWithNextAsync(MergeWithNextRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = mergeWithNextValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call mergeWithNextOnlineValidateBeforeCall(MergeWithNextOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Merge the section with the next one.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> mergeWithNextOnline(MergeWithNextOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = mergeWithNextOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = mergeWithNextOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Merge the section with the next one.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > mergeWithNextOnlineWithHttpInfo(MergeWithNextOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = mergeWithNextOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Merge the section with the next one. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call mergeWithNextOnlineAsync(MergeWithNextOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = mergeWithNextOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call moveFileValidateBeforeCall(MoveFileRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Move file.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void moveFile(MoveFileRequest request) throws ApiException, MessagingException, IOException {
        try {
    moveFileWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    moveFileWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Move file.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > moveFileWithHttpInfo(MoveFileRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = moveFileValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Move file. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call moveFileAsync(MoveFileRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = moveFileValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call moveFolderValidateBeforeCall(MoveFolderRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Move folder.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void moveFolder(MoveFolderRequest request) throws ApiException, MessagingException, IOException {
        try {
    moveFolderWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    moveFolderWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Move folder.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > moveFolderWithHttpInfo(MoveFolderRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = moveFolderValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Move folder. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call moveFolderAsync(MoveFolderRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = moveFolderValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call optimizeDocumentValidateBeforeCall(OptimizeDocumentRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Applies document content optimization options, specific to a particular versions of Microsoft Word.
     * @param request Request object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public void optimizeDocument(OptimizeDocumentRequest request) throws ApiException, MessagingException, IOException {
        try {
    optimizeDocumentWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
    optimizeDocumentWithHttpInfo(request);
            }
            throw ex;
        }
    }

    /**
     * Applies document content optimization options, specific to a particular versions of Microsoft Word.
     * @param request Request object
     * @return ApiResponse< void >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Void > optimizeDocumentWithHttpInfo(OptimizeDocumentRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = optimizeDocumentValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Applies document content optimization options, specific to a particular versions of Microsoft Word. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call optimizeDocumentAsync(OptimizeDocumentRequest request, final ApiCallback< Void > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = optimizeDocumentValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call optimizeDocumentOnlineValidateBeforeCall(OptimizeDocumentOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Applies document content optimization options, specific to a particular versions of Microsoft Word.
     * @param request Request object
     * @return Map<String, byte[]>
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public Map<String, byte[]> optimizeDocumentOnline(OptimizeDocumentOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< Map<String, byte[]> > resp = optimizeDocumentOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< Map<String, byte[]> > resp = optimizeDocumentOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Applies document content optimization options, specific to a particular versions of Microsoft Word.
     * @param request Request object
     * @return ApiResponse< Map<String, byte[]> >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Map<String, byte[]> > optimizeDocumentOnlineWithHttpInfo(OptimizeDocumentOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = optimizeDocumentOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Applies document content optimization options, specific to a particular versions of Microsoft Word. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call optimizeDocumentOnlineAsync(OptimizeDocumentOnlineRequest request, final ApiCallback< Map<String, byte[]> > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = optimizeDocumentOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call protectDocumentValidateBeforeCall(ProtectDocumentRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Changes the document protection. The previous protection will be overwritten if it exist.
     * @param request Request object
     * @return ProtectionDataResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ProtectionDataResponse protectDocument(ProtectDocumentRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ProtectionDataResponse > resp = protectDocumentWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ProtectionDataResponse > resp = protectDocumentWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Changes the document protection. The previous protection will be overwritten if it exist.
     * @param request Request object
     * @return ApiResponse< ProtectionDataResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ProtectionDataResponse > protectDocumentWithHttpInfo(ProtectDocumentRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = protectDocumentValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Changes the document protection. The previous protection will be overwritten if it exist. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call protectDocumentAsync(ProtectDocumentRequest request, final ApiCallback< ProtectionDataResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = protectDocumentValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call protectDocumentOnlineValidateBeforeCall(ProtectDocumentOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Changes the document protection. The previous protection will be overwritten if it exist.
     * @param request Request object
     * @return ProtectDocumentOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public ProtectDocumentOnlineResponse protectDocumentOnline(ProtectDocumentOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< ProtectDocumentOnlineResponse > resp = protectDocumentOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< ProtectDocumentOnlineResponse > resp = protectDocumentOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Changes the document protection. The previous protection will be overwritten if it exist.
     * @param request Request object
     * @return ApiResponse< ProtectDocumentOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< ProtectDocumentOnlineResponse > protectDocumentOnlineWithHttpInfo(ProtectDocumentOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = protectDocumentOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Changes the document protection. The previous protection will be overwritten if it exist. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call protectDocumentOnlineAsync(ProtectDocumentOnlineRequest request, final ApiCallback< ProtectDocumentOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = protectDocumentOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call rejectAllRevisionsValidateBeforeCall(RejectAllRevisionsRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Rejects all revisions in the document.
     * @param request Request object
     * @return RevisionsModificationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public RevisionsModificationResponse rejectAllRevisions(RejectAllRevisionsRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< RevisionsModificationResponse > resp = rejectAllRevisionsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< RevisionsModificationResponse > resp = rejectAllRevisionsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Rejects all revisions in the document.
     * @param request Request object
     * @return ApiResponse< RevisionsModificationResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< RevisionsModificationResponse > rejectAllRevisionsWithHttpInfo(RejectAllRevisionsRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = rejectAllRevisionsValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Rejects all revisions in the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call rejectAllRevisionsAsync(RejectAllRevisionsRequest request, final ApiCallback< RevisionsModificationResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = rejectAllRevisionsValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call rejectAllRevisionsOnlineValidateBeforeCall(RejectAllRevisionsOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Rejects all revisions in the document.
     * @param request Request object
     * @return RejectAllRevisionsOnlineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public RejectAllRevisionsOnlineResponse rejectAllRevisionsOnline(RejectAllRevisionsOnlineRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< RejectAllRevisionsOnlineResponse > resp = rejectAllRevisionsOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< RejectAllRevisionsOnlineResponse > resp = rejectAllRevisionsOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Rejects all revisions in the document.
     * @param request Request object
     * @return ApiResponse< RejectAllRevisionsOnlineResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< RejectAllRevisionsOnlineResponse > rejectAllRevisionsOnlineWithHttpInfo(RejectAllRevisionsOnlineRequest request) throws ApiException, MessagingException, IOException {
        com.squareup.okhttp.Call call = rejectAllRevisionsOnlineValidateBeforeCall(request, null, null);
        return apiClient.execute(call, request);
    }

    /**
     * Rejects all revisions in the document. (asynchronously)
     * @param request Request object
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @throws IOException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call rejectAllRevisionsOnlineAsync(RejectAllRevisionsOnlineRequest request, final ApiCallback< RejectAllRevisionsOnlineResponse > callback) throws ApiException, MessagingException, IOException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = rejectAllRevisionsOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        apiClient.executeAsync(call, request, callback);
        return call;
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call removeAllSignaturesValidateBeforeCall(RemoveAllSignaturesRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        return apiClient.buildCall(request.buildHttpRequest(apiClient, progressListener, progressRequestListener, true));
    }

    /**
     * Removes all signatures of the document.
     * @param request Request object
     * @return SignatureCollectionResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    public SignatureCollectionResponse removeAllSignatures(RemoveAllSignaturesRequest request) throws ApiException, MessagingException, IOException {
        try {
            ApiResponse< SignatureCollectionResponse > resp = removeAllSignaturesWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == apiClient.getNotAuthCode()) {
                apiClient.requestToken();
                ApiResponse< SignatureCollectionResponse > resp = removeAllSignaturesWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Removes all signatures of the document.
     * @param request Request object
     * @return ApiResponse< SignatureCollectionResponse >;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @throws IOException If fail to serialize the request body object
     */
    private ApiResponse< Signatur