/*
 * --------------------------------------------------------------------------------
 * <copyright company="Aspose" file="DownsampleOptionsData.java">
 *   Copyright (c) 2025 Aspose.Words for Cloud
 * </copyright>
 * <summary>
 *   Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 * 
 *  The above copyright notice and this permission notice shall be included in all
 *  copies or substantial portions of the Software.
 * 
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 *  SOFTWARE.
 * </summary>
 * --------------------------------------------------------------------------------
 */

package com.aspose.words.cloud.model;

import java.util.Objects;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.List;
import java.io.IOException;
import org.threeten.bp.OffsetDateTime;
import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.*;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Container class for Downsample options.
 */
@ApiModel(description = "Container class for Downsample options.")
public class DownsampleOptionsData implements ModelIfc {
    @SerializedName("DownsampleImages")
    protected Boolean downsampleImages;

    @SerializedName("Resolution")
    protected Integer resolution;

    @SerializedName("ResolutionThreshold")
    protected Integer resolutionThreshold;
    /**
     * Gets or sets a value indicating whether images should be downsampled.
     * The default value is true.
    * @return downsampleImages
    **/
    @ApiModelProperty(value = "Gets or sets a value indicating whether images should be downsampled. The default value is true.")
    public Boolean getDownsampleImages() {
        return downsampleImages;
    }

    public DownsampleOptionsData downsampleImages(Boolean downsampleImages) {
        this.downsampleImages = downsampleImages;
        return this;
    }

    public void setDownsampleImages(Boolean downsampleImages) {
        this.downsampleImages = downsampleImages;
    }


    /**
     * Gets or sets the resolution in pixels per inch which the images should be downsampled to.
     * The default value is 220 ppi.
    * @return resolution
    **/
    @ApiModelProperty(value = "Gets or sets the resolution in pixels per inch which the images should be downsampled to. The default value is 220 ppi.")
    public Integer getResolution() {
        return resolution;
    }

    public DownsampleOptionsData resolution(Integer resolution) {
        this.resolution = resolution;
        return this;
    }

    public void setResolution(Integer resolution) {
        this.resolution = resolution;
    }


    /**
     * Gets or sets the threshold resolution in pixels per inch. If resolution of an image in the document is less than threshold value, the downsampling algorithm will not be applied. A value of 0 means the threshold check is not used and all images that can be reduced in size are downsampled.
     * The default value is 0.
    * @return resolutionThreshold
    **/
    @ApiModelProperty(value = "Gets or sets the threshold resolution in pixels per inch. If resolution of an image in the document is less than threshold value, the downsampling algorithm will not be applied. A value of 0 means the threshold check is not used and all images that can be reduced in size are downsampled. The default value is 0.")
    public Integer getResolutionThreshold() {
        return resolutionThreshold;
    }

    public DownsampleOptionsData resolutionThreshold(Integer resolutionThreshold) {
        this.resolutionThreshold = resolutionThreshold;
        return this;
    }

    public void setResolutionThreshold(Integer resolutionThreshold) {
        this.resolutionThreshold = resolutionThreshold;
    }


    public DownsampleOptionsData() {
        this.downsampleImages = null;
        this.resolution = null;
        this.resolutionThreshold = null;
    }

    /*
     * Gets files content.
     *
     * @param resultFilesContent List<FileReference> instance.
     */
    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    /*
     * Validate required properties.
     *
     * @throws ApiException If fails to validate required properties.
     */
    @Override
    public void validate() throws ApiException {
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        DownsampleOptionsData downsampleOptionsData = (DownsampleOptionsData) o;
        return
            Objects.equals(this.downsampleImages, downsampleOptionsData.downsampleImages) &&
            Objects.equals(this.resolution, downsampleOptionsData.resolution) &&
            Objects.equals(this.resolutionThreshold, downsampleOptionsData.resolutionThreshold);
  }

  @Override
  public int hashCode() {
    return Objects.hash(downsampleImages, resolution, resolutionThreshold);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DownsampleOptionsData {\n");
    sb.append("    downsampleImages: ").append(toIndentedString(getDownsampleImages())).append("\n");
    sb.append("    resolution: ").append(toIndentedString(getResolution())).append("\n");
    sb.append("    resolutionThreshold: ").append(toIndentedString(getResolutionThreshold())).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
