/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.document;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.BaseEntryList;
import com.aspose.words.cloud.model.DocumentEntry;
import com.aspose.words.cloud.model.DocumentEntryList;
import com.aspose.words.cloud.model.DocumentResponse;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.requests.AppendDocumentOnlineRequest;
import com.aspose.words.cloud.model.requests.AppendDocumentRequest;
import com.aspose.words.cloud.model.responses.AppendDocumentOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.junit.Test;

public class TestAppendDocument
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentActions/AppendDocument";
    private String localFile = "Common/test_multi_pages.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testAppendDocument() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestAppendDocument.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        FileReference requestDocumentListDocumentEntries0FileReference = new FileReference(this.remoteDataFolder + "/" + remoteFileName);
        DocumentEntry requestDocumentListDocumentEntries0 = new DocumentEntry();
        requestDocumentListDocumentEntries0.setFileReference(requestDocumentListDocumentEntries0FileReference);
        requestDocumentListDocumentEntries0.setImportFormatMode(DocumentEntry.ImportFormatModeEnum.KEEPSOURCEFORMATTING);
        ArrayList<DocumentEntry> requestDocumentListDocumentEntries = new ArrayList<DocumentEntry>();
        requestDocumentListDocumentEntries.add(requestDocumentListDocumentEntries0);
        DocumentEntryList requestDocumentList = new DocumentEntryList();
        requestDocumentList.setDocumentEntries(requestDocumentListDocumentEntries);
        AppendDocumentRequest request = new AppendDocumentRequest(remoteFileName, (BaseEntryList)requestDocumentList, this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        DocumentResponse result = TestInitializer.wordsApi.appendDocument(request);
        TestAppendDocument.assertNotNull((Object)result);
        TestAppendDocument.assertNotNull((Object)result.getDocument());
        TestAppendDocument.assertEquals((String)"TestAppendDocument.docx", (String)result.getDocument().getFileName());
    }

    @Test
    public void testAppendDocumentOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        byte[] requestDocumentListDocumentEntries0FileReferenceStream = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        FileReference requestDocumentListDocumentEntries0FileReference = new FileReference(requestDocumentListDocumentEntries0FileReferenceStream);
        DocumentEntry requestDocumentListDocumentEntries0 = new DocumentEntry();
        requestDocumentListDocumentEntries0.setFileReference(requestDocumentListDocumentEntries0FileReference);
        requestDocumentListDocumentEntries0.setImportFormatMode(DocumentEntry.ImportFormatModeEnum.KEEPSOURCEFORMATTING);
        ArrayList<DocumentEntry> requestDocumentListDocumentEntries = new ArrayList<DocumentEntry>();
        requestDocumentListDocumentEntries.add(requestDocumentListDocumentEntries0);
        DocumentEntryList requestDocumentList = new DocumentEntryList();
        requestDocumentList.setDocumentEntries(requestDocumentListDocumentEntries);
        AppendDocumentOnlineRequest request = new AppendDocumentOnlineRequest(requestDocument, (BaseEntryList)requestDocumentList, null, null, null, null, null, null, null);
        AppendDocumentOnlineResponse result = TestInitializer.wordsApi.appendDocumentOnline(request);
        TestAppendDocument.assertNotNull((Object)result);
    }
}

