/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.document;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.ClassificationResponse;
import com.aspose.words.cloud.model.requests.ClassifyDocumentOnlineRequest;
import com.aspose.words.cloud.model.requests.ClassifyDocumentRequest;
import com.aspose.words.cloud.model.requests.ClassifyRequest;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestClassification
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/Common";
    private String localFile = "Common/test_multi_pages.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testClassify() throws ApiException, MessagingException, IOException {
        ClassifyRequest request = new ClassifyRequest("Try text classification", "3");
        ClassificationResponse result = TestInitializer.wordsApi.classify(request);
        TestClassification.assertNotNull((Object)result);
        TestClassification.assertEquals((String)"Science", (String)result.getBestClassName());
        TestClassification.assertNotNull((Object)result.getBestResults());
        TestClassification.assertEquals((int)3, (int)result.getBestResults().size());
    }

    @Test
    public void testClassifyDocument() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestClassifyDocument.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        ClassifyDocumentRequest request = new ClassifyDocumentRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null, "3", null);
        ClassificationResponse result = TestInitializer.wordsApi.classifyDocument(request);
        TestClassification.assertNotNull((Object)result);
        TestClassification.assertEquals((String)"Hobbies_&_Interests", (String)result.getBestClassName());
        TestClassification.assertNotNull((Object)result.getBestResults());
        TestClassification.assertEquals((int)3, (int)result.getBestResults().size());
    }

    @Test
    public void testClassifyDocumentOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        ClassifyDocumentOnlineRequest request = new ClassifyDocumentOnlineRequest(requestDocument, null, null, null, null, "3", null);
        ClassificationResponse result = TestInitializer.wordsApi.classifyDocumentOnline(request);
        TestClassification.assertNotNull((Object)result);
    }
}

