/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.document;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.DocxSaveOptionsData;
import com.aspose.words.cloud.model.HtmlSaveOptionsData;
import com.aspose.words.cloud.model.PdfSaveOptionsData;
import com.aspose.words.cloud.model.SaveOptionsData;
import com.aspose.words.cloud.model.SaveResponse;
import com.aspose.words.cloud.model.TiffSaveOptionsData;
import com.aspose.words.cloud.model.requests.ConvertDocumentRequest;
import com.aspose.words.cloud.model.requests.SaveAsOnlineRequest;
import com.aspose.words.cloud.model.requests.SaveAsRequest;
import com.aspose.words.cloud.model.requests.SaveAsTiffOnlineRequest;
import com.aspose.words.cloud.model.requests.SaveAsTiffRequest;
import com.aspose.words.cloud.model.responses.SaveAsOnlineResponse;
import com.aspose.words.cloud.model.responses.SaveAsTiffOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestConvertDocument
extends TestCase {
    private String remoteFolder = TestInitializer.RemoteTestFolder + "/DocumentActions/ConvertDocument";
    private String localFolder = "DocumentActions/ConvertDocument";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testSaveAs() throws ApiException, MessagingException, IOException {
        String localName = "test_multi_pages.docx";
        String remoteName = "TestSaveAs.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, "Common/" + localName), this.remoteFolder + "/" + remoteName);
        PdfSaveOptionsData requestSaveOptionsData = new PdfSaveOptionsData();
        requestSaveOptionsData.setFileName(TestInitializer.RemoteTestOut + "/TestSaveAs.pdf");
        SaveAsRequest request = new SaveAsRequest(remoteName, (SaveOptionsData)requestSaveOptionsData, this.remoteFolder, null, null, null, null, null, null);
        SaveResponse result = TestInitializer.wordsApi.saveAs(request);
        TestConvertDocument.assertNotNull((Object)result);
        TestConvertDocument.assertNotNull((Object)result.getSaveResult());
        TestConvertDocument.assertNotNull((Object)result.getSaveResult().getDestDocument());
    }

    @Test
    public void testSaveAsOnline() throws ApiException, MessagingException, IOException {
        String localName = "test_multi_pages.docx";
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, "Common/" + localName).toAbsolutePath());
        PdfSaveOptionsData requestSaveOptionsData = new PdfSaveOptionsData();
        requestSaveOptionsData.setFileName(TestInitializer.RemoteTestOut + "/TestSaveAs.pdf");
        SaveAsOnlineRequest request = new SaveAsOnlineRequest(requestDocument, (SaveOptionsData)requestSaveOptionsData, null, null, null, null, null);
        SaveAsOnlineResponse result = TestInitializer.wordsApi.saveAsOnline(request);
        TestConvertDocument.assertNotNull((Object)result);
    }

    @Test
    public void testSaveAsOnlineHtmlMultifile() throws ApiException, MessagingException, IOException {
        String localName = "test_multi_pages.docx";
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, "Common/" + localName).toAbsolutePath());
        HtmlSaveOptionsData requestSaveOptionsData = new HtmlSaveOptionsData();
        requestSaveOptionsData.setFileName(TestInitializer.RemoteTestOut + "/TestSaveAsHtml.html");
        requestSaveOptionsData.setCssStyleSheetType(HtmlSaveOptionsData.CssStyleSheetTypeEnum.EXTERNAL);
        requestSaveOptionsData.setCssStyleSheetFileName(TestInitializer.RemoteTestOut + "/TestSaveAsHtml.css");
        SaveAsOnlineRequest request = new SaveAsOnlineRequest(requestDocument, (SaveOptionsData)requestSaveOptionsData, null, null, null, null, null);
        SaveAsOnlineResponse result = TestInitializer.wordsApi.saveAsOnline(request);
        TestConvertDocument.assertNotNull((Object)result);
    }

    @Test
    public void testSaveAsDocx() throws ApiException, MessagingException, IOException {
        String localName = "45.pdf";
        String remoteName = "TestSaveAsFromPdfToDoc.pdf";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFolder + "/" + localName), this.remoteFolder + "/" + remoteName);
        DocxSaveOptionsData requestSaveOptionsData = new DocxSaveOptionsData();
        requestSaveOptionsData.setFileName(TestInitializer.RemoteTestOut + "/TestSaveAsFromPdfToDoc.docx");
        SaveAsRequest request = new SaveAsRequest(remoteName, (SaveOptionsData)requestSaveOptionsData, this.remoteFolder, null, null, null, null, null, null);
        SaveResponse result = TestInitializer.wordsApi.saveAs(request);
        TestConvertDocument.assertNotNull((Object)result);
        TestConvertDocument.assertNotNull((Object)result.getSaveResult());
        TestConvertDocument.assertNotNull((Object)result.getSaveResult().getDestDocument());
    }

    @Test
    public void testSaveAsTiff() throws ApiException, MessagingException, IOException {
        String localName = "test_multi_pages.docx";
        String remoteName = "TestSaveAsTiff.pdf";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, "Common/" + localName), this.remoteFolder + "/" + remoteName);
        TiffSaveOptionsData requestSaveOptions = new TiffSaveOptionsData();
        requestSaveOptions.setFileName(TestInitializer.RemoteTestOut + "/abc.tiff");
        SaveAsTiffRequest request = new SaveAsTiffRequest(remoteName, requestSaveOptions, this.remoteFolder, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        SaveResponse result = TestInitializer.wordsApi.saveAsTiff(request);
        TestConvertDocument.assertNotNull((Object)result);
        TestConvertDocument.assertNotNull((Object)result.getSaveResult());
        TestConvertDocument.assertNotNull((Object)result.getSaveResult().getDestDocument());
    }

    @Test
    public void testSaveAsTiffOnline() throws ApiException, MessagingException, IOException {
        String localName = "test_multi_pages.docx";
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, "Common/" + localName).toAbsolutePath());
        TiffSaveOptionsData requestSaveOptions = new TiffSaveOptionsData();
        requestSaveOptions.setFileName(TestInitializer.RemoteTestOut + "/abc.tiff");
        SaveAsTiffOnlineRequest request = new SaveAsTiffOnlineRequest(requestDocument, requestSaveOptions, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        SaveAsTiffOnlineResponse result = TestInitializer.wordsApi.saveAsTiffOnline(request);
        TestConvertDocument.assertNotNull((Object)result);
    }

    @Test
    public void testConvertDocument() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFolder + "/test_uploadfile.docx").toAbsolutePath());
        ConvertDocumentRequest request = new ConvertDocumentRequest(requestDocument, "pdf", null, null, null, null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.convertDocument(request);
        TestConvertDocument.assertNotNull((Object)result);
    }
}

