/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.document;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.CustomXmlPart;
import com.aspose.words.cloud.model.CustomXmlPartInsert;
import com.aspose.words.cloud.model.CustomXmlPartResponse;
import com.aspose.words.cloud.model.CustomXmlPartUpdate;
import com.aspose.words.cloud.model.CustomXmlPartsResponse;
import com.aspose.words.cloud.model.requests.DeleteCustomXmlPartOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteCustomXmlPartRequest;
import com.aspose.words.cloud.model.requests.DeleteCustomXmlPartsOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteCustomXmlPartsRequest;
import com.aspose.words.cloud.model.requests.GetCustomXmlPartOnlineRequest;
import com.aspose.words.cloud.model.requests.GetCustomXmlPartRequest;
import com.aspose.words.cloud.model.requests.GetCustomXmlPartsOnlineRequest;
import com.aspose.words.cloud.model.requests.GetCustomXmlPartsRequest;
import com.aspose.words.cloud.model.requests.InsertCustomXmlPartOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertCustomXmlPartRequest;
import com.aspose.words.cloud.model.requests.UpdateCustomXmlPartOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateCustomXmlPartRequest;
import com.aspose.words.cloud.model.responses.InsertCustomXmlPartOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateCustomXmlPartOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;

public class TestCustomXmlParts
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/CustomXmlParts";
    private String localFile = "DocumentElements/CustomXmlParts/MultipleCustomXmlParts.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetCustomXmlPart() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetCustomXmlPart.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetCustomXmlPartRequest request = new GetCustomXmlPartRequest(remoteFileName, Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null);
        CustomXmlPartResponse result = TestInitializer.wordsApi.getCustomXmlPart(request);
        TestCustomXmlParts.assertNotNull((Object)result);
        TestCustomXmlParts.assertNotNull((Object)result.getCustomXmlPart());
        TestCustomXmlParts.assertEquals((String)"aspose", (String)result.getCustomXmlPart().getId());
        TestCustomXmlParts.assertEquals((String)"<Metadata><Author>author1</Author><Initial>initial</Initial><DateTime>2015-01-22T00:00:00</DateTime><Text>text</Text></Metadata>", (String)result.getCustomXmlPart().getData());
    }

    @Test
    public void testGetCustomXmlPartOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetCustomXmlPartOnlineRequest request = new GetCustomXmlPartOnlineRequest(requestDocument, Integer.valueOf(0), null, null, null, null);
        CustomXmlPartResponse result = TestInitializer.wordsApi.getCustomXmlPartOnline(request);
        TestCustomXmlParts.assertNotNull((Object)result);
        TestCustomXmlParts.assertNotNull((Object)result.getCustomXmlPart());
        TestCustomXmlParts.assertEquals((String)"aspose", (String)result.getCustomXmlPart().getId());
        TestCustomXmlParts.assertEquals((String)"<Metadata><Author>author1</Author><Initial>initial</Initial><DateTime>2015-01-22T00:00:00</DateTime><Text>text</Text></Metadata>", (String)result.getCustomXmlPart().getData());
    }

    @Test
    public void testGetCustomXmlParts() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetCustomXmlParts.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetCustomXmlPartsRequest request = new GetCustomXmlPartsRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null);
        CustomXmlPartsResponse result = TestInitializer.wordsApi.getCustomXmlParts(request);
        TestCustomXmlParts.assertNotNull((Object)result);
        TestCustomXmlParts.assertNotNull((Object)result.getCustomXmlParts());
        TestCustomXmlParts.assertNotNull((Object)result.getCustomXmlParts().getCustomXmlPartsList());
        TestCustomXmlParts.assertEquals((int)2, (int)result.getCustomXmlParts().getCustomXmlPartsList().size());
        TestCustomXmlParts.assertEquals((String)"aspose", (String)((CustomXmlPart)result.getCustomXmlParts().getCustomXmlPartsList().get(0)).getId());
        TestCustomXmlParts.assertEquals((String)"<Metadata><Author>author1</Author><Initial>initial</Initial><DateTime>2015-01-22T00:00:00</DateTime><Text>text</Text></Metadata>", (String)((CustomXmlPart)result.getCustomXmlParts().getCustomXmlPartsList().get(0)).getData());
    }

    @Test
    public void testGetCustomXmlPartsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetCustomXmlPartsOnlineRequest request = new GetCustomXmlPartsOnlineRequest(requestDocument, null, null, null, null);
        CustomXmlPartsResponse result = TestInitializer.wordsApi.getCustomXmlPartsOnline(request);
        TestCustomXmlParts.assertNotNull((Object)result);
        TestCustomXmlParts.assertNotNull((Object)result.getCustomXmlParts());
        TestCustomXmlParts.assertNotNull((Object)result.getCustomXmlParts().getCustomXmlPartsList());
        TestCustomXmlParts.assertEquals((int)2, (int)result.getCustomXmlParts().getCustomXmlPartsList().size());
        TestCustomXmlParts.assertEquals((String)"aspose", (String)((CustomXmlPart)result.getCustomXmlParts().getCustomXmlPartsList().get(0)).getId());
        TestCustomXmlParts.assertEquals((String)"<Metadata><Author>author1</Author><Initial>initial</Initial><DateTime>2015-01-22T00:00:00</DateTime><Text>text</Text></Metadata>", (String)((CustomXmlPart)result.getCustomXmlParts().getCustomXmlPartsList().get(0)).getData());
    }

    @Test
    public void testInsertCustomXmlPart() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertCustomXmlPart.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        CustomXmlPartInsert requestCustomXmlPart = new CustomXmlPartInsert();
        requestCustomXmlPart.setId("hello");
        requestCustomXmlPart.setData("<data>Hello world</data>");
        InsertCustomXmlPartRequest request = new InsertCustomXmlPartRequest(remoteFileName, requestCustomXmlPart, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        CustomXmlPartResponse result = TestInitializer.wordsApi.insertCustomXmlPart(request);
        TestCustomXmlParts.assertNotNull((Object)result);
        TestCustomXmlParts.assertNotNull((Object)result.getCustomXmlPart());
        TestCustomXmlParts.assertEquals((String)"hello", (String)result.getCustomXmlPart().getId());
        TestCustomXmlParts.assertEquals((String)"<data>Hello world</data>", (String)result.getCustomXmlPart().getData());
    }

    @Test
    public void testInsertCustomXmlPartOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        CustomXmlPartInsert requestCustomXmlPart = new CustomXmlPartInsert();
        requestCustomXmlPart.setId("hello");
        requestCustomXmlPart.setData("<data>Hello world</data>");
        InsertCustomXmlPartOnlineRequest request = new InsertCustomXmlPartOnlineRequest(requestDocument, requestCustomXmlPart, null, null, null, null, null, null, null);
        InsertCustomXmlPartOnlineResponse result = TestInitializer.wordsApi.insertCustomXmlPartOnline(request);
        TestCustomXmlParts.assertNotNull((Object)result);
        TestCustomXmlParts.assertNotNull((Object)result.getModel().getCustomXmlPart());
        TestCustomXmlParts.assertEquals((String)"hello", (String)result.getModel().getCustomXmlPart().getId());
        TestCustomXmlParts.assertEquals((String)"<data>Hello world</data>", (String)result.getModel().getCustomXmlPart().getData());
    }

    @Test
    public void testUpdateCustomXmlPart() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateCustomXmlPart.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        CustomXmlPartUpdate requestCustomXmlPart = new CustomXmlPartUpdate();
        requestCustomXmlPart.setData("<data>Hello world</data>");
        UpdateCustomXmlPartRequest request = new UpdateCustomXmlPartRequest(remoteFileName, Integer.valueOf(0), requestCustomXmlPart, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        CustomXmlPartResponse result = TestInitializer.wordsApi.updateCustomXmlPart(request);
        TestCustomXmlParts.assertNotNull((Object)result);
        TestCustomXmlParts.assertNotNull((Object)result.getCustomXmlPart());
        TestCustomXmlParts.assertEquals((String)"aspose", (String)result.getCustomXmlPart().getId());
        TestCustomXmlParts.assertEquals((String)"<data>Hello world</data>", (String)result.getCustomXmlPart().getData());
    }

    @Test
    public void testUpdateCustomXmlPartOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        CustomXmlPartUpdate requestCustomXmlPart = new CustomXmlPartUpdate();
        requestCustomXmlPart.setData("<data>Hello world</data>");
        UpdateCustomXmlPartOnlineRequest request = new UpdateCustomXmlPartOnlineRequest(requestDocument, Integer.valueOf(0), requestCustomXmlPart, null, null, null, null, null, null, null);
        UpdateCustomXmlPartOnlineResponse result = TestInitializer.wordsApi.updateCustomXmlPartOnline(request);
        TestCustomXmlParts.assertNotNull((Object)result);
        TestCustomXmlParts.assertNotNull((Object)result.getModel().getCustomXmlPart());
        TestCustomXmlParts.assertEquals((String)"aspose", (String)result.getModel().getCustomXmlPart().getId());
        TestCustomXmlParts.assertEquals((String)"<data>Hello world</data>", (String)result.getModel().getCustomXmlPart().getData());
    }

    @Test
    public void testDeleteCustomXmlPart() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteCustomXmlPart.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteCustomXmlPartRequest request = new DeleteCustomXmlPartRequest(remoteFileName, Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        TestInitializer.wordsApi.deleteCustomXmlPart(request);
    }

    @Test
    public void testDeleteCustomXmlPartOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteCustomXmlPartOnlineRequest request = new DeleteCustomXmlPartOnlineRequest(requestDocument, Integer.valueOf(0), null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteCustomXmlPartOnline(request);
        TestCustomXmlParts.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteCustomXmlParts() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteCustomXmlPart.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteCustomXmlPartsRequest request = new DeleteCustomXmlPartsRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        TestInitializer.wordsApi.deleteCustomXmlParts(request);
    }

    @Test
    public void testDeleteCustomXmlPartsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteCustomXmlPartsOnlineRequest request = new DeleteCustomXmlPartsOnlineRequest(requestDocument, null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteCustomXmlPartsOnline(request);
        TestCustomXmlParts.assertNotNull((Object)result);
    }
}

