/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.document;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.StatDataResponse;
import com.aspose.words.cloud.model.requests.GetDocumentStatisticsOnlineRequest;
import com.aspose.words.cloud.model.requests.GetDocumentStatisticsRequest;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestDocumentStatistics
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentActions/Statistics";
    private String localFile = "Common/test_multi_pages.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetDocumentStatistics() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentStatistics.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetDocumentStatisticsRequest request = new GetDocumentStatisticsRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        StatDataResponse result = TestInitializer.wordsApi.getDocumentStatistics(request);
        TestDocumentStatistics.assertNotNull((Object)result);
        TestDocumentStatistics.assertNotNull((Object)result.getStatData());
        TestDocumentStatistics.assertEquals((Object)10, (Object)result.getStatData().getWordCount());
    }

    @Test
    public void testGetDocumentStatisticsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetDocumentStatisticsOnlineRequest request = new GetDocumentStatisticsOnlineRequest(requestDocument, null, null, null, null, null, null, null);
        StatDataResponse result = TestInitializer.wordsApi.getDocumentStatisticsOnline(request);
        TestDocumentStatistics.assertNotNull((Object)result);
    }
}

