/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.documentProperties;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.DocumentPropertiesResponse;
import com.aspose.words.cloud.model.DocumentProperty;
import com.aspose.words.cloud.model.DocumentPropertyCreateOrUpdate;
import com.aspose.words.cloud.model.DocumentPropertyResponse;
import com.aspose.words.cloud.model.requests.CreateOrUpdateDocumentPropertyOnlineRequest;
import com.aspose.words.cloud.model.requests.CreateOrUpdateDocumentPropertyRequest;
import com.aspose.words.cloud.model.requests.DeleteDocumentPropertyOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteDocumentPropertyRequest;
import com.aspose.words.cloud.model.requests.GetDocumentPropertiesOnlineRequest;
import com.aspose.words.cloud.model.requests.GetDocumentPropertiesRequest;
import com.aspose.words.cloud.model.requests.GetDocumentPropertyOnlineRequest;
import com.aspose.words.cloud.model.requests.GetDocumentPropertyRequest;
import com.aspose.words.cloud.model.responses.CreateOrUpdateDocumentPropertyOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;

public class TestDocumentProperties
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/DocumentProperties";
    private String localFile = "Common/test_multi_pages.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetDocumentProperties() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentProperties.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetDocumentPropertiesRequest request = new GetDocumentPropertiesRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null);
        DocumentPropertiesResponse result = TestInitializer.wordsApi.getDocumentProperties(request);
        TestDocumentProperties.assertNotNull((Object)result);
        TestDocumentProperties.assertNotNull((Object)result.getDocumentProperties());
        TestDocumentProperties.assertNotNull((Object)result.getDocumentProperties().getList());
        TestDocumentProperties.assertEquals((int)27, (int)result.getDocumentProperties().getList().size());
        TestDocumentProperties.assertNotNull(result.getDocumentProperties().getList().get(0));
        TestDocumentProperties.assertEquals((String)"Author", (String)((DocumentProperty)result.getDocumentProperties().getList().get(0)).getName());
        TestDocumentProperties.assertEquals((String)"", (String)((DocumentProperty)result.getDocumentProperties().getList().get(0)).getValue());
    }

    @Test
    public void testGetDocumentPropertiesOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetDocumentPropertiesOnlineRequest request = new GetDocumentPropertiesOnlineRequest(requestDocument, null, null, null, null);
        DocumentPropertiesResponse result = TestInitializer.wordsApi.getDocumentPropertiesOnline(request);
        TestDocumentProperties.assertNotNull((Object)result);
    }

    @Test
    public void testGetDocumentProperty() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentProperty.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetDocumentPropertyRequest request = new GetDocumentPropertyRequest(remoteFileName, "Author", this.remoteDataFolder, null, null, null, null, null);
        DocumentPropertyResponse result = TestInitializer.wordsApi.getDocumentProperty(request);
        TestDocumentProperties.assertNotNull((Object)result);
        TestDocumentProperties.assertNotNull((Object)result.getDocumentProperty());
        TestDocumentProperties.assertEquals((String)"Author", (String)result.getDocumentProperty().getName());
        TestDocumentProperties.assertEquals((String)"", (String)result.getDocumentProperty().getValue());
    }

    @Test
    public void testGetDocumentPropertyOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetDocumentPropertyOnlineRequest request = new GetDocumentPropertyOnlineRequest(requestDocument, "Author", null, null, null, null);
        DocumentPropertyResponse result = TestInitializer.wordsApi.getDocumentPropertyOnline(request);
        TestDocumentProperties.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteDocumentProperty() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteDocumentProperty.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteDocumentPropertyRequest request = new DeleteDocumentPropertyRequest(remoteFileName, "testProp", this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        TestInitializer.wordsApi.deleteDocumentProperty(request);
    }

    @Test
    public void testDeleteDocumentPropertyOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteDocumentPropertyOnlineRequest request = new DeleteDocumentPropertyOnlineRequest(requestDocument, "testProp", null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteDocumentPropertyOnline(request);
        TestDocumentProperties.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateDocumentProperty() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateDocumentProperty.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DocumentPropertyCreateOrUpdate requestProperty = new DocumentPropertyCreateOrUpdate();
        requestProperty.setValue("Imran Anwar");
        CreateOrUpdateDocumentPropertyRequest request = new CreateOrUpdateDocumentPropertyRequest(remoteFileName, "AsposeAuthor", requestProperty, this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        DocumentPropertyResponse result = TestInitializer.wordsApi.createOrUpdateDocumentProperty(request);
        TestDocumentProperties.assertNotNull((Object)result);
        TestDocumentProperties.assertNotNull((Object)result.getDocumentProperty());
        TestDocumentProperties.assertEquals((String)"AsposeAuthor", (String)result.getDocumentProperty().getName());
        TestDocumentProperties.assertEquals((String)"Imran Anwar", (String)result.getDocumentProperty().getValue());
    }

    @Test
    public void testUpdateDocumentPropertyOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DocumentPropertyCreateOrUpdate requestProperty = new DocumentPropertyCreateOrUpdate();
        requestProperty.setValue("Imran Anwar");
        CreateOrUpdateDocumentPropertyOnlineRequest request = new CreateOrUpdateDocumentPropertyOnlineRequest(requestDocument, "AsposeAuthor", requestProperty, null, null, null, null, null, null, null);
        CreateOrUpdateDocumentPropertyOnlineResponse result = TestInitializer.wordsApi.createOrUpdateDocumentPropertyOnline(request);
        TestDocumentProperties.assertNotNull((Object)result);
    }
}

