/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.footnote;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.Footnote;
import com.aspose.words.cloud.model.FootnoteBase;
import com.aspose.words.cloud.model.FootnoteInsert;
import com.aspose.words.cloud.model.FootnoteResponse;
import com.aspose.words.cloud.model.FootnoteUpdate;
import com.aspose.words.cloud.model.FootnotesResponse;
import com.aspose.words.cloud.model.requests.DeleteFootnoteOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteFootnoteRequest;
import com.aspose.words.cloud.model.requests.GetFootnoteOnlineRequest;
import com.aspose.words.cloud.model.requests.GetFootnoteRequest;
import com.aspose.words.cloud.model.requests.GetFootnotesOnlineRequest;
import com.aspose.words.cloud.model.requests.GetFootnotesRequest;
import com.aspose.words.cloud.model.requests.InsertFootnoteOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertFootnoteRequest;
import com.aspose.words.cloud.model.requests.UpdateFootnoteOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateFootnoteRequest;
import com.aspose.words.cloud.model.responses.InsertFootnoteOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateFootnoteOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;

public class TestFootnote
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/Footnotes";
    private String footnoteFolder = "DocumentElements/Footnotes";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testInsertFootnote() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertFootnote.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.footnoteFolder + "/Footnote.doc"), this.remoteDataFolder + "/" + remoteFileName);
        FootnoteInsert requestFootnoteDto = new FootnoteInsert();
        requestFootnoteDto.setFootnoteType(FootnoteBase.FootnoteTypeEnum.ENDNOTE);
        requestFootnoteDto.setText("test endnote");
        InsertFootnoteRequest request = new InsertFootnoteRequest(remoteFileName, requestFootnoteDto, "", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        FootnoteResponse result = TestInitializer.wordsApi.insertFootnote(request);
        TestFootnote.assertNotNull((Object)result);
        TestFootnote.assertNotNull((Object)result.getFootnote());
        TestFootnote.assertEquals((String)"0.1.7.1", (String)result.getFootnote().getNodeId());
        TestFootnote.assertEquals((String)" test endnote\r\n", (String)result.getFootnote().getText());
    }

    @Test
    public void testInsertFootnoteOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.footnoteFolder + "/Footnote.doc").toAbsolutePath());
        FootnoteInsert requestFootnoteDto = new FootnoteInsert();
        requestFootnoteDto.setFootnoteType(FootnoteBase.FootnoteTypeEnum.ENDNOTE);
        requestFootnoteDto.setText("test endnote");
        InsertFootnoteOnlineRequest request = new InsertFootnoteOnlineRequest(requestDocument, requestFootnoteDto, "", null, null, null, null, null, null, null);
        InsertFootnoteOnlineResponse result = TestInitializer.wordsApi.insertFootnoteOnline(request);
        TestFootnote.assertNotNull((Object)result);
    }

    @Test
    public void testInsertFootnoteWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertFootnoteWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.footnoteFolder + "/Footnote.doc"), this.remoteDataFolder + "/" + remoteFileName);
        FootnoteInsert requestFootnoteDto = new FootnoteInsert();
        requestFootnoteDto.setFootnoteType(FootnoteBase.FootnoteTypeEnum.ENDNOTE);
        requestFootnoteDto.setText("test endnote");
        InsertFootnoteRequest request = new InsertFootnoteRequest(remoteFileName, requestFootnoteDto, null, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        FootnoteResponse result = TestInitializer.wordsApi.insertFootnote(request);
        TestFootnote.assertNotNull((Object)result);
        TestFootnote.assertNotNull((Object)result.getFootnote());
        TestFootnote.assertEquals((String)"0.1.7.1", (String)result.getFootnote().getNodeId());
        TestFootnote.assertEquals((String)" test endnote\r\n", (String)result.getFootnote().getText());
    }

    @Test
    public void testDeleteFootnote() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteFootnote.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.footnoteFolder + "/Footnote.doc"), this.remoteDataFolder + "/" + remoteFileName);
        DeleteFootnoteRequest request = new DeleteFootnoteRequest(remoteFileName, Integer.valueOf(0), "", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteFootnote(request);
    }

    @Test
    public void testDeleteFootnoteOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.footnoteFolder + "/Footnote.doc").toAbsolutePath());
        DeleteFootnoteOnlineRequest request = new DeleteFootnoteOnlineRequest(requestDocument, Integer.valueOf(0), "", null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteFootnoteOnline(request);
        TestFootnote.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteFootnoteWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteFootnoteWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.footnoteFolder + "/Footnote.doc"), this.remoteDataFolder + "/" + remoteFileName);
        DeleteFootnoteRequest request = new DeleteFootnoteRequest(remoteFileName, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteFootnote(request);
    }

    @Test
    public void testGetFootnotes() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetFootnotes.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.footnoteFolder + "/Footnote.doc"), this.remoteDataFolder + "/" + remoteFileName);
        GetFootnotesRequest request = new GetFootnotesRequest(remoteFileName, "", this.remoteDataFolder, null, null, null, null, null);
        FootnotesResponse result = TestInitializer.wordsApi.getFootnotes(request);
        TestFootnote.assertNotNull((Object)result);
        TestFootnote.assertNotNull((Object)result.getFootnotes());
        TestFootnote.assertNotNull((Object)result.getFootnotes().getList());
        TestFootnote.assertEquals((int)6, (int)result.getFootnotes().getList().size());
        TestFootnote.assertEquals((String)" Footnote 1.\r\n", (String)((Footnote)result.getFootnotes().getList().get(0)).getText());
    }

    @Test
    public void testGetFootnotesOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.footnoteFolder + "/Footnote.doc").toAbsolutePath());
        GetFootnotesOnlineRequest request = new GetFootnotesOnlineRequest(requestDocument, "", null, null, null, null);
        FootnotesResponse result = TestInitializer.wordsApi.getFootnotesOnline(request);
        TestFootnote.assertNotNull((Object)result);
    }

    @Test
    public void testGetFootnotesWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetFootnotesWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.footnoteFolder + "/Footnote.doc"), this.remoteDataFolder + "/" + remoteFileName);
        GetFootnotesRequest request = new GetFootnotesRequest(remoteFileName, null, this.remoteDataFolder, null, null, null, null, null);
        FootnotesResponse result = TestInitializer.wordsApi.getFootnotes(request);
        TestFootnote.assertNotNull((Object)result);
        TestFootnote.assertNotNull((Object)result.getFootnotes());
        TestFootnote.assertNotNull((Object)result.getFootnotes().getList());
        TestFootnote.assertEquals((int)6, (int)result.getFootnotes().getList().size());
        TestFootnote.assertEquals((String)" Footnote 1.\r\n", (String)((Footnote)result.getFootnotes().getList().get(0)).getText());
    }

    @Test
    public void testGetFootnote() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetFootnote.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.footnoteFolder + "/Footnote.doc"), this.remoteDataFolder + "/" + remoteFileName);
        GetFootnoteRequest request = new GetFootnoteRequest(remoteFileName, Integer.valueOf(0), "", this.remoteDataFolder, null, null, null, null, null);
        FootnoteResponse result = TestInitializer.wordsApi.getFootnote(request);
        TestFootnote.assertNotNull((Object)result);
        TestFootnote.assertNotNull((Object)result.getFootnote());
        TestFootnote.assertEquals((String)" Footnote 1.\r\n", (String)result.getFootnote().getText());
    }

    @Test
    public void testGetFootnoteOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.footnoteFolder + "/Footnote.doc").toAbsolutePath());
        GetFootnoteOnlineRequest request = new GetFootnoteOnlineRequest(requestDocument, Integer.valueOf(0), "", null, null, null, null);
        FootnoteResponse result = TestInitializer.wordsApi.getFootnoteOnline(request);
        TestFootnote.assertNotNull((Object)result);
    }

    @Test
    public void testGetFootnoteWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetFootnoteWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.footnoteFolder + "/Footnote.doc"), this.remoteDataFolder + "/" + remoteFileName);
        GetFootnoteRequest request = new GetFootnoteRequest(remoteFileName, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null);
        FootnoteResponse result = TestInitializer.wordsApi.getFootnote(request);
        TestFootnote.assertNotNull((Object)result);
        TestFootnote.assertNotNull((Object)result.getFootnote());
        TestFootnote.assertEquals((String)" Footnote 1.\r\n", (String)result.getFootnote().getText());
    }

    @Test
    public void testUpdateFootnote() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateFootnote.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.footnoteFolder + "/Footnote.doc"), this.remoteDataFolder + "/" + remoteFileName);
        FootnoteUpdate requestFootnoteDto = new FootnoteUpdate();
        requestFootnoteDto.setText("new text is here");
        UpdateFootnoteRequest request = new UpdateFootnoteRequest(remoteFileName, Integer.valueOf(0), requestFootnoteDto, "", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        FootnoteResponse result = TestInitializer.wordsApi.updateFootnote(request);
        TestFootnote.assertNotNull((Object)result);
        TestFootnote.assertNotNull((Object)result.getFootnote());
        TestFootnote.assertEquals((String)" new text is here\r\n", (String)result.getFootnote().getText());
    }

    @Test
    public void testUpdateFootnoteOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.footnoteFolder + "/Footnote.doc").toAbsolutePath());
        FootnoteUpdate requestFootnoteDto = new FootnoteUpdate();
        requestFootnoteDto.setText("new text is here");
        UpdateFootnoteOnlineRequest request = new UpdateFootnoteOnlineRequest(requestDocument, requestFootnoteDto, Integer.valueOf(0), "", null, null, null, null, null, null, null);
        UpdateFootnoteOnlineResponse result = TestInitializer.wordsApi.updateFootnoteOnline(request);
        TestFootnote.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateFootnoteWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateFootnoteWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.footnoteFolder + "/Footnote.doc"), this.remoteDataFolder + "/" + remoteFileName);
        FootnoteUpdate requestFootnoteDto = new FootnoteUpdate();
        requestFootnoteDto.setText("new text is here");
        UpdateFootnoteRequest request = new UpdateFootnoteRequest(remoteFileName, Integer.valueOf(0), requestFootnoteDto, null, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        FootnoteResponse result = TestInitializer.wordsApi.updateFootnote(request);
        TestFootnote.assertNotNull((Object)result);
        TestFootnote.assertNotNull((Object)result.getFootnote());
        TestFootnote.assertEquals((String)" new text is here\r\n", (String)result.getFootnote().getText());
    }
}

