/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.macros;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.requests.DeleteMacrosOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteMacrosRequest;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;

public class TestMacros
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/Macros";
    private String localFile = "Common/test_multi_pages.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testDeleteMacros() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteDocumentMacros.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteMacrosRequest request = new DeleteMacrosRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteMacros(request);
    }

    @Test
    public void testDeleteMacrosOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteMacrosOnlineRequest request = new DeleteMacrosOnlineRequest(requestDocument, null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteMacrosOnline(request);
        TestMacros.assertNotNull((Object)result);
    }
}

