/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.mailMerge;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.DocumentResponse;
import com.aspose.words.cloud.model.requests.ExecuteMailMergeOnlineRequest;
import com.aspose.words.cloud.model.requests.ExecuteMailMergeRequest;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestExecuteTemplate
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentActions/MailMerge";
    private String mailMergeFolder = "DocumentActions/MailMerge";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testExecuteTemplate() throws ApiException, MessagingException, IOException {
        String localDocumentFile = "TestExecuteTemplate.doc";
        String remoteFileName = "TestExecuteTemplate.docx";
        String localDataFile = new String(Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.mailMergeFolder + "/TestExecuteTemplateData.txt")), "utf8");
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.mailMergeFolder + "/" + localDocumentFile), this.remoteDataFolder + "/" + remoteFileName);
        ExecuteMailMergeRequest request = new ExecuteMailMergeRequest(remoteFileName, localDataFile, null, this.remoteDataFolder, null, null, null, null, null, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName);
        DocumentResponse result = TestInitializer.wordsApi.executeMailMerge(request);
        TestExecuteTemplate.assertNotNull((Object)result);
        TestExecuteTemplate.assertNotNull((Object)result.getDocument());
        TestExecuteTemplate.assertEquals((String)"TestExecuteTemplate.docx", (String)result.getDocument().getFileName());
    }

    @Test
    public void testExecuteTemplateOnline() throws ApiException, MessagingException, IOException {
        String localDocumentFile = "SampleMailMergeTemplate.docx";
        String localDataFile = "SampleExecuteTemplateData.txt";
        byte[] requestTemplate = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.mailMergeFolder + "/" + localDocumentFile).toAbsolutePath());
        byte[] requestData = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.mailMergeFolder + "/" + localDataFile).toAbsolutePath());
        ExecuteMailMergeOnlineRequest request = new ExecuteMailMergeOnlineRequest(requestTemplate, requestData, null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.executeMailMergeOnline(request);
        TestExecuteTemplate.assertNotNull((Object)result);
    }
}

