/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.mailMerge;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.FieldNamesResponse;
import com.aspose.words.cloud.model.requests.GetDocumentFieldNamesOnlineRequest;
import com.aspose.words.cloud.model.requests.GetDocumentFieldNamesRequest;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestMailMergeFileds
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentActions/MailMerge";
    private String mailMergeFolder = "DocumentActions/MailMerge";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetDocumentFieldNamesOnline() throws ApiException, MessagingException, IOException {
        String localDocumentFile = "SampleExecuteTemplate.docx";
        byte[] requestTemplate = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.mailMergeFolder + "/" + localDocumentFile).toAbsolutePath());
        GetDocumentFieldNamesOnlineRequest request = new GetDocumentFieldNamesOnlineRequest(requestTemplate, null, null, null, null, Boolean.valueOf(true));
        FieldNamesResponse result = TestInitializer.wordsApi.getDocumentFieldNamesOnline(request);
        TestMailMergeFileds.assertNotNull((Object)result);
        TestMailMergeFileds.assertNotNull((Object)result.getFieldNames());
        TestMailMergeFileds.assertNotNull((Object)result.getFieldNames().getNames());
        TestMailMergeFileds.assertEquals((int)15, (int)result.getFieldNames().getNames().size());
        TestMailMergeFileds.assertEquals((String)"TableStart:Order", (String)((String)result.getFieldNames().getNames().get(0)));
    }

    @Test
    public void testGetDocumentFieldNames() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentFieldNames.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, "Common/test_multi_pages.docx"), this.remoteDataFolder + "/" + remoteFileName);
        GetDocumentFieldNamesRequest request = new GetDocumentFieldNamesRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null, null);
        FieldNamesResponse result = TestInitializer.wordsApi.getDocumentFieldNames(request);
        TestMailMergeFileds.assertNotNull((Object)result);
        TestMailMergeFileds.assertNotNull((Object)result.getFieldNames());
        TestMailMergeFileds.assertNotNull((Object)result.getFieldNames().getNames());
        TestMailMergeFileds.assertEquals((int)0, (int)result.getFieldNames().getNames().size());
    }
}

