/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.styles;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.Style;
import com.aspose.words.cloud.model.StyleApply;
import com.aspose.words.cloud.model.StyleCopy;
import com.aspose.words.cloud.model.StyleInsert;
import com.aspose.words.cloud.model.StyleResponse;
import com.aspose.words.cloud.model.StyleUpdate;
import com.aspose.words.cloud.model.StylesResponse;
import com.aspose.words.cloud.model.WordsResponse;
import com.aspose.words.cloud.model.requests.ApplyStyleToDocumentElementOnlineRequest;
import com.aspose.words.cloud.model.requests.ApplyStyleToDocumentElementRequest;
import com.aspose.words.cloud.model.requests.CopyStyleOnlineRequest;
import com.aspose.words.cloud.model.requests.CopyStyleRequest;
import com.aspose.words.cloud.model.requests.CopyStylesFromTemplateRequest;
import com.aspose.words.cloud.model.requests.GetStyleFromDocumentElementOnlineRequest;
import com.aspose.words.cloud.model.requests.GetStyleFromDocumentElementRequest;
import com.aspose.words.cloud.model.requests.GetStyleOnlineRequest;
import com.aspose.words.cloud.model.requests.GetStyleRequest;
import com.aspose.words.cloud.model.requests.GetStylesOnlineRequest;
import com.aspose.words.cloud.model.requests.GetStylesRequest;
import com.aspose.words.cloud.model.requests.InsertStyleOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertStyleRequest;
import com.aspose.words.cloud.model.requests.UpdateStyleOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateStyleRequest;
import com.aspose.words.cloud.model.responses.ApplyStyleToDocumentElementOnlineResponse;
import com.aspose.words.cloud.model.responses.CopyStyleOnlineResponse;
import com.aspose.words.cloud.model.responses.InsertStyleOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateStyleOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestStyles
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/Styles";
    private String localFile = "DocumentElements/Styles/GetStyles.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetStyles() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetStyles.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetStylesRequest request = new GetStylesRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null);
        StylesResponse result = TestInitializer.wordsApi.getStyles(request);
        TestStyles.assertNotNull((Object)result);
        TestStyles.assertNotNull((Object)result.getStyles());
        TestStyles.assertEquals((int)22, (int)result.getStyles().size());
        TestStyles.assertEquals((String)"Default Paragraph Font", (String)((Style)result.getStyles().get(0)).getName());
    }

    @Test
    public void testGetStylesOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetStylesOnlineRequest request = new GetStylesOnlineRequest(requestDocument, null, null, null, null);
        StylesResponse result = TestInitializer.wordsApi.getStylesOnline(request);
        TestStyles.assertNotNull((Object)result);
    }

    @Test
    public void testGetStyle() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetStyle.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetStyleRequest request = new GetStyleRequest(remoteFileName, "Heading 1", this.remoteDataFolder, null, null, null, null, null);
        StyleResponse result = TestInitializer.wordsApi.getStyle(request);
        TestStyles.assertNotNull((Object)result);
        TestStyles.assertNotNull((Object)result.getStyle());
        TestStyles.assertEquals((String)"Heading 1", (String)result.getStyle().getName());
    }

    @Test
    public void testGetStyleOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetStyleOnlineRequest request = new GetStyleOnlineRequest(requestDocument, "Heading 1", null, null, null, null);
        StyleResponse result = TestInitializer.wordsApi.getStyleOnline(request);
        TestStyles.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateStyle() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateStyle.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        StyleUpdate requestStyleUpdate = new StyleUpdate();
        requestStyleUpdate.setName("My Style");
        UpdateStyleRequest request = new UpdateStyleRequest(remoteFileName, "Heading 1", requestStyleUpdate, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        StyleResponse result = TestInitializer.wordsApi.updateStyle(request);
        TestStyles.assertNotNull((Object)result);
        TestStyles.assertNotNull((Object)result.getStyle());
        TestStyles.assertEquals((String)"My Style", (String)result.getStyle().getName());
    }

    @Test
    public void testUpdateStyleOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        StyleUpdate requestStyleUpdate = new StyleUpdate();
        requestStyleUpdate.setName("My Style");
        UpdateStyleOnlineRequest request = new UpdateStyleOnlineRequest(requestDocument, "Heading 1", requestStyleUpdate, null, null, null, null, null, null, null);
        UpdateStyleOnlineResponse result = TestInitializer.wordsApi.updateStyleOnline(request);
        TestStyles.assertNotNull((Object)result);
    }

    @Test
    public void testInsertStyle() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertStyle.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        StyleInsert requestStyleInsert = new StyleInsert();
        requestStyleInsert.setStyleName("My Style");
        requestStyleInsert.setStyleType(StyleInsert.StyleTypeEnum.PARAGRAPH);
        InsertStyleRequest request = new InsertStyleRequest(remoteFileName, requestStyleInsert, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        StyleResponse result = TestInitializer.wordsApi.insertStyle(request);
        TestStyles.assertNotNull((Object)result);
        TestStyles.assertNotNull((Object)result.getStyle());
        TestStyles.assertEquals((String)"My Style", (String)result.getStyle().getName());
    }

    @Test
    public void testInsertStyleOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        StyleInsert requestStyleInsert = new StyleInsert();
        requestStyleInsert.setStyleName("My Style");
        requestStyleInsert.setStyleType(StyleInsert.StyleTypeEnum.PARAGRAPH);
        InsertStyleOnlineRequest request = new InsertStyleOnlineRequest(requestDocument, requestStyleInsert, null, null, null, null, null, null, null);
        InsertStyleOnlineResponse result = TestInitializer.wordsApi.insertStyleOnline(request);
        TestStyles.assertNotNull((Object)result);
    }

    @Test
    public void testCopyStyle() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestCopyStyle.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        StyleCopy requestStyleCopy = new StyleCopy();
        requestStyleCopy.setStyleName("Heading 1");
        CopyStyleRequest request = new CopyStyleRequest(remoteFileName, requestStyleCopy, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        StyleResponse result = TestInitializer.wordsApi.copyStyle(request);
        TestStyles.assertNotNull((Object)result);
        TestStyles.assertNotNull((Object)result.getStyle());
        TestStyles.assertEquals((String)"Heading 1_0", (String)result.getStyle().getName());
    }

    @Test
    public void testCopyStyleOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        StyleCopy requestStyleCopy = new StyleCopy();
        requestStyleCopy.setStyleName("Heading 1");
        CopyStyleOnlineRequest request = new CopyStyleOnlineRequest(requestDocument, requestStyleCopy, null, null, null, null, null, null, null);
        CopyStyleOnlineResponse result = TestInitializer.wordsApi.copyStyleOnline(request);
        TestStyles.assertNotNull((Object)result);
    }

    @Test
    public void testGetStyleFromDocumentElement() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetStyleFromDocumentElement.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetStyleFromDocumentElementRequest request = new GetStyleFromDocumentElementRequest(remoteFileName, "paragraphs/1/paragraphFormat", this.remoteDataFolder, null, null, null, null, null);
        StyleResponse result = TestInitializer.wordsApi.getStyleFromDocumentElement(request);
        TestStyles.assertNotNull((Object)result);
        TestStyles.assertNotNull((Object)result.getStyle());
        TestStyles.assertEquals((String)"TOC 1", (String)result.getStyle().getName());
    }

    @Test
    public void testGetStyleFromDocumentElementOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetStyleFromDocumentElementOnlineRequest request = new GetStyleFromDocumentElementOnlineRequest(requestDocument, "paragraphs/1/paragraphFormat", null, null, null, null);
        StyleResponse result = TestInitializer.wordsApi.getStyleFromDocumentElementOnline(request);
        TestStyles.assertNotNull((Object)result);
    }

    @Test
    public void testApplyStyleToDocumentElement() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestApplyStyleToDocumentElement.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        StyleApply requestStyleApply = new StyleApply();
        requestStyleApply.setStyleName("Heading 1");
        ApplyStyleToDocumentElementRequest request = new ApplyStyleToDocumentElementRequest(remoteFileName, "paragraphs/1/paragraphFormat", requestStyleApply, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        WordsResponse result = TestInitializer.wordsApi.applyStyleToDocumentElement(request);
        TestStyles.assertNotNull((Object)result);
    }

    @Test
    public void testApplyStyleToDocumentElementOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        StyleApply requestStyleApply = new StyleApply();
        requestStyleApply.setStyleName("Heading 1");
        ApplyStyleToDocumentElementOnlineRequest request = new ApplyStyleToDocumentElementOnlineRequest(requestDocument, "paragraphs/1/paragraphFormat", requestStyleApply, null, null, null, null, null, null, null);
        ApplyStyleToDocumentElementOnlineResponse result = TestInitializer.wordsApi.applyStyleToDocumentElementOnline(request);
        TestStyles.assertNotNull((Object)result);
    }

    @Test
    public void testCopyStylesFromTemplate() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestCopyStylesFromTemplate.docx";
        String templateFolder = "DocumentElements/Styles";
        String templateName = "StyleTemplate.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, templateFolder + "/" + templateName), this.remoteDataFolder + "/" + templateName);
        CopyStylesFromTemplateRequest request = new CopyStylesFromTemplateRequest(remoteFileName, templateName, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        WordsResponse result = TestInitializer.wordsApi.copyStylesFromTemplate(request);
        TestStyles.assertNotNull((Object)result);
    }
}

