/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.table;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.TableCellFormat;
import com.aspose.words.cloud.model.TableCellFormatResponse;
import com.aspose.words.cloud.model.TableCellInsert;
import com.aspose.words.cloud.model.TableCellResponse;
import com.aspose.words.cloud.model.TableInsert;
import com.aspose.words.cloud.model.TableLink;
import com.aspose.words.cloud.model.TableLinkCollectionResponse;
import com.aspose.words.cloud.model.TableProperties;
import com.aspose.words.cloud.model.TablePropertiesResponse;
import com.aspose.words.cloud.model.TableResponse;
import com.aspose.words.cloud.model.TableRow;
import com.aspose.words.cloud.model.TableRowFormat;
import com.aspose.words.cloud.model.TableRowFormatResponse;
import com.aspose.words.cloud.model.TableRowInsert;
import com.aspose.words.cloud.model.TableRowResponse;
import com.aspose.words.cloud.model.requests.DeleteTableCellOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteTableCellRequest;
import com.aspose.words.cloud.model.requests.DeleteTableOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteTableRequest;
import com.aspose.words.cloud.model.requests.DeleteTableRowOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteTableRowRequest;
import com.aspose.words.cloud.model.requests.GetTableCellFormatOnlineRequest;
import com.aspose.words.cloud.model.requests.GetTableCellFormatRequest;
import com.aspose.words.cloud.model.requests.GetTableCellOnlineRequest;
import com.aspose.words.cloud.model.requests.GetTableCellRequest;
import com.aspose.words.cloud.model.requests.GetTableOnlineRequest;
import com.aspose.words.cloud.model.requests.GetTablePropertiesOnlineRequest;
import com.aspose.words.cloud.model.requests.GetTablePropertiesRequest;
import com.aspose.words.cloud.model.requests.GetTableRequest;
import com.aspose.words.cloud.model.requests.GetTableRowFormatOnlineRequest;
import com.aspose.words.cloud.model.requests.GetTableRowFormatRequest;
import com.aspose.words.cloud.model.requests.GetTableRowOnlineRequest;
import com.aspose.words.cloud.model.requests.GetTableRowRequest;
import com.aspose.words.cloud.model.requests.GetTablesOnlineRequest;
import com.aspose.words.cloud.model.requests.GetTablesRequest;
import com.aspose.words.cloud.model.requests.InsertTableCellOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertTableCellRequest;
import com.aspose.words.cloud.model.requests.InsertTableOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertTableRequest;
import com.aspose.words.cloud.model.requests.InsertTableRowOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertTableRowRequest;
import com.aspose.words.cloud.model.requests.RenderTableOnlineRequest;
import com.aspose.words.cloud.model.requests.RenderTableRequest;
import com.aspose.words.cloud.model.requests.UpdateTableCellFormatOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateTableCellFormatRequest;
import com.aspose.words.cloud.model.requests.UpdateTablePropertiesOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateTablePropertiesRequest;
import com.aspose.words.cloud.model.requests.UpdateTableRowFormatOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateTableRowFormatRequest;
import com.aspose.words.cloud.model.responses.InsertTableCellOnlineResponse;
import com.aspose.words.cloud.model.responses.InsertTableOnlineResponse;
import com.aspose.words.cloud.model.responses.InsertTableRowOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateTableCellFormatOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateTablePropertiesOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateTableRowFormatOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;

public class TestTable
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/Tables";
    private String localFile = "DocumentElements/Tables/TablesGet.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetTables() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetTables.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetTablesRequest request = new GetTablesRequest(remoteFileName, "", this.remoteDataFolder, null, null, null, null, null);
        TableLinkCollectionResponse result = TestInitializer.wordsApi.getTables(request);
        TestTable.assertNotNull((Object)result);
        TestTable.assertNotNull((Object)result.getTables());
        TestTable.assertNotNull((Object)result.getTables().getTableLinkList());
        TestTable.assertEquals((int)5, (int)result.getTables().getTableLinkList().size());
        TestTable.assertEquals((String)"0.0.1", (String)((TableLink)result.getTables().getTableLinkList().get(0)).getNodeId());
    }

    @Test
    public void testGetTablesOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetTablesOnlineRequest request = new GetTablesOnlineRequest(requestDocument, "", null, null, null, null);
        TableLinkCollectionResponse result = TestInitializer.wordsApi.getTablesOnline(request);
        TestTable.assertNotNull((Object)result);
    }

    @Test
    public void testGetTablesWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetTablesWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetTablesRequest request = new GetTablesRequest(remoteFileName, null, this.remoteDataFolder, null, null, null, null, null);
        TableLinkCollectionResponse result = TestInitializer.wordsApi.getTables(request);
        TestTable.assertNotNull((Object)result);
        TestTable.assertNotNull((Object)result.getTables());
        TestTable.assertNotNull((Object)result.getTables().getTableLinkList());
        TestTable.assertEquals((int)5, (int)result.getTables().getTableLinkList().size());
        TestTable.assertEquals((String)"0.0.1", (String)((TableLink)result.getTables().getTableLinkList().get(0)).getNodeId());
    }

    @Test
    public void testGetTable() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetTable.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetTableRequest request = new GetTableRequest(remoteFileName, Integer.valueOf(1), "", this.remoteDataFolder, null, null, null, null, null);
        TableResponse result = TestInitializer.wordsApi.getTable(request);
        TestTable.assertNotNull((Object)result);
        TestTable.assertNotNull((Object)result.getTable());
        TestTable.assertNotNull((Object)result.getTable().getTableRowList());
        TestTable.assertEquals((int)1, (int)result.getTable().getTableRowList().size());
        TestTable.assertNotNull((Object)((TableRow)result.getTable().getTableRowList().get(0)).getTableCellList());
        TestTable.assertEquals((int)2, (int)((TableRow)result.getTable().getTableRowList().get(0)).getTableCellList().size());
    }

    @Test
    public void testGetTableOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetTableOnlineRequest request = new GetTableOnlineRequest(requestDocument, Integer.valueOf(1), "", null, null, null, null);
        TableResponse result = TestInitializer.wordsApi.getTableOnline(request);
        TestTable.assertNotNull((Object)result);
    }

    @Test
    public void testGetTableWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetTableWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetTableRequest request = new GetTableRequest(remoteFileName, Integer.valueOf(1), null, this.remoteDataFolder, null, null, null, null, null);
        TableResponse result = TestInitializer.wordsApi.getTable(request);
        TestTable.assertNotNull((Object)result);
        TestTable.assertNotNull((Object)result.getTable());
        TestTable.assertNotNull((Object)result.getTable().getTableRowList());
        TestTable.assertEquals((int)1, (int)result.getTable().getTableRowList().size());
        TestTable.assertNotNull((Object)((TableRow)result.getTable().getTableRowList().get(0)).getTableCellList());
        TestTable.assertEquals((int)2, (int)((TableRow)result.getTable().getTableRowList().get(0)).getTableCellList().size());
    }

    @Test
    public void testDeleteTable() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteTable.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteTableRequest request = new DeleteTableRequest(remoteFileName, Integer.valueOf(1), "", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteTable(request);
    }

    @Test
    public void testDeleteTableOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteTableOnlineRequest request = new DeleteTableOnlineRequest(requestDocument, Integer.valueOf(1), "", null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteTableOnline(request);
        TestTable.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteTableWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteTableWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteTableRequest request = new DeleteTableRequest(remoteFileName, Integer.valueOf(1), null, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteTable(request);
    }

    @Test
    public void testInsertTable() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertTable.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        TableInsert requestTable = new TableInsert();
        requestTable.setColumnsCount(Integer.valueOf(5));
        requestTable.setRowsCount(Integer.valueOf(4));
        InsertTableRequest request = new InsertTableRequest(remoteFileName, requestTable, "", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TableResponse result = TestInitializer.wordsApi.insertTable(request);
        TestTable.assertNotNull((Object)result);
        TestTable.assertNotNull((Object)result.getTable());
        TestTable.assertNotNull((Object)result.getTable().getTableRowList());
        TestTable.assertEquals((int)4, (int)result.getTable().getTableRowList().size());
        TestTable.assertNotNull((Object)((TableRow)result.getTable().getTableRowList().get(0)).getTableCellList());
        TestTable.assertEquals((int)5, (int)((TableRow)result.getTable().getTableRowList().get(0)).getTableCellList().size());
    }

    @Test
    public void testInsertTableOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        TableInsert requestTable = new TableInsert();
        requestTable.setColumnsCount(Integer.valueOf(5));
        requestTable.setRowsCount(Integer.valueOf(4));
        InsertTableOnlineRequest request = new InsertTableOnlineRequest(requestDocument, requestTable, "", null, null, null, null, null, null, null);
        InsertTableOnlineResponse result = TestInitializer.wordsApi.insertTableOnline(request);
        TestTable.assertNotNull((Object)result);
    }

    @Test
    public void testInsertTableWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertTableWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        TableInsert requestTable = new TableInsert();
        requestTable.setColumnsCount(Integer.valueOf(5));
        requestTable.setRowsCount(Integer.valueOf(4));
        InsertTableRequest request = new InsertTableRequest(remoteFileName, requestTable, null, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TableResponse result = TestInitializer.wordsApi.insertTable(request);
        TestTable.assertNotNull((Object)result);
        TestTable.assertNotNull((Object)result.getTable());
        TestTable.assertNotNull((Object)result.getTable().getTableRowList());
        TestTable.assertEquals((int)4, (int)result.getTable().getTableRowList().size());
        TestTable.assertNotNull((Object)((TableRow)result.getTable().getTableRowList().get(0)).getTableCellList());
        TestTable.assertEquals((int)5, (int)((TableRow)result.getTable().getTableRowList().get(0)).getTableCellList().size());
    }

    @Test
    public void testGetTableProperties() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetTableProperties.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetTablePropertiesRequest request = new GetTablePropertiesRequest(remoteFileName, Integer.valueOf(1), "", this.remoteDataFolder, null, null, null, null, null);
        TablePropertiesResponse result = TestInitializer.wordsApi.getTableProperties(request);
        TestTable.assertNotNull((Object)result);
        TestTable.assertNotNull((Object)result.getProperties());
        TestTable.assertEquals((String)"Table Grid", (String)result.getProperties().getStyleName());
    }

    @Test
    public void testGetTablePropertiesOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetTablePropertiesOnlineRequest request = new GetTablePropertiesOnlineRequest(requestDocument, Integer.valueOf(1), "", null, null, null, null);
        TablePropertiesResponse result = TestInitializer.wordsApi.getTablePropertiesOnline(request);
        TestTable.assertNotNull((Object)result);
    }

    @Test
    public void testGetTablePropertiesWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetTablePropertiesWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetTablePropertiesRequest request = new GetTablePropertiesRequest(remoteFileName, Integer.valueOf(1), null, this.remoteDataFolder, null, null, null, null, null);
        TablePropertiesResponse result = TestInitializer.wordsApi.getTableProperties(request);
        TestTable.assertNotNull((Object)result);
        TestTable.assertNotNull((Object)result.getProperties());
        TestTable.assertEquals((String)"Table Grid", (String)result.getProperties().getStyleName());
    }

    @Test
    public void testUpdateTableProperties() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateTableProperties.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        TableProperties requestProperties = new TableProperties();
        requestProperties.setAlignment(TableProperties.AlignmentEnum.RIGHT);
        requestProperties.setAllowAutoFit(Boolean.valueOf(false));
        requestProperties.setBidi(Boolean.valueOf(true));
        requestProperties.setBottomPadding(Double.valueOf(1.0));
        requestProperties.setCellSpacing(Double.valueOf(2.0));
        requestProperties.setStyleOptions(TableProperties.StyleOptionsEnum.COLUMNBANDS);
        UpdateTablePropertiesRequest request = new UpdateTablePropertiesRequest(remoteFileName, Integer.valueOf(1), requestProperties, "", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TablePropertiesResponse result = TestInitializer.wordsApi.updateTableProperties(request);
        TestTable.assertNotNull((Object)result);
        TestTable.assertNotNull((Object)result.getProperties());
        TestTable.assertEquals((Object)false, (Object)result.getProperties().getAllowAutoFit());
        TestTable.assertEquals((Object)true, (Object)result.getProperties().getBidi());
        TestTable.assertEquals((Object)1.0, (Object)result.getProperties().getBottomPadding());
        TestTable.assertEquals((Object)2.0, (Object)result.getProperties().getCellSpacing());
    }

    @Test
    public void testUpdateTablePropertiesOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        TableProperties requestProperties = new TableProperties();
        requestProperties.setAlignment(TableProperties.AlignmentEnum.RIGHT);
        requestProperties.setAllowAutoFit(Boolean.valueOf(false));
        requestProperties.setBidi(Boolean.valueOf(true));
        requestProperties.setBottomPadding(Double.valueOf(1.0));
        requestProperties.setCellSpacing(Double.valueOf(2.0));
        requestProperties.setStyleOptions(TableProperties.StyleOptionsEnum.COLUMNBANDS);
        UpdateTablePropertiesOnlineRequest request = new UpdateTablePropertiesOnlineRequest(requestDocument, requestProperties, Integer.valueOf(1), "", null, null, null, null, null, null, null);
        UpdateTablePropertiesOnlineResponse result = TestInitializer.wordsApi.updateTablePropertiesOnline(request);
        TestTable.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateTablePropertiesWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateTablePropertiesWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        TableProperties requestProperties = new TableProperties();
        requestProperties.setAlignment(TableProperties.AlignmentEnum.RIGHT);
        requestProperties.setAllowAutoFit(Boolean.valueOf(false));
        requestProperties.setBidi(Boolean.valueOf(true));
        requestProperties.setBottomPadding(Double.valueOf(1.0));
        requestProperties.setCellSpacing(Double.valueOf(2.0));
        requestProperties.setStyleOptions(TableProperties.StyleOptionsEnum.COLUMNBANDS);
        UpdateTablePropertiesRequest request = new UpdateTablePropertiesRequest(remoteFileName, Integer.valueOf(1), requestProperties, null, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TablePropertiesResponse result = TestInitializer.wordsApi.updateTableProperties(request);
        TestTable.assertNotNull((Object)result);
        TestTable.assertNotNull((Object)result.getProperties());
        TestTable.assertEquals((Object)false, (Object)result.getProperties().getAllowAutoFit());
        TestTable.assertEquals((Object)true, (Object)result.getProperties().getBidi());
        TestTable.assertEquals((Object)1.0, (Object)result.getProperties().getBottomPadding());
        TestTable.assertEquals((Object)2.0, (Object)result.getProperties().getCellSpacing());
    }

    @Test
    public void testGetTableRow() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetTableRow.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetTableRowRequest request = new GetTableRowRequest(remoteFileName, "tables/1", Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null);
        TableRowResponse result = TestInitializer.wordsApi.getTableRow(request);
        TestTable.assertNotNull((Object)result);
        TestTable.assertNotNull((Object)result.getRow());
        TestTable.assertNotNull((Object)result.getRow().getTableCellList());
        TestTable.assertEquals((int)2, (int)result.getRow().getTableCellList().size());
    }

    @Test
    public void testGetTableRowOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetTableRowOnlineRequest request = new GetTableRowOnlineRequest(requestDocument, "tables/1", Integer.valueOf(0), null, null, null, null);
        TableRowResponse result = TestInitializer.wordsApi.getTableRowOnline(request);
        TestTable.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteTableRow() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteTableRow.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteTableRowRequest request = new DeleteTableRowRequest(remoteFileName, "tables/1", Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteTableRow(request);
    }

    @Test
    public void testDeleteTableRowOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteTableRowOnlineRequest request = new DeleteTableRowOnlineRequest(requestDocument, "tables/1", Integer.valueOf(0), null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteTableRowOnline(request);
        TestTable.assertNotNull((Object)result);
    }

    @Test
    public void testInsertTableRow() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertTableRow.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        TableRowInsert requestRow = new TableRowInsert();
        requestRow.setColumnsCount(Integer.valueOf(5));
        InsertTableRowRequest request = new InsertTableRowRequest(remoteFileName, requestRow, "sections/0/tables/2", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TableRowResponse result = TestInitializer.wordsApi.insertTableRow(request);
        TestTable.assertNotNull((Object)result);
        TestTable.assertNotNull((Object)result.getRow());
        TestTable.assertNotNull((Object)result.getRow().getTableCellList());
        TestTable.assertEquals((int)5, (int)result.getRow().getTableCellList().size());
    }

    @Test
    public void testInsertTableRowOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        TableRowInsert requestRow = new TableRowInsert();
        requestRow.setColumnsCount(Integer.valueOf(5));
        InsertTableRowOnlineRequest request = new InsertTableRowOnlineRequest(requestDocument, requestRow, "sections/0/tables/2", null, null, null, null, null, null, null);
        InsertTableRowOnlineResponse result = TestInitializer.wordsApi.insertTableRowOnline(request);
        TestTable.assertNotNull((Object)result);
    }

    @Test
    public void testGetTableRowFormat() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetTableRowFormat.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetTableRowFormatRequest request = new GetTableRowFormatRequest(remoteFileName, "sections/0/tables/2", Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null);
        TableRowFormatResponse result = TestInitializer.wordsApi.getTableRowFormat(request);
        TestTable.assertNotNull((Object)result);
        TestTable.assertNotNull((Object)result.getRowFormat());
        TestTable.assertEquals((Object)true, (Object)result.getRowFormat().getAllowBreakAcrossPages());
    }

    @Test
    public void testGetTableRowFormatOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetTableRowFormatOnlineRequest request = new GetTableRowFormatOnlineRequest(requestDocument, "sections/0/tables/2", Integer.valueOf(0), null, null, null, null);
        TableRowFormatResponse result = TestInitializer.wordsApi.getTableRowFormatOnline(request);
        TestTable.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateTableRowFormat() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateTableRowFormat.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        TableRowFormat requestFormat = new TableRowFormat();
        requestFormat.setAllowBreakAcrossPages(Boolean.valueOf(true));
        requestFormat.setHeadingFormat(Boolean.valueOf(true));
        requestFormat.setHeight(Double.valueOf(10.0));
        requestFormat.setHeightRule(TableRowFormat.HeightRuleEnum.EXACTLY);
        UpdateTableRowFormatRequest request = new UpdateTableRowFormatRequest(remoteFileName, "sections/0/tables/2", Integer.valueOf(0), requestFormat, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TableRowFormatResponse result = TestInitializer.wordsApi.updateTableRowFormat(request);
        TestTable.assertNotNull((Object)result);
        TestTable.assertNotNull((Object)result.getRowFormat());
        TestTable.assertEquals((Object)true, (Object)result.getRowFormat().getAllowBreakAcrossPages());
        TestTable.assertEquals((Object)true, (Object)result.getRowFormat().getHeadingFormat());
        TestTable.assertEquals((Object)10.0, (Object)result.getRowFormat().getHeight());
    }

    @Test
    public void testUpdateTableRowFormatOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        TableRowFormat requestFormat = new TableRowFormat();
        requestFormat.setAllowBreakAcrossPages(Boolean.valueOf(true));
        requestFormat.setHeadingFormat(Boolean.valueOf(true));
        requestFormat.setHeight(Double.valueOf(10.0));
        requestFormat.setHeightRule(TableRowFormat.HeightRuleEnum.AUTO);
        UpdateTableRowFormatOnlineRequest request = new UpdateTableRowFormatOnlineRequest(requestDocument, "sections/0/tables/2", requestFormat, Integer.valueOf(0), null, null, null, null, null, null, null);
        UpdateTableRowFormatOnlineResponse result = TestInitializer.wordsApi.updateTableRowFormatOnline(request);
        TestTable.assertNotNull((Object)result);
    }

    @Test
    public void testGetTableCell() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetTableCell.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetTableCellRequest request = new GetTableCellRequest(remoteFileName, "sections/0/tables/2/rows/0", Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null);
        TableCellResponse result = TestInitializer.wordsApi.getTableCell(request);
        TestTable.assertNotNull((Object)result);
        TestTable.assertNotNull((Object)result.getCell());
        TestTable.assertEquals((String)"0.0.5.0.0", (String)result.getCell().getNodeId());
    }

    @Test
    public void testGetTableCellOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetTableCellOnlineRequest request = new GetTableCellOnlineRequest(requestDocument, "sections/0/tables/2/rows/0", Integer.valueOf(0), null, null, null, null);
        TableCellResponse result = TestInitializer.wordsApi.getTableCellOnline(request);
        TestTable.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteTableCell() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteTableCell.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteTableCellRequest request = new DeleteTableCellRequest(remoteFileName, "sections/0/tables/2/rows/0", Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteTableCell(request);
    }

    @Test
    public void testDeleteTableCellOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteTableCellOnlineRequest request = new DeleteTableCellOnlineRequest(requestDocument, "sections/0/tables/2/rows/0", Integer.valueOf(0), null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteTableCellOnline(request);
        TestTable.assertNotNull((Object)result);
    }

    @Test
    public void testInsertTableCell() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertTableCell.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        TableCellInsert requestCell = new TableCellInsert();
        InsertTableCellRequest request = new InsertTableCellRequest(remoteFileName, requestCell, "sections/0/tables/2/rows/0", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TableCellResponse result = TestInitializer.wordsApi.insertTableCell(request);
        TestTable.assertNotNull((Object)result);
        TestTable.assertNotNull((Object)result.getCell());
        TestTable.assertEquals((String)"0.0.5.0.3", (String)result.getCell().getNodeId());
    }

    @Test
    public void testInsertTableCellOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        TableCellInsert requestCell = new TableCellInsert();
        InsertTableCellOnlineRequest request = new InsertTableCellOnlineRequest(requestDocument, requestCell, "sections/0/tables/2/rows/0", null, null, null, null, null, null, null);
        InsertTableCellOnlineResponse result = TestInitializer.wordsApi.insertTableCellOnline(request);
        TestTable.assertNotNull((Object)result);
    }

    @Test
    public void testGetTableCellFormat() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetTableCellFormat.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetTableCellFormatRequest request = new GetTableCellFormatRequest(remoteFileName, "sections/0/tables/2/rows/0", Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null);
        TableCellFormatResponse result = TestInitializer.wordsApi.getTableCellFormat(request);
        TestTable.assertNotNull((Object)result);
        TestTable.assertNotNull((Object)result.getCellFormat());
        TestTable.assertEquals((Object)true, (Object)result.getCellFormat().getWrapText());
    }

    @Test
    public void testGetTableCellFormatOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetTableCellFormatOnlineRequest request = new GetTableCellFormatOnlineRequest(requestDocument, "sections/0/tables/2/rows/0", Integer.valueOf(0), null, null, null, null);
        TableCellFormatResponse result = TestInitializer.wordsApi.getTableCellFormatOnline(request);
        TestTable.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateTableCellFormat() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateTableCellFormat.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        TableCellFormat requestFormat = new TableCellFormat();
        requestFormat.setBottomPadding(Double.valueOf(5.0));
        requestFormat.setFitText(Boolean.valueOf(true));
        requestFormat.setHorizontalMerge(TableCellFormat.HorizontalMergeEnum.FIRST);
        requestFormat.setWrapText(Boolean.valueOf(true));
        UpdateTableCellFormatRequest request = new UpdateTableCellFormatRequest(remoteFileName, "sections/0/tables/2/rows/0", Integer.valueOf(0), requestFormat, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TableCellFormatResponse result = TestInitializer.wordsApi.updateTableCellFormat(request);
        TestTable.assertNotNull((Object)result);
        TestTable.assertNotNull((Object)result.getCellFormat());
        TestTable.assertEquals((Object)5.0, (Object)result.getCellFormat().getBottomPadding());
        TestTable.assertEquals((Object)true, (Object)result.getCellFormat().getFitText());
        TestTable.assertEquals((Object)true, (Object)result.getCellFormat().getWrapText());
    }

    @Test
    public void testUpdateTableCellFormatOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        TableCellFormat requestFormat = new TableCellFormat();
        requestFormat.setBottomPadding(Double.valueOf(5.0));
        requestFormat.setFitText(Boolean.valueOf(true));
        requestFormat.setHorizontalMerge(TableCellFormat.HorizontalMergeEnum.FIRST);
        requestFormat.setWrapText(Boolean.valueOf(true));
        UpdateTableCellFormatOnlineRequest request = new UpdateTableCellFormatOnlineRequest(requestDocument, "sections/0/tables/2/rows/0", requestFormat, Integer.valueOf(0), null, null, null, null, null, null, null);
        UpdateTableCellFormatOnlineResponse result = TestInitializer.wordsApi.updateTableCellFormatOnline(request);
        TestTable.assertNotNull((Object)result);
    }

    @Test
    public void testRenderTable() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestRenderTable.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        RenderTableRequest request = new RenderTableRequest(remoteFileName, "png", Integer.valueOf(0), "", this.remoteDataFolder, null, null, null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.renderTable(request);
        TestTable.assertNotNull((Object)result);
    }

    @Test
    public void testRenderTableOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        RenderTableOnlineRequest request = new RenderTableOnlineRequest(requestDocument, "png", Integer.valueOf(0), "", null, null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.renderTableOnline(request);
        TestTable.assertNotNull((Object)result);
    }

    @Test
    public void testRenderTableWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestRenderTableWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        RenderTableRequest request = new RenderTableRequest(remoteFileName, "png", Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.renderTable(request);
        TestTable.assertNotNull((Object)result);
    }
}

