/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.table;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.Border;
import com.aspose.words.cloud.model.BorderResponse;
import com.aspose.words.cloud.model.BordersResponse;
import com.aspose.words.cloud.model.XmlColor;
import com.aspose.words.cloud.model.requests.DeleteBorderOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteBorderRequest;
import com.aspose.words.cloud.model.requests.DeleteBordersOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteBordersRequest;
import com.aspose.words.cloud.model.requests.GetBorderOnlineRequest;
import com.aspose.words.cloud.model.requests.GetBorderRequest;
import com.aspose.words.cloud.model.requests.GetBordersOnlineRequest;
import com.aspose.words.cloud.model.requests.GetBordersRequest;
import com.aspose.words.cloud.model.requests.UpdateBorderOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateBorderRequest;
import com.aspose.words.cloud.model.responses.DeleteBorderOnlineResponse;
import com.aspose.words.cloud.model.responses.DeleteBordersOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateBorderOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestTableBorder
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/Tables";
    private String localFile = "DocumentElements/Tables/TablesGet.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetBorders() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetBorders.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetBordersRequest request = new GetBordersRequest(remoteFileName, "tables/1/rows/0/cells/0", this.remoteDataFolder, null, null, null, null, null);
        BordersResponse result = TestInitializer.wordsApi.getBorders(request);
        TestTableBorder.assertNotNull((Object)result);
        TestTableBorder.assertNotNull((Object)result.getBorders());
        TestTableBorder.assertNotNull((Object)result.getBorders().getList());
        TestTableBorder.assertEquals((int)6, (int)result.getBorders().getList().size());
        TestTableBorder.assertNotNull((Object)((Border)result.getBorders().getList().get(0)).getColor());
        TestTableBorder.assertEquals((String)"#000000", (String)((Border)result.getBorders().getList().get(0)).getColor().getWeb());
    }

    @Test
    public void testGetBordersOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetBordersOnlineRequest request = new GetBordersOnlineRequest(requestDocument, "tables/1/rows/0/cells/0", null, null, null, null);
        BordersResponse result = TestInitializer.wordsApi.getBordersOnline(request);
        TestTableBorder.assertNotNull((Object)result);
    }

    @Test
    public void testGetBorder() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetBorder.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetBorderRequest request = new GetBorderRequest(remoteFileName, "left", "tables/1/rows/0/cells/0", this.remoteDataFolder, null, null, null, null, null);
        BorderResponse result = TestInitializer.wordsApi.getBorder(request);
        TestTableBorder.assertNotNull((Object)result);
        TestTableBorder.assertNotNull((Object)result.getBorder());
        TestTableBorder.assertNotNull((Object)result.getBorder().getColor());
        TestTableBorder.assertEquals((String)"#000000", (String)result.getBorder().getColor().getWeb());
    }

    @Test
    public void testGetBorderOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetBorderOnlineRequest request = new GetBorderOnlineRequest(requestDocument, "left", "tables/1/rows/0/cells/0", null, null, null, null);
        BorderResponse result = TestInitializer.wordsApi.getBorderOnline(request);
        TestTableBorder.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteBorders() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteBorders.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteBordersRequest request = new DeleteBordersRequest(remoteFileName, "tables/1/rows/0/cells/0", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        BordersResponse result = TestInitializer.wordsApi.deleteBorders(request);
        TestTableBorder.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteBordersOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteBordersOnlineRequest request = new DeleteBordersOnlineRequest(requestDocument, "tables/1/rows/0/cells/0", null, null, null, null, null, null, null);
        DeleteBordersOnlineResponse result = TestInitializer.wordsApi.deleteBordersOnline(request);
        TestTableBorder.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteBorder() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteBorder.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteBorderRequest request = new DeleteBorderRequest(remoteFileName, "left", "tables/1/rows/0/cells/0", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        BorderResponse result = TestInitializer.wordsApi.deleteBorder(request);
        TestTableBorder.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteBorderOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteBorderOnlineRequest request = new DeleteBorderOnlineRequest(requestDocument, "left", "tables/1/rows/0/cells/0", null, null, null, null, null, null, null);
        DeleteBorderOnlineResponse result = TestInitializer.wordsApi.deleteBorderOnline(request);
        TestTableBorder.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateBorder() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateBorder.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        XmlColor requestBorderPropertiesColor = new XmlColor();
        requestBorderPropertiesColor.setWeb("#AABBCC");
        Border requestBorderProperties = new Border();
        requestBorderProperties.setBorderType(Border.BorderTypeEnum.LEFT);
        requestBorderProperties.setColor(requestBorderPropertiesColor);
        requestBorderProperties.setDistanceFromText(Double.valueOf(6.0));
        requestBorderProperties.setLineStyle(Border.LineStyleEnum.DASHDOTSTROKER);
        requestBorderProperties.setLineWidth(Double.valueOf(2.0));
        requestBorderProperties.setShadow(Boolean.valueOf(true));
        UpdateBorderRequest request = new UpdateBorderRequest(remoteFileName, "left", requestBorderProperties, "tables/1/rows/0/cells/0", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        BorderResponse result = TestInitializer.wordsApi.updateBorder(request);
        TestTableBorder.assertNotNull((Object)result);
        TestTableBorder.assertNotNull((Object)result.getBorder());
        TestTableBorder.assertNotNull((Object)result.getBorder().getColor());
        TestTableBorder.assertEquals((String)"#AABBCC", (String)result.getBorder().getColor().getWeb());
        TestTableBorder.assertEquals((Object)6.0, (Object)result.getBorder().getDistanceFromText());
        TestTableBorder.assertEquals((Object)2.0, (Object)result.getBorder().getLineWidth());
        TestTableBorder.assertEquals((Object)true, (Object)result.getBorder().getShadow());
    }

    @Test
    public void testUpdateBorderOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        XmlColor requestBorderPropertiesColor = new XmlColor();
        requestBorderPropertiesColor.setWeb("#AABBCC");
        Border requestBorderProperties = new Border();
        requestBorderProperties.setBorderType(Border.BorderTypeEnum.LEFT);
        requestBorderProperties.setColor(requestBorderPropertiesColor);
        requestBorderProperties.setDistanceFromText(Double.valueOf(6.0));
        requestBorderProperties.setLineStyle(Border.LineStyleEnum.DASHDOTSTROKER);
        requestBorderProperties.setLineWidth(Double.valueOf(2.0));
        requestBorderProperties.setShadow(Boolean.valueOf(true));
        UpdateBorderOnlineRequest request = new UpdateBorderOnlineRequest(requestDocument, requestBorderProperties, "left", "tables/1/rows/0/cells/0", null, null, null, null, null, null, null);
        UpdateBorderOnlineResponse result = TestInitializer.wordsApi.updateBorderOnline(request);
        TestTableBorder.assertNotNull((Object)result);
    }
}

