/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.watermark;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.DocumentResponse;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.WatermarkDataBase;
import com.aspose.words.cloud.model.WatermarkDataImage;
import com.aspose.words.cloud.model.WatermarkDataText;
import com.aspose.words.cloud.model.WatermarkText;
import com.aspose.words.cloud.model.requests.DeleteWatermarkOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteWatermarkRequest;
import com.aspose.words.cloud.model.requests.InsertWatermarkImageOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertWatermarkImageRequest;
import com.aspose.words.cloud.model.requests.InsertWatermarkOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertWatermarkRequest;
import com.aspose.words.cloud.model.requests.InsertWatermarkTextOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertWatermarkTextRequest;
import com.aspose.words.cloud.model.responses.DeleteWatermarkOnlineResponse;
import com.aspose.words.cloud.model.responses.InsertWatermarkImageOnlineResponse;
import com.aspose.words.cloud.model.responses.InsertWatermarkOnlineResponse;
import com.aspose.words.cloud.model.responses.InsertWatermarkTextOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestWatermark
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentActions/Watermark";
    private String localFile = "Common/test_multi_pages.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testInsertWatermarkText() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertWatermarkText.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        WatermarkDataText requestWatermarkData = new WatermarkDataText();
        requestWatermarkData.setText("watermark text");
        InsertWatermarkRequest request = new InsertWatermarkRequest(remoteFileName, (WatermarkDataBase)requestWatermarkData, this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        DocumentResponse result = TestInitializer.wordsApi.insertWatermark(request);
        TestWatermark.assertNotNull((Object)result);
        TestWatermark.assertNotNull((Object)result.getDocument());
    }

    @Test
    public void testInsertWatermarkTextOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        WatermarkDataText requestWatermarkData = new WatermarkDataText();
        requestWatermarkData.setText("watermark text");
        InsertWatermarkOnlineRequest request = new InsertWatermarkOnlineRequest(requestDocument, (WatermarkDataBase)requestWatermarkData, null, null, null, null, null, null, null);
        InsertWatermarkOnlineResponse result = TestInitializer.wordsApi.insertWatermarkOnline(request);
        TestWatermark.assertNotNull((Object)result);
    }

    @Test
    public void testInsertWatermarkImage() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertWatermarkImage.docx";
        String remoteImagePath = this.remoteDataFolder + "/TestInsertWatermarkImage.png";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, "Common/aspose-cloud.png"), remoteImagePath);
        FileReference requestWatermarkDataImage = new FileReference(remoteImagePath);
        WatermarkDataImage requestWatermarkData = new WatermarkDataImage();
        requestWatermarkData.setImage(requestWatermarkDataImage);
        InsertWatermarkRequest request = new InsertWatermarkRequest(remoteFileName, (WatermarkDataBase)requestWatermarkData, this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        DocumentResponse result = TestInitializer.wordsApi.insertWatermark(request);
        TestWatermark.assertNotNull((Object)result);
        TestWatermark.assertNotNull((Object)result.getDocument());
    }

    @Test
    public void testInsertWatermarkImageOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        byte[] requestWatermarkDataImageStream = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, "Common/aspose-cloud.png").toAbsolutePath());
        FileReference requestWatermarkDataImage = new FileReference(requestWatermarkDataImageStream);
        WatermarkDataImage requestWatermarkData = new WatermarkDataImage();
        requestWatermarkData.setImage(requestWatermarkDataImage);
        InsertWatermarkOnlineRequest request = new InsertWatermarkOnlineRequest(requestDocument, (WatermarkDataBase)requestWatermarkData, null, null, null, null, null, null, null);
        InsertWatermarkOnlineResponse result = TestInitializer.wordsApi.insertWatermarkOnline(request);
        TestWatermark.assertNotNull((Object)result);
    }

    @Test
    public void testInsertWatermarkImageDeprecated() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertWatermarkImage.docx";
        String remoteImagePath = this.remoteDataFolder + "/TestInsertWatermarkImage.png";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, "Common/aspose-cloud.png"), remoteImagePath);
        InsertWatermarkImageRequest request = new InsertWatermarkImageRequest(remoteFileName, null, this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null, null, remoteImagePath);
        DocumentResponse result = TestInitializer.wordsApi.insertWatermarkImage(request);
        TestWatermark.assertNotNull((Object)result);
        TestWatermark.assertNotNull((Object)result.getDocument());
        TestWatermark.assertEquals((String)"TestInsertWatermarkImage.docx", (String)result.getDocument().getFileName());
    }

    @Test
    public void testInsertWatermarkImageDeprecatedOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        byte[] requestImageFile = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, "Common/aspose-cloud.png").toAbsolutePath());
        InsertWatermarkImageOnlineRequest request = new InsertWatermarkImageOnlineRequest(requestDocument, requestImageFile, null, null, null, null, null, null, null, null, null);
        InsertWatermarkImageOnlineResponse result = TestInitializer.wordsApi.insertWatermarkImageOnline(request);
        TestWatermark.assertNotNull((Object)result);
    }

    @Test
    public void testInsertWatermarkTextDeprecated() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertWatermarkText.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        WatermarkText requestWatermarkText = new WatermarkText();
        requestWatermarkText.setText("This is the text");
        requestWatermarkText.setRotationAngle(Double.valueOf(90.0));
        InsertWatermarkTextRequest request = new InsertWatermarkTextRequest(remoteFileName, requestWatermarkText, this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        DocumentResponse result = TestInitializer.wordsApi.insertWatermarkText(request);
        TestWatermark.assertNotNull((Object)result);
        TestWatermark.assertNotNull((Object)result.getDocument());
        TestWatermark.assertEquals((String)"TestInsertWatermarkText.docx", (String)result.getDocument().getFileName());
    }

    @Test
    public void testInsertWatermarkTextDeprecatedOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        WatermarkText requestWatermarkText = new WatermarkText();
        requestWatermarkText.setText("This is the text");
        requestWatermarkText.setRotationAngle(Double.valueOf(90.0));
        InsertWatermarkTextOnlineRequest request = new InsertWatermarkTextOnlineRequest(requestDocument, requestWatermarkText, null, null, null, null, null, null, null);
        InsertWatermarkTextOnlineResponse result = TestInitializer.wordsApi.insertWatermarkTextOnline(request);
        TestWatermark.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteWatermark() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteWatermark.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteWatermarkRequest request = new DeleteWatermarkRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        DocumentResponse result = TestInitializer.wordsApi.deleteWatermark(request);
        TestWatermark.assertNotNull((Object)result);
        TestWatermark.assertNotNull((Object)result.getDocument());
        TestWatermark.assertEquals((String)"TestDeleteWatermark.docx", (String)result.getDocument().getFileName());
    }

    @Test
    public void testDeleteWatermarkOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteWatermarkOnlineRequest request = new DeleteWatermarkOnlineRequest(requestDocument, null, null, null, null, null, null, null);
        DeleteWatermarkOnlineResponse result = TestInitializer.wordsApi.deleteWatermarkOnline(request);
        TestWatermark.assertNotNull((Object)result);
    }
}

