/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud;

import com.aspose.words.cloud.ApiCallback;
import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.ApiLoggingInterceptor;
import com.aspose.words.cloud.ApiResponse;
import com.aspose.words.cloud.ChildRequestContent;
import com.aspose.words.cloud.EncryptorFactory;
import com.aspose.words.cloud.JSON;
import com.aspose.words.cloud.Pair;
import com.aspose.words.cloud.ProgressRequestBody;
import com.aspose.words.cloud.StringUtil;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.requests.BatchPartRequest;
import com.aspose.words.cloud.model.requests.RequestIfc;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.internal.http.HttpMethod;
import jakarta.activation.DataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class ApiClient {
    private String apiVersion = "v4.0";
    private String baseUrl = "https://api.aspose.cloud";
    private String basePath = this.baseUrl + "/" + this.apiVersion;
    private String clientVersion = "25.11";
    private boolean debugging = false;
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private String tempFolderPath = null;
    private Integer notAuthCode = 401;
    private Integer badRequestCode = 400;
    private OkHttpClient httpClient = new OkHttpClient();
    private JSON json;
    private Interceptor loggingInterceptor;
    private String accessToken;
    private String refreshToken;
    private String ClientSecret;
    private String clientId;
    private Cipher encryptor;
    private EncryptorFactory encryptorProvider;

    public ApiClient(String clientId, String clientSecret, String baseUrl) {
        this();
        this.clientId = clientId;
        this.ClientSecret = clientSecret;
        if (baseUrl != null) {
            this.setBaseUrl(baseUrl);
        }
    }

    public ApiClient() {
        this.httpClient.setProtocols(Arrays.asList(Protocol.HTTP_1_1));
        this.json = new JSON();
        this.addDefaultHeader("x-aspose-client", "java sdk");
        this.addDefaultHeader("x-aspose-client-version", this.clientVersion);
        this.setConnectTimeout(180);
        this.setReadTimeout(180);
    }

    public EncryptorFactory getEncryptorProvider() {
        return this.encryptorProvider;
    }

    public ApiClient setEncryptorProvider(EncryptorFactory encryptorProvider) {
        this.encryptorProvider = encryptorProvider;
        return this;
    }

    public Integer getNotAuthCode() {
        return this.notAuthCode;
    }

    public Integer getBadRequestCode() {
        return this.badRequestCode;
    }

    public String getClientId() {
        return this.clientId;
    }

    public ApiClient setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getClientSecret() {
        return this.ClientSecret;
    }

    public ApiClient setClientSecret(String clientSecret) {
        this.ClientSecret = clientSecret;
        return this;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public ApiClient setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        this.basePath = baseUrl + "/" + this.apiVersion;
        return this;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        this.baseUrl = basePath.replace("/v1.1", "").replace("/v1", "").replace("/v2", "").replace("/v3", "");
        return this;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public JSON getJSON() {
        return this.json;
    }

    public ApiClient setJSON(JSON json) {
        this.json = json;
        return this;
    }

    public ApiClient setLenientOnJson(boolean lenientOnJson) {
        this.json.setLenientOnJson(lenientOnJson);
        return this;
    }

    public ApiClient setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public ApiClient setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        if (debugging != this.debugging) {
            if (debugging) {
                this.loggingInterceptor = new ApiLoggingInterceptor();
                this.httpClient.interceptors().add(this.loggingInterceptor);
            } else {
                this.httpClient.interceptors().remove(this.loggingInterceptor);
                this.loggingInterceptor = null;
            }
        }
        this.debugging = debugging;
        return this;
    }

    public int getConnectTimeout() {
        return this.httpClient.getConnectTimeout();
    }

    public ApiClient setConnectTimeout(int connectionTimeout) {
        this.httpClient.setConnectTimeout((long)connectionTimeout, TimeUnit.SECONDS);
        return this;
    }

    public int getReadTimeout() {
        return this.httpClient.getReadTimeout();
    }

    public ApiClient setReadTimeout(int readTimeout) {
        this.httpClient.setReadTimeout((long)readTimeout, TimeUnit.SECONDS);
        return this;
    }

    public int getWriteTimeout() {
        return this.httpClient.getWriteTimeout();
    }

    public ApiClient setWriteTimeout(int writeTimeout) {
        this.httpClient.setWriteTimeout((long)writeTimeout, TimeUnit.SECONDS);
        return this;
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date || param instanceof OffsetDateTime || param instanceof LocalDate) {
            String jsonStr = this.json.serialize(param);
            return jsonStr.substring(1, jsonStr.length() - 1);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        if (param instanceof String) {
            return String.valueOf(param);
        }
        return this.json.serialize(param);
    }

    public List<Pair> parameterToPair(String name, Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null || value instanceof Collection) {
            return params;
        }
        params.add(new Pair(name, this.parameterToString(value)));
        return params;
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Collection value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null || value.isEmpty()) {
            return params;
        }
        if ("multi".equals(collectionFormat)) {
            for (Object item : value) {
                params.add(new Pair(name, this.escapeString(this.parameterToString(item))));
            }
            return params;
        }
        String delimiter = ",";
        if ("ssv".equals(collectionFormat)) {
            delimiter = this.escapeString(" ");
        } else if ("tsv".equals(collectionFormat)) {
            delimiter = this.escapeString("\t");
        } else if ("pipes".equals(collectionFormat)) {
            delimiter = this.escapeString("|");
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : value) {
            sb.append(delimiter);
            sb.append(this.escapeString(this.parameterToString(item)));
        }
        params.add(new Pair(name, sb.substring(delimiter.length())));
        return params;
    }

    public String sanitizeFilename(String filename) {
        return filename.replaceAll(".*[/\\\\]", "");
    }

    public boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equals("*/*"));
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0 || contentTypes[0].equals("*/*")) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public <T> T deserialize(Response response, Type returnType) throws ApiException {
        String respBody;
        if (response == null || returnType == null) {
            return null;
        }
        if (returnType.equals(MimeMultipart.class)) {
            try {
                ByteArrayDataSource dataSource = new ByteArrayDataSource(response.body().bytes(), "multipart/mixed");
                return (T)new MimeMultipart((DataSource)dataSource);
            }
            catch (MessagingException | IOException e) {
                throw new ApiException(e);
            }
        }
        if (returnType.equals(byte[].class)) {
            try {
                return (T)response.body().bytes();
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
        }
        try {
            respBody = response.body() != null ? response.body().string() : null;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (respBody == null || "".equals(respBody)) {
            return null;
        }
        String contentType = response.headers().get("Content-Type");
        if (contentType == null) {
            contentType = "application/json";
        }
        if (this.isJsonMime(contentType)) {
            return this.json.deserialize(respBody, returnType);
        }
        if (returnType.equals(String.class)) {
            return (T)respBody;
        }
        throw new ApiException("Content type \"" + contentType + "\" is not supported for type: " + returnType, response.code(), (Map<String, List<String>>)response.headers().toMultimap(), respBody);
    }

    public RequestBody serialize(Object obj) throws ApiException {
        if (obj instanceof RequestBody) {
            return (RequestBody)obj;
        }
        if (obj instanceof byte[]) {
            return RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])((byte[])obj));
        }
        if (obj instanceof ModelIfc) {
            return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.json.serialize(obj));
        }
        if (obj instanceof String) {
            return RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)((String)obj));
        }
        throw new ApiException("Unsupported object type to serialize.");
    }

    public <T> ApiResponse<T> execute(Call call, RequestIfc request) throws ApiException {
        try {
            Response response = call.execute();
            T data = this.handleResponse(request, response);
            return new ApiResponse<T>(response.code(), response.headers().toMultimap(), data);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public <T> void executeAsync(Call call, final RequestIfc request, final ApiCallback<T> callback) {
        call.enqueue(new Callback(){
            final /* synthetic */ ApiClient this$0;
            {
                this.this$0 = this$0;
            }

            public void onFailure(Request request2, IOException e) {
                callback.onFailure(new ApiException(e), 0, null);
            }

            public void onResponse(Response response) throws IOException {
                Object result;
                try {
                    result = this.this$0.handleResponse(request, response);
                }
                catch (ApiException e) {
                    callback.onFailure(e, response.code(), response.headers().toMultimap());
                    return;
                }
                callback.onSuccess(result, response.code(), response.headers().toMultimap());
            }
        });
    }

    public <T> T handleResponse(RequestIfc request, Response response) throws ApiException {
        if (response.isSuccessful()) {
            try {
                return (T)request.deserializeResponse(this, response);
            }
            catch (Exception e) {
                throw new ApiException(e);
            }
        }
        String respBody = null;
        if (response.body() != null) {
            try {
                respBody = response.body().string();
            }
            catch (IOException e) {
                throw new ApiException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
            }
        }
        throw new ApiException(response.message(), response.code(), (Map<String, List<String>>)response.headers().toMultimap(), respBody);
    }

    public Call buildCall(Request request) {
        return this.httpClient.newCall(request);
    }

    public Request buildRequest(String path, String method, List<Pair> queryParams, List<Pair> collectionQueryParams, Map<String, String> headerParams, Map<String, Object> formParams, List<FileReference> filesContentParams, Boolean addAuthHeaders, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, IOException {
        if (addAuthHeaders.booleanValue()) {
            this.addOAuthAuthentication(headerParams);
        }
        RequestBody reqBody = null;
        if (HttpMethod.permitsRequestBody((String)method)) {
            String contentType = headerParams.get("Content-Type");
            int partsCount = formParams.size();
            for (FileReference fileReference : filesContentParams) {
                fileReference.encryptPassword(this);
                if (!"Request".equals(fileReference.getSource())) continue;
                ++partsCount;
            }
            if ("application/x-www-form-urlencoded".equals(contentType)) {
                reqBody = this.buildRequestBodyFormEncoding(formParams);
            } else if (partsCount == 0) {
                if (!"DELETE".equals(method)) {
                    reqBody = RequestBody.create((MediaType)MediaType.parse((String)"none"), (String)"");
                }
            } else if (partsCount == 1) {
                Object part = formParams.values().toArray()[0];
                if (part != null) {
                    reqBody = this.serialize(part);
                }
            } else if (partsCount > 1) {
                String boundary = UUID.randomUUID().toString();
                reqBody = this.buildRequestBodyMultipart(formParams, filesContentParams, boundary);
            }
            if (reqBody != null && reqBody.contentType() != null && !headerParams.containsKey("Content-Type")) {
                headerParams.put("Content-Type", reqBody.contentType().toString());
            }
        }
        String url = this.buildUrl(path, queryParams, collectionQueryParams);
        Request.Builder reqBuilder = new Request.Builder().url(url);
        this.processHeaderParams(headerParams, reqBuilder, addAuthHeaders);
        Request request = null;
        if (progressRequestListener != null && reqBody != null) {
            ProgressRequestBody progressRequestBody = new ProgressRequestBody(reqBody, progressRequestListener);
            request = reqBuilder.method(method, (RequestBody)progressRequestBody).build();
        } else {
            request = reqBuilder.method(method, reqBody).build();
        }
        return request;
    }

    public String buildUrl(String path, List<Pair> queryParams, List<Pair> collectionQueryParams) {
        String value;
        String prefix;
        StringBuilder url = new StringBuilder();
        url.append(this.basePath).append(path);
        if (queryParams != null && !queryParams.isEmpty()) {
            prefix = path.contains("?") ? "&" : "?";
            for (Pair param : queryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(this.escapeString(value));
            }
        }
        if (collectionQueryParams != null && !collectionQueryParams.isEmpty()) {
            prefix = url.toString().contains("?") ? "&" : "?";
            for (Pair param : collectionQueryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(value);
            }
        }
        return url.toString();
    }

    public void processHeaderParams(Map<String, String> headerParams, Request.Builder reqBuilder, Boolean addDefaultHeaders) {
        for (Map.Entry<String, String> param : headerParams.entrySet()) {
            reqBuilder.header(param.getKey(), this.parameterToString(param.getValue()));
        }
        if (addDefaultHeaders.booleanValue()) {
            for (Map.Entry<String, String> header : this.defaultHeaderMap.entrySet()) {
                if (headerParams.containsKey(header.getKey())) continue;
                reqBuilder.header(header.getKey(), this.parameterToString(header.getValue()));
            }
        }
    }

    public RequestBody buildRequestBodyFormEncoding(Map<String, Object> formParams) {
        FormEncodingBuilder formBuilder = new FormEncodingBuilder();
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            formBuilder.add(param.getKey(), this.parameterToString(param.getValue()));
        }
        return formBuilder.build();
    }

    public RequestBody buildRequestBodyMultipart(Map<String, Object> formParams, List<FileReference> fileParams, String boundary) throws IOException, ApiException {
        MultipartBuilder mpBuilder = new MultipartBuilder(boundary).type(MultipartBuilder.FORM);
        if (formParams.isEmpty()) {
            Headers partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data"});
            mpBuilder.addPart(partHeaders, RequestBody.create((MediaType)MediaType.parse((String)"none"), (byte[])new byte[0]));
        } else {
            Headers partHeaders;
            for (Map.Entry<String, Object> param : formParams.entrySet()) {
                partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + param.getKey() + "\""});
                mpBuilder.addPart(partHeaders, this.serialize(param.getValue()));
            }
            for (FileReference fileRef : fileParams) {
                if (!"Request".equals(fileRef.getSource())) continue;
                partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + fileRef.getReference() + "\""});
                mpBuilder.addPart(partHeaders, RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])fileRef.getContent()));
            }
        }
        return mpBuilder.build();
    }

    public String guessContentTypeFromFile(byte[] file) throws IOException {
        String contentType = URLConnection.guessContentTypeFromStream(new ByteArrayInputStream(file));
        if (contentType == null) {
            return "application/octet-stream";
        }
        return contentType;
    }

    public void requestToken() throws ApiException {
        try {
            RequestBody requestBody = new FormEncodingBuilder().addEncoded("grant_type", "client_credentials").addEncoded("client_id", this.getClientId()).addEncoded("client_secret", this.getClientSecret()).build();
            String url = this.baseUrl + "/v4.0/words/connect/token";
            Request request = new Request.Builder().url(url).post(requestBody).addHeader("Content-Type", " application/x-www-form-urlencoded").build();
            Response response = this.httpClient.newCall(request).execute();
            GetAccessTokenResult result = (GetAccessTokenResult)this.json.deserialize(response.body().string(), (Type)((Object)GetAccessTokenResult.class));
            this.setAccessToken(result.access_token);
        }
        catch (Exception ex) {
            throw new ApiException(ex);
        }
    }

    public void addParameterToQuery(List<Pair> queryParams, String paramName, Object paramValue) throws ApiException, IOException {
        if (paramName.equals("password") && paramValue != null && !paramValue.toString().isEmpty()) {
            queryParams.addAll(this.parameterToPair("encryptedPassword", this.encrypt((String)paramValue)));
        } else {
            queryParams.addAll(this.parameterToPair(paramName, paramValue));
        }
    }

    public String addParameterToPath(String path, String paramName, Object paramValue) {
        if (path.contains("{" + paramName + "}")) {
            if (paramValue == null || paramValue.equals("")) {
                return path.replace("{" + paramName + "}", "");
            }
            return path.replace("{" + paramName + "}", paramValue.toString());
        }
        return path;
    }

    public Request buildBatchRequest(BatchPartRequest[] requests, Boolean displayIntermediateResults) throws ApiException, IOException {
        Headers multipartHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data"});
        MultipartBuilder builder = new MultipartBuilder().type(MultipartBuilder.FORM);
        for (BatchPartRequest request : requests) {
            builder.addPart(multipartHeaders, (RequestBody)new ChildRequestContent(this, request, this.basePath + "/words/"));
        }
        RequestBody requestBody = builder.build();
        HashMap<String, String> headers = new HashMap<String, String>();
        HashMap<String, Object> formData = new HashMap<String, Object>();
        formData.put("Body", requestBody);
        String url = "/words/batch";
        if (!displayIntermediateResults.booleanValue()) {
            url = url + "?displayIntermediateResults=false";
        }
        return this.buildRequest(url, "PUT", new ArrayList<Pair>(), new ArrayList<Pair>(), headers, formData, new ArrayList<FileReference>(), true, null);
    }

    public Object parseModel(BodyPart bodyPart, Type returnType) throws IOException, MessagingException {
        int nRead;
        InputStream is = bodyPart.getInputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        try {
            String stringData = buffer.toString("UTF-8");
            return this.json.deserialize(stringData, returnType);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] parseDocument(BodyPart bodyPart) throws IOException, MessagingException {
        int nRead;
        InputStream is = bodyPart.getInputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    public Map<String, byte[]> parseFilesCollection(BodyPart part) throws IOException, MessagingException {
        return this.parseFilesCollection(part.getFileName(), part.getContentType(), this.bodyPartToArray(part).toByteArray());
    }

    public Map<String, byte[]> parseFilesCollection(String filename, String dataType, byte[] data) throws IOException, MessagingException {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        if (dataType.startsWith("multipart/mixed")) {
            ByteArrayDataSource dataSource = new ByteArrayDataSource(data, "multipart/mixed");
            MimeMultipart multipart = new MimeMultipart((DataSource)dataSource);
            for (int i = 0; i < multipart.getCount(); ++i) {
                BodyPart part = multipart.getBodyPart(i);
                result.put(part.getFileName(), this.bodyPartToArray(part).toByteArray());
            }
        } else {
            result.put(filename, data);
        }
        return result;
    }

    public MimeMultipart getMultipartFromResponse(Response response) throws ApiException {
        try {
            ByteArrayDataSource dataSource = new ByteArrayDataSource(response.body().bytes(), "multipart/mixed");
            return new MimeMultipart((DataSource)dataSource);
        }
        catch (MessagingException | IOException e) {
            throw new ApiException(e);
        }
    }

    public ByteArrayOutputStream bodyPartToArray(BodyPart bodyPart) throws MessagingException, IOException {
        int nRead;
        InputStream is = bodyPart.getInputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer;
    }

    public Object parseBatchPart(RequestIfc apiRequest, Request sysRequest, BodyPart bodyPart) throws IOException, MessagingException, ApiException {
        try {
            ByteArrayOutputStream buffer = this.bodyPartToArray(bodyPart);
            String stringData = buffer.toString("UTF-8");
            int lastSplitIndex = stringData.indexOf("\r\n");
            Integer responseCode = Integer.parseInt(stringData.substring(0, lastSplitIndex).split("\\s+")[0]);
            if (responseCode != 200) {
                return new ApiException(responseCode, stringData);
            }
            Headers.Builder headersBuilder = new Headers.Builder();
            while (true) {
                int splitIndex = stringData.indexOf("\r\n", lastSplitIndex + 2);
                String headerStr = stringData.substring(lastSplitIndex + 2, splitIndex);
                lastSplitIndex = splitIndex;
                if (headerStr.isEmpty()) break;
                headersBuilder.add(headerStr);
            }
            ResponseBody responseBody = null;
            Headers headers = headersBuilder.build();
            byte[] rawBody = buffer.toByteArray();
            if (rawBody.length != lastSplitIndex + 2) {
                byte[] responseBytes = new byte[rawBody.length - (lastSplitIndex + 2)];
                System.arraycopy(rawBody, lastSplitIndex + 2, responseBytes, 0, responseBytes.length);
                responseBody = ResponseBody.create((MediaType)MediaType.parse((String)headers.get("Content-Type")), (byte[])responseBytes);
            }
            Response response = new Response.Builder().request(sysRequest).protocol(Protocol.HTTP_1_1).code(responseCode.intValue()).headers(headers).body(responseBody).build();
            return apiRequest.deserializeResponse(this, response);
        }
        catch (Exception e) {
            throw new ApiException(400, "Invalid response format.");
        }
    }

    public String encrypt(String data) throws ApiException, IOException {
        if (data == null || data.isEmpty()) {
            return null;
        }
        if (this.encryptor == null) {
            if (this.encryptorProvider == null) {
                throw new ApiException("Encryption error: EncryptorProvider isn't set.");
            }
            this.encryptor = this.encryptorProvider.create();
        }
        try {
            return Base64.getEncoder().encodeToString(this.encryptor.doFinal(data.toString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new ApiException(e);
        }
    }

    public BodyPart findBodyPartInMultipart(String name, MimeMultipart multipart) throws MessagingException {
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart part = multipart.getBodyPart(i);
            CharSequence[] header = part.getHeader("Content-Disposition");
            header = String.join((CharSequence)";", header).split(";");
            for (int q = 0; q < header.length; ++q) {
                String partName;
                String headerPart = ((String)header[q]).trim();
                if (!headerPart.startsWith("name") || !name.equals(partName = headerPart.split("=")[1].trim().replaceAll("\"", ""))) continue;
                return part;
            }
        }
        return null;
    }

    private void addOAuthAuthentication(Map<String, String> headerParams) throws ApiException {
        if (null == this.accessToken) {
            this.requestToken();
        }
        headerParams.put("Authorization", "Bearer " + this.accessToken);
    }

    private class GetAccessTokenResult {
        public String access_token;

        private GetAccessTokenResult() {
        }
    }
}

