/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud;

import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import okio.Buffer;
import okio.BufferedSink;

public class ApiLoggingInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        long t1 = System.nanoTime();
        System.out.println("Sending request '" + request.url() + "'" + (chain.connection() != null ? " on " + chain.connection() : ""));
        if (request.headers() != null) {
            System.out.println("HEADERS BEGIN\n" + request.headers().toString().trim() + "\nHEADERS END");
        }
        if (request.body() != null) {
            System.out.println("REQUEST BODY BEGIN\n" + ApiLoggingInterceptor.bodyToString(request) + "\nREQUEST BODY END");
        }
        System.out.println();
        Response response = chain.proceed(request);
        ResponseBody responseBody = response.body();
        byte[] responseBodyData = responseBody.bytes();
        Response newResponse = response.newBuilder().body(ResponseBody.create((MediaType)responseBody.contentType(), (byte[])responseBodyData)).build();
        long t2 = System.nanoTime();
        System.out.println("Received response for '" + response.request().url() + "' in " + (double)(t2 - t1) / 1000000.0 + "ms.");
        if (response.headers() != null) {
            System.out.println("HEADERS BEGIN\n" + response.headers().toString().trim() + "\nHEADERS END");
        }
        System.out.println("RESPONSE BODY BEGIN\n" + ApiLoggingInterceptor.formatStringForPrint(responseBodyData) + "\nRESPONSE BODY END");
        System.out.println();
        return newResponse;
    }

    private static String bodyToString(Request request) throws IOException {
        Request copy = request.newBuilder().build();
        Buffer buffer = new Buffer();
        if (copy.body() != null) {
            copy.body().writeTo((BufferedSink)buffer);
        }
        return ApiLoggingInterceptor.formatStringForPrint(buffer.readByteArray());
    }

    private static String formatStringForPrint(byte[] data) {
        if (ApiLoggingInterceptor.hasUnprintableCharacters(data)) {
            StringBuilder sb = new StringBuilder();
            for (byte b : data) {
                sb.append(String.format("%02X ", b));
            }
            return sb.toString();
        }
        return new String(data, StandardCharsets.UTF_8);
    }

    private static boolean hasUnprintableCharacters(byte[] data) {
        for (byte b : data) {
            if (b >= 32 && b <= 126) continue;
            return true;
        }
        return false;
    }
}

