/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.auth;

import com.aspose.words.cloud.Pair;
import com.aspose.words.cloud.auth.Authentication;
import java.util.List;
import java.util.Map;

public class ApiKeyAuth
implements Authentication {
    private final String location;
    private final String paramName;
    private String clientSecret;
    private String clientSecretPrefix;

    public ApiKeyAuth(String location, String paramName) {
        this.location = location;
        this.paramName = paramName;
    }

    public String getLocation() {
        return this.location;
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getClientSecretPrefix() {
        return this.clientSecretPrefix;
    }

    public void setClientSecretPrefix(String clientSecretPrefix) {
        this.clientSecretPrefix = clientSecretPrefix;
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams) {
        if (this.clientSecret == null) {
            return;
        }
        String value = this.clientSecretPrefix != null ? this.clientSecretPrefix + " " + this.clientSecret : this.clientSecret;
        if ("query".equals(this.location)) {
            queryParams.add(new Pair(this.paramName, value));
        } else if ("header".equals(this.location)) {
            headerParams.put(this.paramName, value);
        }
    }
}

