/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.FontInfo;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.WordsResponse;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The REST response with data on system, additional and custom fonts, available for document processing.")
public class AvailableFontsResponse
extends WordsResponse {
    @SerializedName(value="AdditionalFonts")
    protected List<FontInfo> additionalFonts = null;
    @SerializedName(value="CustomFonts")
    protected List<FontInfo> customFonts = null;
    @SerializedName(value="SystemFonts")
    protected List<FontInfo> systemFonts = null;

    @ApiModelProperty(value="Gets or sets the list of additional fonts, provided by Aspose team.")
    public List<FontInfo> getAdditionalFonts() {
        return this.additionalFonts;
    }

    public AvailableFontsResponse additionalFonts(List<FontInfo> additionalFonts) {
        this.additionalFonts = additionalFonts;
        return this;
    }

    public AvailableFontsResponse addAdditionalFontsItem(FontInfo additionalFontsItem) {
        if (this.additionalFonts == null) {
            this.additionalFonts = new ArrayList<FontInfo>();
        }
        this.additionalFonts.add(additionalFontsItem);
        return this;
    }

    public void setAdditionalFonts(List<FontInfo> additionalFonts) {
        this.additionalFonts = additionalFonts;
    }

    @ApiModelProperty(value="Gets or sets the list of custom user fonts from user cloud storage. To use them, you should specify \"fontsLocation\" parameter in any request.")
    public List<FontInfo> getCustomFonts() {
        return this.customFonts;
    }

    public AvailableFontsResponse customFonts(List<FontInfo> customFonts) {
        this.customFonts = customFonts;
        return this;
    }

    public AvailableFontsResponse addCustomFontsItem(FontInfo customFontsItem) {
        if (this.customFonts == null) {
            this.customFonts = new ArrayList<FontInfo>();
        }
        this.customFonts.add(customFontsItem);
        return this;
    }

    public void setCustomFonts(List<FontInfo> customFonts) {
        this.customFonts = customFonts;
    }

    @ApiModelProperty(value="Gets or sets the list of system fonts, available on the server.")
    public List<FontInfo> getSystemFonts() {
        return this.systemFonts;
    }

    public AvailableFontsResponse systemFonts(List<FontInfo> systemFonts) {
        this.systemFonts = systemFonts;
        return this;
    }

    public AvailableFontsResponse addSystemFontsItem(FontInfo systemFontsItem) {
        if (this.systemFonts == null) {
            this.systemFonts = new ArrayList<FontInfo>();
        }
        this.systemFonts.add(systemFontsItem);
        return this;
    }

    public void setSystemFonts(List<FontInfo> systemFonts) {
        this.systemFonts = systemFonts;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.additionalFonts != null) {
            for (ModelIfc modelIfc : this.additionalFonts) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
        if (this.customFonts != null) {
            for (ModelIfc modelIfc : this.customFonts) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
        if (this.systemFonts != null) {
            for (ModelIfc modelIfc : this.systemFonts) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvailableFontsResponse availableFontsResponse = (AvailableFontsResponse)o;
        return Objects.equals(this.additionalFonts, availableFontsResponse.additionalFonts) && Objects.equals(this.customFonts, availableFontsResponse.customFonts) && Objects.equals(this.systemFonts, availableFontsResponse.systemFonts) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.additionalFonts, this.customFonts, this.systemFonts, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AvailableFontsResponse {\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.getRequestId())).append("\n");
        sb.append("    additionalFonts: ").append(this.toIndentedString(this.getAdditionalFonts())).append("\n");
        sb.append("    customFonts: ").append(this.toIndentedString(this.getCustomFonts())).append("\n");
        sb.append("    systemFonts: ").append(this.toIndentedString(this.getSystemFonts())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

