/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.LinkElement;
import com.aspose.words.cloud.model.XmlColor;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a border of an object. Borders can be applied to various document elements including paragraph, run of text inside a paragraph or a table cell.")
public class Border
extends LinkElement {
    @SerializedName(value="BorderType")
    protected BorderTypeEnum borderType = null;
    @SerializedName(value="Color")
    protected XmlColor color = null;
    @SerializedName(value="DistanceFromText")
    protected Double distanceFromText = null;
    @SerializedName(value="LineStyle")
    protected LineStyleEnum lineStyle = null;
    @SerializedName(value="LineWidth")
    protected Double lineWidth = null;
    @SerializedName(value="Shadow")
    protected Boolean shadow = null;

    @ApiModelProperty(value="Gets or sets the border type.")
    public BorderTypeEnum getBorderType() {
        return this.borderType;
    }

    public Border borderType(BorderTypeEnum borderType) {
        this.borderType = borderType;
        return this;
    }

    public void setBorderType(BorderTypeEnum borderType) {
        this.borderType = borderType;
    }

    @ApiModelProperty(value="Gets or sets the border color.")
    public XmlColor getColor() {
        return this.color;
    }

    public Border color(XmlColor color) {
        this.color = color;
        return this;
    }

    public void setColor(XmlColor color) {
        this.color = color;
    }

    @ApiModelProperty(value="Gets or sets the distance of the border from text or from the page edge in points. Has no effect and will be automatically reset to zero for borders of table cells.")
    public Double getDistanceFromText() {
        return this.distanceFromText;
    }

    public Border distanceFromText(Double distanceFromText) {
        this.distanceFromText = distanceFromText;
        return this;
    }

    public void setDistanceFromText(Double distanceFromText) {
        this.distanceFromText = distanceFromText;
    }

    @ApiModelProperty(value="Gets or sets the border style. If you set line style to none, then line width is automatically changed to zero.")
    public LineStyleEnum getLineStyle() {
        return this.lineStyle;
    }

    public Border lineStyle(LineStyleEnum lineStyle) {
        this.lineStyle = lineStyle;
        return this;
    }

    public void setLineStyle(LineStyleEnum lineStyle) {
        this.lineStyle = lineStyle;
    }

    @ApiModelProperty(value="Gets or sets the border width in points. If you set line width greater than zero when line style is none, the line style is automatically changed to single line.")
    public Double getLineWidth() {
        return this.lineWidth;
    }

    public Border lineWidth(Double lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public void setLineWidth(Double lineWidth) {
        this.lineWidth = lineWidth;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the border has a shadow. In Microsoft Word, for a border to have a shadow, the borders on all four sides (left, top, right and bottom) should be of the same type, width, color and all should have the Shadow property set to true.")
    public Boolean getShadow() {
        return this.shadow;
    }

    public Border shadow(Boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public void setShadow(Boolean shadow) {
        this.shadow = shadow;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.color != null) {
            this.color.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Border border = (Border)o;
        return Objects.equals((Object)this.borderType, (Object)border.borderType) && Objects.equals(this.color, border.color) && Objects.equals(this.distanceFromText, border.distanceFromText) && Objects.equals((Object)this.lineStyle, (Object)border.lineStyle) && Objects.equals(this.lineWidth, border.lineWidth) && Objects.equals(this.shadow, border.shadow) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.borderType, this.color, this.distanceFromText, this.lineStyle, this.lineWidth, this.shadow, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Border {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    borderType: ").append(this.toIndentedString((Object)this.getBorderType())).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.getColor())).append("\n");
        sb.append("    distanceFromText: ").append(this.toIndentedString(this.getDistanceFromText())).append("\n");
        sb.append("    lineStyle: ").append(this.toIndentedString((Object)this.getLineStyle())).append("\n");
        sb.append("    lineWidth: ").append(this.toIndentedString(this.getLineWidth())).append("\n");
        sb.append("    shadow: ").append(this.toIndentedString(this.getShadow())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BorderTypeEnum {
        BOTTOM("Bottom"),
        LEFT("Left"),
        RIGHT("Right"),
        TOP("Top"),
        HORIZONTAL("Horizontal"),
        VERTICAL("Vertical"),
        DIAGONALDOWN("DiagonalDown"),
        DIAGONALUP("DiagonalUp"),
        NONE("None");

        private String value;

        private BorderTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BorderTypeEnum fromValue(String text) {
            for (BorderTypeEnum b : BorderTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<BorderTypeEnum> {
            public void write(JsonWriter jsonWriter, BorderTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BorderTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BorderTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LineStyleEnum {
        NONE("None"),
        SINGLE("Single"),
        THICK("Thick"),
        DOUBLE("Double"),
        HAIRLINE("Hairline"),
        DOT("Dot"),
        DASHLARGEGAP("DashLargeGap"),
        DOTDASH("DotDash"),
        DOTDOTDASH("DotDotDash"),
        TRIPLE("Triple"),
        THINTHICKSMALLGAP("ThinThickSmallGap"),
        THICKTHINSMALLGAP("ThickThinSmallGap"),
        THINTHICKTHINSMALLGAP("ThinThickThinSmallGap"),
        THINTHICKMEDIUMGAP("ThinThickMediumGap"),
        THICKTHINMEDIUMGAP("ThickThinMediumGap"),
        THINTHICKTHINMEDIUMGAP("ThinThickThinMediumGap"),
        THINTHICKLARGEGAP("ThinThickLargeGap"),
        THICKTHINLARGEGAP("ThickThinLargeGap"),
        THINTHICKTHINLARGEGAP("ThinThickThinLargeGap"),
        WAVE("Wave"),
        DOUBLEWAVE("DoubleWave"),
        DASHSMALLGAP("DashSmallGap"),
        DASHDOTSTROKER("DashDotStroker"),
        EMBOSS3D("Emboss3D"),
        ENGRAVE3D("Engrave3D"),
        OUTSET("Outset"),
        INSET("Inset");

        private String value;

        private LineStyleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LineStyleEnum fromValue(String text) {
            for (LineStyleEnum b : LineStyleEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LineStyleEnum> {
            public void write(JsonWriter jsonWriter, LineStyleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LineStyleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LineStyleEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

