/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.ClassificationResult;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.WordsResponse;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The REST response with data on multi-class text classification. This response is returned by the Service when handling \"PUT https://api.aspose.cloud/v4.0/words/classify\" REST API requests.")
public class ClassificationResponse
extends WordsResponse {
    @SerializedName(value="BestClassName")
    protected String bestClassName = null;
    @SerializedName(value="BestClassProbability")
    protected Double bestClassProbability = null;
    @SerializedName(value="BestResults")
    protected List<ClassificationResult> bestResults = null;

    @ApiModelProperty(value="Gets or sets the best class name.")
    public String getBestClassName() {
        return this.bestClassName;
    }

    public ClassificationResponse bestClassName(String bestClassName) {
        this.bestClassName = bestClassName;
        return this;
    }

    public void setBestClassName(String bestClassName) {
        this.bestClassName = bestClassName;
    }

    @ApiModelProperty(value="Gets or sets the best class probability.")
    public Double getBestClassProbability() {
        return this.bestClassProbability;
    }

    public ClassificationResponse bestClassProbability(Double bestClassProbability) {
        this.bestClassProbability = bestClassProbability;
        return this;
    }

    public void setBestClassProbability(Double bestClassProbability) {
        this.bestClassProbability = bestClassProbability;
    }

    @ApiModelProperty(value="Gets or sets the array of best classes results.")
    public List<ClassificationResult> getBestResults() {
        return this.bestResults;
    }

    public ClassificationResponse bestResults(List<ClassificationResult> bestResults) {
        this.bestResults = bestResults;
        return this;
    }

    public ClassificationResponse addBestResultsItem(ClassificationResult bestResultsItem) {
        if (this.bestResults == null) {
            this.bestResults = new ArrayList<ClassificationResult>();
        }
        this.bestResults.add(bestResultsItem);
        return this;
    }

    public void setBestResults(List<ClassificationResult> bestResults) {
        this.bestResults = bestResults;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.bestClassProbability == null) {
            throw new ApiException(400, "Property BestClassProbability in ClassificationResponse is required.");
        }
        if (this.bestResults != null) {
            for (ModelIfc modelIfc : this.bestResults) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassificationResponse classificationResponse = (ClassificationResponse)o;
        return Objects.equals(this.bestClassName, classificationResponse.bestClassName) && Objects.equals(this.bestClassProbability, classificationResponse.bestClassProbability) && Objects.equals(this.bestResults, classificationResponse.bestResults) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.bestClassName, this.bestClassProbability, this.bestResults, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClassificationResponse {\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.getRequestId())).append("\n");
        sb.append("    bestClassName: ").append(this.toIndentedString(this.getBestClassName())).append("\n");
        sb.append("    bestClassProbability: ").append(this.toIndentedString(this.getBestClassProbability())).append("\n");
        sb.append("    bestResults: ").append(this.toIndentedString(this.getBestResults())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

