/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a single classification result.")
public class ClassificationResult
implements ModelIfc {
    @SerializedName(value="ClassName")
    protected String className = null;
    @SerializedName(value="ClassProbability")
    protected Double classProbability = null;

    @ApiModelProperty(value="Gets or sets the name of the class.")
    public String getClassName() {
        return this.className;
    }

    public ClassificationResult className(String className) {
        this.className = className;
        return this;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @ApiModelProperty(value="Gets or sets the probability of class.")
    public Double getClassProbability() {
        return this.classProbability;
    }

    public ClassificationResult classProbability(Double classProbability) {
        this.classProbability = classProbability;
        return this;
    }

    public void setClassProbability(Double classProbability) {
        this.classProbability = classProbability;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.classProbability == null) {
            throw new ApiException(400, "Property ClassProbability in ClassificationResult is required.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassificationResult classificationResult = (ClassificationResult)o;
        return Objects.equals(this.className, classificationResult.className) && Objects.equals(this.classProbability, classificationResult.classProbability);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.classProbability);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClassificationResult {\n");
        sb.append("    className: ").append(this.toIndentedString(this.getClassName())).append("\n");
        sb.append("    classProbability: ").append(this.toIndentedString(this.getClassProbability())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

