/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents options for parsing CSV data. To learn more, visit the LINQ Reporting Engine documentation article. An instance of this class can be passed into constructors of CsvDataSource.")
public class CsvDataLoadOptions
implements ModelIfc {
    @SerializedName(value="CommentChar")
    protected String commentChar = null;
    @SerializedName(value="Delimiter")
    protected String delimiter = null;
    @SerializedName(value="HasHeaders")
    protected Boolean hasHeaders = null;
    @SerializedName(value="QuoteChar")
    protected String quoteChar = null;

    @ApiModelProperty(value="Gets or sets the character that is used to comment lines of CSV data. The default value is '#' (number sign).")
    public String getCommentChar() {
        return this.commentChar;
    }

    public CsvDataLoadOptions commentChar(String commentChar) {
        this.commentChar = commentChar;
        return this;
    }

    public void setCommentChar(String commentChar) {
        this.commentChar = commentChar;
    }

    @ApiModelProperty(value="Gets or sets the character to be used as a column delimiter. The default value is ',' (comma).")
    public String getDelimiter() {
        return this.delimiter;
    }

    public CsvDataLoadOptions delimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the first record of CSV data contains column names. The default value is false.")
    public Boolean getHasHeaders() {
        return this.hasHeaders;
    }

    public CsvDataLoadOptions hasHeaders(Boolean hasHeaders) {
        this.hasHeaders = hasHeaders;
        return this;
    }

    public void setHasHeaders(Boolean hasHeaders) {
        this.hasHeaders = hasHeaders;
    }

    @ApiModelProperty(value="Gets or sets the character that is used to quote field values. The default value is '\"' (quotation mark).Double the character to place it into quoted text.")
    public String getQuoteChar() {
        return this.quoteChar;
    }

    public CsvDataLoadOptions quoteChar(String quoteChar) {
        this.quoteChar = quoteChar;
        return this;
    }

    public void setQuoteChar(String quoteChar) {
        this.quoteChar = quoteChar;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.commentChar == null) {
            throw new ApiException(400, "Property CommentChar in CsvDataLoadOptions is required.");
        }
        if (this.delimiter == null) {
            throw new ApiException(400, "Property Delimiter in CsvDataLoadOptions is required.");
        }
        if (this.hasHeaders == null) {
            throw new ApiException(400, "Property HasHeaders in CsvDataLoadOptions is required.");
        }
        if (this.quoteChar == null) {
            throw new ApiException(400, "Property QuoteChar in CsvDataLoadOptions is required.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CsvDataLoadOptions csvDataLoadOptions = (CsvDataLoadOptions)o;
        return Objects.equals(this.commentChar, csvDataLoadOptions.commentChar) && Objects.equals(this.delimiter, csvDataLoadOptions.delimiter) && Objects.equals(this.hasHeaders, csvDataLoadOptions.hasHeaders) && Objects.equals(this.quoteChar, csvDataLoadOptions.quoteChar);
    }

    public int hashCode() {
        return Objects.hash(this.commentChar, this.delimiter, this.hasHeaders, this.quoteChar);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CsvDataLoadOptions {\n");
        sb.append("    commentChar: ").append(this.toIndentedString(this.getCommentChar())).append("\n");
        sb.append("    delimiter: ").append(this.toIndentedString(this.getDelimiter())).append("\n");
        sb.append("    hasHeaders: ").append(this.toIndentedString(this.getHasHeaders())).append("\n");
        sb.append("    quoteChar: ").append(this.toIndentedString(this.getQuoteChar())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

