/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.DocumentProperties;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.Link;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents Words document DTO.")
public class Document
implements ModelIfc {
    @SerializedName(value="Links")
    protected List<Link> links = null;
    @SerializedName(value="DocumentProperties")
    protected DocumentProperties documentProperties = null;
    @SerializedName(value="FileName")
    protected String fileName = null;
    @SerializedName(value="IsEncrypted")
    protected Boolean isEncrypted = null;
    @SerializedName(value="IsSigned")
    protected Boolean isSigned = null;
    @SerializedName(value="SourceFormat")
    protected SourceFormatEnum sourceFormat = null;

    @ApiModelProperty(value="Gets or sets the list of links that originate from this document.")
    public List<Link> getLinks() {
        return this.links;
    }

    public Document links(List<Link> links) {
        this.links = links;
        return this;
    }

    public Document addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    @ApiModelProperty(value="Gets or sets the document properties.")
    public DocumentProperties getDocumentProperties() {
        return this.documentProperties;
    }

    public Document documentProperties(DocumentProperties documentProperties) {
        this.documentProperties = documentProperties;
        return this;
    }

    public void setDocumentProperties(DocumentProperties documentProperties) {
        this.documentProperties = documentProperties;
    }

    @ApiModelProperty(value="Gets or sets the name of the file.")
    public String getFileName() {
        return this.fileName;
    }

    public Document fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the document is encrypted and requires a password to open.")
    public Boolean getIsEncrypted() {
        return this.isEncrypted;
    }

    public Document isEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
        return this;
    }

    public void setIsEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the document contains a digital signature. This property merely informs that a digital signature is present on a document, but it does not specify whether the signature is valid or not.")
    public Boolean getIsSigned() {
        return this.isSigned;
    }

    public Document isSigned(Boolean isSigned) {
        this.isSigned = isSigned;
        return this;
    }

    public void setIsSigned(Boolean isSigned) {
        this.isSigned = isSigned;
    }

    @ApiModelProperty(value="Gets or sets the original format of the document.")
    public SourceFormatEnum getSourceFormat() {
        return this.sourceFormat;
    }

    public Document sourceFormat(SourceFormatEnum sourceFormat) {
        this.sourceFormat = sourceFormat;
        return this;
    }

    public void setSourceFormat(SourceFormatEnum sourceFormat) {
        this.sourceFormat = sourceFormat;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.isEncrypted == null) {
            throw new ApiException(400, "Property IsEncrypted in Document is required.");
        }
        if (this.isSigned == null) {
            throw new ApiException(400, "Property IsSigned in Document is required.");
        }
        if (this.sourceFormat == null) {
            throw new ApiException(400, "Property SourceFormat in Document is required.");
        }
        if (this.links != null) {
            for (ModelIfc modelIfc : this.links) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
        if (this.documentProperties != null) {
            this.documentProperties.validate();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document)o;
        return Objects.equals(this.links, document.links) && Objects.equals(this.documentProperties, document.documentProperties) && Objects.equals(this.fileName, document.fileName) && Objects.equals(this.isEncrypted, document.isEncrypted) && Objects.equals(this.isSigned, document.isSigned) && Objects.equals((Object)this.sourceFormat, (Object)document.sourceFormat);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.links, this.documentProperties, this.fileName, this.isEncrypted, this.isSigned, this.sourceFormat});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Document {\n");
        sb.append("    links: ").append(this.toIndentedString(this.getLinks())).append("\n");
        sb.append("    documentProperties: ").append(this.toIndentedString(this.getDocumentProperties())).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.getFileName())).append("\n");
        sb.append("    isEncrypted: ").append(this.toIndentedString(this.getIsEncrypted())).append("\n");
        sb.append("    isSigned: ").append(this.toIndentedString(this.getIsSigned())).append("\n");
        sb.append("    sourceFormat: ").append(this.toIndentedString((Object)this.getSourceFormat())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SourceFormatEnum {
        UNKNOWN("Unknown"),
        DOC("Doc"),
        DOT("Dot"),
        DOCPREWORD60("DocPreWord60"),
        DOCX("Docx"),
        DOCM("Docm"),
        DOTX("Dotx"),
        DOTM("Dotm"),
        FLATOPC("FlatOpc"),
        RTF("Rtf"),
        WORDML("WordML"),
        HTML("Html"),
        MHTML("Mhtml"),
        EPUB("Epub"),
        TEXT("Text"),
        ODT("Odt"),
        OTT("Ott"),
        PDF("Pdf"),
        XPS("Xps"),
        TIFF("Tiff"),
        SVG("Svg"),
        AZW3("Azw3");

        private String value;

        private SourceFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SourceFormatEnum fromValue(String text) {
            for (SourceFormatEnum b : SourceFormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SourceFormatEnum> {
            public void write(JsonWriter jsonWriter, SourceFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SourceFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SourceFormatEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

