/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container class for Downsample options.")
public class DownsampleOptionsData
implements ModelIfc {
    @SerializedName(value="DownsampleImages")
    protected Boolean downsampleImages = null;
    @SerializedName(value="Resolution")
    protected Integer resolution = null;
    @SerializedName(value="ResolutionThreshold")
    protected Integer resolutionThreshold = null;

    @ApiModelProperty(value="Gets or sets a value indicating whether images should be downsampled. The default value is true.")
    public Boolean getDownsampleImages() {
        return this.downsampleImages;
    }

    public DownsampleOptionsData downsampleImages(Boolean downsampleImages) {
        this.downsampleImages = downsampleImages;
        return this;
    }

    public void setDownsampleImages(Boolean downsampleImages) {
        this.downsampleImages = downsampleImages;
    }

    @ApiModelProperty(value="Gets or sets the resolution in pixels per inch which the images should be downsampled to. The default value is 220 ppi.")
    public Integer getResolution() {
        return this.resolution;
    }

    public DownsampleOptionsData resolution(Integer resolution) {
        this.resolution = resolution;
        return this;
    }

    public void setResolution(Integer resolution) {
        this.resolution = resolution;
    }

    @ApiModelProperty(value="Gets or sets the threshold resolution in pixels per inch. If resolution of an image in the document is less than threshold value, the downsampling algorithm will not be applied. A value of 0 means the threshold check is not used and all images that can be reduced in size are downsampled. The default value is 0.")
    public Integer getResolutionThreshold() {
        return this.resolutionThreshold;
    }

    public DownsampleOptionsData resolutionThreshold(Integer resolutionThreshold) {
        this.resolutionThreshold = resolutionThreshold;
        return this;
    }

    public void setResolutionThreshold(Integer resolutionThreshold) {
        this.resolutionThreshold = resolutionThreshold;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownsampleOptionsData downsampleOptionsData = (DownsampleOptionsData)o;
        return Objects.equals(this.downsampleImages, downsampleOptionsData.downsampleImages) && Objects.equals(this.resolution, downsampleOptionsData.resolution) && Objects.equals(this.resolutionThreshold, downsampleOptionsData.resolutionThreshold);
    }

    public int hashCode() {
        return Objects.hash(this.downsampleImages, this.resolution, this.resolutionThreshold);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DownsampleOptionsData {\n");
        sb.append("    downsampleImages: ").append(this.toIndentedString(this.getDownsampleImages())).append("\n");
        sb.append("    resolution: ").append(this.toIndentedString(this.getResolution())).append("\n");
        sb.append("    resolutionThreshold: ").append(this.toIndentedString(this.getResolutionThreshold())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

