/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiClient;
import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.UUID;

@ApiModel(description="File content special model.")
public class FileReference
implements ModelIfc {
    @SerializedName(value="Source")
    private String source;
    @SerializedName(value="Reference")
    private String reference;
    @SerializedName(value="Password")
    private String password;
    @SerializedName(value="EncryptedPassword")
    private String encryptedPassword;
    private transient byte[] content;

    @ApiModelProperty(value="Gets file source.")
    public String getSource() {
        return this.source;
    }

    @ApiModelProperty(value="Gets file reference.")
    public String getReference() {
        return this.reference;
    }

    public byte[] getContent() {
        return this.content;
    }

    public FileReference(String remoteFilePath) {
        this.source = "Storage";
        this.reference = remoteFilePath;
        this.content = null;
    }

    public FileReference(byte[] localFileContent) {
        this.source = "Request";
        this.reference = UUID.randomUUID().toString();
        this.content = localFileContent;
    }

    public FileReference(String remoteFilePath, String password) {
        this.source = "Storage";
        this.reference = remoteFilePath;
        this.content = null;
        this.password = password;
    }

    public FileReference(byte[] localFileContent, String password) {
        this.source = "Request";
        this.reference = UUID.randomUUID().toString();
        this.content = localFileContent;
        this.password = password;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
        resultFilesContent.add(this);
    }

    @Override
    public void validate() throws ApiException {
    }

    public void encryptPassword(ApiClient apiClient) throws ApiException, IOException {
        if (this.password != null) {
            this.encryptedPassword = apiClient.encrypt(this.password);
            this.password = null;
        }
    }
}

