/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.MetafileRenderingOptionsData;
import com.aspose.words.cloud.model.SaveOptionsData;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Contains common options that can be specified when saving a document into fixed page formats (PDF, XPS, images etc).")
public abstract class FixedPageSaveOptionsData
extends SaveOptionsData {
    @SerializedName(value="ColorMode")
    protected ColorModeEnum colorMode = null;
    @SerializedName(value="JpegQuality")
    protected Integer jpegQuality = null;
    @SerializedName(value="MetafileRenderingOptions")
    protected MetafileRenderingOptionsData metafileRenderingOptions = null;
    @SerializedName(value="NumeralFormat")
    protected NumeralFormatEnum numeralFormat = null;
    @SerializedName(value="OptimizeOutput")
    protected Boolean optimizeOutput = null;
    @SerializedName(value="PageCount")
    protected Integer pageCount = null;
    @SerializedName(value="PageIndex")
    protected Integer pageIndex = null;

    @ApiModelProperty(value="Gets or sets the value determining how colors are rendered. { Normal | Grayscale}. The default value is Normal. This property is used when the document is exported to fixed page formats.")
    public ColorModeEnum getColorMode() {
        return this.colorMode;
    }

    public FixedPageSaveOptionsData colorMode(ColorModeEnum colorMode) {
        this.colorMode = colorMode;
        return this;
    }

    public void setColorMode(ColorModeEnum colorMode) {
        this.colorMode = colorMode;
    }

    @ApiModelProperty(value="Gets or sets the quality of the JPEG images inside PDF document.")
    public Integer getJpegQuality() {
        return this.jpegQuality;
    }

    public FixedPageSaveOptionsData jpegQuality(Integer jpegQuality) {
        this.jpegQuality = jpegQuality;
        return this;
    }

    public void setJpegQuality(Integer jpegQuality) {
        this.jpegQuality = jpegQuality;
    }

    @ApiModelProperty(value="Gets or sets the metafile rendering options.")
    public MetafileRenderingOptionsData getMetafileRenderingOptions() {
        return this.metafileRenderingOptions;
    }

    public FixedPageSaveOptionsData metafileRenderingOptions(MetafileRenderingOptionsData metafileRenderingOptions) {
        this.metafileRenderingOptions = metafileRenderingOptions;
        return this;
    }

    public void setMetafileRenderingOptions(MetafileRenderingOptionsData metafileRenderingOptions) {
        this.metafileRenderingOptions = metafileRenderingOptions;
    }

    @ApiModelProperty(value="Gets or sets the symbol set, that is used to represent numbers while rendering to fixed page formats.")
    public NumeralFormatEnum getNumeralFormat() {
        return this.numeralFormat;
    }

    public FixedPageSaveOptionsData numeralFormat(NumeralFormatEnum numeralFormat) {
        this.numeralFormat = numeralFormat;
        return this;
    }

    public void setNumeralFormat(NumeralFormatEnum numeralFormat) {
        this.numeralFormat = numeralFormat;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether it is required to optimize output of XPS. If this flag is set redundant nested canvases and empty canvases are removed, also neighbor glyphs with the same formatting are concatenated. Note: The accuracy of the content display may be affected if this property is set to true.. The default value is false.")
    public Boolean getOptimizeOutput() {
        return this.optimizeOutput;
    }

    public FixedPageSaveOptionsData optimizeOutput(Boolean optimizeOutput) {
        this.optimizeOutput = optimizeOutput;
        return this;
    }

    public void setOptimizeOutput(Boolean optimizeOutput) {
        this.optimizeOutput = optimizeOutput;
    }

    @ApiModelProperty(value="Gets or sets the number of pages to render.")
    public Integer getPageCount() {
        return this.pageCount;
    }

    public FixedPageSaveOptionsData pageCount(Integer pageCount) {
        this.pageCount = pageCount;
        return this;
    }

    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    @ApiModelProperty(value="Gets or sets the 0-based index of the first page to render.")
    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public FixedPageSaveOptionsData pageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
        return this;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.metafileRenderingOptions != null) {
            this.metafileRenderingOptions.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedPageSaveOptionsData fixedPageSaveOptionsData = (FixedPageSaveOptionsData)o;
        return Objects.equals((Object)this.colorMode, (Object)fixedPageSaveOptionsData.colorMode) && Objects.equals(this.jpegQuality, fixedPageSaveOptionsData.jpegQuality) && Objects.equals(this.metafileRenderingOptions, fixedPageSaveOptionsData.metafileRenderingOptions) && Objects.equals((Object)this.numeralFormat, (Object)fixedPageSaveOptionsData.numeralFormat) && Objects.equals(this.optimizeOutput, fixedPageSaveOptionsData.optimizeOutput) && Objects.equals(this.pageCount, fixedPageSaveOptionsData.pageCount) && Objects.equals(this.pageIndex, fixedPageSaveOptionsData.pageIndex) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.colorMode, this.jpegQuality, this.metafileRenderingOptions, this.numeralFormat, this.optimizeOutput, this.pageCount, this.pageIndex, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FixedPageSaveOptionsData {\n");
        sb.append("    allowEmbeddingPostScriptFonts: ").append(this.toIndentedString(this.getAllowEmbeddingPostScriptFonts())).append("\n");
        sb.append("    customTimeZoneInfoData: ").append(this.toIndentedString(this.getCustomTimeZoneInfoData())).append("\n");
        sb.append("    dml3DEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDml3DEffectsRenderingMode())).append("\n");
        sb.append("    dmlEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDmlEffectsRenderingMode())).append("\n");
        sb.append("    dmlRenderingMode: ").append(this.toIndentedString((Object)this.getDmlRenderingMode())).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.getFileName())).append("\n");
        sb.append("    imlRenderingMode: ").append(this.toIndentedString((Object)this.getImlRenderingMode())).append("\n");
        sb.append("    updateAmbiguousTextFont: ").append(this.toIndentedString(this.getUpdateAmbiguousTextFont())).append("\n");
        sb.append("    updateCreatedTimeProperty: ").append(this.toIndentedString(this.getUpdateCreatedTimeProperty())).append("\n");
        sb.append("    updateFields: ").append(this.toIndentedString(this.getUpdateFields())).append("\n");
        sb.append("    updateLastPrintedProperty: ").append(this.toIndentedString(this.getUpdateLastPrintedProperty())).append("\n");
        sb.append("    updateLastSavedTimeProperty: ").append(this.toIndentedString(this.getUpdateLastSavedTimeProperty())).append("\n");
        sb.append("    zipOutput: ").append(this.toIndentedString(this.getZipOutput())).append("\n");
        sb.append("    saveFormat: ").append(this.toIndentedString(this.getSaveFormat())).append("\n");
        sb.append("    colorMode: ").append(this.toIndentedString((Object)this.getColorMode())).append("\n");
        sb.append("    jpegQuality: ").append(this.toIndentedString(this.getJpegQuality())).append("\n");
        sb.append("    metafileRenderingOptions: ").append(this.toIndentedString(this.getMetafileRenderingOptions())).append("\n");
        sb.append("    numeralFormat: ").append(this.toIndentedString((Object)this.getNumeralFormat())).append("\n");
        sb.append("    optimizeOutput: ").append(this.toIndentedString(this.getOptimizeOutput())).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.getPageCount())).append("\n");
        sb.append("    pageIndex: ").append(this.toIndentedString(this.getPageIndex())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ColorModeEnum {
        NORMAL("Normal"),
        GRAYSCALE("Grayscale");

        private String value;

        private ColorModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ColorModeEnum fromValue(String text) {
            for (ColorModeEnum b : ColorModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ColorModeEnum> {
            public void write(JsonWriter jsonWriter, ColorModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ColorModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ColorModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum NumeralFormatEnum {
        EUROPEAN("European"),
        ARABICINDIC("ArabicIndic"),
        EASTERNARABICINDIC("EasternArabicIndic"),
        CONTEXT("Context"),
        SYSTEM("System");

        private String value;

        private NumeralFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static NumeralFormatEnum fromValue(String text) {
            for (NumeralFormatEnum b : NumeralFormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<NumeralFormatEnum> {
            public void write(JsonWriter jsonWriter, NumeralFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public NumeralFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return NumeralFormatEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

