/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.Footnote;
import com.aspose.words.cloud.model.LinkElement;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with a collection of footnotes.")
public class FootnoteCollection
extends LinkElement {
    @SerializedName(value="List")
    protected List<Footnote> list = null;

    @ApiModelProperty(value="Gets or sets the collection of footnotes.")
    public List<Footnote> getList() {
        return this.list;
    }

    public FootnoteCollection list(List<Footnote> list) {
        this.list = list;
        return this;
    }

    public FootnoteCollection addListItem(Footnote listItem) {
        if (this.list == null) {
            this.list = new ArrayList<Footnote>();
        }
        this.list.add(listItem);
        return this;
    }

    public void setList(List<Footnote> list) {
        this.list = list;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.list != null) {
            for (ModelIfc modelIfc : this.list) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FootnoteCollection footnoteCollection = (FootnoteCollection)o;
        return Objects.equals(this.list, footnoteCollection.list) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.list, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FootnoteCollection {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    list: ").append(this.toIndentedString(this.getList())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

