/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.NodeLink;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="FromField.")
public abstract class FormField
extends NodeLink {
    @SerializedName(value="Name")
    protected String name = null;
    @SerializedName(value="Enabled")
    protected Boolean enabled = null;
    @SerializedName(value="StatusText")
    protected String statusText = null;
    @SerializedName(value="OwnStatus")
    protected Boolean ownStatus = null;
    @SerializedName(value="HelpText")
    protected String helpText = null;
    @SerializedName(value="OwnHelp")
    protected Boolean ownHelp = null;
    @SerializedName(value="CalculateOnExit")
    protected Boolean calculateOnExit = null;
    @SerializedName(value="EntryMacro")
    protected String entryMacro = null;
    @SerializedName(value="ExitMacro")
    protected String exitMacro = null;

    @ApiModelProperty(value="Gets or sets the form field name.")
    public String getName() {
        return this.name;
    }

    public FormField name(String name) {
        this.name = name;
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether a form field is enabled. If a form field is enabled, its contents can be changed as the form is filled in.")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public FormField enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @ApiModelProperty(value="Gets or sets text, displayed in the status bar when a form field has the focus. If the OwnStatus property is set to true, the StatusText property specifies the status bar text. If the OwnStatus property is set to false, the StatusText property specifies the name of an AutoText entry that contains status bar text for the form field.")
    public String getStatusText() {
        return this.statusText;
    }

    public FormField statusText(String statusText) {
        this.statusText = statusText;
        return this;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the source of the text that's displayed in the status bar when a form field has the focus. If true, the text specified by the StatusText property is displayed. If false, the text of the AutoText entry specified by the StatusText property is displayed.")
    public Boolean getOwnStatus() {
        return this.ownStatus;
    }

    public FormField ownStatus(Boolean ownStatus) {
        this.ownStatus = ownStatus;
        return this;
    }

    public void setOwnStatus(Boolean ownStatus) {
        this.ownStatus = ownStatus;
    }

    @ApiModelProperty(value="Gets or sets text, displayed in a message box when the form field has the focus and the user presses F1. If the OwnHelp property is set to True, HelpText specifies the text string value. If OwnHelp is set to False, HelpText specifies the name of an AutoText entry that contains help text for the form field.")
    public String getHelpText() {
        return this.helpText;
    }

    public FormField helpText(String helpText) {
        this.helpText = helpText;
        return this;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the source of the text that's displayed in a message box when a form field has the focus and the user presses F1. If true, the text specified by the HelpText property is displayed. If False, the text in the AutoText entry specified by the HelpText property is displayed.")
    public Boolean getOwnHelp() {
        return this.ownHelp;
    }

    public FormField ownHelp(Boolean ownHelp) {
        this.ownHelp = ownHelp;
        return this;
    }

    public void setOwnHelp(Boolean ownHelp) {
        this.ownHelp = ownHelp;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether references to the specified form field are automatically updated whenever the field is exited. Setting CalculateOnExit only affects the behavior of the form field when the document is opened in Microsoft Word. Aspose.Words never updates references to the form field.")
    public Boolean getCalculateOnExit() {
        return this.calculateOnExit;
    }

    public FormField calculateOnExit(Boolean calculateOnExit) {
        this.calculateOnExit = calculateOnExit;
        return this;
    }

    public void setCalculateOnExit(Boolean calculateOnExit) {
        this.calculateOnExit = calculateOnExit;
    }

    @ApiModelProperty(value="Gets or sets the entry macro name for the form field. The entry macro runs when the form field gets the focus in Microsoft Word.")
    public String getEntryMacro() {
        return this.entryMacro;
    }

    public FormField entryMacro(String entryMacro) {
        this.entryMacro = entryMacro;
        return this;
    }

    public void setEntryMacro(String entryMacro) {
        this.entryMacro = entryMacro;
    }

    @ApiModelProperty(value="Gets or sets the exit macro name for the form field. The exit macro runs when the form field loses the focus in Microsoft Word.")
    public String getExitMacro() {
        return this.exitMacro;
    }

    public FormField exitMacro(String exitMacro) {
        this.exitMacro = exitMacro;
        return this;
    }

    public void setExitMacro(String exitMacro) {
        this.exitMacro = exitMacro;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.name == null) {
            throw new ApiException(400, "Property Name in FormField is required.");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormField formField = (FormField)o;
        return Objects.equals(this.name, formField.name) && Objects.equals(this.enabled, formField.enabled) && Objects.equals(this.statusText, formField.statusText) && Objects.equals(this.ownStatus, formField.ownStatus) && Objects.equals(this.helpText, formField.helpText) && Objects.equals(this.ownHelp, formField.ownHelp) && Objects.equals(this.calculateOnExit, formField.calculateOnExit) && Objects.equals(this.entryMacro, formField.entryMacro) && Objects.equals(this.exitMacro, formField.exitMacro) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.enabled, this.statusText, this.ownStatus, this.helpText, this.ownHelp, this.calculateOnExit, this.entryMacro, this.exitMacro, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormField {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.getNodeId())).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.getName())).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.getEnabled())).append("\n");
        sb.append("    statusText: ").append(this.toIndentedString(this.getStatusText())).append("\n");
        sb.append("    ownStatus: ").append(this.toIndentedString(this.getOwnStatus())).append("\n");
        sb.append("    helpText: ").append(this.toIndentedString(this.getHelpText())).append("\n");
        sb.append("    ownHelp: ").append(this.toIndentedString(this.getOwnHelp())).append("\n");
        sb.append("    calculateOnExit: ").append(this.toIndentedString(this.getCalculateOnExit())).append("\n");
        sb.append("    entryMacro: ").append(this.toIndentedString(this.getEntryMacro())).append("\n");
        sb.append("    exitMacro: ").append(this.toIndentedString(this.getExitMacro())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

