/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.SaveOptionsData;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container class for html save options.")
public class HtmlSaveOptionsData
extends SaveOptionsData {
    @SerializedName(value="AllowNegativeIndent")
    protected Boolean allowNegativeIndent = null;
    @SerializedName(value="CssClassNamePrefix")
    protected String cssClassNamePrefix = null;
    @SerializedName(value="CssStyleSheetFileName")
    protected String cssStyleSheetFileName = null;
    @SerializedName(value="CssStyleSheetType")
    protected CssStyleSheetTypeEnum cssStyleSheetType = null;
    @SerializedName(value="DocumentSplitCriteria")
    protected DocumentSplitCriteriaEnum documentSplitCriteria = null;
    @SerializedName(value="DocumentSplitHeadingLevel")
    protected Integer documentSplitHeadingLevel = null;
    @SerializedName(value="Encoding")
    protected String encoding = null;
    @SerializedName(value="ExportDocumentProperties")
    protected Boolean exportDocumentProperties = null;
    @SerializedName(value="ExportDropDownFormFieldAsText")
    protected Boolean exportDropDownFormFieldAsText = null;
    @SerializedName(value="ExportFontResources")
    protected Boolean exportFontResources = null;
    @SerializedName(value="ExportFontsAsBase64")
    protected Boolean exportFontsAsBase64 = null;
    @SerializedName(value="ExportHeadersFootersMode")
    protected ExportHeadersFootersModeEnum exportHeadersFootersMode = null;
    @SerializedName(value="ExportImagesAsBase64")
    protected Boolean exportImagesAsBase64 = null;
    @SerializedName(value="ExportLanguageInformation")
    protected Boolean exportLanguageInformation = null;
    @SerializedName(value="ExportListLabels")
    protected ExportListLabelsEnum exportListLabels = null;
    @SerializedName(value="ExportOriginalUrlForLinkedImages")
    protected Boolean exportOriginalUrlForLinkedImages = null;
    @SerializedName(value="ExportPageMargins")
    protected Boolean exportPageMargins = null;
    @SerializedName(value="ExportPageSetup")
    protected Boolean exportPageSetup = null;
    @SerializedName(value="ExportRelativeFontSize")
    protected Boolean exportRelativeFontSize = null;
    @SerializedName(value="ExportRoundtripInformation")
    protected Boolean exportRoundtripInformation = null;
    @SerializedName(value="ExportTextInputFormFieldAsText")
    protected Boolean exportTextInputFormFieldAsText = null;
    @SerializedName(value="ExportTocPageNumbers")
    protected Boolean exportTocPageNumbers = null;
    @SerializedName(value="ExportXhtmlTransitional")
    protected Boolean exportXhtmlTransitional = null;
    @SerializedName(value="FontResourcesSubsettingSizeThreshold")
    protected Integer fontResourcesSubsettingSizeThreshold = null;
    @SerializedName(value="FontsFolder")
    protected String fontsFolder = null;
    @SerializedName(value="FontsFolderAlias")
    protected String fontsFolderAlias = null;
    @SerializedName(value="HtmlVersion")
    protected HtmlVersionEnum htmlVersion = null;
    @SerializedName(value="ImageResolution")
    protected Integer imageResolution = null;
    @SerializedName(value="ImagesFolder")
    protected String imagesFolder = null;
    @SerializedName(value="ImagesFolderAlias")
    protected String imagesFolderAlias = null;
    @SerializedName(value="MetafileFormat")
    protected MetafileFormatEnum metafileFormat = null;
    @SerializedName(value="OfficeMathOutputMode")
    protected OfficeMathOutputModeEnum officeMathOutputMode = null;
    @SerializedName(value="PrettyFormat")
    protected Boolean prettyFormat = null;
    @SerializedName(value="RemoveJavaScriptFromLinks")
    protected Boolean removeJavaScriptFromLinks = null;
    @SerializedName(value="ReplaceBackslashWithYenSign")
    protected Boolean replaceBackslashWithYenSign = null;
    @SerializedName(value="ResolveFontNames")
    protected Boolean resolveFontNames = null;
    @SerializedName(value="ResourceFolder")
    protected String resourceFolder = null;
    @SerializedName(value="ResourceFolderAlias")
    protected String resourceFolderAlias = null;
    @SerializedName(value="ScaleImageToShapeSize")
    protected Boolean scaleImageToShapeSize = null;
    @SerializedName(value="TableWidthOutputMode")
    protected TableWidthOutputModeEnum tableWidthOutputMode = null;

    @ApiModelProperty(value="Gets or sets a value indicating whether negative left and right indents of paragraphs are allowed (not normalized).")
    public Boolean getAllowNegativeIndent() {
        return this.allowNegativeIndent;
    }

    public HtmlSaveOptionsData allowNegativeIndent(Boolean allowNegativeIndent) {
        this.allowNegativeIndent = allowNegativeIndent;
        return this;
    }

    public void setAllowNegativeIndent(Boolean allowNegativeIndent) {
        this.allowNegativeIndent = allowNegativeIndent;
    }

    @ApiModelProperty(value="Gets or sets the prefix which is added to all CSS class names. The default value is an empty string and generated CSS class names have no common prefix. If this value is not empty, all CSS classes generated by Aspose.Words will start with the specified prefix.This might be useful, for example, if you add custom CSS to generated documents and want to prevent class name conflicts. If the value is not null or empty, it must be a valid CSS identifier.")
    public String getCssClassNamePrefix() {
        return this.cssClassNamePrefix;
    }

    public HtmlSaveOptionsData cssClassNamePrefix(String cssClassNamePrefix) {
        this.cssClassNamePrefix = cssClassNamePrefix;
        return this;
    }

    public void setCssClassNamePrefix(String cssClassNamePrefix) {
        this.cssClassNamePrefix = cssClassNamePrefix;
    }

    @ApiModelProperty(value="Gets or sets the name of the CSS file written when the document is exported to HTML.")
    public String getCssStyleSheetFileName() {
        return this.cssStyleSheetFileName;
    }

    public HtmlSaveOptionsData cssStyleSheetFileName(String cssStyleSheetFileName) {
        this.cssStyleSheetFileName = cssStyleSheetFileName;
        return this;
    }

    public void setCssStyleSheetFileName(String cssStyleSheetFileName) {
        this.cssStyleSheetFileName = cssStyleSheetFileName;
    }

    @ApiModelProperty(value="Gets or sets the option that controls how the CSS styles are exported.")
    public CssStyleSheetTypeEnum getCssStyleSheetType() {
        return this.cssStyleSheetType;
    }

    public HtmlSaveOptionsData cssStyleSheetType(CssStyleSheetTypeEnum cssStyleSheetType) {
        this.cssStyleSheetType = cssStyleSheetType;
        return this;
    }

    public void setCssStyleSheetType(CssStyleSheetTypeEnum cssStyleSheetType) {
        this.cssStyleSheetType = cssStyleSheetType;
    }

    @ApiModelProperty(value="Gets or sets the option that controls how the document should be split when saving.")
    public DocumentSplitCriteriaEnum getDocumentSplitCriteria() {
        return this.documentSplitCriteria;
    }

    public HtmlSaveOptionsData documentSplitCriteria(DocumentSplitCriteriaEnum documentSplitCriteria) {
        this.documentSplitCriteria = documentSplitCriteria;
        return this;
    }

    public void setDocumentSplitCriteria(DocumentSplitCriteriaEnum documentSplitCriteria) {
        this.documentSplitCriteria = documentSplitCriteria;
    }

    @ApiModelProperty(value="Gets or sets the maximum level of headings at which to split the document.")
    public Integer getDocumentSplitHeadingLevel() {
        return this.documentSplitHeadingLevel;
    }

    public HtmlSaveOptionsData documentSplitHeadingLevel(Integer documentSplitHeadingLevel) {
        this.documentSplitHeadingLevel = documentSplitHeadingLevel;
        return this;
    }

    public void setDocumentSplitHeadingLevel(Integer documentSplitHeadingLevel) {
        this.documentSplitHeadingLevel = documentSplitHeadingLevel;
    }

    @ApiModelProperty(value="Gets or sets the character encoding to use when exporting.")
    public String getEncoding() {
        return this.encoding;
    }

    public HtmlSaveOptionsData encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to export built-in and custom document properties.")
    public Boolean getExportDocumentProperties() {
        return this.exportDocumentProperties;
    }

    public HtmlSaveOptionsData exportDocumentProperties(Boolean exportDocumentProperties) {
        this.exportDocumentProperties = exportDocumentProperties;
        return this;
    }

    public void setExportDocumentProperties(Boolean exportDocumentProperties) {
        this.exportDocumentProperties = exportDocumentProperties;
    }

    @ApiModelProperty(value="Gets or sets the flag, that controls how drop-down form fields are saved to HTML. The default value is false. When set to true, exports drop-down form fields as normal text. When false, exports drop-down form fields as SELECT element in HTML.")
    public Boolean getExportDropDownFormFieldAsText() {
        return this.exportDropDownFormFieldAsText;
    }

    public HtmlSaveOptionsData exportDropDownFormFieldAsText(Boolean exportDropDownFormFieldAsText) {
        this.exportDropDownFormFieldAsText = exportDropDownFormFieldAsText;
        return this;
    }

    public void setExportDropDownFormFieldAsText(Boolean exportDropDownFormFieldAsText) {
        this.exportDropDownFormFieldAsText = exportDropDownFormFieldAsText;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether font resources should be exported.")
    public Boolean getExportFontResources() {
        return this.exportFontResources;
    }

    public HtmlSaveOptionsData exportFontResources(Boolean exportFontResources) {
        this.exportFontResources = exportFontResources;
        return this;
    }

    public void setExportFontResources(Boolean exportFontResources) {
        this.exportFontResources = exportFontResources;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether fonts resources should be embedded to HTML in Base64 encoding. The default value is false.")
    public Boolean getExportFontsAsBase64() {
        return this.exportFontsAsBase64;
    }

    public HtmlSaveOptionsData exportFontsAsBase64(Boolean exportFontsAsBase64) {
        this.exportFontsAsBase64 = exportFontsAsBase64;
        return this;
    }

    public void setExportFontsAsBase64(Boolean exportFontsAsBase64) {
        this.exportFontsAsBase64 = exportFontsAsBase64;
    }

    @ApiModelProperty(value="Gets or sets the option that controls how headers and footers are exported.")
    public ExportHeadersFootersModeEnum getExportHeadersFootersMode() {
        return this.exportHeadersFootersMode;
    }

    public HtmlSaveOptionsData exportHeadersFootersMode(ExportHeadersFootersModeEnum exportHeadersFootersMode) {
        this.exportHeadersFootersMode = exportHeadersFootersMode;
        return this;
    }

    public void setExportHeadersFootersMode(ExportHeadersFootersModeEnum exportHeadersFootersMode) {
        this.exportHeadersFootersMode = exportHeadersFootersMode;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether images are saved in Base64 format.")
    public Boolean getExportImagesAsBase64() {
        return this.exportImagesAsBase64;
    }

    public HtmlSaveOptionsData exportImagesAsBase64(Boolean exportImagesAsBase64) {
        this.exportImagesAsBase64 = exportImagesAsBase64;
        return this;
    }

    public void setExportImagesAsBase64(Boolean exportImagesAsBase64) {
        this.exportImagesAsBase64 = exportImagesAsBase64;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether language information is exported.")
    public Boolean getExportLanguageInformation() {
        return this.exportLanguageInformation;
    }

    public HtmlSaveOptionsData exportLanguageInformation(Boolean exportLanguageInformation) {
        this.exportLanguageInformation = exportLanguageInformation;
        return this;
    }

    public void setExportLanguageInformation(Boolean exportLanguageInformation) {
        this.exportLanguageInformation = exportLanguageInformation;
    }

    @ApiModelProperty(value="Gets or sets the option that controls how list labels are exported.")
    public ExportListLabelsEnum getExportListLabels() {
        return this.exportListLabels;
    }

    public HtmlSaveOptionsData exportListLabels(ExportListLabelsEnum exportListLabels) {
        this.exportListLabels = exportListLabels;
        return this;
    }

    public void setExportListLabels(ExportListLabelsEnum exportListLabels) {
        this.exportListLabels = exportListLabels;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the original URL should be used as the URL of the linked images. The default value is false. If value is set to true - ResourceFolder value is used as the URL of linked images and linked images are not loaded into document's folder or ImagesFolder.If value is set to false - linked images are loaded into document's folder or ImagesFolder and URL of each linked image is constructed depending on document's folder, ImagesFolder and ImagesFolderAlias properties.")
    public Boolean getExportOriginalUrlForLinkedImages() {
        return this.exportOriginalUrlForLinkedImages;
    }

    public HtmlSaveOptionsData exportOriginalUrlForLinkedImages(Boolean exportOriginalUrlForLinkedImages) {
        this.exportOriginalUrlForLinkedImages = exportOriginalUrlForLinkedImages;
        return this;
    }

    public void setExportOriginalUrlForLinkedImages(Boolean exportOriginalUrlForLinkedImages) {
        this.exportOriginalUrlForLinkedImages = exportOriginalUrlForLinkedImages;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether page margins are exported to HTML, MHTML or EPUB. The default value is false. Aspose.Words does not show the area of page margins by default. If any elements are completely or partially clipped by the document edge the displayed area can be extended with this option.")
    public Boolean getExportPageMargins() {
        return this.exportPageMargins;
    }

    public HtmlSaveOptionsData exportPageMargins(Boolean exportPageMargins) {
        this.exportPageMargins = exportPageMargins;
        return this;
    }

    public void setExportPageMargins(Boolean exportPageMargins) {
        this.exportPageMargins = exportPageMargins;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether page setup is exported.")
    public Boolean getExportPageSetup() {
        return this.exportPageSetup;
    }

    public HtmlSaveOptionsData exportPageSetup(Boolean exportPageSetup) {
        this.exportPageSetup = exportPageSetup;
        return this;
    }

    public void setExportPageSetup(Boolean exportPageSetup) {
        this.exportPageSetup = exportPageSetup;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether font sizes should be output in relative units when saving.")
    public Boolean getExportRelativeFontSize() {
        return this.exportRelativeFontSize;
    }

    public HtmlSaveOptionsData exportRelativeFontSize(Boolean exportRelativeFontSize) {
        this.exportRelativeFontSize = exportRelativeFontSize;
        return this;
    }

    public void setExportRelativeFontSize(Boolean exportRelativeFontSize) {
        this.exportRelativeFontSize = exportRelativeFontSize;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to write the roundtrip information when saving to HTML. The default value is true. Saving of the roundtrip information allows to restore document properties such as tab stops, comments, headers and footers during the HTML documents loading back into a Document object.When true, the roundtrip information is exported as -aw-* CSS properties of the corresponding HTML elements.When false, causes no roundtrip information to be output into produced files.")
    public Boolean getExportRoundtripInformation() {
        return this.exportRoundtripInformation;
    }

    public HtmlSaveOptionsData exportRoundtripInformation(Boolean exportRoundtripInformation) {
        this.exportRoundtripInformation = exportRoundtripInformation;
        return this;
    }

    public void setExportRoundtripInformation(Boolean exportRoundtripInformation) {
        this.exportRoundtripInformation = exportRoundtripInformation;
    }

    @ApiModelProperty(value="Gets or sets the flag, that controls how text input form fields are saved.")
    public Boolean getExportTextInputFormFieldAsText() {
        return this.exportTextInputFormFieldAsText;
    }

    public HtmlSaveOptionsData exportTextInputFormFieldAsText(Boolean exportTextInputFormFieldAsText) {
        this.exportTextInputFormFieldAsText = exportTextInputFormFieldAsText;
        return this;
    }

    public void setExportTextInputFormFieldAsText(Boolean exportTextInputFormFieldAsText) {
        this.exportTextInputFormFieldAsText = exportTextInputFormFieldAsText;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to write page numbers to table of contents when saving.")
    public Boolean getExportTocPageNumbers() {
        return this.exportTocPageNumbers;
    }

    public HtmlSaveOptionsData exportTocPageNumbers(Boolean exportTocPageNumbers) {
        this.exportTocPageNumbers = exportTocPageNumbers;
        return this;
    }

    public void setExportTocPageNumbers(Boolean exportTocPageNumbers) {
        this.exportTocPageNumbers = exportTocPageNumbers;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to write the DOCTYPE declaration when saving.")
    public Boolean getExportXhtmlTransitional() {
        return this.exportXhtmlTransitional;
    }

    public HtmlSaveOptionsData exportXhtmlTransitional(Boolean exportXhtmlTransitional) {
        this.exportXhtmlTransitional = exportXhtmlTransitional;
        return this;
    }

    public void setExportXhtmlTransitional(Boolean exportXhtmlTransitional) {
        this.exportXhtmlTransitional = exportXhtmlTransitional;
    }

    @ApiModelProperty(value="Gets or sets the option that controls which font resources need subsetting when saving.")
    public Integer getFontResourcesSubsettingSizeThreshold() {
        return this.fontResourcesSubsettingSizeThreshold;
    }

    public HtmlSaveOptionsData fontResourcesSubsettingSizeThreshold(Integer fontResourcesSubsettingSizeThreshold) {
        this.fontResourcesSubsettingSizeThreshold = fontResourcesSubsettingSizeThreshold;
        return this;
    }

    public void setFontResourcesSubsettingSizeThreshold(Integer fontResourcesSubsettingSizeThreshold) {
        this.fontResourcesSubsettingSizeThreshold = fontResourcesSubsettingSizeThreshold;
    }

    @ApiModelProperty(value="Gets or sets the physical folder where fonts are saved when exporting a document.")
    public String getFontsFolder() {
        return this.fontsFolder;
    }

    public HtmlSaveOptionsData fontsFolder(String fontsFolder) {
        this.fontsFolder = fontsFolder;
        return this;
    }

    public void setFontsFolder(String fontsFolder) {
        this.fontsFolder = fontsFolder;
    }

    @ApiModelProperty(value="Gets or sets the name of the folder used to construct font URIs.")
    public String getFontsFolderAlias() {
        return this.fontsFolderAlias;
    }

    public HtmlSaveOptionsData fontsFolderAlias(String fontsFolderAlias) {
        this.fontsFolderAlias = fontsFolderAlias;
        return this;
    }

    public void setFontsFolderAlias(String fontsFolderAlias) {
        this.fontsFolderAlias = fontsFolderAlias;
    }

    @ApiModelProperty(value="Gets or sets the version of HTML standard, that should be used when saving the document to HTML or MHTML. The default value is Aspose.Words.Saving.HtmlVersion.Xhtml.")
    public HtmlVersionEnum getHtmlVersion() {
        return this.htmlVersion;
    }

    public HtmlSaveOptionsData htmlVersion(HtmlVersionEnum htmlVersion) {
        this.htmlVersion = htmlVersion;
        return this;
    }

    public void setHtmlVersion(HtmlVersionEnum htmlVersion) {
        this.htmlVersion = htmlVersion;
    }

    @ApiModelProperty(value="Gets or sets the output resolution for images when exporting.")
    public Integer getImageResolution() {
        return this.imageResolution;
    }

    public HtmlSaveOptionsData imageResolution(Integer imageResolution) {
        this.imageResolution = imageResolution;
        return this;
    }

    public void setImageResolution(Integer imageResolution) {
        this.imageResolution = imageResolution;
    }

    @ApiModelProperty(value="Gets or sets the physical folder where images are saved when exporting a document.")
    public String getImagesFolder() {
        return this.imagesFolder;
    }

    public HtmlSaveOptionsData imagesFolder(String imagesFolder) {
        this.imagesFolder = imagesFolder;
        return this;
    }

    public void setImagesFolder(String imagesFolder) {
        this.imagesFolder = imagesFolder;
    }

    @ApiModelProperty(value="Gets or sets the name of the folder used to construct image URIs.")
    public String getImagesFolderAlias() {
        return this.imagesFolderAlias;
    }

    public HtmlSaveOptionsData imagesFolderAlias(String imagesFolderAlias) {
        this.imagesFolderAlias = imagesFolderAlias;
        return this;
    }

    public void setImagesFolderAlias(String imagesFolderAlias) {
        this.imagesFolderAlias = imagesFolderAlias;
    }

    @ApiModelProperty(value="Gets or sets the options, that controls in what format metafiles are saved when exporting to HTML, MHTML, or EPUB. The default value is Aspose.Words.Saving.HtmlMetafileFormat.Png, meaning that metafiles are rendered to raster PNG images. Metafiles are not natively displayed by HTML browsers. By default, Aspose.Words converts WMF and EMF images into PNG files when exporting to HTML.Other options are to convert metafiles to SVG images or to export them as is without conversion. Some image transforms, in particular image cropping, will not be applied to metafile images if they are exported to HTML without conversion.")
    public MetafileFormatEnum getMetafileFormat() {
        return this.metafileFormat;
    }

    public HtmlSaveOptionsData metafileFormat(MetafileFormatEnum metafileFormat) {
        this.metafileFormat = metafileFormat;
        return this;
    }

    public void setMetafileFormat(MetafileFormatEnum metafileFormat) {
        this.metafileFormat = metafileFormat;
    }

    @ApiModelProperty(value="Gets or sets the option that controls how OfficeMath objects are exported to HTML, MHTML or EPUB. The default value is HtmlOfficeMathOutputMode.Image.")
    public OfficeMathOutputModeEnum getOfficeMathOutputMode() {
        return this.officeMathOutputMode;
    }

    public HtmlSaveOptionsData officeMathOutputMode(OfficeMathOutputModeEnum officeMathOutputMode) {
        this.officeMathOutputMode = officeMathOutputMode;
        return this;
    }

    public void setOfficeMathOutputMode(OfficeMathOutputModeEnum officeMathOutputMode) {
        this.officeMathOutputMode = officeMathOutputMode;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to use pretty formats output.")
    public Boolean getPrettyFormat() {
        return this.prettyFormat;
    }

    public HtmlSaveOptionsData prettyFormat(Boolean prettyFormat) {
        this.prettyFormat = prettyFormat;
        return this;
    }

    public void setPrettyFormat(Boolean prettyFormat) {
        this.prettyFormat = prettyFormat;
    }

    @ApiModelProperty(value="Gets or sets the flag that indicates whether JavaScript will be removed from links. Default is false. If this option is enabled, all links containing JavaScript (e.g., links with \"javascript:\" in the href attribute) will be replaced with \"javascript:void(0)\". This can help prevent potential security risks, such as XSS attacks.")
    public Boolean getRemoveJavaScriptFromLinks() {
        return this.removeJavaScriptFromLinks;
    }

    public HtmlSaveOptionsData removeJavaScriptFromLinks(Boolean removeJavaScriptFromLinks) {
        this.removeJavaScriptFromLinks = removeJavaScriptFromLinks;
        return this;
    }

    public void setRemoveJavaScriptFromLinks(Boolean removeJavaScriptFromLinks) {
        this.removeJavaScriptFromLinks = removeJavaScriptFromLinks;
    }

    @ApiModelProperty(value="Gets or sets the flag that indicates whether backslash characters should be replaced with yen signs. The default value is false. By default, Aspose.Words mimics MS Word's behavior and doesn't replace backslash characters with yen signs in generated HTML documents. However, previous versions of Aspose.Words performed such replacements in certain scenarios. This flag enables backward compatibility with previous versions of Aspose.Words.")
    public Boolean getReplaceBackslashWithYenSign() {
        return this.replaceBackslashWithYenSign;
    }

    public HtmlSaveOptionsData replaceBackslashWithYenSign(Boolean replaceBackslashWithYenSign) {
        this.replaceBackslashWithYenSign = replaceBackslashWithYenSign;
        return this;
    }

    public void setReplaceBackslashWithYenSign(Boolean replaceBackslashWithYenSign) {
        this.replaceBackslashWithYenSign = replaceBackslashWithYenSign;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether font family names used in the document are resolved and substituted according to FontSettings when being written into HTML-based formats. The default value is false.")
    public Boolean getResolveFontNames() {
        return this.resolveFontNames;
    }

    public HtmlSaveOptionsData resolveFontNames(Boolean resolveFontNames) {
        this.resolveFontNames = resolveFontNames;
        return this;
    }

    public void setResolveFontNames(Boolean resolveFontNames) {
        this.resolveFontNames = resolveFontNames;
    }

    @ApiModelProperty(value="Gets or sets the physical folder where all resources like images, fonts, and external CSS are saved when a document is exported to HTML. The default value is an empty string.")
    public String getResourceFolder() {
        return this.resourceFolder;
    }

    public HtmlSaveOptionsData resourceFolder(String resourceFolder) {
        this.resourceFolder = resourceFolder;
        return this;
    }

    public void setResourceFolder(String resourceFolder) {
        this.resourceFolder = resourceFolder;
    }

    @ApiModelProperty(value="Gets or sets the name of the folder used to construct URIs of all resources written into HTML document. The default value is an empty string.")
    public String getResourceFolderAlias() {
        return this.resourceFolderAlias;
    }

    public HtmlSaveOptionsData resourceFolderAlias(String resourceFolderAlias) {
        this.resourceFolderAlias = resourceFolderAlias;
        return this;
    }

    public void setResourceFolderAlias(String resourceFolderAlias) {
        this.resourceFolderAlias = resourceFolderAlias;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether images are scaled by Aspose.Words to the bounding shape size when exporting.")
    public Boolean getScaleImageToShapeSize() {
        return this.scaleImageToShapeSize;
    }

    public HtmlSaveOptionsData scaleImageToShapeSize(Boolean scaleImageToShapeSize) {
        this.scaleImageToShapeSize = scaleImageToShapeSize;
        return this;
    }

    public void setScaleImageToShapeSize(Boolean scaleImageToShapeSize) {
        this.scaleImageToShapeSize = scaleImageToShapeSize;
    }

    @ApiModelProperty(value="Gets or sets the option that controls how table, row and cell widths are exported.")
    public TableWidthOutputModeEnum getTableWidthOutputMode() {
        return this.tableWidthOutputMode;
    }

    public HtmlSaveOptionsData tableWidthOutputMode(TableWidthOutputModeEnum tableWidthOutputMode) {
        this.tableWidthOutputMode = tableWidthOutputMode;
        return this;
    }

    public void setTableWidthOutputMode(TableWidthOutputModeEnum tableWidthOutputMode) {
        this.tableWidthOutputMode = tableWidthOutputMode;
    }

    public HtmlSaveOptionsData() {
        this.saveFormat = "html";
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HtmlSaveOptionsData htmlSaveOptionsData = (HtmlSaveOptionsData)o;
        return Objects.equals(this.allowNegativeIndent, htmlSaveOptionsData.allowNegativeIndent) && Objects.equals(this.cssClassNamePrefix, htmlSaveOptionsData.cssClassNamePrefix) && Objects.equals(this.cssStyleSheetFileName, htmlSaveOptionsData.cssStyleSheetFileName) && Objects.equals((Object)this.cssStyleSheetType, (Object)htmlSaveOptionsData.cssStyleSheetType) && Objects.equals((Object)this.documentSplitCriteria, (Object)htmlSaveOptionsData.documentSplitCriteria) && Objects.equals(this.documentSplitHeadingLevel, htmlSaveOptionsData.documentSplitHeadingLevel) && Objects.equals(this.encoding, htmlSaveOptionsData.encoding) && Objects.equals(this.exportDocumentProperties, htmlSaveOptionsData.exportDocumentProperties) && Objects.equals(this.exportDropDownFormFieldAsText, htmlSaveOptionsData.exportDropDownFormFieldAsText) && Objects.equals(this.exportFontResources, htmlSaveOptionsData.exportFontResources) && Objects.equals(this.exportFontsAsBase64, htmlSaveOptionsData.exportFontsAsBase64) && Objects.equals((Object)this.exportHeadersFootersMode, (Object)htmlSaveOptionsData.exportHeadersFootersMode) && Objects.equals(this.exportImagesAsBase64, htmlSaveOptionsData.exportImagesAsBase64) && Objects.equals(this.exportLanguageInformation, htmlSaveOptionsData.exportLanguageInformation) && Objects.equals((Object)this.exportListLabels, (Object)htmlSaveOptionsData.exportListLabels) && Objects.equals(this.exportOriginalUrlForLinkedImages, htmlSaveOptionsData.exportOriginalUrlForLinkedImages) && Objects.equals(this.exportPageMargins, htmlSaveOptionsData.exportPageMargins) && Objects.equals(this.exportPageSetup, htmlSaveOptionsData.exportPageSetup) && Objects.equals(this.exportRelativeFontSize, htmlSaveOptionsData.exportRelativeFontSize) && Objects.equals(this.exportRoundtripInformation, htmlSaveOptionsData.exportRoundtripInformation) && Objects.equals(this.exportTextInputFormFieldAsText, htmlSaveOptionsData.exportTextInputFormFieldAsText) && Objects.equals(this.exportTocPageNumbers, htmlSaveOptionsData.exportTocPageNumbers) && Objects.equals(this.exportXhtmlTransitional, htmlSaveOptionsData.exportXhtmlTransitional) && Objects.equals(this.fontResourcesSubsettingSizeThreshold, htmlSaveOptionsData.fontResourcesSubsettingSizeThreshold) && Objects.equals(this.fontsFolder, htmlSaveOptionsData.fontsFolder) && Objects.equals(this.fontsFolderAlias, htmlSaveOptionsData.fontsFolderAlias) && Objects.equals((Object)this.htmlVersion, (Object)htmlSaveOptionsData.htmlVersion) && Objects.equals(this.imageResolution, htmlSaveOptionsData.imageResolution) && Objects.equals(this.imagesFolder, htmlSaveOptionsData.imagesFolder) && Objects.equals(this.imagesFolderAlias, htmlSaveOptionsData.imagesFolderAlias) && Objects.equals((Object)this.metafileFormat, (Object)htmlSaveOptionsData.metafileFormat) && Objects.equals((Object)this.officeMathOutputMode, (Object)htmlSaveOptionsData.officeMathOutputMode) && Objects.equals(this.prettyFormat, htmlSaveOptionsData.prettyFormat) && Objects.equals(this.removeJavaScriptFromLinks, htmlSaveOptionsData.removeJavaScriptFromLinks) && Objects.equals(this.replaceBackslashWithYenSign, htmlSaveOptionsData.replaceBackslashWithYenSign) && Objects.equals(this.resolveFontNames, htmlSaveOptionsData.resolveFontNames) && Objects.equals(this.resourceFolder, htmlSaveOptionsData.resourceFolder) && Objects.equals(this.resourceFolderAlias, htmlSaveOptionsData.resourceFolderAlias) && Objects.equals(this.scaleImageToShapeSize, htmlSaveOptionsData.scaleImageToShapeSize) && Objects.equals((Object)this.tableWidthOutputMode, (Object)htmlSaveOptionsData.tableWidthOutputMode) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.allowNegativeIndent, this.cssClassNamePrefix, this.cssStyleSheetFileName, this.cssStyleSheetType, this.documentSplitCriteria, this.documentSplitHeadingLevel, this.encoding, this.exportDocumentProperties, this.exportDropDownFormFieldAsText, this.exportFontResources, this.exportFontsAsBase64, this.exportHeadersFootersMode, this.exportImagesAsBase64, this.exportLanguageInformation, this.exportListLabels, this.exportOriginalUrlForLinkedImages, this.exportPageMargins, this.exportPageSetup, this.exportRelativeFontSize, this.exportRoundtripInformation, this.exportTextInputFormFieldAsText, this.exportTocPageNumbers, this.exportXhtmlTransitional, this.fontResourcesSubsettingSizeThreshold, this.fontsFolder, this.fontsFolderAlias, this.htmlVersion, this.imageResolution, this.imagesFolder, this.imagesFolderAlias, this.metafileFormat, this.officeMathOutputMode, this.prettyFormat, this.removeJavaScriptFromLinks, this.replaceBackslashWithYenSign, this.resolveFontNames, this.resourceFolder, this.resourceFolderAlias, this.scaleImageToShapeSize, this.tableWidthOutputMode, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HtmlSaveOptionsData {\n");
        sb.append("    allowEmbeddingPostScriptFonts: ").append(this.toIndentedString(this.getAllowEmbeddingPostScriptFonts())).append("\n");
        sb.append("    customTimeZoneInfoData: ").append(this.toIndentedString(this.getCustomTimeZoneInfoData())).append("\n");
        sb.append("    dml3DEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDml3DEffectsRenderingMode())).append("\n");
        sb.append("    dmlEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDmlEffectsRenderingMode())).append("\n");
        sb.append("    dmlRenderingMode: ").append(this.toIndentedString((Object)this.getDmlRenderingMode())).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.getFileName())).append("\n");
        sb.append("    imlRenderingMode: ").append(this.toIndentedString((Object)this.getImlRenderingMode())).append("\n");
        sb.append("    updateAmbiguousTextFont: ").append(this.toIndentedString(this.getUpdateAmbiguousTextFont())).append("\n");
        sb.append("    updateCreatedTimeProperty: ").append(this.toIndentedString(this.getUpdateCreatedTimeProperty())).append("\n");
        sb.append("    updateFields: ").append(this.toIndentedString(this.getUpdateFields())).append("\n");
        sb.append("    updateLastPrintedProperty: ").append(this.toIndentedString(this.getUpdateLastPrintedProperty())).append("\n");
        sb.append("    updateLastSavedTimeProperty: ").append(this.toIndentedString(this.getUpdateLastSavedTimeProperty())).append("\n");
        sb.append("    zipOutput: ").append(this.toIndentedString(this.getZipOutput())).append("\n");
        sb.append("    allowNegativeIndent: ").append(this.toIndentedString(this.getAllowNegativeIndent())).append("\n");
        sb.append("    cssClassNamePrefix: ").append(this.toIndentedString(this.getCssClassNamePrefix())).append("\n");
        sb.append("    cssStyleSheetFileName: ").append(this.toIndentedString(this.getCssStyleSheetFileName())).append("\n");
        sb.append("    cssStyleSheetType: ").append(this.toIndentedString((Object)this.getCssStyleSheetType())).append("\n");
        sb.append("    documentSplitCriteria: ").append(this.toIndentedString((Object)this.getDocumentSplitCriteria())).append("\n");
        sb.append("    documentSplitHeadingLevel: ").append(this.toIndentedString(this.getDocumentSplitHeadingLevel())).append("\n");
        sb.append("    encoding: ").append(this.toIndentedString(this.getEncoding())).append("\n");
        sb.append("    exportDocumentProperties: ").append(this.toIndentedString(this.getExportDocumentProperties())).append("\n");
        sb.append("    exportDropDownFormFieldAsText: ").append(this.toIndentedString(this.getExportDropDownFormFieldAsText())).append("\n");
        sb.append("    exportFontResources: ").append(this.toIndentedString(this.getExportFontResources())).append("\n");
        sb.append("    exportFontsAsBase64: ").append(this.toIndentedString(this.getExportFontsAsBase64())).append("\n");
        sb.append("    exportHeadersFootersMode: ").append(this.toIndentedString((Object)this.getExportHeadersFootersMode())).append("\n");
        sb.append("    exportImagesAsBase64: ").append(this.toIndentedString(this.getExportImagesAsBase64())).append("\n");
        sb.append("    exportLanguageInformation: ").append(this.toIndentedString(this.getExportLanguageInformation())).append("\n");
        sb.append("    exportListLabels: ").append(this.toIndentedString((Object)this.getExportListLabels())).append("\n");
        sb.append("    exportOriginalUrlForLinkedImages: ").append(this.toIndentedString(this.getExportOriginalUrlForLinkedImages())).append("\n");
        sb.append("    exportPageMargins: ").append(this.toIndentedString(this.getExportPageMargins())).append("\n");
        sb.append("    exportPageSetup: ").append(this.toIndentedString(this.getExportPageSetup())).append("\n");
        sb.append("    exportRelativeFontSize: ").append(this.toIndentedString(this.getExportRelativeFontSize())).append("\n");
        sb.append("    exportRoundtripInformation: ").append(this.toIndentedString(this.getExportRoundtripInformation())).append("\n");
        sb.append("    exportTextInputFormFieldAsText: ").append(this.toIndentedString(this.getExportTextInputFormFieldAsText())).append("\n");
        sb.append("    exportTocPageNumbers: ").append(this.toIndentedString(this.getExportTocPageNumbers())).append("\n");
        sb.append("    exportXhtmlTransitional: ").append(this.toIndentedString(this.getExportXhtmlTransitional())).append("\n");
        sb.append("    fontResourcesSubsettingSizeThreshold: ").append(this.toIndentedString(this.getFontResourcesSubsettingSizeThreshold())).append("\n");
        sb.append("    fontsFolder: ").append(this.toIndentedString(this.getFontsFolder())).append("\n");
        sb.append("    fontsFolderAlias: ").append(this.toIndentedString(this.getFontsFolderAlias())).append("\n");
        sb.append("    htmlVersion: ").append(this.toIndentedString((Object)this.getHtmlVersion())).append("\n");
        sb.append("    imageResolution: ").append(this.toIndentedString(this.getImageResolution())).append("\n");
        sb.append("    imagesFolder: ").append(this.toIndentedString(this.getImagesFolder())).append("\n");
        sb.append("    imagesFolderAlias: ").append(this.toIndentedString(this.getImagesFolderAlias())).append("\n");
        sb.append("    metafileFormat: ").append(this.toIndentedString((Object)this.getMetafileFormat())).append("\n");
        sb.append("    officeMathOutputMode: ").append(this.toIndentedString((Object)this.getOfficeMathOutputMode())).append("\n");
        sb.append("    prettyFormat: ").append(this.toIndentedString(this.getPrettyFormat())).append("\n");
        sb.append("    removeJavaScriptFromLinks: ").append(this.toIndentedString(this.getRemoveJavaScriptFromLinks())).append("\n");
        sb.append("    replaceBackslashWithYenSign: ").append(this.toIndentedString(this.getReplaceBackslashWithYenSign())).append("\n");
        sb.append("    resolveFontNames: ").append(this.toIndentedString(this.getResolveFontNames())).append("\n");
        sb.append("    resourceFolder: ").append(this.toIndentedString(this.getResourceFolder())).append("\n");
        sb.append("    resourceFolderAlias: ").append(this.toIndentedString(this.getResourceFolderAlias())).append("\n");
        sb.append("    scaleImageToShapeSize: ").append(this.toIndentedString(this.getScaleImageToShapeSize())).append("\n");
        sb.append("    tableWidthOutputMode: ").append(this.toIndentedString((Object)this.getTableWidthOutputMode())).append("\n");
        sb.append("    saveFormat: ").append(this.toIndentedString(this.getSaveFormat())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CssStyleSheetTypeEnum {
        INLINE("Inline"),
        EMBEDDED("Embedded"),
        EXTERNAL("External");

        private String value;

        private CssStyleSheetTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CssStyleSheetTypeEnum fromValue(String text) {
            for (CssStyleSheetTypeEnum b : CssStyleSheetTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CssStyleSheetTypeEnum> {
            public void write(JsonWriter jsonWriter, CssStyleSheetTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CssStyleSheetTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CssStyleSheetTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DocumentSplitCriteriaEnum {
        NONE("None"),
        PAGEBREAK("PageBreak"),
        COLUMNBREAK("ColumnBreak"),
        SECTIONBREAK("SectionBreak"),
        HEADINGPARAGRAPH("HeadingParagraph");

        private String value;

        private DocumentSplitCriteriaEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DocumentSplitCriteriaEnum fromValue(String text) {
            for (DocumentSplitCriteriaEnum b : DocumentSplitCriteriaEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DocumentSplitCriteriaEnum> {
            public void write(JsonWriter jsonWriter, DocumentSplitCriteriaEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DocumentSplitCriteriaEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DocumentSplitCriteriaEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ExportHeadersFootersModeEnum {
        NONE("None"),
        PERSECTION("PerSection"),
        FIRSTSECTIONHEADERLASTSECTIONFOOTER("FirstSectionHeaderLastSectionFooter"),
        FIRSTPAGEHEADERFOOTERPERSECTION("FirstPageHeaderFooterPerSection");

        private String value;

        private ExportHeadersFootersModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ExportHeadersFootersModeEnum fromValue(String text) {
            for (ExportHeadersFootersModeEnum b : ExportHeadersFootersModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ExportHeadersFootersModeEnum> {
            public void write(JsonWriter jsonWriter, ExportHeadersFootersModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ExportHeadersFootersModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ExportHeadersFootersModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ExportListLabelsEnum {
        AUTO("Auto"),
        ASINLINETEXT("AsInlineText"),
        BYHTMLTAGS("ByHtmlTags");

        private String value;

        private ExportListLabelsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ExportListLabelsEnum fromValue(String text) {
            for (ExportListLabelsEnum b : ExportListLabelsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ExportListLabelsEnum> {
            public void write(JsonWriter jsonWriter, ExportListLabelsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ExportListLabelsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ExportListLabelsEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum HtmlVersionEnum {
        XHTML("Xhtml"),
        HTML5("Html5");

        private String value;

        private HtmlVersionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static HtmlVersionEnum fromValue(String text) {
            for (HtmlVersionEnum b : HtmlVersionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<HtmlVersionEnum> {
            public void write(JsonWriter jsonWriter, HtmlVersionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public HtmlVersionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return HtmlVersionEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MetafileFormatEnum {
        PNG("Png"),
        SVG("Svg"),
        EMFORWMF("EmfOrWmf");

        private String value;

        private MetafileFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MetafileFormatEnum fromValue(String text) {
            for (MetafileFormatEnum b : MetafileFormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MetafileFormatEnum> {
            public void write(JsonWriter jsonWriter, MetafileFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MetafileFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MetafileFormatEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OfficeMathOutputModeEnum {
        IMAGE("Image"),
        MATHML("MathML"),
        TEXT("Text");

        private String value;

        private OfficeMathOutputModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OfficeMathOutputModeEnum fromValue(String text) {
            for (OfficeMathOutputModeEnum b : OfficeMathOutputModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OfficeMathOutputModeEnum> {
            public void write(JsonWriter jsonWriter, OfficeMathOutputModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OfficeMathOutputModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OfficeMathOutputModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TableWidthOutputModeEnum {
        ALL("All"),
        RELATIVEONLY("RelativeOnly"),
        NONE("None");

        private String value;

        private TableWidthOutputModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TableWidthOutputModeEnum fromValue(String text) {
            for (TableWidthOutputModeEnum b : TableWidthOutputModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TableWidthOutputModeEnum> {
            public void write(JsonWriter jsonWriter, TableWidthOutputModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TableWidthOutputModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TableWidthOutputModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

