/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.BaseEntryList;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ImageEntry;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a list of images which will be appended to the original resource document or image.")
public class ImageEntryList
extends BaseEntryList {
    @SerializedName(value="AppendEachImageOnNewPage")
    protected Boolean appendEachImageOnNewPage = null;
    @SerializedName(value="ImageEntries")
    protected List<ImageEntry> imageEntries = null;

    @ApiModelProperty(value="Gets or sets a value indicating whether each image should be added to a new page in the document. This value only has an effect when adding images to a document that supports pagination.")
    public Boolean getAppendEachImageOnNewPage() {
        return this.appendEachImageOnNewPage;
    }

    public ImageEntryList appendEachImageOnNewPage(Boolean appendEachImageOnNewPage) {
        this.appendEachImageOnNewPage = appendEachImageOnNewPage;
        return this;
    }

    public void setAppendEachImageOnNewPage(Boolean appendEachImageOnNewPage) {
        this.appendEachImageOnNewPage = appendEachImageOnNewPage;
    }

    @ApiModelProperty(value="Gets or sets the list of images.")
    public List<ImageEntry> getImageEntries() {
        return this.imageEntries;
    }

    public ImageEntryList imageEntries(List<ImageEntry> imageEntries) {
        this.imageEntries = imageEntries;
        return this;
    }

    public ImageEntryList addImageEntriesItem(ImageEntry imageEntriesItem) {
        if (this.imageEntries == null) {
            this.imageEntries = new ArrayList<ImageEntry>();
        }
        this.imageEntries.add(imageEntriesItem);
        return this;
    }

    public void setImageEntries(List<ImageEntry> imageEntries) {
        this.imageEntries = imageEntries;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
        super.getFilesContent(resultFilesContent);
        if (this.imageEntries != null) {
            for (ModelIfc modelIfc : this.imageEntries) {
                modelIfc.getFilesContent(resultFilesContent);
            }
        }
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.imageEntries == null) {
            throw new ApiException(400, "Property ImageEntries in ImageEntryList is required.");
        }
        if (this.imageEntries != null) {
            for (ModelIfc modelIfc : this.imageEntries) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageEntryList imageEntryList = (ImageEntryList)o;
        return Objects.equals(this.appendEachImageOnNewPage, imageEntryList.appendEachImageOnNewPage) && Objects.equals(this.imageEntries, imageEntryList.imageEntries) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.appendEachImageOnNewPage, this.imageEntries, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageEntryList {\n");
        sb.append("    appendEachImageOnNewPage: ").append(this.toIndentedString(this.getAppendEachImageOnNewPage())).append("\n");
        sb.append("    imageEntries: ").append(this.toIndentedString(this.getImageEntries())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

