/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.LinkElement;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with a paragraph list format element.")
public class ListFormat
extends LinkElement {
    @SerializedName(value="ListLevelNumber")
    protected Integer listLevelNumber = null;
    @SerializedName(value="ListId")
    protected Integer listId = null;
    @SerializedName(value="IsListItem")
    protected Boolean isListItem = null;

    @ApiModelProperty(value="Gets or sets the list level number (0 to 8) for the paragraph. In Word documents, lists may consist of 1 or 9 levels, numbered 0 to 8. Has effect only when the Aspose.Words.ListFormat.List property is set to reference a valid list. Aspose.Words.ListFormat.List.")
    public Integer getListLevelNumber() {
        return this.listLevelNumber;
    }

    public ListFormat listLevelNumber(Integer listLevelNumber) {
        this.listLevelNumber = listLevelNumber;
        return this;
    }

    public void setListLevelNumber(Integer listLevelNumber) {
        this.listLevelNumber = listLevelNumber;
    }

    @ApiModelProperty(value="Gets or sets the list id of this paragraph. The list that is being assigned to this property must belong to the current document.The list that is being assigned to this property must not be a list style definition.")
    public Integer getListId() {
        return this.listId;
    }

    public ListFormat listId(Integer listId) {
        this.listId = listId;
        return this;
    }

    public void setListId(Integer listId) {
        this.listId = listId;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the paragraph has bulleted or numbered formatting applied to it.")
    public Boolean getIsListItem() {
        return this.isListItem;
    }

    public ListFormat isListItem(Boolean isListItem) {
        this.isListItem = isListItem;
        return this;
    }

    public void setIsListItem(Boolean isListItem) {
        this.isListItem = isListItem;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.listLevelNumber == null) {
            throw new ApiException(400, "Property ListLevelNumber in ListFormat is required.");
        }
        if (this.isListItem == null) {
            throw new ApiException(400, "Property IsListItem in ListFormat is required.");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListFormat listFormat = (ListFormat)o;
        return Objects.equals(this.listLevelNumber, listFormat.listLevelNumber) && Objects.equals(this.listId, listFormat.listId) && Objects.equals(this.isListItem, listFormat.isListItem) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.listLevelNumber, this.listId, this.isListItem, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListFormat {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    listLevelNumber: ").append(this.toIndentedString(this.getListLevelNumber())).append("\n");
        sb.append("    listId: ").append(this.toIndentedString(this.getListId())).append("\n");
        sb.append("    isListItem: ").append(this.toIndentedString(this.getIsListItem())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

