/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Paragraph list format element for update.")
public class ListFormatUpdate
implements ModelIfc {
    @SerializedName(value="ListLevelNumber")
    protected Integer listLevelNumber = null;
    @SerializedName(value="ListId")
    protected Integer listId = null;

    @ApiModelProperty(value="Gets or sets the list level number (0 to 8) for the paragraph. In Word documents, lists may consist of 1 or 9 levels, numbered 0 to 8. Has effect only when the Aspose.Words.ListFormat.List property is set to reference a valid list. Aspose.Words.ListFormat.List.")
    public Integer getListLevelNumber() {
        return this.listLevelNumber;
    }

    public ListFormatUpdate listLevelNumber(Integer listLevelNumber) {
        this.listLevelNumber = listLevelNumber;
        return this;
    }

    public void setListLevelNumber(Integer listLevelNumber) {
        this.listLevelNumber = listLevelNumber;
    }

    @ApiModelProperty(value="Gets or sets the list id of this paragraph. The list that is being assigned to this property must belong to the current document. The list that is being assigned to this property must not be a list style definition.")
    public Integer getListId() {
        return this.listId;
    }

    public ListFormatUpdate listId(Integer listId) {
        this.listId = listId;
        return this;
    }

    public void setListId(Integer listId) {
        this.listId = listId;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListFormatUpdate listFormatUpdate = (ListFormatUpdate)o;
        return Objects.equals(this.listLevelNumber, listFormatUpdate.listLevelNumber) && Objects.equals(this.listId, listFormatUpdate.listId);
    }

    public int hashCode() {
        return Objects.hash(this.listLevelNumber, this.listId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListFormatUpdate {\n");
        sb.append("    listLevelNumber: ").append(this.toIndentedString(this.getListLevelNumber())).append("\n");
        sb.append("    listId: ").append(this.toIndentedString(this.getListId())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

