/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.LinkElement;
import com.aspose.words.cloud.model.ListLevels;
import com.aspose.words.cloud.model.Style;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with a single document list.")
public class ListInfo
extends LinkElement {
    @SerializedName(value="ListId")
    protected Integer listId = null;
    @SerializedName(value="IsMultiLevel")
    protected Boolean isMultiLevel = null;
    @SerializedName(value="IsRestartAtEachSection")
    protected Boolean isRestartAtEachSection = null;
    @SerializedName(value="IsListStyleDefinition")
    protected Boolean isListStyleDefinition = null;
    @SerializedName(value="IsListStyleReference")
    protected Boolean isListStyleReference = null;
    @SerializedName(value="Style")
    protected Style style = null;
    @SerializedName(value="ListLevels")
    protected ListLevels listLevels = null;

    @ApiModelProperty(value="Gets or sets the unique identifier of the list. You do not normally need to use this property. But if you use it, you normally do so in conjunction with the Aspose.Words.Lists.ListCollection.GetListByListId(System.Int32) method to find a list by its identifier.")
    public Integer getListId() {
        return this.listId;
    }

    public ListInfo listId(Integer listId) {
        this.listId = listId;
        return this;
    }

    public void setListId(Integer listId) {
        this.listId = listId;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the list contains 9 levels; false when 1 level. The lists that you create with Aspose.Words are always multi-level lists and contain 9 levels. Microsoft Word 2003 and later always create multi-level lists with 9 levels. But in some documents, created with earlier versions of Microsoft Word you might encounter lists that have 1 level only.")
    public Boolean getIsMultiLevel() {
        return this.isMultiLevel;
    }

    public ListInfo isMultiLevel(Boolean isMultiLevel) {
        this.isMultiLevel = isMultiLevel;
        return this;
    }

    public void setIsMultiLevel(Boolean isMultiLevel) {
        this.isMultiLevel = isMultiLevel;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether list should be restarted at each section. The default value is false. This option is supported only in RTF, DOC and DOCX document formats. This option will be written to DOCX only if Aspose.Words.Saving.OoxmlCompliance is higher then Aspose.Words.Saving.OoxmlCompliance.Ecma376_2006.")
    public Boolean getIsRestartAtEachSection() {
        return this.isRestartAtEachSection;
    }

    public ListInfo isRestartAtEachSection(Boolean isRestartAtEachSection) {
        this.isRestartAtEachSection = isRestartAtEachSection;
        return this;
    }

    public void setIsRestartAtEachSection(Boolean isRestartAtEachSection) {
        this.isRestartAtEachSection = isRestartAtEachSection;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether this list is a definition of a list style. When this property is true, the Aspose.Words.Lists.List.Style property returns the list style that this list defines. By modifying properties of a list that defines a list style, you modify The properties of the list style. A list that is a definition of a list style cannot be applied directly to paragraphs to make them numbered. Aspose.Words.Lists.List.Style Aspose.Words.Lists.List.IsListStyleReference.")
    public Boolean getIsListStyleDefinition() {
        return this.isListStyleDefinition;
    }

    public ListInfo isListStyleDefinition(Boolean isListStyleDefinition) {
        this.isListStyleDefinition = isListStyleDefinition;
        return this;
    }

    public void setIsListStyleDefinition(Boolean isListStyleDefinition) {
        this.isListStyleDefinition = isListStyleDefinition;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether this list is a reference to a list style. Note, modifying properties of a list that is a reference to list style has no effect. The list formatting specified in the list style itself always takes precedence. Aspose.Words.Lists.List.Style Aspose.Words.Lists.List.IsListStyleDefinition.")
    public Boolean getIsListStyleReference() {
        return this.isListStyleReference;
    }

    public ListInfo isListStyleReference(Boolean isListStyleReference) {
        this.isListStyleReference = isListStyleReference;
        return this;
    }

    public void setIsListStyleReference(Boolean isListStyleReference) {
        this.isListStyleReference = isListStyleReference;
    }

    @ApiModelProperty(value="Gets or sets the list style that this list references or defines. If this list is not associated with a list style, the property will return null. A list could be a reference to a list style, in this case Aspose.Words.Lists.List.IsListStyleReference will be true. A list could be a definition of a list style, in this case Aspose.Words.Lists.List.IsListStyleDefinition will be true. Such a list cannot be applied to paragraphs in the document directly.")
    public Style getStyle() {
        return this.style;
    }

    public ListInfo style(Style style) {
        this.style = style;
        return this;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    @ApiModelProperty(value="Gets or sets the collection of list levels for this list. Use this property to access and modify formatting individual to each level of the list.")
    public ListLevels getListLevels() {
        return this.listLevels;
    }

    public ListInfo listLevels(ListLevels listLevels) {
        this.listLevels = listLevels;
        return this;
    }

    public void setListLevels(ListLevels listLevels) {
        this.listLevels = listLevels;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.listId == null) {
            throw new ApiException(400, "Property ListId in ListInfo is required.");
        }
        if (this.isMultiLevel == null) {
            throw new ApiException(400, "Property IsMultiLevel in ListInfo is required.");
        }
        if (this.isRestartAtEachSection == null) {
            throw new ApiException(400, "Property IsRestartAtEachSection in ListInfo is required.");
        }
        if (this.isListStyleDefinition == null) {
            throw new ApiException(400, "Property IsListStyleDefinition in ListInfo is required.");
        }
        if (this.isListStyleReference == null) {
            throw new ApiException(400, "Property IsListStyleReference in ListInfo is required.");
        }
        if (this.style != null) {
            this.style.validate();
        }
        if (this.listLevels != null) {
            this.listLevels.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListInfo listInfo = (ListInfo)o;
        return Objects.equals(this.listId, listInfo.listId) && Objects.equals(this.isMultiLevel, listInfo.isMultiLevel) && Objects.equals(this.isRestartAtEachSection, listInfo.isRestartAtEachSection) && Objects.equals(this.isListStyleDefinition, listInfo.isListStyleDefinition) && Objects.equals(this.isListStyleReference, listInfo.isListStyleReference) && Objects.equals(this.style, listInfo.style) && Objects.equals(this.listLevels, listInfo.listLevels) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.listId, this.isMultiLevel, this.isRestartAtEachSection, this.isListStyleDefinition, this.isListStyleReference, this.style, this.listLevels, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListInfo {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    listId: ").append(this.toIndentedString(this.getListId())).append("\n");
        sb.append("    isMultiLevel: ").append(this.toIndentedString(this.getIsMultiLevel())).append("\n");
        sb.append("    isRestartAtEachSection: ").append(this.toIndentedString(this.getIsRestartAtEachSection())).append("\n");
        sb.append("    isListStyleDefinition: ").append(this.toIndentedString(this.getIsListStyleDefinition())).append("\n");
        sb.append("    isListStyleReference: ").append(this.toIndentedString(this.getIsListStyleReference())).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.getStyle())).append("\n");
        sb.append("    listLevels: ").append(this.toIndentedString(this.getListLevels())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

