/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.OfficeMathLink;
import com.aspose.words.cloud.model.StoryChildNodes;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with an OfficeMath object.")
public class OfficeMathObject
extends OfficeMathLink {
    @SerializedName(value="Content")
    protected StoryChildNodes content = null;
    @SerializedName(value="DisplayType")
    protected DisplayTypeEnum displayType = null;
    @SerializedName(value="Justification")
    protected JustificationEnum justification = null;
    @SerializedName(value="MathObjectType")
    protected MathObjectTypeEnum mathObjectType = null;

    @ApiModelProperty(value="Gets or sets the content of a footnote.")
    public StoryChildNodes getContent() {
        return this.content;
    }

    public OfficeMathObject content(StoryChildNodes content) {
        this.content = content;
        return this;
    }

    public void setContent(StoryChildNodes content) {
        this.content = content;
    }

    @ApiModelProperty(value="Gets or sets the display format type of the OfficeMath object. This display format defines whether an equation is displayed inline with the text or displayed on its own line. Display format type has effect for top level Office Math only.Returned display format type is always Inline for nested Office Math.")
    public DisplayTypeEnum getDisplayType() {
        return this.displayType;
    }

    public OfficeMathObject displayType(DisplayTypeEnum displayType) {
        this.displayType = displayType;
        return this;
    }

    public void setDisplayType(DisplayTypeEnum displayType) {
        this.displayType = displayType;
    }

    @ApiModelProperty(value="Gets or sets the justification of the OfficeMath object. Justification cannot be set to the Office Math with display format type Inline.Inline justification cannot be set to the Office Math with display format type Display.Corresponding DisplayType has to be set before setting Office Math justification.")
    public JustificationEnum getJustification() {
        return this.justification;
    }

    public OfficeMathObject justification(JustificationEnum justification) {
        this.justification = justification;
        return this;
    }

    public void setJustification(JustificationEnum justification) {
        this.justification = justification;
    }

    @ApiModelProperty(value="Gets or sets the type of the OfficeMath object.")
    public MathObjectTypeEnum getMathObjectType() {
        return this.mathObjectType;
    }

    public OfficeMathObject mathObjectType(MathObjectTypeEnum mathObjectType) {
        this.mathObjectType = mathObjectType;
        return this;
    }

    public void setMathObjectType(MathObjectTypeEnum mathObjectType) {
        this.mathObjectType = mathObjectType;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.content != null) {
            this.content.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfficeMathObject officeMathObject = (OfficeMathObject)o;
        return Objects.equals(this.content, officeMathObject.content) && Objects.equals((Object)this.displayType, (Object)officeMathObject.displayType) && Objects.equals((Object)this.justification, (Object)officeMathObject.justification) && Objects.equals((Object)this.mathObjectType, (Object)officeMathObject.mathObjectType) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.content, this.displayType, this.justification, this.mathObjectType, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfficeMathObject {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.getNodeId())).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.getContent())).append("\n");
        sb.append("    displayType: ").append(this.toIndentedString((Object)this.getDisplayType())).append("\n");
        sb.append("    justification: ").append(this.toIndentedString((Object)this.getJustification())).append("\n");
        sb.append("    mathObjectType: ").append(this.toIndentedString((Object)this.getMathObjectType())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DisplayTypeEnum {
        DISPLAY("Display"),
        INLINE("Inline");

        private String value;

        private DisplayTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DisplayTypeEnum fromValue(String text) {
            for (DisplayTypeEnum b : DisplayTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DisplayTypeEnum> {
            public void write(JsonWriter jsonWriter, DisplayTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DisplayTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DisplayTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum JustificationEnum {
        CENTERGROUP("CenterGroup"),
        DEFAULT("Default"),
        CENTER("Center"),
        LEFT("Left"),
        RIGHT("Right"),
        INLINE("Inline");

        private String value;

        private JustificationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static JustificationEnum fromValue(String text) {
            for (JustificationEnum b : JustificationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<JustificationEnum> {
            public void write(JsonWriter jsonWriter, JustificationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public JustificationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return JustificationEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MathObjectTypeEnum {
        OMATH("OMath"),
        OMATHPARA("OMathPara"),
        ACCENT("Accent"),
        BAR("Bar"),
        BORDERBOX("BorderBox"),
        BOX("Box"),
        DELIMITER("Delimiter"),
        DEGREE("Degree"),
        ARGUMENT("Argument"),
        ARRAY("Array"),
        FRACTION("Fraction"),
        DENOMINATOR("Denominator"),
        NUMERATOR("Numerator"),
        FUNCTION("Function"),
        FUNCTIONNAME("FunctionName"),
        GROUPCHARACTER("GroupCharacter"),
        LIMIT("Limit"),
        LOWERLIMIT("LowerLimit"),
        UPPERLIMIT("UpperLimit"),
        MATRIX("Matrix"),
        MATRIXROW("MatrixRow"),
        NARY("NAry"),
        PHANTOM("Phantom"),
        RADICAL("Radical"),
        SUBSCRIPTPART("SubscriptPart"),
        SUPERSCRIPTPART("SuperscriptPart"),
        PRESUBSUPERSCRIPT("PreSubSuperscript"),
        SUBSCRIPT("Subscript"),
        SUBSUPERSCRIPT("SubSuperscript"),
        SUPERCRIPT("Supercript");

        private String value;

        private MathObjectTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MathObjectTypeEnum fromValue(String text) {
            for (MathObjectTypeEnum b : MathObjectTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MathObjectTypeEnum> {
            public void write(JsonWriter jsonWriter, MathObjectTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MathObjectTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MathObjectTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

