/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.SaveOptionsData;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container class for docx/docm/dotx/dotm/flatopc save options.")
public abstract class OoxmlSaveOptionsData
extends SaveOptionsData {
    @SerializedName(value="Compliance")
    protected ComplianceEnum compliance = null;
    @SerializedName(value="CompressionLevel")
    protected CompressionLevelEnum compressionLevel = null;
    @SerializedName(value="Password")
    protected String password = null;
    @SerializedName(value="PrettyFormat")
    protected Boolean prettyFormat = null;

    @ApiModelProperty(value="Gets or sets the oOXML version for the output document.")
    public ComplianceEnum getCompliance() {
        return this.compliance;
    }

    public OoxmlSaveOptionsData compliance(ComplianceEnum compliance) {
        this.compliance = compliance;
        return this;
    }

    public void setCompliance(ComplianceEnum compliance) {
        this.compliance = compliance;
    }

    @ApiModelProperty(value="Gets or sets the compression level.")
    public CompressionLevelEnum getCompressionLevel() {
        return this.compressionLevel;
    }

    public OoxmlSaveOptionsData compressionLevel(CompressionLevelEnum compressionLevel) {
        this.compressionLevel = compressionLevel;
        return this;
    }

    public void setCompressionLevel(CompressionLevelEnum compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    @ApiModelProperty(value="Gets or sets the password to encrypt document using ECMA376 Standard encryption algorithm.")
    public String getPassword() {
        return this.password;
    }

    public OoxmlSaveOptionsData password(String password) {
        this.password = password;
        return this;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to use pretty formats output.")
    public Boolean getPrettyFormat() {
        return this.prettyFormat;
    }

    public OoxmlSaveOptionsData prettyFormat(Boolean prettyFormat) {
        this.prettyFormat = prettyFormat;
        return this;
    }

    public void setPrettyFormat(Boolean prettyFormat) {
        this.prettyFormat = prettyFormat;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OoxmlSaveOptionsData ooxmlSaveOptionsData = (OoxmlSaveOptionsData)o;
        return Objects.equals((Object)this.compliance, (Object)ooxmlSaveOptionsData.compliance) && Objects.equals((Object)this.compressionLevel, (Object)ooxmlSaveOptionsData.compressionLevel) && Objects.equals(this.password, ooxmlSaveOptionsData.password) && Objects.equals(this.prettyFormat, ooxmlSaveOptionsData.prettyFormat) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.compliance, this.compressionLevel, this.password, this.prettyFormat, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OoxmlSaveOptionsData {\n");
        sb.append("    allowEmbeddingPostScriptFonts: ").append(this.toIndentedString(this.getAllowEmbeddingPostScriptFonts())).append("\n");
        sb.append("    customTimeZoneInfoData: ").append(this.toIndentedString(this.getCustomTimeZoneInfoData())).append("\n");
        sb.append("    dml3DEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDml3DEffectsRenderingMode())).append("\n");
        sb.append("    dmlEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDmlEffectsRenderingMode())).append("\n");
        sb.append("    dmlRenderingMode: ").append(this.toIndentedString((Object)this.getDmlRenderingMode())).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.getFileName())).append("\n");
        sb.append("    imlRenderingMode: ").append(this.toIndentedString((Object)this.getImlRenderingMode())).append("\n");
        sb.append("    updateAmbiguousTextFont: ").append(this.toIndentedString(this.getUpdateAmbiguousTextFont())).append("\n");
        sb.append("    updateCreatedTimeProperty: ").append(this.toIndentedString(this.getUpdateCreatedTimeProperty())).append("\n");
        sb.append("    updateFields: ").append(this.toIndentedString(this.getUpdateFields())).append("\n");
        sb.append("    updateLastPrintedProperty: ").append(this.toIndentedString(this.getUpdateLastPrintedProperty())).append("\n");
        sb.append("    updateLastSavedTimeProperty: ").append(this.toIndentedString(this.getUpdateLastSavedTimeProperty())).append("\n");
        sb.append("    zipOutput: ").append(this.toIndentedString(this.getZipOutput())).append("\n");
        sb.append("    saveFormat: ").append(this.toIndentedString(this.getSaveFormat())).append("\n");
        sb.append("    compliance: ").append(this.toIndentedString((Object)this.getCompliance())).append("\n");
        sb.append("    compressionLevel: ").append(this.toIndentedString((Object)this.getCompressionLevel())).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.getPassword())).append("\n");
        sb.append("    prettyFormat: ").append(this.toIndentedString(this.getPrettyFormat())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ComplianceEnum {
        ECMA376_2006("Ecma376_2006"),
        ISO29500_2008_TRANSITIONAL("Iso29500_2008_Transitional"),
        ISO29500_2008_STRICT("Iso29500_2008_Strict");

        private String value;

        private ComplianceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ComplianceEnum fromValue(String text) {
            for (ComplianceEnum b : ComplianceEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ComplianceEnum> {
            public void write(JsonWriter jsonWriter, ComplianceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ComplianceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ComplianceEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CompressionLevelEnum {
        NORMAL("Normal"),
        MAXIMUM("Maximum"),
        FAST("Fast"),
        SUPERFAST("SuperFast");

        private String value;

        private CompressionLevelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CompressionLevelEnum fromValue(String text) {
            for (CompressionLevelEnum b : CompressionLevelEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CompressionLevelEnum> {
            public void write(JsonWriter jsonWriter, CompressionLevelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CompressionLevelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CompressionLevelEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

