/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Class is used for insert page number request building.")
public class PageNumber
implements ModelIfc {
    @SerializedName(value="Alignment")
    protected String alignment = null;
    @SerializedName(value="Format")
    protected String format = null;
    @SerializedName(value="IsTop")
    protected Boolean isTop = null;
    @SerializedName(value="PageStartingNumber")
    protected Integer pageStartingNumber = null;
    @SerializedName(value="SetPageNumberOnFirstPage")
    protected Boolean setPageNumberOnFirstPage = null;

    @ApiModelProperty(value="Gets or sets text alignment, possible values are left, right, center or justify.")
    public String getAlignment() {
        return this.alignment;
    }

    public PageNumber alignment(String alignment) {
        this.alignment = alignment;
        return this;
    }

    public void setAlignment(String alignment) {
        this.alignment = alignment;
    }

    @ApiModelProperty(value="Gets or sets the page number format, e.g. \"{PAGE} of {NUMPAGES}\".")
    public String getFormat() {
        return this.format;
    }

    public PageNumber format(String format) {
        this.format = format;
        return this;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether if true the page number is added at the top of the page, else at the bottom.")
    public Boolean getIsTop() {
        return this.isTop;
    }

    public PageNumber isTop(Boolean isTop) {
        this.isTop = isTop;
        return this;
    }

    public void setIsTop(Boolean isTop) {
        this.isTop = isTop;
    }

    @ApiModelProperty(value="Gets or sets the starting page number of the document.")
    public Integer getPageStartingNumber() {
        return this.pageStartingNumber;
    }

    public PageNumber pageStartingNumber(Integer pageStartingNumber) {
        this.pageStartingNumber = pageStartingNumber;
        return this;
    }

    public void setPageStartingNumber(Integer pageStartingNumber) {
        this.pageStartingNumber = pageStartingNumber;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether if true the page number is added on first page too.")
    public Boolean getSetPageNumberOnFirstPage() {
        return this.setPageNumberOnFirstPage;
    }

    public PageNumber setPageNumberOnFirstPage(Boolean setPageNumberOnFirstPage) {
        this.setPageNumberOnFirstPage = setPageNumberOnFirstPage;
        return this;
    }

    public void setSetPageNumberOnFirstPage(Boolean setPageNumberOnFirstPage) {
        this.setPageNumberOnFirstPage = setPageNumberOnFirstPage;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.isTop == null) {
            throw new ApiException(400, "Property IsTop in PageNumber is required.");
        }
        if (this.setPageNumberOnFirstPage == null) {
            throw new ApiException(400, "Property SetPageNumberOnFirstPage in PageNumber is required.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageNumber pageNumber = (PageNumber)o;
        return Objects.equals(this.alignment, pageNumber.alignment) && Objects.equals(this.format, pageNumber.format) && Objects.equals(this.isTop, pageNumber.isTop) && Objects.equals(this.pageStartingNumber, pageNumber.pageStartingNumber) && Objects.equals(this.setPageNumberOnFirstPage, pageNumber.setPageNumberOnFirstPage);
    }

    public int hashCode() {
        return Objects.hash(this.alignment, this.format, this.isTop, this.pageStartingNumber, this.setPageNumberOnFirstPage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PageNumber {\n");
        sb.append("    alignment: ").append(this.toIndentedString(this.getAlignment())).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.getFormat())).append("\n");
        sb.append("    isTop: ").append(this.toIndentedString(this.getIsTop())).append("\n");
        sb.append("    pageStartingNumber: ").append(this.toIndentedString(this.getPageStartingNumber())).append("\n");
        sb.append("    setPageNumberOnFirstPage: ").append(this.toIndentedString(this.getSetPageNumberOnFirstPage())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

