/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.LinkElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents the page setup properties of a section. PageSetup object contains all the page setup attributes of a section (left margin, bottom margin, paper size, and so on) as properties.")
public class PageSetup
extends LinkElement {
    @SerializedName(value="Bidi")
    protected Boolean bidi = null;
    @SerializedName(value="BorderAlwaysInFront")
    protected Boolean borderAlwaysInFront = null;
    @SerializedName(value="BorderAppliesTo")
    protected BorderAppliesToEnum borderAppliesTo = null;
    @SerializedName(value="BorderDistanceFrom")
    protected BorderDistanceFromEnum borderDistanceFrom = null;
    @SerializedName(value="BottomMargin")
    protected Double bottomMargin = null;
    @SerializedName(value="DifferentFirstPageHeaderFooter")
    protected Boolean differentFirstPageHeaderFooter = null;
    @SerializedName(value="FirstPageTray")
    protected Integer firstPageTray = null;
    @SerializedName(value="FooterDistance")
    protected Double footerDistance = null;
    @SerializedName(value="Gutter")
    protected Double gutter = null;
    @SerializedName(value="HeaderDistance")
    protected Double headerDistance = null;
    @SerializedName(value="LeftMargin")
    protected Double leftMargin = null;
    @SerializedName(value="LineNumberCountBy")
    protected Integer lineNumberCountBy = null;
    @SerializedName(value="LineNumberDistanceFromText")
    protected Double lineNumberDistanceFromText = null;
    @SerializedName(value="LineNumberRestartMode")
    protected LineNumberRestartModeEnum lineNumberRestartMode = null;
    @SerializedName(value="LineStartingNumber")
    protected Integer lineStartingNumber = null;
    @SerializedName(value="Orientation")
    protected OrientationEnum orientation = null;
    @SerializedName(value="OtherPagesTray")
    protected Integer otherPagesTray = null;
    @SerializedName(value="PageHeight")
    protected Double pageHeight = null;
    @SerializedName(value="PageNumberStyle")
    protected PageNumberStyleEnum pageNumberStyle = null;
    @SerializedName(value="PageStartingNumber")
    protected Integer pageStartingNumber = null;
    @SerializedName(value="PageWidth")
    protected Double pageWidth = null;
    @SerializedName(value="PaperSize")
    protected PaperSizeEnum paperSize = null;
    @SerializedName(value="RestartPageNumbering")
    protected Boolean restartPageNumbering = null;
    @SerializedName(value="RightMargin")
    protected Double rightMargin = null;
    @SerializedName(value="RtlGutter")
    protected Boolean rtlGutter = null;
    @SerializedName(value="SectionStart")
    protected SectionStartEnum sectionStart = null;
    @SerializedName(value="SuppressEndnotes")
    protected Boolean suppressEndnotes = null;
    @SerializedName(value="TopMargin")
    protected Double topMargin = null;
    @SerializedName(value="VerticalAlignment")
    protected VerticalAlignmentEnum verticalAlignment = null;

    @ApiModelProperty(value="Gets or sets a value indicating whether this section contains bidirectional (complex scripts) text. When true, the columns in this section are laid out from right to left.")
    public Boolean getBidi() {
        return this.bidi;
    }

    public PageSetup bidi(Boolean bidi) {
        this.bidi = bidi;
        return this;
    }

    public void setBidi(Boolean bidi) {
        this.bidi = bidi;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the page border is positioned relative to intersecting texts and objects.")
    public Boolean getBorderAlwaysInFront() {
        return this.borderAlwaysInFront;
    }

    public PageSetup borderAlwaysInFront(Boolean borderAlwaysInFront) {
        this.borderAlwaysInFront = borderAlwaysInFront;
        return this;
    }

    public void setBorderAlwaysInFront(Boolean borderAlwaysInFront) {
        this.borderAlwaysInFront = borderAlwaysInFront;
    }

    @ApiModelProperty(value="Gets or sets the option that controls which pages the page border is printed on.")
    public BorderAppliesToEnum getBorderAppliesTo() {
        return this.borderAppliesTo;
    }

    public PageSetup borderAppliesTo(BorderAppliesToEnum borderAppliesTo) {
        this.borderAppliesTo = borderAppliesTo;
        return this;
    }

    public void setBorderAppliesTo(BorderAppliesToEnum borderAppliesTo) {
        this.borderAppliesTo = borderAppliesTo;
    }

    @ApiModelProperty(value="Gets or sets the value, that indicates whether the specified page border is measured from the edge of the page or from the text it surrounds.")
    public BorderDistanceFromEnum getBorderDistanceFrom() {
        return this.borderDistanceFrom;
    }

    public PageSetup borderDistanceFrom(BorderDistanceFromEnum borderDistanceFrom) {
        this.borderDistanceFrom = borderDistanceFrom;
        return this;
    }

    public void setBorderDistanceFrom(BorderDistanceFromEnum borderDistanceFrom) {
        this.borderDistanceFrom = borderDistanceFrom;
    }

    @ApiModelProperty(value="Gets or sets the distance (in points) between the bottom edge of the page and the bottom boundary of the body text.")
    public Double getBottomMargin() {
        return this.bottomMargin;
    }

    public PageSetup bottomMargin(Double bottomMargin) {
        this.bottomMargin = bottomMargin;
        return this;
    }

    public void setBottomMargin(Double bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether a different header or footer is used on the first page.")
    public Boolean getDifferentFirstPageHeaderFooter() {
        return this.differentFirstPageHeaderFooter;
    }

    public PageSetup differentFirstPageHeaderFooter(Boolean differentFirstPageHeaderFooter) {
        this.differentFirstPageHeaderFooter = differentFirstPageHeaderFooter;
        return this;
    }

    public void setDifferentFirstPageHeaderFooter(Boolean differentFirstPageHeaderFooter) {
        this.differentFirstPageHeaderFooter = differentFirstPageHeaderFooter;
    }

    @ApiModelProperty(value="Gets or sets the paper tray (bin) to use for the first page of a section. The value is implementation (printer) specific.")
    public Integer getFirstPageTray() {
        return this.firstPageTray;
    }

    public PageSetup firstPageTray(Integer firstPageTray) {
        this.firstPageTray = firstPageTray;
        return this;
    }

    public void setFirstPageTray(Integer firstPageTray) {
        this.firstPageTray = firstPageTray;
    }

    @ApiModelProperty(value="Gets or sets the distance (in points) between the footer and the bottom of the page.")
    public Double getFooterDistance() {
        return this.footerDistance;
    }

    public PageSetup footerDistance(Double footerDistance) {
        this.footerDistance = footerDistance;
        return this;
    }

    public void setFooterDistance(Double footerDistance) {
        this.footerDistance = footerDistance;
    }

    @ApiModelProperty(value="Gets or sets the amount of extra space added to the margin for document binding.")
    public Double getGutter() {
        return this.gutter;
    }

    public PageSetup gutter(Double gutter) {
        this.gutter = gutter;
        return this;
    }

    public void setGutter(Double gutter) {
        this.gutter = gutter;
    }

    @ApiModelProperty(value="Gets or sets the distance (in points) between the header and the top of the page.")
    public Double getHeaderDistance() {
        return this.headerDistance;
    }

    public PageSetup headerDistance(Double headerDistance) {
        this.headerDistance = headerDistance;
        return this;
    }

    public void setHeaderDistance(Double headerDistance) {
        this.headerDistance = headerDistance;
    }

    @ApiModelProperty(value="Gets or sets the distance (in points) between the left edge of the page and the left boundary of the body text.")
    public Double getLeftMargin() {
        return this.leftMargin;
    }

    public PageSetup leftMargin(Double leftMargin) {
        this.leftMargin = leftMargin;
        return this;
    }

    public void setLeftMargin(Double leftMargin) {
        this.leftMargin = leftMargin;
    }

    @ApiModelProperty(value="Gets or sets the numeric increment for line numbers.")
    public Integer getLineNumberCountBy() {
        return this.lineNumberCountBy;
    }

    public PageSetup lineNumberCountBy(Integer lineNumberCountBy) {
        this.lineNumberCountBy = lineNumberCountBy;
        return this;
    }

    public void setLineNumberCountBy(Integer lineNumberCountBy) {
        this.lineNumberCountBy = lineNumberCountBy;
    }

    @ApiModelProperty(value="Gets or sets the distance between the right edge of line numbers and the left edge of the document. Set this property to zero for automatic distance between the line numbers and text of the document.")
    public Double getLineNumberDistanceFromText() {
        return this.lineNumberDistanceFromText;
    }

    public PageSetup lineNumberDistanceFromText(Double lineNumberDistanceFromText) {
        this.lineNumberDistanceFromText = lineNumberDistanceFromText;
        return this;
    }

    public void setLineNumberDistanceFromText(Double lineNumberDistanceFromText) {
        this.lineNumberDistanceFromText = lineNumberDistanceFromText;
    }

    @ApiModelProperty(value="Gets or sets the way line numbering runs  that is, whether it starts over at the beginning of a new page or section or runs continuously.")
    public LineNumberRestartModeEnum getLineNumberRestartMode() {
        return this.lineNumberRestartMode;
    }

    public PageSetup lineNumberRestartMode(LineNumberRestartModeEnum lineNumberRestartMode) {
        this.lineNumberRestartMode = lineNumberRestartMode;
        return this;
    }

    public void setLineNumberRestartMode(LineNumberRestartModeEnum lineNumberRestartMode) {
        this.lineNumberRestartMode = lineNumberRestartMode;
    }

    @ApiModelProperty(value="Gets or sets the starting line number.")
    public Integer getLineStartingNumber() {
        return this.lineStartingNumber;
    }

    public PageSetup lineStartingNumber(Integer lineStartingNumber) {
        this.lineStartingNumber = lineStartingNumber;
        return this;
    }

    public void setLineStartingNumber(Integer lineStartingNumber) {
        this.lineStartingNumber = lineStartingNumber;
    }

    @ApiModelProperty(value="Gets or sets the orientation of the page. Changing Orientation swaps PageWidth and PageHeight.")
    public OrientationEnum getOrientation() {
        return this.orientation;
    }

    public PageSetup orientation(OrientationEnum orientation) {
        this.orientation = orientation;
        return this;
    }

    public void setOrientation(OrientationEnum orientation) {
        this.orientation = orientation;
    }

    @ApiModelProperty(value="Gets or sets the paper tray (bin) to be used for all but the first page of a section. The value is implementation (printer) specific.")
    public Integer getOtherPagesTray() {
        return this.otherPagesTray;
    }

    public PageSetup otherPagesTray(Integer otherPagesTray) {
        this.otherPagesTray = otherPagesTray;
        return this;
    }

    public void setOtherPagesTray(Integer otherPagesTray) {
        this.otherPagesTray = otherPagesTray;
    }

    @ApiModelProperty(value="Gets or sets the height of the page in points.")
    public Double getPageHeight() {
        return this.pageHeight;
    }

    public PageSetup pageHeight(Double pageHeight) {
        this.pageHeight = pageHeight;
        return this;
    }

    public void setPageHeight(Double pageHeight) {
        this.pageHeight = pageHeight;
    }

    @ApiModelProperty(value="Gets or sets the page number format.")
    public PageNumberStyleEnum getPageNumberStyle() {
        return this.pageNumberStyle;
    }

    public PageSetup pageNumberStyle(PageNumberStyleEnum pageNumberStyle) {
        this.pageNumberStyle = pageNumberStyle;
        return this;
    }

    public void setPageNumberStyle(PageNumberStyleEnum pageNumberStyle) {
        this.pageNumberStyle = pageNumberStyle;
    }

    @ApiModelProperty(value="Gets or sets the starting page number of the section. The RestartPageNumbering property, if set to false, will override the PageStartingNumber property so that page numbering can continue from the previous section.")
    public Integer getPageStartingNumber() {
        return this.pageStartingNumber;
    }

    public PageSetup pageStartingNumber(Integer pageStartingNumber) {
        this.pageStartingNumber = pageStartingNumber;
        return this;
    }

    public void setPageStartingNumber(Integer pageStartingNumber) {
        this.pageStartingNumber = pageStartingNumber;
    }

    @ApiModelProperty(value="Gets or sets the width of the page in points.")
    public Double getPageWidth() {
        return this.pageWidth;
    }

    public PageSetup pageWidth(Double pageWidth) {
        this.pageWidth = pageWidth;
        return this;
    }

    public void setPageWidth(Double pageWidth) {
        this.pageWidth = pageWidth;
    }

    @ApiModelProperty(value="Gets or sets the paper size. Setting this property updates PageWidth and PageHeight values. Setting this value to Custom does not change existing values.")
    public PaperSizeEnum getPaperSize() {
        return this.paperSize;
    }

    public PageSetup paperSize(PaperSizeEnum paperSize) {
        this.paperSize = paperSize;
        return this;
    }

    public void setPaperSize(PaperSizeEnum paperSize) {
        this.paperSize = paperSize;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether page numbering restarts at the beginning of the section. If set to false, the RestartPageNumbering property will override the PageStartingNumber property so that page numbering can continue from the previous section.")
    public Boolean getRestartPageNumbering() {
        return this.restartPageNumbering;
    }

    public PageSetup restartPageNumbering(Boolean restartPageNumbering) {
        this.restartPageNumbering = restartPageNumbering;
        return this;
    }

    public void setRestartPageNumbering(Boolean restartPageNumbering) {
        this.restartPageNumbering = restartPageNumbering;
    }

    @ApiModelProperty(value="Gets or sets the distance (in points) between the right edge of the page and the right boundary of the body text.")
    public Double getRightMargin() {
        return this.rightMargin;
    }

    public PageSetup rightMargin(Double rightMargin) {
        this.rightMargin = rightMargin;
        return this;
    }

    public void setRightMargin(Double rightMargin) {
        this.rightMargin = rightMargin;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether Microsoft Word uses gutters for the section based on a right-to-left language or a left-to-right language.")
    public Boolean getRtlGutter() {
        return this.rtlGutter;
    }

    public PageSetup rtlGutter(Boolean rtlGutter) {
        this.rtlGutter = rtlGutter;
        return this;
    }

    public void setRtlGutter(Boolean rtlGutter) {
        this.rtlGutter = rtlGutter;
    }

    @ApiModelProperty(value="Gets or sets the type of section break for the specified object.")
    public SectionStartEnum getSectionStart() {
        return this.sectionStart;
    }

    public PageSetup sectionStart(SectionStartEnum sectionStart) {
        this.sectionStart = sectionStart;
        return this;
    }

    public void setSectionStart(SectionStartEnum sectionStart) {
        this.sectionStart = sectionStart;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether endnotes are printed at the end of the next section that doesn't suppress endnotes. Suppressed endnotes are printed before the endnotes in that section.")
    public Boolean getSuppressEndnotes() {
        return this.suppressEndnotes;
    }

    public PageSetup suppressEndnotes(Boolean suppressEndnotes) {
        this.suppressEndnotes = suppressEndnotes;
        return this;
    }

    public void setSuppressEndnotes(Boolean suppressEndnotes) {
        this.suppressEndnotes = suppressEndnotes;
    }

    @ApiModelProperty(value="Gets or sets the distance (in points) between the top edge of the page and the top boundary of the body text.")
    public Double getTopMargin() {
        return this.topMargin;
    }

    public PageSetup topMargin(Double topMargin) {
        this.topMargin = topMargin;
        return this;
    }

    public void setTopMargin(Double topMargin) {
        this.topMargin = topMargin;
    }

    @ApiModelProperty(value="Gets or sets the vertical alignment of text on each page in the document.or section.")
    public VerticalAlignmentEnum getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public PageSetup verticalAlignment(VerticalAlignmentEnum verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    public void setVerticalAlignment(VerticalAlignmentEnum verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageSetup pageSetup = (PageSetup)o;
        return Objects.equals(this.bidi, pageSetup.bidi) && Objects.equals(this.borderAlwaysInFront, pageSetup.borderAlwaysInFront) && Objects.equals((Object)this.borderAppliesTo, (Object)pageSetup.borderAppliesTo) && Objects.equals((Object)this.borderDistanceFrom, (Object)pageSetup.borderDistanceFrom) && Objects.equals(this.bottomMargin, pageSetup.bottomMargin) && Objects.equals(this.differentFirstPageHeaderFooter, pageSetup.differentFirstPageHeaderFooter) && Objects.equals(this.firstPageTray, pageSetup.firstPageTray) && Objects.equals(this.footerDistance, pageSetup.footerDistance) && Objects.equals(this.gutter, pageSetup.gutter) && Objects.equals(this.headerDistance, pageSetup.headerDistance) && Objects.equals(this.leftMargin, pageSetup.leftMargin) && Objects.equals(this.lineNumberCountBy, pageSetup.lineNumberCountBy) && Objects.equals(this.lineNumberDistanceFromText, pageSetup.lineNumberDistanceFromText) && Objects.equals((Object)this.lineNumberRestartMode, (Object)pageSetup.lineNumberRestartMode) && Objects.equals(this.lineStartingNumber, pageSetup.lineStartingNumber) && Objects.equals((Object)this.orientation, (Object)pageSetup.orientation) && Objects.equals(this.otherPagesTray, pageSetup.otherPagesTray) && Objects.equals(this.pageHeight, pageSetup.pageHeight) && Objects.equals((Object)this.pageNumberStyle, (Object)pageSetup.pageNumberStyle) && Objects.equals(this.pageStartingNumber, pageSetup.pageStartingNumber) && Objects.equals(this.pageWidth, pageSetup.pageWidth) && Objects.equals((Object)this.paperSize, (Object)pageSetup.paperSize) && Objects.equals(this.restartPageNumbering, pageSetup.restartPageNumbering) && Objects.equals(this.rightMargin, pageSetup.rightMargin) && Objects.equals(this.rtlGutter, pageSetup.rtlGutter) && Objects.equals((Object)this.sectionStart, (Object)pageSetup.sectionStart) && Objects.equals(this.suppressEndnotes, pageSetup.suppressEndnotes) && Objects.equals(this.topMargin, pageSetup.topMargin) && Objects.equals((Object)this.verticalAlignment, (Object)pageSetup.verticalAlignment) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.bidi, this.borderAlwaysInFront, this.borderAppliesTo, this.borderDistanceFrom, this.bottomMargin, this.differentFirstPageHeaderFooter, this.firstPageTray, this.footerDistance, this.gutter, this.headerDistance, this.leftMargin, this.lineNumberCountBy, this.lineNumberDistanceFromText, this.lineNumberRestartMode, this.lineStartingNumber, this.orientation, this.otherPagesTray, this.pageHeight, this.pageNumberStyle, this.pageStartingNumber, this.pageWidth, this.paperSize, this.restartPageNumbering, this.rightMargin, this.rtlGutter, this.sectionStart, this.suppressEndnotes, this.topMargin, this.verticalAlignment, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PageSetup {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    bidi: ").append(this.toIndentedString(this.getBidi())).append("\n");
        sb.append("    borderAlwaysInFront: ").append(this.toIndentedString(this.getBorderAlwaysInFront())).append("\n");
        sb.append("    borderAppliesTo: ").append(this.toIndentedString((Object)this.getBorderAppliesTo())).append("\n");
        sb.append("    borderDistanceFrom: ").append(this.toIndentedString((Object)this.getBorderDistanceFrom())).append("\n");
        sb.append("    bottomMargin: ").append(this.toIndentedString(this.getBottomMargin())).append("\n");
        sb.append("    differentFirstPageHeaderFooter: ").append(this.toIndentedString(this.getDifferentFirstPageHeaderFooter())).append("\n");
        sb.append("    firstPageTray: ").append(this.toIndentedString(this.getFirstPageTray())).append("\n");
        sb.append("    footerDistance: ").append(this.toIndentedString(this.getFooterDistance())).append("\n");
        sb.append("    gutter: ").append(this.toIndentedString(this.getGutter())).append("\n");
        sb.append("    headerDistance: ").append(this.toIndentedString(this.getHeaderDistance())).append("\n");
        sb.append("    leftMargin: ").append(this.toIndentedString(this.getLeftMargin())).append("\n");
        sb.append("    lineNumberCountBy: ").append(this.toIndentedString(this.getLineNumberCountBy())).append("\n");
        sb.append("    lineNumberDistanceFromText: ").append(this.toIndentedString(this.getLineNumberDistanceFromText())).append("\n");
        sb.append("    lineNumberRestartMode: ").append(this.toIndentedString((Object)this.getLineNumberRestartMode())).append("\n");
        sb.append("    lineStartingNumber: ").append(this.toIndentedString(this.getLineStartingNumber())).append("\n");
        sb.append("    orientation: ").append(this.toIndentedString((Object)this.getOrientation())).append("\n");
        sb.append("    otherPagesTray: ").append(this.toIndentedString(this.getOtherPagesTray())).append("\n");
        sb.append("    pageHeight: ").append(this.toIndentedString(this.getPageHeight())).append("\n");
        sb.append("    pageNumberStyle: ").append(this.toIndentedString((Object)this.getPageNumberStyle())).append("\n");
        sb.append("    pageStartingNumber: ").append(this.toIndentedString(this.getPageStartingNumber())).append("\n");
        sb.append("    pageWidth: ").append(this.toIndentedString(this.getPageWidth())).append("\n");
        sb.append("    paperSize: ").append(this.toIndentedString((Object)this.getPaperSize())).append("\n");
        sb.append("    restartPageNumbering: ").append(this.toIndentedString(this.getRestartPageNumbering())).append("\n");
        sb.append("    rightMargin: ").append(this.toIndentedString(this.getRightMargin())).append("\n");
        sb.append("    rtlGutter: ").append(this.toIndentedString(this.getRtlGutter())).append("\n");
        sb.append("    sectionStart: ").append(this.toIndentedString((Object)this.getSectionStart())).append("\n");
        sb.append("    suppressEndnotes: ").append(this.toIndentedString(this.getSuppressEndnotes())).append("\n");
        sb.append("    topMargin: ").append(this.toIndentedString(this.getTopMargin())).append("\n");
        sb.append("    verticalAlignment: ").append(this.toIndentedString((Object)this.getVerticalAlignment())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BorderAppliesToEnum {
        ALLPAGES("AllPages"),
        FIRSTPAGE("FirstPage"),
        OTHERPAGES("OtherPages");

        private String value;

        private BorderAppliesToEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BorderAppliesToEnum fromValue(String text) {
            for (BorderAppliesToEnum b : BorderAppliesToEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<BorderAppliesToEnum> {
            public void write(JsonWriter jsonWriter, BorderAppliesToEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BorderAppliesToEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BorderAppliesToEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BorderDistanceFromEnum {
        TEXT("Text"),
        PAGEEDGE("PageEdge");

        private String value;

        private BorderDistanceFromEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BorderDistanceFromEnum fromValue(String text) {
            for (BorderDistanceFromEnum b : BorderDistanceFromEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<BorderDistanceFromEnum> {
            public void write(JsonWriter jsonWriter, BorderDistanceFromEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BorderDistanceFromEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BorderDistanceFromEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LineNumberRestartModeEnum {
        RESTARTPAGE("RestartPage"),
        RESTARTSECTION("RestartSection"),
        CONTINUOUS("Continuous");

        private String value;

        private LineNumberRestartModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LineNumberRestartModeEnum fromValue(String text) {
            for (LineNumberRestartModeEnum b : LineNumberRestartModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LineNumberRestartModeEnum> {
            public void write(JsonWriter jsonWriter, LineNumberRestartModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LineNumberRestartModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LineNumberRestartModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OrientationEnum {
        PORTRAIT("Portrait"),
        LANDSCAPE("Landscape");

        private String value;

        private OrientationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OrientationEnum fromValue(String text) {
            for (OrientationEnum b : OrientationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OrientationEnum> {
            public void write(JsonWriter jsonWriter, OrientationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OrientationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OrientationEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PageNumberStyleEnum {
        ARABIC("Arabic"),
        UPPERCASEROMAN("UppercaseRoman"),
        LOWERCASEROMAN("LowercaseRoman"),
        UPPERCASELETTER("UppercaseLetter"),
        LOWERCASELETTER("LowercaseLetter"),
        ORDINAL("Ordinal"),
        NUMBER("Number"),
        ORDINALTEXT("OrdinalText"),
        HEX("Hex"),
        CHICAGOMANUAL("ChicagoManual"),
        KANJI("Kanji"),
        KANJIDIGIT("KanjiDigit"),
        AIUEOHALFWIDTH("AiueoHalfWidth"),
        IROHAHALFWIDTH("IrohaHalfWidth"),
        ARABICFULLWIDTH("ArabicFullWidth"),
        ARABICHALFWIDTH("ArabicHalfWidth"),
        KANJITRADITIONAL("KanjiTraditional"),
        KANJITRADITIONAL2("KanjiTraditional2"),
        NUMBERINCIRCLE("NumberInCircle"),
        DECIMALFULLWIDTH("DecimalFullWidth"),
        AIUEO("Aiueo"),
        IROHA("Iroha"),
        LEADINGZERO("LeadingZero"),
        BULLET("Bullet"),
        GANADA("Ganada"),
        CHOSUNG("Chosung"),
        GB1("GB1"),
        GB2("GB2"),
        GB3("GB3"),
        GB4("GB4"),
        ZODIAC1("Zodiac1"),
        ZODIAC2("Zodiac2"),
        ZODIAC3("Zodiac3"),
        TRADCHINNUM1("TradChinNum1"),
        TRADCHINNUM2("TradChinNum2"),
        TRADCHINNUM3("TradChinNum3"),
        TRADCHINNUM4("TradChinNum4"),
        SIMPCHINNUM1("SimpChinNum1"),
        SIMPCHINNUM2("SimpChinNum2"),
        SIMPCHINNUM3("SimpChinNum3"),
        SIMPCHINNUM4("SimpChinNum4"),
        HANJAREAD("HanjaRead"),
        HANJAREADDIGIT("HanjaReadDigit"),
        HANGUL("Hangul"),
        HANJA("Hanja"),
        HEBREW1("Hebrew1"),
        ARABIC1("Arabic1"),
        HEBREW2("Hebrew2"),
        ARABIC2("Arabic2"),
        HINDILETTER1("HindiLetter1"),
        HINDILETTER2("HindiLetter2"),
        HINDIARABIC("HindiArabic"),
        HINDICARDINALTEXT("HindiCardinalText"),
        THAILETTER("ThaiLetter"),
        THAIARABIC("ThaiArabic"),
        THAICARDINALTEXT("ThaiCardinalText"),
        VIETCARDINALTEXT("VietCardinalText"),
        NUMBERINDASH("NumberInDash"),
        LOWERCASERUSSIAN("LowercaseRussian"),
        UPPERCASERUSSIAN("UppercaseRussian"),
        NONE("None"),
        CUSTOM("Custom");

        private String value;

        private PageNumberStyleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PageNumberStyleEnum fromValue(String text) {
            for (PageNumberStyleEnum b : PageNumberStyleEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PageNumberStyleEnum> {
            public void write(JsonWriter jsonWriter, PageNumberStyleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PageNumberStyleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PageNumberStyleEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PaperSizeEnum {
        A3("A3"),
        A4("A4"),
        A5("A5"),
        B4("B4"),
        B5("B5"),
        EXECUTIVE("Executive"),
        FOLIO("Folio"),
        LEDGER("Ledger"),
        LEGAL("Legal"),
        LETTER("Letter"),
        ENVELOPEDL("EnvelopeDL"),
        QUARTO("Quarto"),
        STATEMENT("Statement"),
        TABLOID("Tabloid"),
        PAPER10X14("Paper10x14"),
        PAPER11X17("Paper11x17"),
        NUMBER10ENVELOPE("Number10Envelope"),
        JISB4("JisB4"),
        JISB5("JisB5"),
        CUSTOM("Custom");

        private String value;

        private PaperSizeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PaperSizeEnum fromValue(String text) {
            for (PaperSizeEnum b : PaperSizeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PaperSizeEnum> {
            public void write(JsonWriter jsonWriter, PaperSizeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PaperSizeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PaperSizeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SectionStartEnum {
        CONTINUOUS("Continuous"),
        NEWCOLUMN("NewColumn"),
        NEWPAGE("NewPage"),
        EVENPAGE("EvenPage"),
        ODDPAGE("OddPage");

        private String value;

        private SectionStartEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SectionStartEnum fromValue(String text) {
            for (SectionStartEnum b : SectionStartEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SectionStartEnum> {
            public void write(JsonWriter jsonWriter, SectionStartEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SectionStartEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SectionStartEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VerticalAlignmentEnum {
        TOP("Top"),
        CENTER("Center"),
        JUSTIFY("Justify"),
        BOTTOM("Bottom");

        private String value;

        private VerticalAlignmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VerticalAlignmentEnum fromValue(String text) {
            for (VerticalAlignmentEnum b : VerticalAlignmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<VerticalAlignmentEnum> {
            public void write(JsonWriter jsonWriter, VerticalAlignmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VerticalAlignmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VerticalAlignmentEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

