/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.PdfPermissions;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container class for details of encryption.")
public class PdfEncryptionDetailsData
implements ModelIfc {
    @SerializedName(value="OwnerPassword")
    protected String ownerPassword = null;
    @SerializedName(value="Permissions")
    protected List<PdfPermissions> permissions = null;
    @SerializedName(value="UserPassword")
    protected String userPassword = null;

    @ApiModelProperty(value="Gets or sets the owner password for the encrypted PDF document.")
    public String getOwnerPassword() {
        return this.ownerPassword;
    }

    public PdfEncryptionDetailsData ownerPassword(String ownerPassword) {
        this.ownerPassword = ownerPassword;
        return this;
    }

    public void setOwnerPassword(String ownerPassword) {
        this.ownerPassword = ownerPassword;
    }

    @ApiModelProperty(value="Gets or sets the operations that are allowed to a user on the encrypted PDF document.")
    public List<PdfPermissions> getPermissions() {
        return this.permissions;
    }

    public PdfEncryptionDetailsData permissions(List<PdfPermissions> permissions) {
        this.permissions = permissions;
        return this;
    }

    public PdfEncryptionDetailsData addPermissionsItem(PdfPermissions permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<PdfPermissions>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    public void setPermissions(List<PdfPermissions> permissions) {
        this.permissions = permissions;
    }

    @ApiModelProperty(value="Gets or sets the user password required for opening the encrypted PDF document.")
    public String getUserPassword() {
        return this.userPassword;
    }

    public PdfEncryptionDetailsData userPassword(String userPassword) {
        this.userPassword = userPassword;
        return this;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfEncryptionDetailsData pdfEncryptionDetailsData = (PdfEncryptionDetailsData)o;
        return Objects.equals(this.ownerPassword, pdfEncryptionDetailsData.ownerPassword) && Objects.equals(this.permissions, pdfEncryptionDetailsData.permissions) && Objects.equals(this.userPassword, pdfEncryptionDetailsData.userPassword);
    }

    public int hashCode() {
        return Objects.hash(this.ownerPassword, this.permissions, this.userPassword);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PdfEncryptionDetailsData {\n");
        sb.append("    ownerPassword: ").append(this.toIndentedString(this.getOwnerPassword())).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.getPermissions())).append("\n");
        sb.append("    userPassword: ").append(this.toIndentedString(this.getUserPassword())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

