/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ProtectionRequestBase;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Request on changing of protection.")
public class ProtectionRequestV2
extends ProtectionRequestBase {
    @SerializedName(value="ProtectionPassword")
    protected String protectionPassword = null;
    @SerializedName(value="ProtectionType")
    protected ProtectionTypeEnum protectionType = null;

    @ApiModelProperty(value="Gets or sets the new password for the document protection. This property is required, but empty value is allowed.")
    public String getProtectionPassword() {
        return this.protectionPassword;
    }

    public ProtectionRequestV2 protectionPassword(String protectionPassword) {
        this.protectionPassword = protectionPassword;
        return this;
    }

    public void setProtectionPassword(String protectionPassword) {
        this.protectionPassword = protectionPassword;
    }

    @ApiModelProperty(value="Gets or sets the new type of the document protection.")
    public ProtectionTypeEnum getProtectionType() {
        return this.protectionType;
    }

    public ProtectionRequestV2 protectionType(ProtectionTypeEnum protectionType) {
        this.protectionType = protectionType;
        return this;
    }

    public void setProtectionType(ProtectionTypeEnum protectionType) {
        this.protectionType = protectionType;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.protectionPassword == null) {
            throw new ApiException(400, "Property ProtectionPassword in ProtectionRequestV2 is required.");
        }
        if (this.protectionType == null) {
            throw new ApiException(400, "Property ProtectionType in ProtectionRequestV2 is required.");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtectionRequestV2 protectionRequestV2 = (ProtectionRequestV2)o;
        return Objects.equals(this.protectionPassword, protectionRequestV2.protectionPassword) && Objects.equals((Object)this.protectionType, (Object)protectionRequestV2.protectionType) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.protectionPassword, this.protectionType, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProtectionRequestV2 {\n");
        sb.append("    protectionPassword: ").append(this.toIndentedString(this.getProtectionPassword())).append("\n");
        sb.append("    protectionType: ").append(this.toIndentedString((Object)this.getProtectionType())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ProtectionTypeEnum {
        ALLOWONLYREVISIONS("AllowOnlyRevisions"),
        ALLOWONLYCOMMENTS("AllowOnlyComments"),
        ALLOWONLYFORMFIELDS("AllowOnlyFormFields"),
        READONLY("ReadOnly"),
        NOPROTECTION("NoProtection");

        private String value;

        private ProtectionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ProtectionTypeEnum fromValue(String text) {
            for (ProtectionTypeEnum b : ProtectionTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ProtectionTypeEnum> {
            public void write(JsonWriter jsonWriter, ProtectionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ProtectionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ProtectionTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

