/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.SaveOptionsData;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container class for rtf save options.")
public class RtfSaveOptionsData
extends SaveOptionsData {
    @SerializedName(value="ExportCompactSize")
    protected Boolean exportCompactSize = null;
    @SerializedName(value="ExportImagesForOldReaders")
    protected Boolean exportImagesForOldReaders = null;
    @SerializedName(value="PrettyFormat")
    protected Boolean prettyFormat = null;
    @SerializedName(value="SaveImagesAsWmf")
    protected Boolean saveImagesAsWmf = null;

    @ApiModelProperty(value="Gets or sets a value indicating whether to make output RTF documents smaller in size, but if they contain RTL (right-to-left) text, it will not be displayed correctly.")
    public Boolean getExportCompactSize() {
        return this.exportCompactSize;
    }

    public RtfSaveOptionsData exportCompactSize(Boolean exportCompactSize) {
        this.exportCompactSize = exportCompactSize;
        return this;
    }

    public void setExportCompactSize(Boolean exportCompactSize) {
        this.exportCompactSize = exportCompactSize;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the keywords for \"old readers\" are written to RTF or not.")
    public Boolean getExportImagesForOldReaders() {
        return this.exportImagesForOldReaders;
    }

    public RtfSaveOptionsData exportImagesForOldReaders(Boolean exportImagesForOldReaders) {
        this.exportImagesForOldReaders = exportImagesForOldReaders;
        return this;
    }

    public void setExportImagesForOldReaders(Boolean exportImagesForOldReaders) {
        this.exportImagesForOldReaders = exportImagesForOldReaders;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to use pretty formats output.")
    public Boolean getPrettyFormat() {
        return this.prettyFormat;
    }

    public RtfSaveOptionsData prettyFormat(Boolean prettyFormat) {
        this.prettyFormat = prettyFormat;
        return this;
    }

    public void setPrettyFormat(Boolean prettyFormat) {
        this.prettyFormat = prettyFormat;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether when true all images will be saved as WMF. This option might help to avoid WordPad warning messages.")
    public Boolean getSaveImagesAsWmf() {
        return this.saveImagesAsWmf;
    }

    public RtfSaveOptionsData saveImagesAsWmf(Boolean saveImagesAsWmf) {
        this.saveImagesAsWmf = saveImagesAsWmf;
        return this;
    }

    public void setSaveImagesAsWmf(Boolean saveImagesAsWmf) {
        this.saveImagesAsWmf = saveImagesAsWmf;
    }

    public RtfSaveOptionsData() {
        this.saveFormat = "rtf";
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RtfSaveOptionsData rtfSaveOptionsData = (RtfSaveOptionsData)o;
        return Objects.equals(this.exportCompactSize, rtfSaveOptionsData.exportCompactSize) && Objects.equals(this.exportImagesForOldReaders, rtfSaveOptionsData.exportImagesForOldReaders) && Objects.equals(this.prettyFormat, rtfSaveOptionsData.prettyFormat) && Objects.equals(this.saveImagesAsWmf, rtfSaveOptionsData.saveImagesAsWmf) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.exportCompactSize, this.exportImagesForOldReaders, this.prettyFormat, this.saveImagesAsWmf, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RtfSaveOptionsData {\n");
        sb.append("    allowEmbeddingPostScriptFonts: ").append(this.toIndentedString(this.getAllowEmbeddingPostScriptFonts())).append("\n");
        sb.append("    customTimeZoneInfoData: ").append(this.toIndentedString(this.getCustomTimeZoneInfoData())).append("\n");
        sb.append("    dml3DEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDml3DEffectsRenderingMode())).append("\n");
        sb.append("    dmlEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDmlEffectsRenderingMode())).append("\n");
        sb.append("    dmlRenderingMode: ").append(this.toIndentedString((Object)this.getDmlRenderingMode())).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.getFileName())).append("\n");
        sb.append("    imlRenderingMode: ").append(this.toIndentedString((Object)this.getImlRenderingMode())).append("\n");
        sb.append("    updateAmbiguousTextFont: ").append(this.toIndentedString(this.getUpdateAmbiguousTextFont())).append("\n");
        sb.append("    updateCreatedTimeProperty: ").append(this.toIndentedString(this.getUpdateCreatedTimeProperty())).append("\n");
        sb.append("    updateFields: ").append(this.toIndentedString(this.getUpdateFields())).append("\n");
        sb.append("    updateLastPrintedProperty: ").append(this.toIndentedString(this.getUpdateLastPrintedProperty())).append("\n");
        sb.append("    updateLastSavedTimeProperty: ").append(this.toIndentedString(this.getUpdateLastSavedTimeProperty())).append("\n");
        sb.append("    zipOutput: ").append(this.toIndentedString(this.getZipOutput())).append("\n");
        sb.append("    exportCompactSize: ").append(this.toIndentedString(this.getExportCompactSize())).append("\n");
        sb.append("    exportImagesForOldReaders: ").append(this.toIndentedString(this.getExportImagesForOldReaders())).append("\n");
        sb.append("    prettyFormat: ").append(this.toIndentedString(this.getPrettyFormat())).append("\n");
        sb.append("    saveImagesAsWmf: ").append(this.toIndentedString(this.getSaveImagesAsWmf())).append("\n");
        sb.append("    saveFormat: ").append(this.toIndentedString(this.getSaveFormat())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

