/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileLink;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Result of saving.")
public class SaveResult
implements ModelIfc {
    @SerializedName(value="DestDocument")
    protected FileLink destDocument = null;
    @SerializedName(value="SourceDocument")
    protected FileLink sourceDocument = null;
    @SerializedName(value="AdditionalItems")
    protected List<FileLink> additionalItems = null;

    @ApiModelProperty(value="Gets or sets the link to destination document.")
    public FileLink getDestDocument() {
        return this.destDocument;
    }

    public SaveResult destDocument(FileLink destDocument) {
        this.destDocument = destDocument;
        return this;
    }

    public void setDestDocument(FileLink destDocument) {
        this.destDocument = destDocument;
    }

    @ApiModelProperty(value="Gets or sets the link to source document.")
    public FileLink getSourceDocument() {
        return this.sourceDocument;
    }

    public SaveResult sourceDocument(FileLink sourceDocument) {
        this.sourceDocument = sourceDocument;
        return this;
    }

    public void setSourceDocument(FileLink sourceDocument) {
        this.sourceDocument = sourceDocument;
    }

    @ApiModelProperty(value="Gets or sets the list of links to additional items (css, images etc).")
    public List<FileLink> getAdditionalItems() {
        return this.additionalItems;
    }

    public SaveResult additionalItems(List<FileLink> additionalItems) {
        this.additionalItems = additionalItems;
        return this;
    }

    public SaveResult addAdditionalItemsItem(FileLink additionalItemsItem) {
        if (this.additionalItems == null) {
            this.additionalItems = new ArrayList<FileLink>();
        }
        this.additionalItems.add(additionalItemsItem);
        return this;
    }

    public void setAdditionalItems(List<FileLink> additionalItems) {
        this.additionalItems = additionalItems;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.destDocument != null) {
            this.destDocument.validate();
        }
        if (this.sourceDocument != null) {
            this.sourceDocument.validate();
        }
        if (this.additionalItems != null) {
            for (ModelIfc modelIfc : this.additionalItems) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SaveResult saveResult = (SaveResult)o;
        return Objects.equals(this.destDocument, saveResult.destDocument) && Objects.equals(this.sourceDocument, saveResult.sourceDocument) && Objects.equals(this.additionalItems, saveResult.additionalItems);
    }

    public int hashCode() {
        return Objects.hash(this.destDocument, this.sourceDocument, this.additionalItems);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SaveResult {\n");
        sb.append("    destDocument: ").append(this.toIndentedString(this.getDestDocument())).append("\n");
        sb.append("    sourceDocument: ").append(this.toIndentedString(this.getSourceDocument())).append("\n");
        sb.append("    additionalItems: ").append(this.toIndentedString(this.getAdditionalItems())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

