/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileLink;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Result of splitting document.")
public class SplitDocumentResult
implements ModelIfc {
    @SerializedName(value="SourceDocument")
    protected FileLink sourceDocument = null;
    @SerializedName(value="ZippedPages")
    protected FileLink zippedPages = null;
    @SerializedName(value="Pages")
    protected List<FileLink> pages = null;

    @ApiModelProperty(value="Gets or sets the link to the source document.")
    public FileLink getSourceDocument() {
        return this.sourceDocument;
    }

    public SplitDocumentResult sourceDocument(FileLink sourceDocument) {
        this.sourceDocument = sourceDocument;
        return this;
    }

    public void setSourceDocument(FileLink sourceDocument) {
        this.sourceDocument = sourceDocument;
    }

    @ApiModelProperty(value="Gets or sets the link to the file archive with pages.")
    public FileLink getZippedPages() {
        return this.zippedPages;
    }

    public SplitDocumentResult zippedPages(FileLink zippedPages) {
        this.zippedPages = zippedPages;
        return this;
    }

    public void setZippedPages(FileLink zippedPages) {
        this.zippedPages = zippedPages;
    }

    @ApiModelProperty(value="Gets or sets the list of pages.")
    public List<FileLink> getPages() {
        return this.pages;
    }

    public SplitDocumentResult pages(List<FileLink> pages) {
        this.pages = pages;
        return this;
    }

    public SplitDocumentResult addPagesItem(FileLink pagesItem) {
        if (this.pages == null) {
            this.pages = new ArrayList<FileLink>();
        }
        this.pages.add(pagesItem);
        return this;
    }

    public void setPages(List<FileLink> pages) {
        this.pages = pages;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.sourceDocument != null) {
            this.sourceDocument.validate();
        }
        if (this.zippedPages != null) {
            this.zippedPages.validate();
        }
        if (this.pages != null) {
            for (ModelIfc modelIfc : this.pages) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitDocumentResult splitDocumentResult = (SplitDocumentResult)o;
        return Objects.equals(this.sourceDocument, splitDocumentResult.sourceDocument) && Objects.equals(this.zippedPages, splitDocumentResult.zippedPages) && Objects.equals(this.pages, splitDocumentResult.pages);
    }

    public int hashCode() {
        return Objects.hash(this.sourceDocument, this.zippedPages, this.pages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SplitDocumentResult {\n");
        sb.append("    sourceDocument: ").append(this.toIndentedString(this.getSourceDocument())).append("\n");
        sb.append("    zippedPages: ").append(this.toIndentedString(this.getZippedPages())).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.getPages())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

