/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.DocumentStatData;
import com.aspose.words.cloud.model.FileLink;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.WordsResponse;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The REST response with document's statistical data.")
public class StatDataResponse
extends WordsResponse {
    @SerializedName(value="DocumentLink")
    protected FileLink documentLink = null;
    @SerializedName(value="StatData")
    protected DocumentStatData statData = null;

    @ApiModelProperty(value="Gets or sets the link to the document.")
    public FileLink getDocumentLink() {
        return this.documentLink;
    }

    public StatDataResponse documentLink(FileLink documentLink) {
        this.documentLink = documentLink;
        return this;
    }

    public void setDocumentLink(FileLink documentLink) {
        this.documentLink = documentLink;
    }

    @ApiModelProperty(value="Gets or sets the statistical data of the document.")
    public DocumentStatData getStatData() {
        return this.statData;
    }

    public StatDataResponse statData(DocumentStatData statData) {
        this.statData = statData;
        return this;
    }

    public void setStatData(DocumentStatData statData) {
        this.statData = statData;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.documentLink != null) {
            this.documentLink.validate();
        }
        if (this.statData != null) {
            this.statData.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatDataResponse statDataResponse = (StatDataResponse)o;
        return Objects.equals(this.documentLink, statDataResponse.documentLink) && Objects.equals(this.statData, statDataResponse.statData) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.documentLink, this.statData, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StatDataResponse {\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.getRequestId())).append("\n");
        sb.append("    documentLink: ").append(this.toIndentedString(this.getDocumentLink())).append("\n");
        sb.append("    statData: ").append(this.toIndentedString(this.getStatData())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

