/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.NodeLink;
import com.aspose.words.cloud.model.StructuredDocumentTagListItem;
import com.aspose.words.cloud.model.XmlColor;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="DTO container with a StructuredDocumentTagBaseDto.")
public abstract class StructuredDocumentTagBase
extends NodeLink {
    @SerializedName(value="ListItems")
    protected List<StructuredDocumentTagListItem> listItems = null;
    @SerializedName(value="Checked")
    protected Boolean checked = null;
    @SerializedName(value="Appearance")
    protected AppearanceEnum appearance = null;
    @SerializedName(value="DateDisplayLocale")
    protected Integer dateDisplayLocale = null;
    @SerializedName(value="DateDisplayFormat")
    protected String dateDisplayFormat = null;
    @SerializedName(value="FullDate")
    protected OffsetDateTime fullDate = null;
    @SerializedName(value="Title")
    protected String title = null;
    @SerializedName(value="DateStorageFormat")
    protected DateStorageFormatEnum dateStorageFormat = null;
    @SerializedName(value="BuildingBlockGallery")
    protected String buildingBlockGallery = null;
    @SerializedName(value="BuildingBlockCategory")
    protected String buildingBlockCategory = null;
    @SerializedName(value="Multiline")
    protected Boolean multiline = null;
    @SerializedName(value="Color")
    protected XmlColor color = null;
    @SerializedName(value="StyleName")
    protected String styleName = null;
    @SerializedName(value="CalendarType")
    protected CalendarTypeEnum calendarType = null;
    @SerializedName(value="IsTemporary")
    protected Boolean isTemporary = null;
    @SerializedName(value="PlaceholderName")
    protected String placeholderName = null;
    @SerializedName(value="LockContentControl")
    protected Boolean lockContentControl = null;
    @SerializedName(value="LockContents")
    protected Boolean lockContents = null;
    @SerializedName(value="IsShowingPlaceholderText")
    protected Boolean isShowingPlaceholderText = null;
    @SerializedName(value="Tag")
    protected String tag = null;
    @SerializedName(value="Id")
    protected Integer id = null;
    @SerializedName(value="WordOpenXML")
    protected String wordOpenXML = null;

    @ApiModelProperty(value="Gets or sets Aspose.Words.Markup.SdtListItemCollection associated with this SDT. Accessing this property will work only for Aspose.Words.Markup.SdtType.ComboBox or Aspose.Words.Markup.SdtType.DropDownList SDT types. For all other SDT types, an exception will occur.")
    public List<StructuredDocumentTagListItem> getListItems() {
        return this.listItems;
    }

    public StructuredDocumentTagBase listItems(List<StructuredDocumentTagListItem> listItems) {
        this.listItems = listItems;
        return this;
    }

    public StructuredDocumentTagBase addListItemsItem(StructuredDocumentTagListItem listItemsItem) {
        if (this.listItems == null) {
            this.listItems = new ArrayList<StructuredDocumentTagListItem>();
        }
        this.listItems.add(listItemsItem);
        return this;
    }

    public void setListItems(List<StructuredDocumentTagListItem> listItems) {
        this.listItems = listItems;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether current state of the Checkbox SDT. Default value for this property. Accessing this property will work only for Aspose.Words.Markup.SdtType.Checkbox SDT types. For all other SDT types, an exception will occur.")
    public Boolean getChecked() {
        return this.checked;
    }

    public StructuredDocumentTagBase checked(Boolean checked) {
        this.checked = checked;
        return this;
    }

    public void setChecked(Boolean checked) {
        this.checked = checked;
    }

    @ApiModelProperty(value="Gets or sets the appearance of a structured document tag.")
    public AppearanceEnum getAppearance() {
        return this.appearance;
    }

    public StructuredDocumentTagBase appearance(AppearanceEnum appearance) {
        this.appearance = appearance;
        return this;
    }

    public void setAppearance(AppearanceEnum appearance) {
        this.appearance = appearance;
    }

    @ApiModelProperty(value="Gets or sets the language format for the date displayed in this SDT. Accessing this property will work only for Aspose.Words.Markup.SdtType.Date SDT type. For all other SDT types, an exception will occur.")
    public Integer getDateDisplayLocale() {
        return this.dateDisplayLocale;
    }

    public StructuredDocumentTagBase dateDisplayLocale(Integer dateDisplayLocale) {
        this.dateDisplayLocale = dateDisplayLocale;
        return this;
    }

    public void setDateDisplayLocale(Integer dateDisplayLocale) {
        this.dateDisplayLocale = dateDisplayLocale;
    }

    @ApiModelProperty(value="Gets or sets String that represents the format in which dates are displayed. Can not be null. The dates for English (U.S.) is \"mm/dd/yyyy\". Accessing this property will work only for Aspose.Words.Markup.SdtType.Date SDT type. For all other SDT types, an exception will occur.")
    public String getDateDisplayFormat() {
        return this.dateDisplayFormat;
    }

    public StructuredDocumentTagBase dateDisplayFormat(String dateDisplayFormat) {
        this.dateDisplayFormat = dateDisplayFormat;
        return this;
    }

    public void setDateDisplayFormat(String dateDisplayFormat) {
        this.dateDisplayFormat = dateDisplayFormat;
    }

    @ApiModelProperty(value="Gets or sets the full date and time last entered into this SDT. Accessing this property will work only for Aspose.Words.Markup.SdtType.Date SDT type. For all other SDT types, an exception will occur.")
    public OffsetDateTime getFullDate() {
        return this.fullDate;
    }

    public StructuredDocumentTagBase fullDate(OffsetDateTime fullDate) {
        this.fullDate = fullDate;
        return this;
    }

    public void setFullDate(OffsetDateTime fullDate) {
        this.fullDate = fullDate;
    }

    @ApiModelProperty(value="Gets or sets the friendly name associated with this SDT. Can not be null.")
    public String getTitle() {
        return this.title;
    }

    public StructuredDocumentTagBase title(String title) {
        this.title = title;
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @ApiModelProperty(value="Gets or sets format in which the date for a date SDT is stored when the SDT is bound to an XML node in the document's data store. The default value is Aspose.Words.Markup.SdtDateStorageFormat.DateTime. Accessing this property will work only for Aspose.Words.Markup.SdtType.Date SDT type. For all other SDT types, an exception will occur.")
    public DateStorageFormatEnum getDateStorageFormat() {
        return this.dateStorageFormat;
    }

    public StructuredDocumentTagBase dateStorageFormat(DateStorageFormatEnum dateStorageFormat) {
        this.dateStorageFormat = dateStorageFormat;
        return this;
    }

    public void setDateStorageFormat(DateStorageFormatEnum dateStorageFormat) {
        this.dateStorageFormat = dateStorageFormat;
    }

    @ApiModelProperty(value="Gets or sets type of building block for this SDT. Can not be null. Accessing this property will work only for Aspose.Words.Markup.SdtType.BuildingBlockGallery and Aspose.Words.Markup.SdtType.DocPartObj SDT types. It is read-only for SDT of the document part type. For all other SDT types, an exception will occur.")
    public String getBuildingBlockGallery() {
        return this.buildingBlockGallery;
    }

    public StructuredDocumentTagBase buildingBlockGallery(String buildingBlockGallery) {
        this.buildingBlockGallery = buildingBlockGallery;
        return this;
    }

    public void setBuildingBlockGallery(String buildingBlockGallery) {
        this.buildingBlockGallery = buildingBlockGallery;
    }

    @ApiModelProperty(value="Gets or sets category of building block for this SDT node. Can not be null. Accessing this property will work only for Aspose.Words.Markup.SdtType.BuildingBlockGallery and Aspose.Words.Markup.SdtType.DocPartObj SDT types. It is read-only for SDT of the document part type. For all other SDT types, an exception will occur.")
    public String getBuildingBlockCategory() {
        return this.buildingBlockCategory;
    }

    public StructuredDocumentTagBase buildingBlockCategory(String buildingBlockCategory) {
        this.buildingBlockCategory = buildingBlockCategory;
        return this;
    }

    public void setBuildingBlockCategory(String buildingBlockCategory) {
        this.buildingBlockCategory = buildingBlockCategory;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether this SDT allows multiple lines of text. Accessing this property will work only for Aspose.Words.Markup.SdtType.RichText and Aspose.Words.Markup.SdtType.PlainText SDT type. For all other SDT types, an exception will occur.")
    public Boolean getMultiline() {
        return this.multiline;
    }

    public StructuredDocumentTagBase multiline(Boolean multiline) {
        this.multiline = multiline;
        return this;
    }

    public void setMultiline(Boolean multiline) {
        this.multiline = multiline;
    }

    @ApiModelProperty(value="Gets or sets the color of the structured document tag.")
    public XmlColor getColor() {
        return this.color;
    }

    public StructuredDocumentTagBase color(XmlColor color) {
        this.color = color;
        return this;
    }

    public void setColor(XmlColor color) {
        this.color = color;
    }

    @ApiModelProperty(value="Gets or sets the name of the style applied to the structured document tag.")
    public String getStyleName() {
        return this.styleName;
    }

    public StructuredDocumentTagBase styleName(String styleName) {
        this.styleName = styleName;
        return this;
    }

    public void setStyleName(String styleName) {
        this.styleName = styleName;
    }

    @ApiModelProperty(value="Gets or sets the type of calendar for this SDT. Default is Aspose.Words.Markup.SdtCalendarType.Default. Accessing this property will work only for Aspose.Words.Markup.SdtType.Date SDT type. For all other SDT types, an exception will occur.")
    public CalendarTypeEnum getCalendarType() {
        return this.calendarType;
    }

    public StructuredDocumentTagBase calendarType(CalendarTypeEnum calendarType) {
        this.calendarType = calendarType;
        return this;
    }

    public void setCalendarType(CalendarTypeEnum calendarType) {
        this.calendarType = calendarType;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether this SDT shall be removed from the WordProcessingML document when its contents are modified.")
    public Boolean getIsTemporary() {
        return this.isTemporary;
    }

    public StructuredDocumentTagBase isTemporary(Boolean isTemporary) {
        this.isTemporary = isTemporary;
        return this;
    }

    public void setIsTemporary(Boolean isTemporary) {
        this.isTemporary = isTemporary;
    }

    @ApiModelProperty(value="Gets or sets Name of the Aspose.Words.BuildingBlocks.BuildingBlock containing placeholder text. Aspose.Words.BuildingBlocks.BuildingBlock with this name Aspose.Words.BuildingBlocks.BuildingBlock.Name has to be present in the Aspose.Words.Document.GlossaryDocument otherwise System.InvalidOperationException will occur.")
    public String getPlaceholderName() {
        return this.placeholderName;
    }

    public StructuredDocumentTagBase placeholderName(String placeholderName) {
        this.placeholderName = placeholderName;
        return this;
    }

    public void setPlaceholderName(String placeholderName) {
        this.placeholderName = placeholderName;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether, this property will prohibit a user from deleting this SDT.")
    public Boolean getLockContentControl() {
        return this.lockContentControl;
    }

    public StructuredDocumentTagBase lockContentControl(Boolean lockContentControl) {
        this.lockContentControl = lockContentControl;
        return this;
    }

    public void setLockContentControl(Boolean lockContentControl) {
        this.lockContentControl = lockContentControl;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether, this property will prohibit a user from editing the contents of this SDT.")
    public Boolean getLockContents() {
        return this.lockContents;
    }

    public StructuredDocumentTagBase lockContents(Boolean lockContents) {
        this.lockContents = lockContents;
        return this;
    }

    public void setLockContents(Boolean lockContents) {
        this.lockContents = lockContents;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the content of this SDT shall be interpreted to contain placeholder text (as opposed to regular text contents within the SDT). If set to true, this state shall be resumed (showing placeholder text) upon opening his document.")
    public Boolean getIsShowingPlaceholderText() {
        return this.isShowingPlaceholderText;
    }

    public StructuredDocumentTagBase isShowingPlaceholderText(Boolean isShowingPlaceholderText) {
        this.isShowingPlaceholderText = isShowingPlaceholderText;
        return this;
    }

    public void setIsShowingPlaceholderText(Boolean isShowingPlaceholderText) {
        this.isShowingPlaceholderText = isShowingPlaceholderText;
    }

    @ApiModelProperty(value="Gets or sets a tag associated with the current SDT node. Can not be null. A tag is an arbitrary string which applications can associate with SDT in order to identify it without providing a visible friendly name.")
    public String getTag() {
        return this.tag;
    }

    public StructuredDocumentTagBase tag(String tag) {
        this.tag = tag;
        return this;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @ApiModelProperty(value="Gets or sets a unique read-only persistent numerical Id for this SDT. Id attribute shall follow these rules: - The document shall retain SDT ids only if the whole document is cloned Aspose.Words.Document.Clone. - During Aspose.Words.DocumentBase.ImportNode(Aspose.Words.Node,System.Boolean) - Id shall be retained if import does not cause conflicts with other SDT Ids in the target document. - If multiple SDT nodes specify the same decimal number value for the Id attribute, then the first SDT in the document shall maintain this original Id, and all subsequent - SDT nodes shall have new identifiers assigned to them when the document is loaded. - During standalone SDT Aspose.Words.Markup.StructuredDocumentTag.Clone(System.Boolean,Aspose.Words.INodeCloningListener) operation new unique ID will be generated for the cloned SDT node. - If Id is not specified in the source document, then the SDT node shall have a new unique identifier assigned to it when the document is loaded.")
    public Integer getId() {
        return this.id;
    }

    public StructuredDocumentTagBase id(Integer id) {
        this.id = id;
        return this;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @ApiModelProperty(value="Gets a string that represents the XML contained within the node in the Aspose.Words.SaveFormat.FlatOpc format.")
    public String getWordOpenXML() {
        return this.wordOpenXML;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.listItems != null) {
            for (ModelIfc modelIfc : this.listItems) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
        if (this.color != null) {
            this.color.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructuredDocumentTagBase structuredDocumentTagBase = (StructuredDocumentTagBase)o;
        return Objects.equals(this.listItems, structuredDocumentTagBase.listItems) && Objects.equals(this.checked, structuredDocumentTagBase.checked) && Objects.equals((Object)this.appearance, (Object)structuredDocumentTagBase.appearance) && Objects.equals(this.dateDisplayLocale, structuredDocumentTagBase.dateDisplayLocale) && Objects.equals(this.dateDisplayFormat, structuredDocumentTagBase.dateDisplayFormat) && Objects.equals(this.fullDate, structuredDocumentTagBase.fullDate) && Objects.equals(this.title, structuredDocumentTagBase.title) && Objects.equals((Object)this.dateStorageFormat, (Object)structuredDocumentTagBase.dateStorageFormat) && Objects.equals(this.buildingBlockGallery, structuredDocumentTagBase.buildingBlockGallery) && Objects.equals(this.buildingBlockCategory, structuredDocumentTagBase.buildingBlockCategory) && Objects.equals(this.multiline, structuredDocumentTagBase.multiline) && Objects.equals(this.color, structuredDocumentTagBase.color) && Objects.equals(this.styleName, structuredDocumentTagBase.styleName) && Objects.equals((Object)this.calendarType, (Object)structuredDocumentTagBase.calendarType) && Objects.equals(this.isTemporary, structuredDocumentTagBase.isTemporary) && Objects.equals(this.placeholderName, structuredDocumentTagBase.placeholderName) && Objects.equals(this.lockContentControl, structuredDocumentTagBase.lockContentControl) && Objects.equals(this.lockContents, structuredDocumentTagBase.lockContents) && Objects.equals(this.isShowingPlaceholderText, structuredDocumentTagBase.isShowingPlaceholderText) && Objects.equals(this.tag, structuredDocumentTagBase.tag) && Objects.equals(this.id, structuredDocumentTagBase.id) && Objects.equals(this.wordOpenXML, structuredDocumentTagBase.wordOpenXML) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.listItems, this.checked, this.appearance, this.dateDisplayLocale, this.dateDisplayFormat, this.fullDate, this.title, this.dateStorageFormat, this.buildingBlockGallery, this.buildingBlockCategory, this.multiline, this.color, this.styleName, this.calendarType, this.isTemporary, this.placeholderName, this.lockContentControl, this.lockContents, this.isShowingPlaceholderText, this.tag, this.id, this.wordOpenXML, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StructuredDocumentTagBase {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.getNodeId())).append("\n");
        sb.append("    listItems: ").append(this.toIndentedString(this.getListItems())).append("\n");
        sb.append("    checked: ").append(this.toIndentedString(this.getChecked())).append("\n");
        sb.append("    appearance: ").append(this.toIndentedString((Object)this.getAppearance())).append("\n");
        sb.append("    dateDisplayLocale: ").append(this.toIndentedString(this.getDateDisplayLocale())).append("\n");
        sb.append("    dateDisplayFormat: ").append(this.toIndentedString(this.getDateDisplayFormat())).append("\n");
        sb.append("    fullDate: ").append(this.toIndentedString(this.getFullDate())).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.getTitle())).append("\n");
        sb.append("    dateStorageFormat: ").append(this.toIndentedString((Object)this.getDateStorageFormat())).append("\n");
        sb.append("    buildingBlockGallery: ").append(this.toIndentedString(this.getBuildingBlockGallery())).append("\n");
        sb.append("    buildingBlockCategory: ").append(this.toIndentedString(this.getBuildingBlockCategory())).append("\n");
        sb.append("    multiline: ").append(this.toIndentedString(this.getMultiline())).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.getColor())).append("\n");
        sb.append("    styleName: ").append(this.toIndentedString(this.getStyleName())).append("\n");
        sb.append("    calendarType: ").append(this.toIndentedString((Object)this.getCalendarType())).append("\n");
        sb.append("    isTemporary: ").append(this.toIndentedString(this.getIsTemporary())).append("\n");
        sb.append("    placeholderName: ").append(this.toIndentedString(this.getPlaceholderName())).append("\n");
        sb.append("    lockContentControl: ").append(this.toIndentedString(this.getLockContentControl())).append("\n");
        sb.append("    lockContents: ").append(this.toIndentedString(this.getLockContents())).append("\n");
        sb.append("    isShowingPlaceholderText: ").append(this.toIndentedString(this.getIsShowingPlaceholderText())).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.getTag())).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.getId())).append("\n");
        sb.append("    wordOpenXML: ").append(this.toIndentedString(this.getWordOpenXML())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AppearanceEnum {
        BOUNDINGBOX("BoundingBox"),
        DEFAULT("Default"),
        TAGS("Tags"),
        HIDDEN("Hidden");

        private String value;

        private AppearanceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AppearanceEnum fromValue(String text) {
            for (AppearanceEnum b : AppearanceEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AppearanceEnum> {
            public void write(JsonWriter jsonWriter, AppearanceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AppearanceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AppearanceEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DateStorageFormatEnum {
        DATE("Date"),
        DATETIME("DateTime"),
        DEFAULT("Default"),
        TEXT("Text");

        private String value;

        private DateStorageFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DateStorageFormatEnum fromValue(String text) {
            for (DateStorageFormatEnum b : DateStorageFormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DateStorageFormatEnum> {
            public void write(JsonWriter jsonWriter, DateStorageFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DateStorageFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DateStorageFormatEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CalendarTypeEnum {
        DEFAULT("Default"),
        GREGORIAN("Gregorian"),
        GREGORIANARABIC("GregorianArabic"),
        GREGORIANMEFRENCH("GregorianMeFrench"),
        GREGORIANUS("GregorianUs"),
        GREGORIANXLITENGLISH("GregorianXlitEnglish"),
        GREGORIANXLITFRENCH("GregorianXlitFrench"),
        HEBREW("Hebrew"),
        HIJRI("Hijri"),
        JAPAN("Japan"),
        KOREA("Korea"),
        NONE("None"),
        SAKA("Saka"),
        TAIWAN("Taiwan"),
        THAI("Thai");

        private String value;

        private CalendarTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CalendarTypeEnum fromValue(String text) {
            for (CalendarTypeEnum b : CalendarTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CalendarTypeEnum> {
            public void write(JsonWriter jsonWriter, CalendarTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CalendarTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CalendarTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

